/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.PC_GresButton;
import net.minecraft.src.PC_GresLabel;
import net.minecraft.src.PC_GresLayoutH;
import net.minecraft.src.PC_GresTextEdit;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.PC_GresWindow;
import net.minecraft.src.PC_IGresBase;
import net.minecraft.src.PC_IGresGui;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PClo_TileEntityGate;

public class PClo_GuiCustomGate
implements PC_IGresBase {
    private PClo_TileEntityGate tileEntity;
    private PC_GresWidget buttonOK;
    private PC_GresWidget buttonCancel;
    private PC_GresWidget edit;
    private PC_GresWidget txError;

    public PClo_GuiCustomGate(PClo_TileEntityGate tileEntity) {
        this.tileEntity = tileEntity;
    }

    @Override
    public EntityPlayer getPlayer() {
        return PC_Utils.mc().thePlayer;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        PC_GresWindow w = new PC_GresWindow(PC_Lang.tr("tile.PCloLogicGate.programmable.name"));
        this.edit = new PC_GresTextEdit(this.tileEntity.programm, 20);
        w.add(this.edit);
        this.txError = new PC_GresLabel("").setColor(0, 0x990000);
        w.add(this.txError);
        PC_GresWidget hg = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        hg.add(new PC_GresButton("L").setId(100).setMinWidth(0));
        hg.add(new PC_GresButton("R").setId(100).setMinWidth(0));
        hg.add(new PC_GresButton("B").setId(100).setMinWidth(0));
        hg.add(new PC_GresButton("(").setId(100).setMinWidth(0));
        hg.add(new PC_GresButton(")").setId(100).setMinWidth(0));
        hg.add(new PC_GresButton("|").setId(100).setMinWidth(0));
        hg.add(new PC_GresButton("&").setId(100).setMinWidth(0));
        hg.add(new PC_GresButton("^").setId(100).setMinWidth(0));
        hg.add(new PC_GresButton("!").setId(100).setMinWidth(0));
        w.add(hg);
        hg = new PC_GresLayoutH().setAlignH(PC_GresWidget.PC_GresAlign.CENTER);
        this.buttonCancel = new PC_GresButton(PC_Lang.tr("pc.gui.cancel")).setId(1);
        hg.add(this.buttonCancel);
        this.buttonOK = new PC_GresButton(PC_Lang.tr("pc.gui.ok")).setId(0);
        hg.add(this.buttonOK);
        w.add(hg);
        gui.add(w);
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
    }

    private int isProgrammOK(String program) {
        int i;
        program = program.trim();
        int h = 0;
        if (program.length() < 1) {
            this.txError.setText(PC_Lang.tr("pc.gui.customGate.errProgEq0"));
            return 1;
        }
        if (program.length() == 1) {
            char c = program.charAt(0);
            if (c == 'l' || c == 'L') {
                return 0;
            }
            if (c == 'b' || c == 'B') {
                return 0;
            }
            if (c == 'r' || c == 'R') {
                return 0;
            }
            this.txError.setText(PC_Lang.tr("pc.gui.customGate.errUnkChar", new String[]{"" + c}));
            return 2;
        }
        if (program.charAt(0) == '(') {
            h = 1;
            for (i = 1; i < program.length() - 1; ++i) {
                if (program.charAt(i) == '(') {
                    ++h;
                }
                if (program.charAt(i) == ')' && --h == 0) break;
            }
            if (h > 0) {
                if (program.charAt(program.length() - 1) == ')') {
                    return this.isProgrammOK(program.substring(1, program.length() - 1));
                }
                this.txError.setText(PC_Lang.tr("pc.gui.customGate.errUnclosed"));
                return 3;
            }
        }
        h = 0;
        block6: for (i = program.length() - 1; i >= 0; --i) {
            switch (program.charAt(i)) {
                case '(': {
                    --h;
                    continue block6;
                }
                case ')': {
                    ++h;
                    continue block6;
                }
                case '&': 
                case '^': 
                case '|': {
                    if (h > 0) continue block6;
                    int e1 = this.isProgrammOK(program.substring(0, i));
                    int e2 = this.isProgrammOK(program.substring(i + 1));
                    if (e1 == 0 && e2 == 0) {
                        return 0;
                    }
                    if (e1 == 1) {
                        this.txError.setText(PC_Lang.tr("pc.gui.customGate.errNoTextBefore", new String[]{"" + program.charAt(i)}));
                        return 6;
                    }
                    if (e2 == 1) {
                        this.txError.setText(PC_Lang.tr("pc.gui.customGate.errNoTextBehind", new String[]{"" + program.charAt(i)}));
                        return 6;
                    }
                    return e1 == 0 ? e2 : e1;
                }
            }
        }
        if (program.charAt(0) == '!') {
            int e = this.isProgrammOK(program.substring(1));
            if (e == 0) {
                return 0;
            }
            if (e == 1) {
                this.txError.setText(PC_Lang.tr("pc.gui.customGate.errNoTextBehind", new String[]{"!"}));
                return 5;
            }
            return e;
        }
        this.txError.setText(PC_Lang.tr("pc.gui.customGate.errUnkString", new String[]{program}));
        return 4;
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget == this.buttonCancel) {
            gui.close();
        } else if (widget == this.buttonOK) {
            this.txError.setText("");
            if (this.isProgrammOK(this.edit.getText()) == 0) {
                this.tileEntity.programm = this.edit.getText();
                gui.close();
            }
        } else if (widget == this.edit) {
            this.txError.setText("");
            this.isProgrammOK(this.edit.getText());
        } else if (widget.getId() == 100) {
            ((PC_GresTextEdit)this.edit).addKey(widget.getText().charAt(0));
            this.actionPerformed(this.edit, gui);
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        this.actionPerformed(this.buttonOK, gui);
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory) {
    }
}

