/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PClo_GuiRadioChannel;
import net.minecraft.src.PClo_ItemRadioRemote;
import net.minecraft.src.PClo_RadioManager;
import net.minecraft.src.PClo_Renderer;
import net.minecraft.src.PClo_TileEntityRadio;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_PClogic;

public class PClo_BlockRadio
extends BlockContainer
implements PC_IBlockType {
    protected PClo_BlockRadio(int id) {
        super(id, Block.stone.blockIndexInTexture, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.255f, 1.0f);
    }

    @Override
    public void getCollidingBoundingBoxes(World world, int x, int y, int z, AxisAlignedBB collidedbox, ArrayList list) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        super.getCollidingBoundingBoxes(world, x, y, z, collidedbox, list);
        this.setBlockBounds(0.65f, 0.0f, 0.65f, 0.95f, 0.9f, 0.65f);
        super.getCollidingBoundingBoxes(world, x, y, z, collidedbox, list);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.255f, 1.0f);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.255f, 1.0f);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return true;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return 6;
    }

    @Override
    public int getRenderType() {
        return PClo_Renderer.radioRenderer;
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer) {
        Block bhold;
        ItemStack ihold = entityplayer.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID && (bhold = Block.blocksList[ihold.getItem().shiftedIndex]) instanceof PC_IBlockType) {
            return false;
        }
        ItemStack holditem = entityplayer.getCurrentEquippedItem();
        if (holditem != null && holditem.itemID == mod_PClogic.portableTx.shiftedIndex) {
            String channel = mod_PClogic.default_radio_channel;
            channel = PClo_BlockRadio.getTE(world, x, y, z).getChannel();
            PClo_ItemRadioRemote.setChannel(holditem, channel);
            world.playSoundAtEntity(entityplayer, "note.snare", (world.rand.nextFloat() + 0.7f) / 2.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.4f);
            return true;
        }
        int rtype = PClo_BlockRadio.getTE(world, x, y, z).isTransmitter() ? 0 : 1;
        String channel = PClo_BlockRadio.getTE(world, x, y, z).getChannel();
        PC_Utils.openGres(entityplayer, new PClo_GuiRadioChannel(entityplayer.dimension, new PC_CoordI(x, y, z), channel, rtype));
        return true;
    }

    public static PClo_TileEntityRadio getTE(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.getBlockTileEntity(i, j, k);
        if (te == null) {
            return null;
        }
        PClo_TileEntityRadio ter = (PClo_TileEntityRadio)te;
        return ter;
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    @Override
    public int idDropped(int i, Random random, int j) {
        return -1;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        world.setBlockAndMetadataWithNotify(i, j, k, 0, 0);
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        PClo_TileEntityRadio ter = PClo_BlockRadio.getTE(world, i, j, k);
        if (ter.isTransmitter()) {
            PClo_RadioManager.unregisterTx(ter.dim, new PC_CoordI(i, j, k), ter.getChannel());
        } else {
            PClo_RadioManager.unregisterReceiver(new PC_CoordI(i, j, k));
        }
        if (!PC_Utils.isCreative()) {
            this.dropBlockAsItem_do(world, i, j, k, new ItemStack(mod_PClogic.radio, 1, PClo_BlockRadio.getTE(world, i, j, k).isTransmitter() ? 0 : 1));
        }
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        int meta = world.getBlockMetadata(i, j, k);
        PClo_TileEntityRadio ter = PClo_BlockRadio.getTE(world, i, j, k);
        if (ter.isTransmitter()) {
            boolean on = meta == 1;
            boolean power = this.isGettingPower(world, i, j, k);
            if (on && !power) {
                world.setBlockMetadataWithNotify(i, j, k, 0);
                ter.setStateWithNotify(false);
            } else if (!on && power) {
                world.setBlockMetadataWithNotify(i, j, k, 1);
                ter.setStateWithNotify(true);
            }
        } else {
            boolean power;
            boolean on = meta == 1;
            boolean bl = power = PClo_RadioManager.getSignalStrength(ter.getChannel()) > 0;
            if (on && !power) {
                world.setBlockMetadataWithNotify(i, j, k, 0);
                ter.setStateWithNotify(false);
            } else if (!on && power) {
                world.setBlockMetadataWithNotify(i, j, k, 1);
                ter.setStateWithNotify(true);
            }
        }
        world.markBlockNeedsUpdate(i, j, k);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, world.getBlockId(i, j - 1, k));
    }

    private boolean isGettingPower(World world, int i, int j, int k) {
        return world.isBlockGettingPowered(i, j, k) || world.isBlockGettingPowered(i, j - 1, k) || world.isBlockIndirectlyGettingPowered(i, j, k) || world.isBlockIndirectlyGettingPowered(i, j - 1, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (PClo_BlockRadio.getTE(world, i, j, k).isReceiver()) {
            return;
        }
        if (l <= 0 || !Block.blocksList[l].canProvidePower()) {
            return;
        }
        boolean on = world.getBlockMetadata(i, j, k) == 1;
        boolean power = this.isGettingPower(world, i, j, k);
        if (on && !power) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, 1);
        } else if (!on && power) {
            world.scheduleBlockUpdate(i, j, k, this.blockID, 1);
        }
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        int meta = iblockaccess.getBlockMetadata(i, j, k);
        return PClo_BlockRadio.getTE(iblockaccess, i, j, k).isReceiver() && meta == 1;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int i1 = world.getBlockMetadata(i, j, k);
        if (i1 != 1) {
            return;
        }
        double x = (double)((float)i + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double y = (double)((float)j + 0.9f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double z = (double)((float)k + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        world.spawnParticle("reddust", x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public int getMobilityFlag() {
        return 2;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("REDSTONE");
        set.add("LOGIC");
        set.add("RADIO");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PClo_TileEntityRadio();
    }
}

