/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PClo_GuiPulsar;
import net.minecraft.src.PClo_TileEntityPulsar;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class PClo_BlockPulsar
extends BlockContainer
implements PC_IBlockType {
    protected PClo_BlockPulsar(int i) {
        super(i, 74, Material.wood);
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PClo_TileEntityPulsar();
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.isActive(iblockaccess, i, j, k);
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return this.isActive(world, i, j, k);
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer player) {
        PClo_TileEntityPulsar ent;
        ItemStack ihold = player.getCurrentEquippedItem();
        if (ihold != null) {
            Block bhold;
            if (ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != this.blockID && (bhold = Block.blocksList[ihold.getItem().shiftedIndex]) instanceof PC_IBlockType) {
                return false;
            }
            if (ihold.getItem().shiftedIndex == Item.stick.shiftedIndex) {
                PClo_BlockPulsar.changeDelay(world, i, j, k, player.isSneaking() ? -1 : 1);
                return true;
            }
        }
        if ((ent = (PClo_TileEntityPulsar)world.getBlockTileEntity(i, j, k)) != null) {
            PC_Utils.openGres(player, new PClo_GuiPulsar(ent));
        }
        return true;
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        PClo_BlockPulsar.printDelay(world, i, j, k);
    }

    public static void changeDelay(World world, int x, int y, int z, int delay) {
        PClo_TileEntityPulsar ent = (PClo_TileEntityPulsar)world.getBlockTileEntity(x, y, z);
        ent.changeDelay(delay);
        ent.printDelay();
    }

    public static void printDelay(World world, int x, int y, int z) {
        PClo_TileEntityPulsar ent = (PClo_TileEntityPulsar)world.getBlockTileEntity(x, y, z);
        ent.printDelayTime();
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (this.isActive(world, i, j, k)) {
            world.spawnParticle("reddust", (double)i + 0.5, (double)j + 1.0, (double)k + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean isActive(IBlockAccess iblockaccess, int x, int y, int z) {
        TileEntity te = iblockaccess.getBlockTileEntity(x, y, z);
        if (te == null) {
            return false;
        }
        PClo_TileEntityPulsar tep = (PClo_TileEntityPulsar)te;
        return tep.active;
    }

    @Override
    public int getRenderColor(int i) {
        return 0xFF3333;
    }

    @Override
    public int colorMultiplier(IBlockAccess iblockaccess, int i, int j, int k) {
        if (this.isActive(iblockaccess, i, j, k)) {
            return 0xFF3333;
        }
        return 0x771111;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("HARVEST_STOP");
        set.add("REDSTONE");
        set.add("LOGIC");
        set.add("PULSAR");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

