/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.PC_IRotatedBox;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PClo_GuiCustomGate;
import net.minecraft.src.PClo_GuiDelayer;
import net.minecraft.src.PClo_TileEntityGate;
import net.minecraft.src.PClo_TileEntityPulsar;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.World;
import net.minecraft.src.forge.ITextureProvider;
import net.minecraft.src.mod_PClogic;

public class PClo_BlockGate
extends BlockContainer
implements PC_IRotatedBox,
PC_ISwapTerrain,
PC_IBlockType,
ITextureProvider {
    public boolean active;
    private static boolean changingState;

    protected PClo_BlockGate(int id, boolean flag) {
        super(id, Material.circuits);
        this.active = flag;
        this.blockIndexInTexture = 6;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
    }

    @Override
    public boolean renderItemOnSide() {
        return false;
    }

    @Override
    public TileEntity getBlockEntity() {
        return new PClo_TileEntityGate();
    }

    @Override
    public String getTextureFile() {
        return this.getTerrainFile();
    }

    public PClo_TileEntityGate getTE(IBlockAccess iblockaccess, int x, int y, int z) {
        TileEntity te = iblockaccess.getBlockTileEntity(x, y, z);
        if (te == null) {
            return null;
        }
        return (PClo_TileEntityGate)te;
    }

    public int getType(IBlockAccess iblockaccess, int x, int y, int z) {
        return this.getTE((IBlockAccess)iblockaccess, (int)x, (int)y, (int)z).gateType;
    }

    public void setType(IBlockAccess iblockaccess, int x, int y, int z, int type) {
        this.getTE((IBlockAccess)iblockaccess, (int)x, (int)y, (int)z).gateType = type;
    }

    private boolean getOldClock(IBlockAccess iblockaccess, int x, int y, int z) {
        return this.getTE((IBlockAccess)iblockaccess, (int)x, (int)y, (int)z).prevClockState;
    }

    private void setClock(IBlockAccess iblockaccess, int x, int y, int z, boolean clk) {
        this.getTE((IBlockAccess)iblockaccess, (int)x, (int)y, (int)z).prevClockState = clk;
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        if (side == 1) {
            int index = this.getTE((IBlockAccess)iblockaccess, (int)x, (int)y, (int)z).gateType;
            if (index == 23) {
                int variant = this.getTE(iblockaccess, x, y, z).getCrossingVariant();
                switch (variant) {
                    case 0: {
                        return 48;
                    }
                    case 1: {
                        return 49;
                    }
                    case 2: {
                        return 50;
                    }
                    case 3: {
                        return 51;
                    }
                }
                return 48;
            }
            return this.getTopFaceFromEnum(index) + (this.active ? 16 : 0);
        }
        if (side == 0) {
            return 6;
        }
        return 5;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int side, int meta) {
        if (side == 0) {
            return 6;
        }
        if (side == 1) {
            if (meta == 23) {
                return 48;
            }
            return this.getTopFaceFromEnum(meta) + 16;
        }
        return 5;
    }

    private int getTopFaceFromEnum(int meta) {
        if (meta > 23) {
            --meta;
        }
        if (meta <= 15) {
            return 16 + meta;
        }
        return 64 + meta;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        return side != 1;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return PC_Renderer.rotatedBoxRenderer;
    }

    @Override
    public int getRotation(int meta) {
        return PClo_BlockGate.getRotation_static(meta);
    }

    public static int getRotation_static(int meta) {
        return meta & 3;
    }

    @Override
    public String getTerrainFile() {
        return mod_PClogic.getTerrainFile();
    }

    @Override
    public int idDropped(int i, Random random, int j) {
        return -1;
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    @Override
    public void onBlockRemoval(World world, int x, int y, int z) {
        PClo_TileEntityGate teg;
        if (!changingState && (teg = this.getTE(world, x, y, z)) != null) {
            if (teg.gateType == 20) {
                this.unpausePausedBlocks(world, x, y, z);
            }
            teg.zombie = true;
            if (!PC_Utils.isCreative()) {
                this.dropBlockAsItem_do(world, x, y, z, new ItemStack(mod_PClogic.gateOn, 1, teg.gateType));
            }
        }
        super.onBlockRemoval(world, x, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int under = world.getBlockId(x, y - 1, z);
        return Block.blocksList[under] == null || !(Block.blocksList[under] instanceof PClo_BlockGate);
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        return this.isPoweringTo(world, x, y, z, side);
    }

    private boolean checkEmptyChest(World world, int x, int y, int z) {
        return this.getTE(world, x, y, z).isChestEmpty();
    }

    private boolean checkFullChest(World world, int x, int y, int z) {
        return this.getTE(world, x, y, z).isChestFull();
    }

    private boolean isOutputActive(World world, int x, int y, int z) {
        if (this.getType(world, x, y, z) == 16) {
            return world.isDaytime();
        }
        if (this.getType(world, x, y, z) == 17) {
            return world.isRaining();
        }
        if (this.getType(world, x, y, z) == 18) {
            return this.checkEmptyChest(world, x, y, z);
        }
        if (this.getType(world, x, y, z) == 19) {
            return this.checkFullChest(world, x, y, z);
        }
        if (this.getType(world, x, y, z) == 20) {
            return PClo_BlockGate.powered_from_input(world, x, y, z, 0);
        }
        if (this.getType(world, x, y, z) == 21) {
            return this.getTE(world, x, y, z).getBufferOutput();
        }
        TileEntity tileEntity = world.getBlockTileEntity(x, y, z);
        boolean q = false;
        if (tileEntity instanceof PClo_TileEntityGate) {
            q = this.getResult(this.getType(world, x, y, z), PClo_BlockGate.powered_from_input(world, x, y, z, 0), PClo_BlockGate.powered_from_input(world, x, y, z, 1), PClo_BlockGate.powered_from_input(world, x, y, z, 2), (PClo_TileEntityGate)tileEntity);
        }
        return q;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random random) {
        int type = this.getType(world, x, y, z);
        switch (type) {
            case 23: {
                boolean[] powered = new boolean[]{PClo_BlockGate.powered_from_input(world, x, y, z, 0), PClo_BlockGate.powered_from_input(world, x, y, z, 1), PClo_BlockGate.powered_from_input(world, x, y, z, 2), PClo_BlockGate.powered_from_input(world, x, y, z, 3)};
                if (!Arrays.equals(powered, this.getTE((IBlockAccess)world, (int)x, (int)y, (int)z).powered)) {
                    this.getTE((IBlockAccess)world, (int)x, (int)y, (int)z).powered = powered;
                    world.notifyBlockChange(x, y, z, this.blockID);
                }
                return;
            }
            case 20: {
                boolean on = PClo_BlockGate.powered_from_input(world, x, y, z, 0);
                if (!on) {
                    this.unpausePausedBlocks(world, x, y, z);
                }
                if (on && !this.active) {
                    this.spawnMobsFromSpawners(world, x, y, z);
                    this.changeGateState(true, world, x, y, z);
                    break;
                }
                if (on || !this.active) break;
                this.changeGateState(false, world, x, y, z);
                break;
            }
            case 16: {
                if (world.isDaytime() && !this.active) {
                    this.changeGateState(true, world, x, y, z);
                    break;
                }
                if (world.isDaytime() || !this.active) break;
                this.changeGateState(false, world, x, y, z);
                break;
            }
            case 21: {
                boolean state = this.getTE(world, x, y, z).getBufferOutput();
                if (state && !this.active) {
                    this.changeGateState(true, world, x, y, z);
                    break;
                }
                if (state || !this.active) break;
                this.changeGateState(false, world, x, y, z);
                break;
            }
            case 22: {
                boolean state;
                boolean inp = PClo_BlockGate.powered_from_input(world, x, y, z, 0);
                if (inp) {
                    this.getTE(world, x, y, z).repeaterStartHolding();
                }
                if ((state = this.getTE(world, x, y, z).isRepeaterOutputActive()) && !this.active) {
                    this.changeGateState(true, world, x, y, z);
                    break;
                }
                if (state || !this.active) break;
                this.changeGateState(false, world, x, y, z);
                break;
            }
            case 17: {
                if (world.isRaining() && !this.active) {
                    this.changeGateState(true, world, x, y, z);
                    break;
                }
                if (world.isRaining() || !this.active) break;
                this.changeGateState(false, world, x, y, z);
                break;
            }
            case 18: {
                boolean empty = this.checkEmptyChest(world, x, y, z);
                if (empty && !this.active) {
                    this.changeGateState(true, world, x, y, z);
                    break;
                }
                if (empty || !this.active) break;
                this.changeGateState(false, world, x, y, z);
                break;
            }
            case 19: {
                boolean full = this.checkFullChest(world, x, y, z);
                if (full && !this.active) {
                    this.changeGateState(true, world, x, y, z);
                    break;
                }
                if (full || !this.active) break;
                this.changeGateState(false, world, x, y, z);
                break;
            }
            case 13: {
                int CLOCK = 2;
                int DATA = 0;
                int RST = 1;
                if (PClo_BlockGate.powered_from_input(world, x, y, z, RST)) {
                    this.changeGateState(false, world, x, y, z);
                    this.setClock(world, x, y, z, PClo_BlockGate.powered_from_input(world, x, y, z, CLOCK));
                    break;
                }
                if (PClo_BlockGate.powered_from_input(world, x, y, z, CLOCK)) {
                    if (this.getOldClock(world, x, y, z)) break;
                    if (PClo_BlockGate.powered_from_input(world, x, y, z, DATA)) {
                        this.setClock(world, x, y, z, true);
                        this.changeGateState(true, world, x, y, z);
                        break;
                    }
                    this.setClock(world, x, y, z, true);
                    this.changeGateState(false, world, x, y, z);
                    break;
                }
                if (!this.getOldClock(world, x, y, z)) break;
                this.setClock(world, x, y, z, false);
                break;
            }
            case 14: {
                int R = 2;
                int S = 1;
                boolean on = this.isActive();
                if (!on && PClo_BlockGate.powered_from_input(world, x, y, z, S) && !PClo_BlockGate.powered_from_input(world, x, y, z, R)) {
                    this.changeGateState(true, world, x, y, z);
                    break;
                }
                if (!on || !PClo_BlockGate.powered_from_input(world, x, y, z, R) || PClo_BlockGate.powered_from_input(world, x, y, z, S)) break;
                this.changeGateState(false, world, x, y, z);
                break;
            }
            case 15: {
                int T = 0;
                if (PClo_BlockGate.powered_from_input(world, x, y, z, 1) || PClo_BlockGate.powered_from_input(world, x, y, z, 2)) {
                    this.changeGateState(false, world, x, y, z);
                    this.setClock(world, x, y, z, PClo_BlockGate.powered_from_input(world, x, y, z, T));
                    break;
                }
                if (PClo_BlockGate.powered_from_input(world, x, y, z, T)) {
                    if (this.getOldClock(world, x, y, z)) break;
                    this.setClock(world, x, y, z, true);
                    if (!this.isActive()) {
                        this.changeGateState(true, world, x, y, z);
                        break;
                    }
                    this.changeGateState(false, world, x, y, z);
                    break;
                }
                if (!this.getOldClock(world, x, y, z)) break;
                this.setClock(world, x, y, z, false);
                break;
            }
            case 24: {
                int Ri = 0;
                if (PClo_BlockGate.powered_from_input(world, x, y, z, Ri)) {
                    if (this.getOldClock(world, x, y, z)) break;
                    this.setClock(world, x, y, z, true);
                    this.changeGateState(random.nextBoolean(), world, x, y, z);
                    break;
                }
                if (!this.getOldClock(world, x, y, z)) break;
                this.setClock(world, x, y, z, false);
                break;
            }
            default: {
                boolean on = this.isActive();
                boolean outputActive = this.isOutputActive(world, x, y, z);
                if (on && !outputActive) {
                    this.changeGateState(false, world, x, y, z);
                    break;
                }
                if (on || !outputActive) break;
                this.changeGateState(true, world, x, y, z);
            }
        }
    }

    private void spawnMobsFromSpawners(World world, int x, int y, int z) {
        TileEntity te = world.getBlockTileEntity(x + 1, y, z);
        if (te != null && te instanceof TileEntityMobSpawner) {
            this.spawnMobs(world, x, y, z, ((TileEntityMobSpawner)te).getMobID());
        }
        if ((te = world.getBlockTileEntity(x - 1, y, z)) != null && te instanceof TileEntityMobSpawner) {
            this.spawnMobs(world, x, y, z, ((TileEntityMobSpawner)te).getMobID());
        }
        if ((te = world.getBlockTileEntity(x, y, z + 1)) != null && te instanceof TileEntityMobSpawner) {
            this.spawnMobs(world, x, y, z, ((TileEntityMobSpawner)te).getMobID());
        }
        if ((te = world.getBlockTileEntity(x, y, z - 1)) != null && te instanceof TileEntityMobSpawner) {
            this.spawnMobs(world, x, y, z, ((TileEntityMobSpawner)te).getMobID());
        }
        if ((te = world.getBlockTileEntity(x, y + 1, z)) != null && te instanceof TileEntityMobSpawner) {
            this.spawnMobs(world, x, y, z, ((TileEntityMobSpawner)te).getMobID());
        }
    }

    private boolean shouldSpawnParticles(World world, int x, int y, int z) {
        return world.getClosestPlayer((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 16.0) != null;
    }

    private void spawnMobs(World world, int x, int y, int z, String type) {
        int count = 5;
        boolean spawnParticles = this.shouldSpawnParticles(world, x, y, z);
        for (int q = 0; q < count; ++q) {
            EntityLiving entityliving = (EntityLiving)EntityList.createEntityByName(type, world);
            if (entityliving == null) {
                return;
            }
            int c = world.getEntitiesWithinAABB(entityliving.getClass(), AxisAlignedBB.getBoundingBoxFromPool(x, y, z, x + 1, y + 1, z + 1).expand(8.0, 4.0, 8.0)).size();
            if (c >= 6) {
                if (spawnParticles) {
                    double d = world.rand.nextGaussian() * 0.02;
                    double d1 = world.rand.nextGaussian() * 0.02;
                    double d2 = world.rand.nextGaussian() * 0.02;
                    world.spawnParticle("smoke", (double)x + 0.5, (double)y + 0.4, (double)z + 0.5, d, d1, d2);
                }
                return;
            }
            double d3 = (double)x + (world.rand.nextDouble() - world.rand.nextDouble()) * 3.0;
            double d4 = y + world.rand.nextInt(3) - 1;
            double d5 = (double)z + (world.rand.nextDouble() - world.rand.nextDouble()) * 3.0;
            entityliving.setLocationAndAngles(d3, d4, d5, world.rand.nextFloat() * 360.0f, 0.0f);
            if (!world.checkIfAABBIsClear(entityliving.boundingBox) || world.getCollidingBoundingBoxes(entityliving, entityliving.boundingBox).size() != 0) continue;
            world.spawnEntityInWorld(entityliving);
            if (spawnParticles) {
                world.playAuxSFX(2004, x, y, z, 0);
                entityliving.spawnExplosionParticle();
            }
            return;
        }
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int x, int y, int z) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    private void changeGateState(boolean state, World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        TileEntity tileentity = world.getBlockTileEntity(x, y, z);
        changingState = true;
        if (state) {
            world.setBlockWithNotify(x, y, z, mod_PClogic.gateOn.blockID);
        } else {
            world.setBlockWithNotify(x, y, z, mod_PClogic.gateOff.blockID);
        }
        world.setBlockMetadataWithNotify(x, y, z, l);
        changingState = false;
        if (tileentity != null) {
            tileentity.validate();
            world.setBlockTileEntity(x, y, z, tileentity);
        }
        PClo_BlockGate.hugeUpdate(world, x, y, z, this.blockID);
    }

    private boolean isSpecialDevice(int type) {
        return type == 13 || type == 14 || type == 15 || type == 24 || type == 22;
    }

    private boolean hasTwoOutputs(int type) {
        return type == 14;
    }

    private void unpausePausedBlocks(World world, int x, int y, int z) {
        int type = this.getType(world, x, y, z);
        if (type == 20) {
            TileEntity te = world.getBlockTileEntity(x + 1, y, z);
            if (te != null && te instanceof PClo_TileEntityPulsar) {
                ((PClo_TileEntityPulsar)te).paused = false;
            }
            if ((te = world.getBlockTileEntity(x - 1, y, z)) != null && te instanceof PClo_TileEntityPulsar) {
                ((PClo_TileEntityPulsar)te).paused = false;
            }
            if ((te = world.getBlockTileEntity(x, y, z + 1)) != null && te instanceof PClo_TileEntityPulsar) {
                ((PClo_TileEntityPulsar)te).paused = false;
            }
            if ((te = world.getBlockTileEntity(x, y, z - 1)) != null && te instanceof PClo_TileEntityPulsar) {
                ((PClo_TileEntityPulsar)te).paused = false;
            }
            if ((te = world.getBlockTileEntity(x, y + 1, z)) != null && te instanceof PClo_TileEntityPulsar) {
                ((PClo_TileEntityPulsar)te).paused = false;
            }
            if ((te = world.getBlockTileEntity(x, y - 1, z)) != null && te instanceof PClo_TileEntityPulsar) {
                ((PClo_TileEntityPulsar)te).paused = false;
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int l) {
        int type = this.getType(world, x, y, z);
        if (type == 21) {
            return;
        }
        if (type == 23) {
            world.scheduleBlockUpdate(x, y, z, this.blockID, 1);
        }
        if (type == 16 || type == 17 || type == 18 || type == 19) {
            world.scheduleBlockUpdate(x, y, z, this.blockID, 1);
            return;
        }
        if (this.isSpecialDevice(this.getType(world, x, y, z))) {
            world.scheduleBlockUpdate(x, y, z, this.blockID, 1);
            return;
        }
        boolean outputActive = this.isOutputActive(world, x, y, z);
        boolean on = this.isActive();
        if (on && !outputActive) {
            world.scheduleBlockUpdate(x, y, z, this.blockID, 1);
        } else if (!on && outputActive) {
            world.scheduleBlockUpdate(x, y, z, this.blockID, 1);
        }
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        int meta = iblockaccess.getBlockMetadata(x, y, z);
        int rotation = this.getRotation(meta);
        int type = this.getType(iblockaccess, x, y, z);
        if (type == 23) {
            World world = ModLoader.getMinecraftInstance().theWorld;
            int variant = this.getTE(iblockaccess, x, y, z).getCrossingVariant();
            switch (variant) {
                case 0: {
                    if (side == 3) {
                        return PClo_BlockGate.powered_from_input(world, x, y, z, 0);
                    }
                    if (side != 4) break;
                    return PClo_BlockGate.powered_from_input(world, x, y, z, 1);
                }
                case 1: {
                    if (side == 3) {
                        return PClo_BlockGate.powered_from_input(world, x, y, z, 0);
                    }
                    if (side != 5) break;
                    return PClo_BlockGate.powered_from_input(world, x, y, z, 2);
                }
                case 2: {
                    if (side == 2) {
                        return PClo_BlockGate.powered_from_input(world, x, y, z, 3);
                    }
                    if (side != 4) break;
                    return PClo_BlockGate.powered_from_input(world, x, y, z, 1);
                }
                case 3: {
                    if (side == 2) {
                        return PClo_BlockGate.powered_from_input(world, x, y, z, 3);
                    }
                    if (side != 5) break;
                    return PClo_BlockGate.powered_from_input(world, x, y, z, 2);
                }
            }
            return false;
        }
        boolean on = this.isActive();
        if (!on) {
            return false;
        }
        if (type == 20) {
            return false;
        }
        if (type == 16 || type == 17) {
            return true;
        }
        if (rotation == 0 && side == 3 || rotation == 2 && side == 3 && this.hasTwoOutputs(this.getType(iblockaccess, x, y, z))) {
            return true;
        }
        if (rotation == 1 && side == 4 || rotation == 3 && side == 4 && this.hasTwoOutputs(this.getType(iblockaccess, x, y, z))) {
            return true;
        }
        if (rotation == 2 && side == 2 || rotation == 0 && side == 2 && this.hasTwoOutputs(this.getType(iblockaccess, x, y, z))) {
            return true;
        }
        return rotation == 3 && side == 5 || rotation == 1 && side == 5 && this.hasTwoOutputs(this.getType(iblockaccess, x, y, z));
    }

    boolean calcGates(String stri, boolean A, boolean B, boolean C) {
        int i;
        stri = stri.trim();
        int h = 0;
        if (stri.length() < 1) {
            return false;
        }
        if (stri.length() == 1) {
            char c = stri.charAt(0);
            if (c == 'l' || c == 'L') {
                return B;
            }
            if (c == 'b' || c == 'B') {
                return A;
            }
            if (c == 'r' || c == 'R') {
                return C;
            }
            return false;
        }
        if (stri.charAt(0) == '(') {
            h = 1;
            for (i = 1; i < stri.length() - 1; ++i) {
                if (stri.charAt(i) == '(') {
                    ++h;
                }
                if (stri.charAt(i) == ')' && --h == 0) break;
            }
            if (h > 0) {
                if (stri.charAt(stri.length() - 1) == ')') {
                    return this.calcGates(stri.substring(1, stri.length() - 1), A, B, C);
                }
                return this.calcGates(stri.substring(1), A, B, C);
            }
            h = 0;
        }
        block8: for (i = stri.length() - 1; i >= 0; --i) {
            switch (stri.charAt(i)) {
                case '(': {
                    --h;
                    continue block8;
                }
                case ')': {
                    ++h;
                    continue block8;
                }
                case '&': {
                    if (h > 0) continue block8;
                    return this.calcGates(stri.substring(0, i), A, B, C) & this.calcGates(stri.substring(i + 1), A, B, C);
                }
                case '|': {
                    if (h > 0) continue block8;
                    return this.calcGates(stri.substring(0, i), A, B, C) | this.calcGates(stri.substring(i + 1), A, B, C);
                }
                case '^': {
                    if (h > 0) continue block8;
                    return this.calcGates(stri.substring(0, i), A, B, C) ^ this.calcGates(stri.substring(i + 1), A, B, C);
                }
            }
        }
        if (stri.charAt(0) == '!') {
            return !this.calcGates(stri.substring(1), A, B, C);
        }
        return false;
    }

    private boolean getResult(int gateType, boolean A, boolean B, boolean C, PClo_TileEntityGate tileEntety) {
        if (gateType == 0) {
            return !A;
        }
        if (gateType == 1) {
            return B & C;
        }
        if (gateType == 2) {
            return !(B & C);
        }
        if (gateType == 3) {
            return B | C;
        }
        if (gateType == 4) {
            return !(B | C);
        }
        if (gateType == 5) {
            return B != C;
        }
        if (gateType == 6) {
            return B == C;
        }
        if (gateType == 7) {
            return A & B & C;
        }
        if (gateType == 8) {
            return !(A & B & C);
        }
        if (gateType == 9) {
            return A | B | C;
        }
        if (gateType == 10) {
            return !(A | B | C);
        }
        if (gateType == 11) {
            return A != B | B != C | C != A;
        }
        if (gateType == 12) {
            return A == B && B == C && C == A;
        }
        if (gateType == 25) {
            return this.calcGates(tileEntety.programm, A, B, C);
        }
        return false;
    }

    public static boolean powered_from_input(World world, int x, int y, int z, int inp) {
        int rotation = PClo_BlockGate.getRotation_static(world.getBlockMetadata(x, y, z));
        int N0 = 0;
        int N1 = 1;
        int N2 = 2;
        int N3 = 3;
        if (inp == 0) {
            N0 = 0;
            N1 = 1;
            N2 = 2;
            N3 = 3;
        }
        if (inp == 1) {
            N0 = 3;
            N1 = 0;
            N2 = 1;
            N3 = 2;
        } else if (inp == 2) {
            N0 = 1;
            N1 = 2;
            N2 = 3;
            N3 = 0;
        } else if (inp == 3) {
            N0 = 2;
            N1 = 3;
            N2 = 0;
            N3 = 1;
        }
        if (rotation == N0) {
            return world.isBlockIndirectlyProvidingPowerTo(x, y, z + 1, 3) || world.getBlockId(x, y, z + 1) == Block.redstoneWire.blockID && world.getBlockMetadata(x, y, z + 1) > 0;
        }
        if (rotation == N1) {
            return world.isBlockIndirectlyProvidingPowerTo(x - 1, y, z, 4) || world.getBlockId(x - 1, y, z) == Block.redstoneWire.blockID && world.getBlockMetadata(x - 1, y, z) > 0;
        }
        if (rotation == N2) {
            return world.isBlockIndirectlyProvidingPowerTo(x, y, z - 1, 2) || world.getBlockId(x, y, z - 1) == Block.redstoneWire.blockID && world.getBlockMetadata(x, y, z - 1) > 0;
        }
        if (rotation == N3) {
            return world.isBlockIndirectlyProvidingPowerTo(x + 1, y, z, 5) || world.getBlockId(x + 1, y, z) == Block.redstoneWire.blockID && world.getBlockMetadata(x + 1, y, z) > 0;
        }
        return false;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLiving entityliving) {
        if (this.getType(world, x, y, z) == 23) {
            world.scheduleBlockUpdate(x, y, z, this.blockID, 1);
            return;
        }
        int l = ((MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) + 2) % 4;
        if (PC_Utils.isPlacingReversed()) {
            l = PC_Utils.reverseSide(l);
        }
        world.setBlockMetadataWithNotify(x, y, z, l);
        boolean flag = this.isOutputActive(world, x, y, z);
        if (flag) {
            world.scheduleBlockUpdate(x, y, z, this.blockID, 1);
        }
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        PClo_BlockGate.hugeUpdate(world, x, y, z, this.blockID);
        super.onBlockAdded(world, x, y, z);
    }

    public static void hugeUpdate(World world, int x, int y, int z, int id) {
        world.notifyBlocksOfNeighborChange(x, y, z, id);
        world.notifyBlocksOfNeighborChange(x + 1, y, z, id);
        world.notifyBlocksOfNeighborChange(x - 1, y, z, id);
        world.notifyBlocksOfNeighborChange(x, y, z + 1, id);
        world.notifyBlocksOfNeighborChange(x, y, z - 1, id);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, id);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, id);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        if (!this.active) {
            return;
        }
        if (random.nextInt(3) != 0) {
            return;
        }
        double d = (double)((float)x + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d1 = (double)((float)y + 0.2f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        double d2 = (double)((float)z + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
        world.spawnParticle("reddust", d, d1, d2, 0.0, 0.0, 0.0);
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        Block bhold;
        ItemStack ihold = player.getCurrentEquippedItem();
        if (ihold != null && ihold.getItem() instanceof ItemBlock && ihold.getItem().shiftedIndex != mod_PClogic.gateOn.blockID && ihold.getItem().shiftedIndex != mod_PClogic.gateOff.blockID && (bhold = Block.blocksList[ihold.getItem().shiftedIndex]) instanceof PC_IBlockType) {
            return false;
        }
        if (this.getType(world, x, y, z) == 23) {
            int side = ((MathHelper.floor_double((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5) & 3) + 2) % 4;
            if (side == 0 || side == 2) {
                this.getTE(world, x, y, z).toggleCrossingZ();
            }
            if (side == 1 || side == 3) {
                this.getTE(world, x, y, z).toggleCrossingX();
            }
        }
        if (this.getType(world, x, y, z) == 25) {
            PC_Utils.openGres(player, new PClo_GuiCustomGate(this.getTE(world, x, y, z)));
            boolean outputActive = this.isOutputActive(world, x, y, z);
            boolean on = this.isActive();
            if (on && !outputActive) {
                this.changeGateState(false, world, x, y, z);
            } else if (!on && outputActive) {
                this.changeGateState(true, world, x, y, z);
            }
            return true;
        }
        if (this.getType(world, x, y, z) == 21) {
            PC_Utils.openGres(player, new PClo_GuiDelayer(this.getTE(world, x, y, z), 1));
            return true;
        }
        if (this.getType(world, x, y, z) == 22) {
            PC_Utils.openGres(player, new PClo_GuiDelayer(this.getTE(world, x, y, z), 0));
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getBlockFlags(World world, PC_CoordI pos) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_HARVEST");
        set.add("TRANSLUCENT");
        set.add("REDSTONE");
        set.add("LOGIC");
        set.add("GATE");
        return set;
    }

    @Override
    public Set<String> getItemFlags(int damage) {
        HashSet<String> set = new HashSet<String>();
        set.add("NO_BUILD");
        return set;
    }
}

