/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.src.Block;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_Utils;
import net.minecraft.src.PClo_RadioManager;
import net.minecraft.src.PClo_TileEntityRadio;
import net.minecraft.src.SaveHandler;
import net.minecraft.src.TileEntity;
import net.minecraft.src.mod_PClogic;

public class PCfix_TileEntityRadioPlaceholder
extends TileEntity {
    public String channel = mod_PClogic.default_radio_channel;
    public int type = 0;
    public int dim = 0;
    private boolean loaded = false;

    @Override
    public void updateEntity() {
        if (!this.loaded) {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(((SaveHandler)this.worldObj.saveHandler).getSaveDirectory() + "/radio/" + this.xCoord + "_" + this.yCoord + "_" + this.zCoord));
                String type_s = (String)props.get("type");
                if (type_s == null) {
                    throw new NullPointerException();
                }
                String channel_s = (String)props.get("channel");
                if (channel_s == null) {
                    throw new NullPointerException();
                }
                this.type = Integer.parseInt(type_s);
                this.channel = channel_s;
                PC_Logger.fine("Loaded old radio entry for block at [" + this.xCoord + "," + this.yCoord + "," + this.zCoord + "], channel=" + this.channel + ", type=" + this.type);
                Block block = mod_PClogic.radio;
                int i = this.xCoord;
                int j = this.yCoord;
                int k = this.zCoord;
                if (this.worldObj.setBlockWithNotify(i, j, k, block.blockID)) {
                    block.onBlockPlaced(this.worldObj, i, j, k, 0);
                    this.worldObj.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                    PClo_TileEntityRadio ter = (PClo_TileEntityRadio)this.worldObj.getBlockTileEntity(i, j, k);
                    if (ter == null) {
                        ter = (PClo_TileEntityRadio)((BlockContainer)block).getBlockEntity();
                    }
                    ter.channel = this.channel;
                    ter.setType(this.type);
                    ter.dim = PC_Utils.mc().thePlayer.dimension;
                    this.worldObj.setBlockTileEntity(this.xCoord, this.yCoord, this.zCoord, ter);
                    if (this.type == 1) {
                        boolean bl = ter.active = PClo_RadioManager.getSignalStrength(this.channel) > 0;
                        if (ter.active) {
                            this.worldObj.setBlockMetadataWithNotify(i, j, k, 1);
                        }
                    }
                    this.worldObj.scheduleBlockUpdate(i, j, k, block.blockID, 1);
                }
                PC_Logger.fine("Radio device replaced with new version.");
            }
            catch (FileNotFoundException e) {
                PC_Logger.throwing(this.getClass().getName(), "updateEntity()", e);
                e.printStackTrace();
            }
            catch (IOException e) {
                PC_Logger.throwing(this.getClass().getName(), "updateEntity()", e);
                e.printStackTrace();
            }
            catch (NumberFormatException e) {
                PC_Logger.throwing(this.getClass().getName(), "updateEntity()", e);
                e.printStackTrace();
            }
            catch (Throwable t) {
                PC_Logger.throwing(this.getClass().getName(), "updateEntity()", t);
                t.printStackTrace();
            }
            this.loaded = true;
        }
    }

    public boolean canUpdate() {
        return true;
    }
}

