/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.PC_Renderer;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.Tessellator;

public class PCco_Renderer {
    public static int crystalRenderer = 0;

    public static boolean renderBlockByType(RenderBlocks renderblocks, IBlockAccess blockAccess, int i, int j, int k, Block block, int rtype) {
        if (rtype == crystalRenderer) {
            return PCco_Renderer.renderBlockCrystal(renderblocks, blockAccess, i, j, k, block);
        }
        return false;
    }

    public static boolean renderBlockCrystal(RenderBlocks renderblocks, IBlockAccess iblockaccess, int i, int j, int k, Block block) {
        RenderEngine renderengine = ModLoader.getMinecraftInstance().renderEngine;
        Tessellator tessellator = Tessellator.instance;
        if (block instanceof PC_ISwapTerrain) {
            tessellator.draw();
            tessellator.startDrawingQuads();
            renderengine.bindTexture(renderengine.getTexture(((PC_ISwapTerrain)((Object)block)).getTerrainFile()));
            boolean gf = RenderBlocks.cfgGrassFix;
            RenderBlocks.cfgGrassFix = false;
            Random posRand = new Random(i + i * j * k + k + iblockaccess.getBlockMetadata(i, j, k));
            for (int q = 3 + posRand.nextInt(2); q > 0; --q) {
                float x = posRand.nextFloat() * 0.6f;
                float y = q == 2 ? 0.001f : posRand.nextFloat() * 0.6f;
                float z = posRand.nextFloat() * 0.6f;
                float a = x + 0.3f + posRand.nextFloat() * (0.7f - x);
                float b = y + 0.3f + posRand.nextFloat() * (0.7f - y);
                float c = z + 0.3f + posRand.nextFloat() * (0.7f - z);
                block.setBlockBounds(x, y, z, a, b, c);
                renderblocks.renderStandardBlock(block, i, j, k);
            }
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            RenderBlocks.cfgGrassFix = gf;
            tessellator.draw();
            tessellator.startDrawingQuads();
            renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
            return true;
        }
        return false;
    }

    public static void renderInvBlockByType(RenderBlocks renderblocks, Block block, int meta, int rtype) {
        if (rtype == crystalRenderer) {
            PCco_Renderer.renderInvBlockCrystal(renderblocks, block, meta);
        }
    }

    public static void renderInvBlockCrystal(RenderBlocks renderblocks, Block block, int meta) {
        RenderEngine renderengine = ModLoader.getMinecraftInstance().renderEngine;
        if (block instanceof PC_ISwapTerrain) {
            renderengine.bindTexture(renderengine.getTexture(((PC_ISwapTerrain)((Object)block)).getTerrainFile()));
            Random posRand = new Random(meta);
            for (int q = 3 + posRand.nextInt(3); q > 0; --q) {
                float x = 0.0f + posRand.nextFloat() * 0.6f;
                float y = 0.0f + posRand.nextFloat() * 0.6f;
                float z = 0.0f + posRand.nextFloat() * 0.6f;
                float a = 0.2f + Math.max(posRand.nextFloat() * (0.7f - x), 0.3f);
                float b = 0.2f + Math.max(posRand.nextFloat() * (0.7f - y), 0.3f);
                float c = 0.2f + Math.max(posRand.nextFloat() * (0.7f - z), 0.3f);
                block.setBlockBounds(x, y, z, x + a, y + b, z + c);
                PC_Renderer.renderInvBox(renderblocks, block, meta);
            }
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
        }
    }
}

