/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.AchievementList;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.PC_GresButton;
import net.minecraft.src.PC_GresInventory;
import net.minecraft.src.PC_GresInventoryPlayer;
import net.minecraft.src.PC_GresLayoutH;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.PC_GresWindow;
import net.minecraft.src.PC_IGresBase;
import net.minecraft.src.PC_IGresGui;
import net.minecraft.src.PC_Lang;
import net.minecraft.src.PCco_CraftingToolManager;
import net.minecraft.src.PCco_SlotDirectCrafting;
import net.minecraft.src.Slot;

public class PCco_GuiCraftingTool
implements PC_IGresBase {
    private PC_GresButton buttonPrev;
    private PC_GresButton buttonNext;
    private EntityPlayer player;
    private PC_GresInventory craftingToolInventory;
    private PCco_CraftingToolManager craftingToolManager;
    private static int page = 0;
    private static final int invWidth = 13;
    private static final int invHeight = 7;

    public PCco_GuiCraftingTool(EntityPlayer player) {
        this.player = player;
        player.addStat(AchievementList.openInventory, 1);
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public void initGui(PC_IGresGui gui) {
        PC_GresWindow w = new PC_GresWindow(PC_Lang.tr("pc.gui.craftingTool.title"));
        w.padding.setTo(10, 3);
        w.gapUnderTitle = 8;
        this.craftingToolManager = new PCco_CraftingToolManager();
        this.craftingToolInventory = new PC_GresInventory(13, 7);
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 7; ++j) {
                int indexSlot = 91 + j * 13 + i;
                this.craftingToolInventory.setSlot(new PCco_SlotDirectCrafting(this.player, null, indexSlot, 0, 0), i, j);
            }
        }
        w.add(this.craftingToolInventory);
        PC_GresWidget hg = new PC_GresLayoutH().setAlignV(PC_GresWidget.PC_GresAlign.TOP);
        this.buttonPrev = (PC_GresButton)new PC_GresButton("<<<").setMinWidth(30);
        hg.add(this.buttonPrev);
        if (page <= 0) {
            page = 0;
            this.buttonPrev.enable(false);
        }
        hg.add(new PC_GresInventoryPlayer(false));
        this.buttonNext = (PC_GresButton)new PC_GresButton(">>>").setMinWidth(30);
        hg.add(this.buttonNext);
        if (page >= this.getMaxPages()) {
            page = this.getMaxPages();
            this.buttonNext.enable(false);
        }
        w.add(hg);
        gui.add(w);
        gui.setCanShiftTransfer(false);
        this.loadSlotsForCorrentPage(gui);
        this.actionPerformed(this.craftingToolInventory, gui);
    }

    private void loadSlotsForCorrentPage(PC_IGresGui gui) {
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 7; ++j) {
                int indexInList = page * 13 * 7 + j * 13 + i;
                ((PCco_SlotDirectCrafting)this.craftingToolInventory.getSlot(i, j)).setProduct(this.craftingToolManager.getItemForSlotNumber(indexInList));
            }
        }
        this.actionPerformed(this.craftingToolInventory, gui);
    }

    private int getMaxPages() {
        return this.craftingToolManager.stacklist.size() / 91;
    }

    @Override
    public void onGuiClosed(PC_IGresGui gui) {
        this.player.inventory.closeChest();
    }

    @Override
    public void actionPerformed(PC_GresWidget widget, PC_IGresGui gui) {
        if (widget == this.craftingToolInventory) {
            for (int i = 0; i < 13; ++i) {
                for (int j = 0; j < 7; ++j) {
                    Slot slot = this.craftingToolInventory.getSlot(i, j);
                    if (slot == null) continue;
                    ((PCco_SlotDirectCrafting)slot).updateAvailability();
                }
            }
        } else if (widget == this.buttonPrev) {
            if (--page <= 0) {
                page = 0;
                this.buttonPrev.enable(false);
            }
            if (page < this.getMaxPages()) {
                this.buttonNext.enable(true);
            }
            this.loadSlotsForCorrentPage(gui);
        } else if (widget == this.buttonNext) {
            if (++page >= this.getMaxPages()) {
                page = this.getMaxPages();
                this.buttonNext.enable(false);
            }
            if (page > 0) {
                this.buttonPrev.enable(true);
            }
            this.loadSlotsForCorrentPage(gui);
        }
    }

    @Override
    public void onEscapePressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onReturnPressed(PC_IGresGui gui) {
        gui.close();
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory) {
    }
}

