/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_InvUtils;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.PC_Struct2;
import net.minecraft.src.PC_Struct3;
import net.minecraft.src.World;
import net.minecraft.src.mod_PCcore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PC_TreeHarvestingManager {
    private static final File folder = new File(Minecraft.getMinecraftDir() + "/PowerCraft" + "/trees");
    private static boolean treesLoaded = false;
    private static ArrayList<PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>>> trees = new ArrayList();
    public static int MAXLOGS = 1000;
    private static int cnt = 0;

    public static void registerTree(int WOOD_ID, int WOOD_META, int LEAVES_ID, int LEAVES_META, int SAPLING_ID, int SAPLING_META) {
        PC_Logger.finest("Registering new tree into Tree Harvesting Manager.");
        trees.add(new PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>>(new PC_Struct2<Integer, Integer>(WOOD_ID, WOOD_META), new PC_Struct2<Integer, Integer>(LEAVES_ID, LEAVES_META), new PC_Struct2<Integer, Integer>(SAPLING_ID, SAPLING_META)));
    }

    public static PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>> getStructForTree(int wood_id, int wood_meta) {
        for (PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>> tree : trees) {
            if ((Integer)((PC_Struct2)tree.a).a != wood_id || (Integer)((PC_Struct2)tree.a).b != wood_meta && (Integer)((PC_Struct2)tree.a).b != -1) continue;
            return tree;
        }
        return null;
    }

    public static boolean isBlockTreeWood(int id, int meta) {
        for (PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>> tree : trees) {
            if ((Integer)((PC_Struct2)tree.a).a != id || (Integer)((PC_Struct2)tree.a).b != meta && (Integer)((PC_Struct2)tree.a).b != -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockTreeSapling(int id, int meta) {
        for (PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>> tree : trees) {
            if (tree.c == null || (Integer)((PC_Struct2)tree.c).a != id || (Integer)((PC_Struct2)tree.c).b != meta && (Integer)((PC_Struct2)tree.c).b != -1) continue;
            return true;
        }
        return false;
    }

    public static ItemStack[] harvestTreeAt(World world, PC_CoordI treeStart) {
        PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>> treeData = PC_TreeHarvestingManager.getStructForTree(treeStart.getId(world), treeStart.getMeta(world));
        ArrayList<ItemStack> harvestedStacks = new ArrayList<ItemStack>();
        if (treeData != null) {
            cnt = 0;
            PC_TreeHarvestingManager.chopTree(world, treeStart, treeStart, harvestedStacks, treeData);
            if (harvestedStacks.size() > 0) {
                return PC_InvUtils.mergeStacks(PC_InvUtils.stacksToArray(harvestedStacks));
            }
        }
        return null;
    }

    public static void chopTree(World world, PC_CoordI treeRootPos, PC_CoordI pos, ArrayList<ItemStack> harvestedStacks, PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>> treeData) {
        if (cnt >= MAXLOGS || pos.distanceHorizontalTo(treeRootPos) > 10.0) {
            return;
        }
        int id = pos.getId(world);
        int meta = pos.getMeta(world);
        int wood_id = (Integer)((PC_Struct2)treeData.a).a;
        int wood_meta = (Integer)((PC_Struct2)treeData.a).b;
        int leaves_id = (Integer)((PC_Struct2)treeData.b).a;
        int leaves_meta = (Integer)((PC_Struct2)treeData.b).b;
        int sapling_id = (Integer)((PC_Struct2)treeData.c).a;
        int sapling_meta = (Integer)((PC_Struct2)treeData.c).b;
        if (id == wood_id && (meta == wood_meta || wood_meta == -1) || (meta & 3) == leaves_meta || leaves_meta == -1) {
            int dropI = Block.blocksList[id].idDropped(meta, world.rand, 0);
            int dropM = Block.blocksList[id].damageDropped(meta);
            int dropQ = Block.blocksList[id].quantityDropped(world.rand);
            ItemStack dropped = new ItemStack(dropI, dropQ, dropM);
            if (dropQ > 0 && dropI > 0 && Item.itemsList[dropI] != null) {
                harvestedStacks.add(dropped);
            }
            pos.setBlock(world, 0, 0);
            if (world.rand.nextInt(10 - (id == wood_id && (meta == wood_meta || wood_meta == -1) ? 8 : 0)) == 0 && mod_PCcore.soundsEnabled) {
                world.playAuxSFX(2001, pos.x, pos.y, pos.z, id + (meta << 12));
            }
            if (cnt == 0) {
                if (pos.offset(0, 1, 0).getId(world) != wood_id || pos.offset(0, 1, 0).getMeta(world) != wood_meta && wood_meta != -1) {
                    return;
                }
                if (pos.offset(0, 2, 0).getId(world) != wood_id || pos.offset(0, 2, 0).getMeta(world) != wood_meta && wood_meta != -1) {
                    return;
                }
                if (pos.offset(0, 3, 0).getId(world) != wood_id || pos.offset(0, 3, 0).getMeta(world) != wood_meta && wood_meta != -1) {
                    return;
                }
            }
            if (pos.offset(0, -1, 0).getId(world) == Block.dirt.blockID && sapling_id > 0 && sapling_meta >= 0) {
                pos.setBlock(world, sapling_id, sapling_meta);
            }
            if (++cnt >= MAXLOGS) {
                return;
            }
            for (int x = pos.x - 1; x <= pos.x + 1; ++x) {
                for (int y = pos.y - 1; y <= pos.y + 1; ++y) {
                    for (int z = pos.z - 1; z <= pos.z + 1; ++z) {
                        PC_CoordI here = new PC_CoordI(x, y, z);
                        int here_id = here.getId(world);
                        int here_meta = here.getMeta(world);
                        if ((here_id != wood_id || here_meta != wood_meta && wood_meta != -1) && (here_id != leaves_id || (here_meta & 3) != leaves_meta && leaves_meta != -1)) continue;
                        PC_TreeHarvestingManager.chopTree(world, treeRootPos, here, harvestedStacks, treeData);
                    }
                }
            }
        }
    }

    public static void loadTrees() {
        String[] files;
        if (treesLoaded) {
            return;
        }
        PC_Logger.finer("Loading XML configuration for trees.");
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!new File(folder + "/" + "default.xml").exists()) {
            try {
                PC_Logger.finest("Generating default trees configuration file in /PowerCraft/trees.xml");
                FileWriter out = new FileWriter(new File(folder + "/" + "default.xml"));
                try {
                    out.write("<?xml version='1.1' encoding='UTF-8' ?>\n<!-- \n This file defines trees harvestable automatically (eg. by harvester machine)\n The purpose of this system is to make PowerCraft compatible with new trees from mods.\n All files in 'trees' directory will be parsed, so please DO NOT EDIT THIS FILE but make your own.\n-->\n\n<trees>\n\n\t<tree name='Oak'>\n\t\t<wood id='17' meta='0' />\n\t\t<leaves id='18' meta='0' />\n\t\t<sapling id='6' meta='0' />\n\t</tree>\n\n\t<tree name='Pine'>\n\t\t<wood id='17' meta='1' />\n\t\t<leaves id='18' meta='1' />\n\t\t<sapling id='6' meta='1' />\n\t</tree>\n\n\t<tree name='Birch'>\n\t\t<wood id='17' meta='2' />\n\t\t<leaves id='18' meta='2' />\n\t\t<sapling id='6' meta='2' />\n\t</tree>\n\n\t<tree name='Jungle'>\n\t\t<wood id='17' meta='3' />\n\t\t<leaves id='18' meta='3' />\n\t\t<sapling id='6' meta='3' />\n\t</tree>\n\n\t<tree name='Huge Brown Mushroom'>\n\t\t<wood id='99' meta='-1' />\n\t\t<sapling id='39' meta='0' />\n\t</tree>\n\n\t<tree name='Huge Red Mushroom'>\n\t\t<wood id='100' meta='-1' />\n\t\t<sapling id='40' meta='0' />\n\t</tree>\n\n</trees>");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String filename : files = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.matches("[^.]+[.]xml");
            }
        })) {
            PC_Logger.finest("* loading file " + filename + "...");
            File file = new File(folder + "/" + filename);
            PC_TreeHarvestingManager.parseFile(file);
        }
        PC_Logger.finer("Trees configuration loaded.");
        treesLoaded = true;
    }

    private static void parseFile(File file) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            doc.getDocumentElement().normalize();
            NodeList treesList = doc.getElementsByTagName("tree");
            for (int i = 0; i < treesList.getLength(); ++i) {
                Node treeNode = treesList.item(i);
                if (treeNode.getNodeType() != 1) continue;
                Element tree = (Element)treeNode;
                NodeList woodlist = tree.getElementsByTagName("wood");
                if (woodlist.getLength() != 1) {
                    PC_Logger.warning("Tree manager - parseFile - Error while parsing " + file + " - invalid no. of <wood> tags in <tree>");
                    continue;
                }
                Element wood = (Element)woodlist.item(0);
                NodeList leaveslist = tree.getElementsByTagName("leaves");
                Element leaves = null;
                if (leaveslist.getLength() == 1) {
                    leaves = (Element)leaveslist.item(0);
                }
                NodeList saplinglist = tree.getElementsByTagName("sapling");
                Element sapling = null;
                if (saplinglist.getLength() == 1) {
                    sapling = (Element)saplinglist.item(0);
                }
                PC_Struct2<Integer, Integer> leavesStruct = new PC_Struct2<Integer, Integer>(-1, -1);
                PC_Struct2<Integer, Integer> saplingStruct = new PC_Struct2<Integer, Integer>(-1, -1);
                String woodId_s = wood.getAttribute("id");
                if (woodId_s.equals("") || !woodId_s.matches("[0-9]+")) {
                    PC_Logger.warning("Tree manager - parseFile - Error while parsing " + file + " - bad wood ID");
                    continue;
                }
                int wood_id = Integer.parseInt(woodId_s);
                String woodMeta_s = wood.getAttribute("meta");
                if (woodMeta_s.equals("") || !woodMeta_s.matches("-?[0-9]+")) {
                    PC_Logger.warning("Tree manager - parseFile - Error while parsing " + file + " - bad wood meta");
                    continue;
                }
                int wood_meta = Integer.parseInt(woodMeta_s);
                PC_Struct2<Integer, Integer> woodStruct = new PC_Struct2<Integer, Integer>(wood_id, wood_meta);
                if (leaves != null) {
                    String leavesId_s = leaves.getAttribute("id");
                    if (leavesId_s.equals("") || !leavesId_s.matches("[0-9]+")) {
                        PC_Logger.warning("Tree manager - parseFile - Error while parsing " + file + " - bad leaves ID");
                        continue;
                    }
                    int leaves_id = Integer.parseInt(leavesId_s);
                    String leavesMeta_s = leaves.getAttribute("meta");
                    if (leavesMeta_s.equals("") || !leavesMeta_s.matches("-?[0-9]+")) {
                        PC_Logger.warning("Tree manager - parseFile - Error while parsing " + file + " - bad leaves meta");
                        continue;
                    }
                    int leaves_meta = Integer.parseInt(leavesMeta_s);
                    leavesStruct = new PC_Struct2<Integer, Integer>(leaves_id, leaves_meta);
                }
                if (sapling != null) {
                    String saplingId_s = sapling.getAttribute("id");
                    if (saplingId_s.equals("") || !saplingId_s.matches("[0-9]+")) {
                        PC_Logger.warning("Tree manager - parseFile - Error while parsing " + file + " - bad sapling ID");
                        continue;
                    }
                    int sapling_id = Integer.parseInt(saplingId_s);
                    String saplingMeta_s = sapling.getAttribute("meta");
                    if (saplingMeta_s.equals("") || !saplingMeta_s.matches("[0-9]+")) {
                        PC_Logger.warning("Tree manager - parseFile - Error while parsing " + file + " - bad sapling meta");
                        continue;
                    }
                    int sapling_meta = Integer.parseInt(saplingMeta_s);
                    saplingStruct = new PC_Struct2<Integer, Integer>(sapling_id, sapling_meta);
                }
                PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>> struct = new PC_Struct3<PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>, PC_Struct2<Integer, Integer>>(woodStruct, leavesStruct, saplingStruct);
                trees.add(struct);
                PC_Logger.finest("   - Tree \"" + tree.getAttribute("name") + "\" loaded. -> " + struct);
            }
        }
        catch (SAXParseException err) {
            PC_Logger.severe("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            PC_Logger.severe(" " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

