/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ModLoader;
import net.minecraft.src.PC_CoordF;
import net.minecraft.src.PC_IRotatedBox;
import net.minecraft.src.PC_ISpecialInventoryTextures;
import net.minecraft.src.PC_ISwapTerrain;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderManager;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class PC_Renderer {
    public static int swapTerrainRenderer = 0;
    public static int rotatedBoxRenderer = 0;

    public static boolean renderBlockByType(RenderBlocks renderblocks, IBlockAccess blockAccess, int x, int y, int z, Block block, int rtype) {
        if (rtype == swapTerrainRenderer) {
            return PC_Renderer.renderBlockSwapTerrain(renderblocks, blockAccess, x, y, z, block);
        }
        if (rtype == rotatedBoxRenderer) {
            return PC_Renderer.renderBlockRotatedBox(renderblocks, blockAccess, x, y, z, block);
        }
        return false;
    }

    public static boolean renderBlockSwapTerrain(RenderBlocks renderblocks, IBlockAccess blockAccess, int x, int y, int z, Block block) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.draw();
        tessellator.startDrawingQuads();
        boolean swapped = PC_Renderer.swapTerrain(block);
        boolean gf = RenderBlocks.cfgGrassFix;
        RenderBlocks.cfgGrassFix = false;
        block.setBlockBoundsBasedOnState(blockAccess, x, y, z);
        renderblocks.renderStandardBlock(block, x, y, z);
        RenderBlocks.cfgGrassFix = gf;
        tessellator.draw();
        tessellator.startDrawingQuads();
        PC_Renderer.resetTerrain(swapped);
        return true;
    }

    public static boolean renderBlockRotatedBox(RenderBlocks renderblocks, IBlockAccess blockAccess, int x, int y, int z, Block block) {
        Tessellator tessellator = Tessellator.instance;
        int metaAt = blockAccess.getBlockMetadata(x, y, z);
        if (block instanceof PC_IRotatedBox) {
            int l;
            tessellator.draw();
            tessellator.startDrawingQuads();
            boolean swapped = PC_Renderer.swapTerrain(block);
            block.setBlockBoundsBasedOnState(blockAccess, x, y, z);
            int i1 = l = ((PC_IRotatedBox)((Object)block)).getRotation(metaAt);
            renderblocks.renderStandardBlock(block, x, y, z);
            tessellator.setBrightness(block.getMixedBrightnessForBlock(blockAccess, x, y, z));
            tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            int k1 = block.getBlockTexture(blockAccess, x, y, z, 1);
            int l1 = (k1 & 0xF) << 4;
            int i2 = k1 & 0xF0;
            double d5 = (float)l1 / 256.0f;
            double d6 = ((float)l1 + 15.99f) / 256.0f;
            double d7 = (float)i2 / 256.0f;
            double d8 = ((float)i2 + 15.99f) / 256.0f;
            double d9 = block.maxY;
            double d10 = (double)x + block.maxX;
            double d11 = (double)x + block.maxX;
            double d12 = (double)x + block.minX;
            double d13 = (double)x + block.minX;
            double d14 = (double)z + block.minZ;
            double d15 = (double)z + block.maxZ;
            double d16 = (double)z + block.maxZ;
            double d17 = (double)z + block.minZ;
            double d18 = (double)y + d9;
            if (i1 == 2) {
                d10 = d11 = (double)x + block.minX;
                d12 = d13 = (double)x + block.maxX;
                d14 = d17 = (double)z + block.maxZ;
                d15 = d16 = (double)z + block.minZ;
            } else if (i1 == 3) {
                d10 = d13 = (double)x + block.minX;
                d11 = d12 = (double)x + block.maxX;
                d14 = d15 = (double)z + block.minZ;
                d16 = d17 = (double)z + block.maxZ;
            } else if (i1 == 1) {
                d10 = d13 = (double)x + block.maxX;
                d11 = d12 = (double)x + block.minX;
                d14 = d15 = (double)z + block.maxZ;
                d16 = d17 = (double)z + block.minZ;
            }
            tessellator.addVertexWithUV(d13, d18, d17, d5, d7);
            tessellator.addVertexWithUV(d12, d18, d16, d5, d8);
            tessellator.addVertexWithUV(d11, d18, d15, d6, d8);
            tessellator.addVertexWithUV(d10, d18, d14, d6, d7);
            tessellator.draw();
            tessellator.startDrawingQuads();
            PC_Renderer.resetTerrain(swapped);
            return true;
        }
        return false;
    }

    public static void renderCrossedSquares(RenderBlocks renderblocks, IBlockAccess blockAccess, int x, int y, int z, Block block) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.draw();
        tessellator.startDrawingQuads();
        boolean swapped = PC_Renderer.swapTerrain(block);
        block.setBlockBoundsBasedOnState(blockAccess, x, y, z);
        tessellator.setBrightness(block.getMixedBrightnessForBlock(blockAccess, x, y, z));
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        int t = block.getBlockTextureFromSideAndMetadata(0, blockAccess.getBlockMetadata(x, y, z));
        int k = (t & 0xF) << 4;
        int l = t & 0xF0;
        double d3 = (float)k / 256.0f;
        double d4 = ((float)k + 15.99f) / 256.0f;
        double d5 = (float)l / 256.0f;
        double d6 = ((float)l + 15.99f) / 256.0f;
        double d7 = (double)x + 0.5 - 0.45;
        double d8 = (double)x + 0.5 + 0.45;
        double d9 = (double)z + 0.5 - 0.45;
        double d10 = (double)z + 0.5 + 0.45;
        tessellator.addVertexWithUV(d7, (double)y + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d7, (double)y + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d8, (double)y + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d8, (double)y + 1.0, d10, d4, d5);
        tessellator.addVertexWithUV(d8, (double)y + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d8, (double)y + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d7, (double)y + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d7, (double)y + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d7, (double)y + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d7, (double)y + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d8, (double)y + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d8, (double)y + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d8, (double)y + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d8, (double)y + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d7, (double)y + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d7, (double)y + 1.0, d10, d4, d5);
        tessellator.draw();
        tessellator.startDrawingQuads();
        PC_Renderer.resetTerrain(swapped);
    }

    public static void renderInvBlockByType(RenderBlocks renderblocks, Block block, int meta, int rtype) {
        if (rtype == swapTerrainRenderer) {
            PC_Renderer.renderInvBlock(renderblocks, block, meta);
        } else if (rtype == rotatedBoxRenderer) {
            PC_Renderer.renderInvBlockRotatedBox(renderblocks, block, meta);
        }
    }

    public static void renderInvBox(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.instance;
        int[] textures = new int[6];
        if (block instanceof PC_ISpecialInventoryTextures) {
            for (int a = 0; a < 6; ++a) {
                textures[a] = ((PC_ISpecialInventoryTextures)((Object)block)).getInvTexture(a, meta);
            }
        } else {
            for (int a = 0; a < 6; ++a) {
                textures[a] = block.getBlockTextureFromSideAndMetadata(a, meta);
            }
        }
        block.setBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderblocks.renderBottomFace(block, 0.0, 0.0, 0.0, textures[0]);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderblocks.renderTopFace(block, 0.0, 0.0, 0.0, textures[1]);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderblocks.renderEastFace(block, 0.0, 0.0, 0.0, textures[2]);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderblocks.renderWestFace(block, 0.0, 0.0, 0.0, textures[3]);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderblocks.renderNorthFace(block, 0.0, 0.0, 0.0, textures[4]);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderblocks.renderSouthFace(block, 0.0, 0.0, 0.0, textures[5]);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void renderInvBoxWithTexture(RenderBlocks renderblocks, Block block, int texture) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderblocks.renderBottomFace(block, 0.0, 0.0, 0.0, texture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderblocks.renderTopFace(block, 0.0, 0.0, 0.0, texture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderblocks.renderEastFace(block, 0.0, 0.0, 0.0, texture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderblocks.renderWestFace(block, 0.0, 0.0, 0.0, texture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderblocks.renderNorthFace(block, 0.0, 0.0, 0.0, texture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderblocks.renderSouthFace(block, 0.0, 0.0, 0.0, texture);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void renderInvBlock(RenderBlocks renderblocks, Block block, int meta) {
        boolean swapped = PC_Renderer.swapTerrain(block);
        PC_Renderer.renderInvBox(renderblocks, block, meta);
        PC_Renderer.resetTerrain(swapped);
    }

    public static void renderInvBlockRotatedBox(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.instance;
        if (block instanceof PC_IRotatedBox) {
            boolean swapped = PC_Renderer.swapTerrain(block);
            boolean renderOnSide = ((PC_IRotatedBox)((Object)block)).renderItemOnSide();
            if (renderOnSide) {
                block.setBlockBoundsForItemRender();
            } else {
                block.setBlockBounds(-0.1f, -0.1f, 0.4f, 1.1f, 1.1f, 0.6f);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderblocks.renderBottomFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(renderOnSide ? 0 : 0, meta));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderblocks.renderTopFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(renderOnSide ? 1 : 0, meta));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderblocks.renderEastFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(renderOnSide ? 2 : 0, meta));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderblocks.renderWestFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(renderOnSide ? 3 : 1, meta));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderblocks.renderNorthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(renderOnSide ? 4 : 0, meta));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderblocks.renderSouthFace(block, 0.0, 0.0, 0.0, block.getBlockTextureFromSideAndMetadata(renderOnSide ? 5 : 0, meta));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            PC_Renderer.resetTerrain(swapped);
            return;
        }
    }

    public static void renderInvBlockCrossedSquares(RenderBlocks renderblocks, Block block, int meta) {
        int texture = block.getBlockTextureFromSideAndMetadata(0, meta);
        PC_Renderer.renderInvBlockCrossedSquaresWithTexture(renderblocks, texture, block);
    }

    public static void renderInvBlockCrossedSquaresWithTexture(RenderBlocks renderblocks, int textureIndex, Block block) {
        boolean swapped = PC_Renderer.swapTerrain(block);
        PC_Renderer.renderInvBlockCrossedSquares_do(renderblocks, textureIndex, block);
        PC_Renderer.resetTerrain(swapped);
    }

    private static void renderInvBlockCrossedSquares_do(RenderBlocks renderblocks, int textureIndex, Block block) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.startDrawingQuads();
        double d = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int k = (textureIndex & 0xF) << 4;
        int l = textureIndex & 0xF0;
        double d3 = (float)k / 256.0f;
        double d4 = ((float)k + 15.99f) / 256.0f;
        double d5 = (float)l / 256.0f;
        double d6 = ((float)l + 15.99f) / 256.0f;
        double d7 = d + 0.5 - 0.45;
        double d8 = d + 0.5 + 0.45;
        double d9 = d2 + 0.5 - 0.45;
        double d10 = d2 + 0.5 + 0.45;
        tessellator.addVertexWithUV(d7, d1 + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d10, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d10, d3, d5);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d10, d3, d6);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d9, d4, d6);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d9, d4, d5);
        tessellator.addVertexWithUV(d8, d1 + 1.0, d9, d3, d5);
        tessellator.addVertexWithUV(d8, d1 + 0.0, d9, d3, d6);
        tessellator.addVertexWithUV(d7, d1 + 0.0, d10, d4, d6);
        tessellator.addVertexWithUV(d7, d1 + 1.0, d10, d4, d5);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void swapTerrain(String filename) {
        RenderEngine renderengine = ModLoader.getMinecraftInstance().renderEngine;
        renderengine.bindTexture(renderengine.getTexture(filename));
    }

    public static boolean swapTerrain(Block block) {
        RenderEngine renderengine = ModLoader.getMinecraftInstance().renderEngine;
        if (block instanceof PC_ISwapTerrain) {
            renderengine.bindTexture(renderengine.getTexture(((PC_ISwapTerrain)((Object)block)).getTerrainFile()));
            return true;
        }
        return false;
    }

    public static void resetTerrain(Boolean do_it) {
        RenderEngine renderengine = ModLoader.getMinecraftInstance().renderEngine;
        renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
    }

    public static int preloadTexture(String filename) {
        return ModLoader.getMinecraftInstance().renderEngine.getTexture(filename);
    }

    public static void renderEntityLabelAt(String label, PC_CoordF realPos, int viewDistance, float yOffset, double x, double y, double z) {
        RenderManager renderManager = RenderManager.instance;
        float f = (float)renderManager.livingPlayer.getDistance((double)realPos.x + 0.5, (double)realPos.y + 0.5, (double)realPos.z + 0.5);
        if (f > (float)viewDistance) {
            return;
        }
        FontRenderer fontrenderer = renderManager.getFontRenderer();
        float f1 = 1.0f;
        float f2 = 0.01666667f * f1;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + yOffset), (float)((float)z + 0.5f));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f2), (float)(-f2), (float)f2);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        int byte0 = 0;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        float i = (float)(fontrenderer.getStringWidth(label) / 2) * 1.12f;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-i - 1.0f, -1 + byte0, 0.0);
        tessellator.addVertex(-i - 1.0f, 8 + byte0, 0.0);
        tessellator.addVertex(i + 1.0f, 8 + byte0, 0.0);
        tessellator.addVertex(i + 1.0f, -1 + byte0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(label, -fontrenderer.getStringWidth(label) / 2, byte0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

