/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.src.PC_Logger;
import net.minecraft.src.TMIItemInfo;

public class PC_InveditManager {
    protected static HashSet<Integer> hidden = new HashSet();
    protected static HashMap<Integer, Integer[]> damageRanges = new HashMap();
    protected static HashMap<Integer, Integer[]> damageLists = new HashMap();
    protected static HashMap<Integer, String> categories = new HashMap();
    private static boolean mod_items_sent_to_TMI = false;

    public static void hideItem(int id) {
        hidden.add(id);
    }

    public static void setDamageRange(int id, int min, int max) {
        damageRanges.put(id, new Integer[]{min, max});
    }

    public static void setDamageList(int id, Integer[] listOfDamages) {
        damageLists.put(id, listOfDamages);
    }

    public static void setItemCategory(int id, String category) {
        categories.put(id, category);
    }

    public static void sendToTMI() {
        if (mod_items_sent_to_TMI) {
            return;
        }
        mod_items_sent_to_TMI = true;
        try {
            Class.forName("net.minecraft.src.TMIItemInfo.class", false, PC_InveditManager.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            PC_Logger.fine("\nInvedit Manager: TMI mod not found.");
            return;
        }
        for (Integer id : hidden) {
            PC_InveditManager.TMI_hideId(id);
        }
        for (Integer id : damageRanges.keySet()) {
            Integer[] range = damageRanges.get(id);
            if (range.length != 2) {
                PC_Logger.severe("Invedit Manager: Invalid damage range for item with ID=" + id);
            }
            PC_InveditManager.TMI_rangeDamage(id, range[0], range[1]);
        }
    }

    private static void TMI_hideId(int id) {
        try {
            TMIItemInfo.hideItem(id);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void TMI_rangeDamage(int id, int from, int to) {
        try {
            TMIItemInfo.showItemWithDamageRange(id, from, to);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

