/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.PC_Utils;
import org.lwjgl.input.Keyboard;

public class PC_GresTextEdit
extends PC_GresWidget {
    private int maxChars;
    private int mouseSelectStart = 0;
    private int mouseSelectEnd = 0;
    private boolean mousePressed = false;
    private PC_GresInputType type = PC_GresInputType.TEXT;

    public PC_GresTextEdit(String label, int chars) {
        super((chars + 1) * 10, PC_Utils.mc().fontRenderer.FONT_HEIGHT + 12, label);
        this.maxChars = chars;
        this.canAddWidget = false;
        this.color[0] = -1;
        this.color[1] = -13092808;
        this.color[2] = -1;
        this.color[3] = -13092808;
    }

    public PC_GresTextEdit(String initText, int chars, PC_GresInputType type) {
        super((chars + 1) * 10, PC_Utils.mc().fontRenderer.FONT_HEIGHT + 12, initText);
        this.maxChars = chars;
        this.canAddWidget = false;
        this.color[0] = -1;
        this.color[1] = -13092808;
        this.color[2] = -1;
        this.color[3] = -13092808;
        this.type = type;
    }

    @Override
    public PC_CoordI calcSize() {
        this.size.setTo(this.getMinSize());
        if (this.size.x < this.minSize.x) {
            this.size.x = this.minSize.x;
        }
        return this.size.copy();
    }

    @Override
    public void calcChildPositions() {
    }

    @Override
    protected void render(PC_CoordI offsetPos) {
        if (this.mouseSelectEnd > this.text.length()) {
            this.mouseSelectEnd = this.text.length();
        }
        if (this.mouseSelectStart > this.text.length()) {
            this.mouseSelectStart = this.text.length();
        }
        this.drawHorizontalLine(offsetPos.x + this.pos.x, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y, -6250336);
        this.drawHorizontalLine(offsetPos.x + this.pos.x, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        this.drawVerticalLine(offsetPos.x + this.pos.x, offsetPos.y + this.pos.y, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        this.drawVerticalLine(offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        PC_GresTextEdit.drawRect(offsetPos.x + this.pos.x + 1, offsetPos.y + this.pos.y + 1, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y + this.size.y - 1, -16777216);
        if (this.text.length() > this.maxChars) {
            this.text = this.text.substring(0, this.maxChars);
        }
        if (this.mouseSelectStart != this.mouseSelectEnd && this.hasFocus) {
            int s = this.mouseSelectStart;
            int e = this.mouseSelectEnd;
            if (s > e) {
                e = this.mouseSelectStart;
                s = this.mouseSelectEnd;
            }
            PC_GresTextEdit.drawRect(offsetPos.x + this.pos.x + this.getStringWidth(this.text.substring(0, s)) + 6, offsetPos.y + this.pos.y + 4, offsetPos.x + this.pos.x + this.getStringWidth(this.text.substring(0, e)) + 6, offsetPos.y + this.pos.y + this.size.y - 5, -13395457);
        }
        this.drawString(this.text, offsetPos.x + this.pos.x + 6, offsetPos.y + this.pos.y + (this.size.y - 8) / 2);
        if (this.mouseSelectEnd == this.text.length()) {
            if (this.hasFocus && this.cursorCounter / 6 % 2 == 0) {
                this.drawString("_", offsetPos.x + this.pos.x + this.getStringWidth(this.text) + 6, offsetPos.y + this.pos.y + (this.size.y - 8) / 2);
            }
        } else if (this.hasFocus && this.cursorCounter / 6 % 2 == 0) {
            this.drawVerticalLine(offsetPos.x + this.pos.x + this.getStringWidth(this.text.substring(0, this.mouseSelectEnd)) + 5, offsetPos.y + this.pos.y + 3, offsetPos.y + this.pos.y + this.size.y - 5, this.color[this.enabled ? 0 : 2]);
        }
    }

    @Override
    public boolean mouseOver(PC_CoordI mpos) {
        return true;
    }

    private int getMousePositionInString(int x) {
        x -= 6;
        for (int i = 0; i < this.text.length(); ++i) {
            int charSize = this.getStringWidth("" + this.text.charAt(i));
            if (x - charSize / 2 < 0) {
                return i;
            }
            x -= charSize;
        }
        return this.text.length();
    }

    @Override
    public boolean mouseClick(PC_CoordI mpos, int key) {
        this.mousePressed = false;
        if (!this.enabled) {
            return false;
        }
        if (key != -1) {
            this.mouseSelectEnd = this.mouseSelectStart = this.getMousePositionInString(mpos.x);
            this.mousePressed = true;
            return true;
        }
        return false;
    }

    protected void addKey(char c) {
        int s = this.mouseSelectStart;
        int e = this.mouseSelectEnd;
        if (s > e) {
            e = this.mouseSelectStart;
            s = this.mouseSelectEnd;
        }
        String s1 = this.text.substring(0, s);
        String s2 = this.text.substring(e);
        if ((s1 + c + s2).length() > this.maxChars) {
            return;
        }
        this.text = s1 + c + s2;
        ++this.mouseSelectEnd;
        this.mouseSelectStart = this.mouseSelectEnd;
    }

    private void deleteSelected() {
        int s = this.mouseSelectStart;
        int e = this.mouseSelectEnd;
        if (s > e) {
            e = this.mouseSelectStart;
            s = this.mouseSelectEnd;
        }
        String s1 = this.text.substring(0, s);
        String s2 = this.text.substring(e);
        this.text = s1 + s2;
        this.mouseSelectEnd = s;
        this.mouseSelectStart = s;
    }

    private void key_backspace() {
        if (this.mouseSelectStart != this.mouseSelectEnd) {
            this.deleteSelected();
            return;
        }
        if (this.mouseSelectEnd <= 0) {
            return;
        }
        String s1 = this.text.substring(0, this.mouseSelectEnd - 1);
        String s2 = this.text.substring(this.mouseSelectEnd);
        this.text = s1 + s2;
        --this.mouseSelectEnd;
        this.mouseSelectStart = this.mouseSelectEnd;
    }

    private void key_delete() {
        if (this.mouseSelectStart != this.mouseSelectEnd) {
            this.deleteSelected();
            return;
        }
        if (this.mouseSelectEnd >= this.text.length()) {
            return;
        }
        String s1 = this.text.substring(0, this.mouseSelectEnd);
        String s2 = this.text.substring(this.mouseSelectEnd + 1);
        this.text = s1 + s2;
    }

    private String getSelect() {
        int s = this.mouseSelectStart;
        int e = this.mouseSelectEnd;
        if (s > e) {
            e = this.mouseSelectStart;
            s = this.mouseSelectEnd;
        }
        return this.text.substring(s, e);
    }

    private void setSelected(String stri) {
        int s = this.mouseSelectStart;
        int e = this.mouseSelectEnd;
        if (s > e) {
            e = this.mouseSelectStart;
            s = this.mouseSelectEnd;
        }
        String s1 = this.text.substring(0, s);
        String s2 = this.text.substring(e);
        String ss = "";
        switch (this.type) {
            case UNSIGNED_INT: {
                for (int i = 0; i < stri.length(); ++i) {
                    if (!Character.isDigit(Character.valueOf(stri.charAt(i)).charValue())) continue;
                    ss = ss + stri.charAt(i);
                }
                break;
            }
            case INT: {
                if (this.text.length() > 0 && this.text.charAt(0) == '-' && this.mouseSelectStart == 0 && this.mouseSelectEnd == 0) break;
                for (int i = 0; i < stri.length(); ++i) {
                    if (i == 0 && stri.charAt(0) == '-' && s == 0) {
                        ss = ss + stri.charAt(i);
                    }
                    if (!Character.isDigit(Character.valueOf(stri.charAt(i)).charValue())) continue;
                    ss = ss + stri.charAt(i);
                }
                break;
            }
            case SIGNED_FLOAT: {
                if (this.text.length() > 0 && this.text.charAt(0) == '-' && this.mouseSelectStart == 0 && this.mouseSelectEnd == 0) break;
                for (int i = 0; i < stri.length(); ++i) {
                    if (i == 0 && stri.charAt(0) == '-' && s == 0) {
                        ss = ss + stri.charAt(i);
                    }
                    if (!(stri.charAt(i) != '.' || s1.contains(".") || s2.contains(".") || ss.contains("."))) {
                        ss = ss + ".";
                    }
                    if (!Character.isDigit(Character.valueOf(stri.charAt(i)).charValue())) continue;
                    ss = ss + stri.charAt(i);
                }
                break;
            }
            case UNSIGNED_FLOAT: {
                for (int i = 0; i < stri.length(); ++i) {
                    if (!(stri.charAt(i) != '.' || s1.contains(".") || s2.contains(".") || ss.contains("."))) {
                        ss = ss + ".";
                    }
                    if (!Character.isDigit(Character.valueOf(stri.charAt(i)).charValue())) continue;
                    ss = ss + stri.charAt(i);
                }
                break;
            }
            default: {
                for (int i = 0; i < stri.length(); ++i) {
                    if (!ChatAllowedCharacters.isAllowedCharacter(stri.charAt(i))) continue;
                    ss = ss + stri.charAt(i);
                }
            }
        }
        if ((s1 + ss + s2).length() > this.maxChars) {
            return;
        }
        this.text = s1 + ss + s2;
        this.mouseSelectEnd = s + ss.length();
        this.mouseSelectStart = s;
    }

    @Override
    public boolean keyTyped(char c, int key) {
        if (!this.enabled || !this.hasFocus) {
            return false;
        }
        switch (c) {
            case '\u0003': {
                GuiScreen.setClipboardString(this.getSelect());
                return true;
            }
            case '\u0016': {
                this.setSelected(GuiScreen.getClipboardString());
                return true;
            }
            case '\u0018': {
                GuiScreen.setClipboardString(this.getSelect());
                this.deleteSelected();
                return true;
            }
        }
        switch (key) {
            case 28: {
                return true;
            }
            case 14: {
                this.key_backspace();
                return true;
            }
            case 199: {
                this.mouseSelectStart = 0;
                this.mouseSelectEnd = 0;
                return true;
            }
            case 207: {
                this.mouseSelectEnd = this.mouseSelectStart = this.text.length();
                return true;
            }
            case 211: {
                this.key_delete();
                return true;
            }
            case 203: {
                if (this.mouseSelectEnd > 0) {
                    --this.mouseSelectEnd;
                    if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                        this.mouseSelectStart = this.mouseSelectEnd;
                    }
                }
                return true;
            }
            case 205: {
                if (this.mouseSelectEnd < this.text.length()) {
                    ++this.mouseSelectEnd;
                    if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                        this.mouseSelectStart = this.mouseSelectEnd;
                    }
                }
                return true;
            }
        }
        switch (this.type) {
            case UNSIGNED_INT: {
                if (Character.isDigit(Character.valueOf(c).charValue())) {
                    this.addKey(c);
                    return true;
                }
                return false;
            }
            case INT: {
                if (this.text.length() > 0 && this.text.charAt(0) == '-' && this.mouseSelectStart == 0 && this.mouseSelectEnd == 0) {
                    return true;
                }
                if (Character.isDigit(Character.valueOf(c).charValue())) {
                    this.addKey(c);
                    return true;
                }
                if ((this.mouseSelectStart == 0 || this.mouseSelectEnd == 0) && c == '-') {
                    this.addKey(c);
                    return true;
                }
                return false;
            }
            case SIGNED_FLOAT: {
                if (c == '.') {
                    if (this.mouseSelectStart == 0 || this.mouseSelectEnd == 0) {
                        return true;
                    }
                    if (this.text.length() > 0 && (this.mouseSelectStart == 1 || this.mouseSelectEnd == 1) && this.text.charAt(0) == '-') {
                        return true;
                    }
                    if (this.text.length() > 0 && this.text.contains(".")) {
                        return true;
                    }
                    this.addKey(c);
                    return true;
                }
                if (this.text.length() > 0 && this.text.charAt(0) == '-' && this.mouseSelectStart == 0 && this.mouseSelectEnd == 0) {
                    return true;
                }
                if (Character.isDigit(Character.valueOf(c).charValue())) {
                    this.addKey(c);
                    return true;
                }
                if ((this.mouseSelectStart == 0 || this.mouseSelectEnd == 0) && c == '-') {
                    this.addKey(c);
                    return true;
                }
                return false;
            }
            case UNSIGNED_FLOAT: {
                if (c == '.') {
                    if (this.mouseSelectStart == 0 || this.mouseSelectEnd == 0) {
                        return true;
                    }
                    if (this.text.length() > 0 && this.text.contains(".")) {
                        return true;
                    }
                    this.addKey(c);
                    return true;
                }
                if (Character.isDigit(Character.valueOf(c).charValue())) {
                    this.addKey(c);
                    return true;
                }
                return false;
            }
        }
        if (ChatAllowedCharacters.isAllowedCharacter(c)) {
            this.addKey(c);
            return true;
        }
        return false;
    }

    @Override
    public void mouseMove(PC_CoordI mpos) {
        if (this.mousePressed) {
            this.mouseSelectEnd = this.getMousePositionInString(mpos.x);
        }
    }

    @Override
    public PC_CoordI getMinSize() {
        return new PC_CoordI((this.maxChars + 1) * 10, this.getFontRenderer().FONT_HEIGHT + 12);
    }

    @Override
    public void mouseWheel(int i) {
        if (i > 0 && this.mouseSelectEnd > 0) {
            --this.mouseSelectEnd;
            if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                this.mouseSelectStart = this.mouseSelectEnd;
            }
        }
        if (i < 0 && this.mouseSelectEnd < this.text.length()) {
            ++this.mouseSelectEnd;
            if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                this.mouseSelectStart = this.mouseSelectEnd;
            }
        }
    }

    @Override
    public void addedToWidget() {
    }

    public static enum PC_GresInputType {
        TEXT,
        INT,
        UNSIGNED_INT,
        SIGNED_FLOAT,
        UNSIGNED_FLOAT;

    }
}

