/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresWidget;
import net.minecraft.src.PC_Utils;
import org.lwjgl.input.Keyboard;

public class PC_GresMultiTextEdit
extends PC_GresWidget {
    private static final char br = '\n';
    private PC_CoordI lastMousePosition = new PC_CoordI(0, 0);
    private PC_CoordI mouseSelectStart = new PC_CoordI(0, 0);
    private PC_CoordI mouseSelectEnd = new PC_CoordI(0, 0);
    private int mousePressed = 0;
    private PC_CoordI scroll = new PC_CoordI(0, 0);
    private ArrayList<Keyword> keyWords = null;
    private int vScrollPos = 0;
    private int vScrollSize = 0;
    private int hScrollPos = 0;
    private int hScrollSize = 0;

    public PC_GresMultiTextEdit(String text, int minWidth, int minHeight) {
        super(minWidth > 20 ? minWidth : 20, minHeight > PC_Utils.mc().fontRenderer.FONT_HEIGHT + 26 ? minHeight : PC_Utils.mc().fontRenderer.FONT_HEIGHT + 26, text);
        this.canAddWidget = false;
        this.color[0] = -1;
        this.color[1] = -13092808;
        this.color[2] = -1;
        this.color[3] = -13092808;
    }

    public PC_GresMultiTextEdit(String text, int minWidth, int minHeight, ArrayList<Keyword> keyWords) {
        super(minWidth > 20 ? minWidth : 20, minHeight > PC_Utils.mc().fontRenderer.FONT_HEIGHT + 26 ? minHeight : PC_Utils.mc().fontRenderer.FONT_HEIGHT + 26, text);
        this.canAddWidget = false;
        this.color[0] = -1;
        this.color[1] = -13092808;
        this.color[2] = -1;
        this.color[3] = -13092808;
        this.keyWords = keyWords;
    }

    @Override
    public PC_CoordI getMinSize() {
        return this.calcSize();
    }

    @Override
    public PC_CoordI calcSize() {
        return this.size;
    }

    @Override
    public void calcChildPositions() {
    }

    private int getMaxLineLength() {
        int maxLength = 0;
        int length = 0;
        for (int i = 0; i <= this.getLineNumbers(); ++i) {
            length = this.getStringWidth(this.getLine(i));
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    private void calcScrollPosition() {
        int sizeX = this.size.x - 12;
        int maxSizeX = this.getMaxLineLength();
        int sizeOutOfFrame = maxSizeX - sizeX + 14;
        if (sizeOutOfFrame < 0) {
            sizeOutOfFrame = 0;
        }
        float prozent = maxSizeX > 0 ? (float)sizeOutOfFrame / (float)maxSizeX : 0.0f;
        this.hScrollPos = (int)((double)((sizeOutOfFrame > 0 ? (float)this.scroll.x / (float)sizeOutOfFrame : 0.0f) * prozent * (float)sizeX) + 0.5);
        this.hScrollSize = (int)((double)((1.0f - prozent) * (float)sizeX) + 0.5);
        int lineNumbers = this.getLineNumbers() + 1;
        int linesNotToSee = lineNumbers - this.shownLines();
        if (linesNotToSee < 0) {
            linesNotToSee = 0;
        }
        prozent = lineNumbers > 0 ? (float)linesNotToSee / (float)lineNumbers : 0.0f;
        int sizeY = this.size.y - 12;
        this.vScrollPos = (int)((double)((linesNotToSee > 0 ? (float)this.scroll.y / (float)linesNotToSee : 0.0f) * prozent * (float)sizeY) + 0.5);
        this.vScrollSize = (int)((double)((1.0f - prozent) * (float)sizeY) + 0.5);
        this.updateScrollPosition();
    }

    private void updateScrollPosition() {
        float prozent;
        int sizeX = this.size.x - 12;
        int maxSizeX = this.getMaxLineLength();
        int sizeOutOfFrame = maxSizeX - sizeX + 14;
        if (sizeOutOfFrame < 0) {
            sizeOutOfFrame = 0;
        }
        float f = prozent = maxSizeX > 0 ? (float)sizeOutOfFrame / (float)maxSizeX : 0.0f;
        if (this.hScrollPos < 0) {
            this.hScrollPos = 0;
        }
        if (this.hScrollPos > sizeX - this.hScrollSize) {
            this.hScrollPos = sizeX - this.hScrollSize;
        }
        this.scroll.x = (int)((double)((float)this.hScrollPos / prozent / (float)sizeX * (float)sizeOutOfFrame) + 0.5);
        int sizeY = this.size.y - 12;
        int lineNumbers = this.getLineNumbers() + 1;
        int linesNotToSee = lineNumbers - this.shownLines();
        if (linesNotToSee < 0) {
            linesNotToSee = 0;
        }
        float f2 = prozent = lineNumbers > 0 ? (float)linesNotToSee / (float)lineNumbers : 0.0f;
        if (this.vScrollPos < 0) {
            this.vScrollPos = 0;
        }
        if (this.vScrollPos > sizeY - this.vScrollSize) {
            this.vScrollPos = sizeY - this.vScrollSize;
        }
        this.scroll.y = (int)((double)((float)this.vScrollPos / prozent / (float)sizeY * (float)linesNotToSee) + 0.5);
    }

    private int getColorForWord(String word) {
        if (this.keyWords != null) {
            for (Keyword k : this.keyWords) {
                if (!k.word.equalsIgnoreCase(word)) continue;
                return k.color;
            }
        }
        return -1;
    }

    private boolean yCoordsInDrawRect(int cy) {
        return cy >= this.scroll.y && cy < this.scroll.y + this.shownLines();
    }

    private boolean coordsInDrawRect(PC_CoordI c) {
        if (!this.yCoordsInDrawRect(c.y)) {
            return false;
        }
        int cx = this.getStringWidth(this.getLine(c.y).substring(0, c.x));
        return cx >= this.scroll.x && cx < this.scroll.x + this.size.x - 26;
    }

    private void drawSelect(PC_CoordI offsetPos, int sx, int ex, int y) {
        if (!this.yCoordsInDrawRect(y)) {
            return;
        }
        String line = this.getLine(y);
        if (sx < 0) {
            sx = 0;
        }
        if (ex < 0) {
            ex = line.length();
        }
        int cy = y - this.scroll.y;
        int sxx = this.getStringWidth(line.substring(0, sx)) - this.scroll.x;
        int exx = this.getStringWidth(line.substring(0, ex)) - this.scroll.x;
        if (sxx < 0) {
            sxx = 0;
        } else if (sxx > this.size.x - 24) {
            return;
        }
        if (exx < 0) {
            return;
        }
        if (exx > this.size.x - 24) {
            exx = this.size.x - 24;
        }
        PC_GresMultiTextEdit.drawRect(offsetPos.x + this.pos.x + sxx + 6, offsetPos.y + this.pos.y + 6 + cy * PC_Utils.mc().fontRenderer.FONT_HEIGHT, offsetPos.x + this.pos.x + exx + 6, offsetPos.y + this.pos.y + 6 + (cy + 1) * PC_Utils.mc().fontRenderer.FONT_HEIGHT, -13395457);
    }

    private void drawWord(PC_CoordI offsetPos, int x, int y, String word, boolean highlited) {
        int charSize;
        if (!this.yCoordsInDrawRect(y)) {
            return;
        }
        int wordlength = this.getStringWidth(word);
        if (x > this.size.x + wordlength - 26) {
            return;
        }
        int color = highlited ? this.getColorForWord(word) : -1;
        int strposStart = 0;
        int strSize = 0;
        int sx = x;
        for (strposStart = 0; strposStart < word.length() && sx < 0; sx += charSize, ++strposStart) {
            charSize = this.getStringWidth("" + word.charAt(strposStart));
        }
        int xp = sx;
        strSize = 0;
        while (strSize + strposStart < word.length() && sx <= this.size.x - 25) {
            charSize = this.getStringWidth("" + word.charAt(strposStart + strSize));
            sx += charSize;
            ++strSize;
        }
        this.getFontRenderer().drawStringWithShadow(word.substring(strposStart, strposStart + strSize), offsetPos.x + this.pos.x + 6 + xp, offsetPos.y + this.pos.y + 6 + (y - this.scroll.y) * PC_Utils.mc().fontRenderer.FONT_HEIGHT, color);
    }

    private void drawStringLine(PC_CoordI offsetPos, int y) {
        int sx;
        if (!this.yCoordsInDrawRect(y)) {
            return;
        }
        String line = this.getLine(y);
        String word = "";
        int wordStart = sx = -this.scroll.x;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (word.equals("")) {
                    wordStart = sx;
                }
                word = word + c;
            } else if (Character.isSpaceChar(c)) {
                if (!word.equals("")) {
                    this.drawWord(offsetPos, wordStart, y, word, true);
                }
                word = "";
            } else {
                if (!word.equals("")) {
                    this.drawWord(offsetPos, wordStart, y, word, true);
                }
                this.drawWord(offsetPos, sx, y, "" + c, true);
                word = "";
            }
            sx += this.getStringWidth("" + c);
        }
        if (!word.equals("")) {
            this.drawWord(offsetPos, wordStart, y, word, true);
        }
    }

    @Override
    protected void render(PC_CoordI offsetPos) {
        this.drawHorizontalLine(offsetPos.x + this.pos.x, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y, -6250336);
        this.drawHorizontalLine(offsetPos.x + this.pos.x, offsetPos.x + this.pos.x + this.size.x - 12, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        this.drawVerticalLine(offsetPos.x + this.pos.x, offsetPos.y + this.pos.y, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        this.drawVerticalLine(offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y, offsetPos.y + this.pos.y + this.size.y - 12, -6250336);
        PC_GresMultiTextEdit.drawRect(offsetPos.x + this.pos.x + 1, offsetPos.y + this.pos.y + 1, offsetPos.x + this.pos.x + this.size.x - 12, offsetPos.y + this.pos.y + this.size.y - 12, -16777216);
        PC_GresMultiTextEdit.drawRect(offsetPos.x + this.pos.x + 1, offsetPos.y + this.pos.y + this.size.y - 11, offsetPos.x + this.pos.x + this.size.x - 12, offsetPos.y + this.pos.y + this.size.y - 1, -1);
        PC_GresMultiTextEdit.drawRect(offsetPos.x + this.pos.x + this.size.x - 11, offsetPos.y + this.pos.y + 1, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y + this.size.y - 12, -1);
        this.drawHorizontalLine(offsetPos.x + this.pos.x, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y + this.size.y - 12, -6250336);
        this.drawVerticalLine(offsetPos.x + this.pos.x + this.size.x - 12, offsetPos.y + this.pos.y, offsetPos.y + this.pos.y + this.size.y - 1, -6250336);
        if (this.mousePressed == 0 || this.mousePressed == 1) {
            this.calcScrollPosition();
        }
        PC_GresMultiTextEdit.drawRect(offsetPos.x + this.pos.x + 1 + this.hScrollPos, offsetPos.y + this.pos.y + this.size.y - 11, offsetPos.x + this.pos.x + this.hScrollPos + this.hScrollSize, offsetPos.y + this.pos.y + this.size.y - 1, -8747521);
        PC_GresMultiTextEdit.drawRect(offsetPos.x + this.pos.x + this.size.x - 11, offsetPos.y + this.pos.y + 1 + this.vScrollPos, offsetPos.x + this.pos.x + this.size.x - 1, offsetPos.y + this.pos.y + this.vScrollPos + this.vScrollSize, -8747521);
        if ((this.mouseSelectStart.x != this.mouseSelectEnd.x || this.mouseSelectStart.y != this.mouseSelectEnd.y) && this.hasFocus) {
            int s = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
            int e = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
            PC_CoordI cs = this.mouseSelectStart;
            PC_CoordI ce = this.mouseSelectEnd;
            if (s > e) {
                cs = this.mouseSelectEnd;
                ce = this.mouseSelectStart;
            }
            if (this.mouseSelectStart.y == this.mouseSelectEnd.y) {
                if (this.yCoordsInDrawRect(this.mouseSelectStart.y)) {
                    this.drawSelect(offsetPos, cs.x, ce.x, cs.y);
                }
            } else {
                if (this.yCoordsInDrawRect(cs.y)) {
                    this.drawSelect(offsetPos, cs.x, -1, cs.y);
                }
                for (int i = cs.y + 1; i < ce.y; ++i) {
                    if (!this.yCoordsInDrawRect(i)) continue;
                    this.drawSelect(offsetPos, 0, -1, i);
                }
                if (this.yCoordsInDrawRect(ce.y)) {
                    this.drawSelect(offsetPos, 0, ce.x, ce.y);
                }
            }
        }
        for (int i = 0; i < this.shownLines(); ++i) {
            this.drawStringLine(offsetPos, i + this.scroll.y);
        }
        if (this.hasFocus && this.cursorCounter / 6 % 2 == 0 && this.coordsInDrawRect(new PC_CoordI(this.mouseSelectEnd.x > 0 ? this.mouseSelectEnd.x - 1 : 0, this.mouseSelectEnd.y))) {
            if (this.calcSelectCoordsToStringIndex(this.mouseSelectEnd) == this.text.length()) {
                this.drawString("_", offsetPos.x + this.pos.x + this.getStringWidth(this.getLine(this.mouseSelectEnd.y)) + 6 - this.scroll.x, offsetPos.y + this.pos.y + 6 + (this.mouseSelectEnd.y - this.scroll.y) * PC_Utils.mc().fontRenderer.FONT_HEIGHT);
            } else {
                this.drawVerticalLine(offsetPos.x + this.pos.x + this.getStringWidth(this.getLine(this.mouseSelectEnd.y).substring(0, this.mouseSelectEnd.x)) + 5 - this.scroll.x, offsetPos.y + this.pos.y + 6 + (this.mouseSelectEnd.y - this.scroll.y) * PC_Utils.mc().fontRenderer.FONT_HEIGHT, offsetPos.y + this.pos.y + 6 + (this.mouseSelectEnd.y - this.scroll.y + 1) * PC_Utils.mc().fontRenderer.FONT_HEIGHT, this.color[this.enabled ? 0 : 2]);
            }
        }
    }

    @Override
    public boolean mouseOver(PC_CoordI mousePos) {
        return true;
    }

    private String getLine(int line) {
        String s = "";
        int pos = 0;
        while (line > 0) {
            if (pos >= this.text.length()) {
                return "";
            }
            if (this.text.charAt(pos) == '\n') {
                --line;
            }
            ++pos;
        }
        while (pos < this.text.length()) {
            if (this.text.charAt(pos) == '\n') {
                return s;
            }
            s = s + this.text.charAt(pos);
            ++pos;
        }
        return s;
    }

    private PC_CoordI getMousePositionInString(PC_CoordI pos) {
        int i;
        int row = this.scroll.y;
        PC_CoordI coord = null;
        pos = pos.copy();
        pos.x -= 6;
        pos.y -= 6;
        int n = pos.y < 0 ? -1 : pos.y / PC_Utils.mc().fontRenderer.FONT_HEIGHT;
        pos.x += this.scroll.x;
        if ((row += n) < 0) {
            row = 0;
        }
        String rowText = this.getLine(row);
        for (i = 0; i < rowText.length(); ++i) {
            int charSize = this.getStringWidth("" + rowText.charAt(i));
            if (pos.x - charSize / 2 < 0) {
                coord = new PC_CoordI(i, row);
                break;
            }
            pos.x -= charSize;
        }
        if ((i = this.calcSelectCoordsToStringIndex(coord == null ? new PC_CoordI(rowText.length(), row) : coord)) > this.text.length()) {
            i = this.text.length();
        }
        return this.calcStringIndexToSelectCoords(i);
    }

    private PC_CoordI lineUp() {
        if (this.mouseSelectEnd.y <= 0) {
            return new PC_CoordI(0, 0);
        }
        int xP = this.getStringWidth(this.getLine(this.mouseSelectEnd.y).substring(0, this.mouseSelectEnd.x));
        String rowText = this.getLine(this.mouseSelectEnd.y - 1);
        PC_CoordI coord = null;
        for (int i = 0; i < rowText.length(); ++i) {
            int charSize = this.getStringWidth("" + rowText.charAt(i));
            if (xP - charSize / 2 < 0) {
                coord = new PC_CoordI(i, this.mouseSelectEnd.y - 1);
                break;
            }
            xP -= charSize;
        }
        return coord == null ? new PC_CoordI(rowText.length(), this.mouseSelectEnd.y - 1) : coord;
    }

    private PC_CoordI lineDown() {
        int i;
        int xP = this.getStringWidth(this.getLine(this.mouseSelectEnd.y).substring(0, this.mouseSelectEnd.x));
        String rowText = this.getLine(this.mouseSelectEnd.y + 1);
        PC_CoordI coord = null;
        for (i = 0; i < rowText.length(); ++i) {
            int charSize = this.getStringWidth("" + rowText.charAt(i));
            if (xP - charSize / 2 < 0) {
                coord = new PC_CoordI(i, this.mouseSelectEnd.y + 1);
                break;
            }
            xP -= charSize;
        }
        if ((i = this.calcSelectCoordsToStringIndex(coord == null ? new PC_CoordI(rowText.length(), this.mouseSelectEnd.y + 1) : coord)) > this.text.length()) {
            i = this.text.length();
        }
        return this.calcStringIndexToSelectCoords(i);
    }

    @Override
    public boolean mouseClick(PC_CoordI mousePos, int key) {
        this.mousePressed = 0;
        if (!this.enabled) {
            return false;
        }
        this.lastMousePosition.setTo(mousePos);
        if (key != -1) {
            if (mousePos.x < this.size.x - 12 && mousePos.y < this.size.y - 12) {
                this.mouseSelectEnd.setTo(this.getMousePositionInString(mousePos));
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.mousePressed = 1;
                this.setScrollToCursor();
                return true;
            }
            if (mousePos.y < this.size.y - 12) {
                if (mousePos.y - 1 < this.vScrollPos) {
                    --this.scroll.y;
                    return true;
                }
                if (mousePos.y - 1 >= this.vScrollPos + this.vScrollSize) {
                    ++this.scroll.y;
                    return true;
                }
                this.mousePressed = 2;
                return true;
            }
            if (mousePos.x < this.size.x - 12) {
                if (mousePos.x - 1 < this.hScrollPos) {
                    this.scroll.x -= 5;
                    return true;
                }
                if (mousePos.x - 1 >= this.hScrollPos + this.hScrollSize) {
                    this.scroll.x += 5;
                    return true;
                }
                this.mousePressed = 3;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseMove(PC_CoordI mousePos) {
        switch (this.mousePressed) {
            case 1: {
                this.mouseSelectEnd.setTo(this.getMousePositionInString(mousePos));
                this.setScrollToCursor();
                break;
            }
            case 2: {
                this.vScrollPos += mousePos.y - this.lastMousePosition.y;
                this.updateScrollPosition();
                break;
            }
            case 3: {
                this.hScrollPos += mousePos.x - this.lastMousePosition.x;
                this.updateScrollPosition();
            }
        }
        this.lastMousePosition.setTo(mousePos);
    }

    private int calcSelectCoordsToStringIndex(PC_CoordI c) {
        int pos = 0;
        int line = c.y;
        while (line > 0) {
            if (pos >= this.text.length()) {
                return pos;
            }
            if (this.text.charAt(pos) == '\n') {
                --line;
            }
            ++pos;
        }
        for (int p = c.x; p > 0; --p) {
            if (pos >= this.text.length()) {
                return pos;
            }
            if (this.text.charAt(pos) == '\n') {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private PC_CoordI calcStringIndexToSelectCoords(int index) {
        int xx = 0;
        int yy = 0;
        for (int i = 0; i < index && i < this.text.length(); ++i) {
            if (this.text.charAt(i) == '\n') {
                ++yy;
                xx = -1;
            }
            ++xx;
        }
        return new PC_CoordI(xx, yy);
    }

    private void addKey(char c) {
        int e;
        int s = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
        if (s > (e = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd))) {
            int t = e;
            e = s;
            s = t;
        }
        String s1 = this.text.substring(0, s);
        String s2 = this.text.substring(e);
        this.text = s1 + c + s2;
        this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(++e));
        this.mouseSelectStart.setTo(this.mouseSelectEnd);
    }

    private void deleteSelected() {
        int e;
        int s = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
        if (s > (e = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd))) {
            int t = e;
            e = s;
            s = t;
        }
        String s1 = this.text.substring(0, s);
        String s2 = this.text.substring(e);
        this.text = s1 + s2;
        this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(s));
        this.mouseSelectStart.setTo(this.mouseSelectEnd);
    }

    private void key_backspace() {
        if (this.mouseSelectStart.x != this.mouseSelectEnd.x || this.mouseSelectStart.y != this.mouseSelectEnd.y) {
            this.deleteSelected();
            return;
        }
        int e = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
        if (e <= 0) {
            return;
        }
        String s1 = this.text.substring(0, e - 1);
        String s2 = this.text.substring(e);
        this.text = s1 + s2;
        this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(e - 1));
        this.mouseSelectStart.setTo(this.mouseSelectEnd);
    }

    private void key_delete() {
        if (this.mouseSelectStart.x != this.mouseSelectEnd.x || this.mouseSelectStart.y != this.mouseSelectEnd.y) {
            this.deleteSelected();
            return;
        }
        int p = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
        if (p >= this.text.length()) {
            return;
        }
        String s1 = this.text.substring(0, p);
        String s2 = this.text.substring(p + 1);
        this.text = s1 + s2;
    }

    private String getSelect() {
        int e;
        int s = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
        if (s > (e = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd))) {
            int t = e;
            e = s;
            s = t;
        }
        return this.text.substring(s, e);
    }

    private void setSelected(String stri) {
        int e;
        int s = this.calcSelectCoordsToStringIndex(this.mouseSelectStart);
        if (s > (e = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd))) {
            int t = e;
            e = s;
            s = t;
            this.mouseSelectStart.setTo(this.mouseSelectEnd);
        }
        String s1 = this.text.substring(0, s);
        String s2 = this.text.substring(e);
        this.text = s1 + stri + s2;
        this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(s + stri.length()));
    }

    private int shownLines() {
        return (this.size.y - 26) / PC_Utils.mc().fontRenderer.FONT_HEIGHT;
    }

    private void setScrollToCursor() {
        int cy = this.mouseSelectEnd.y - this.scroll.y;
        if (cy < 0) {
            this.scroll.y = this.mouseSelectEnd.y;
        } else if (cy >= this.shownLines()) {
            this.scroll.y = this.mouseSelectEnd.y - this.shownLines() + 1;
        }
        String line = this.getLine(this.mouseSelectEnd.y);
        int cxs = this.getStringWidth(line.substring(0, this.mouseSelectEnd.x));
        int cxb = this.mouseSelectEnd.x > 0 ? this.getStringWidth(line.substring(this.mouseSelectEnd.x - 1, this.mouseSelectEnd.x)) : 0;
        int cx = cxs - this.scroll.x;
        if (cx <= cxb) {
            this.scroll.x = cxs - cxb;
        } else if (cx >= this.size.x - 25) {
            this.scroll.x = cxs - this.size.x + 27;
        }
    }

    @Override
    public boolean keyTyped(char c, int key) {
        if (!this.enabled || !this.hasFocus || this.mousePressed != 0 && this.mousePressed != 1) {
            return false;
        }
        switch (c) {
            case '\u0003': {
                GuiScreen.setClipboardString(this.getSelect());
                this.setScrollToCursor();
                return true;
            }
            case '\u0016': {
                this.setSelected(GuiScreen.getClipboardString());
                this.setScrollToCursor();
                return true;
            }
            case '\u0018': {
                GuiScreen.setClipboardString(this.getSelect());
                this.deleteSelected();
                this.setScrollToCursor();
                return true;
            }
        }
        switch (key) {
            case 28: {
                this.addKey('\n');
                this.setScrollToCursor();
                return true;
            }
            case 14: {
                this.key_backspace();
                this.setScrollToCursor();
                return true;
            }
            case 211: {
                this.key_delete();
                this.setScrollToCursor();
                return true;
            }
            case 203: {
                int p = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
                if (p > 0) {
                    this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(p - 1));
                }
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.setScrollToCursor();
                return true;
            }
            case 205: {
                int p = this.calcSelectCoordsToStringIndex(this.mouseSelectEnd);
                if (p < this.text.length()) {
                    this.mouseSelectEnd.setTo(this.calcStringIndexToSelectCoords(p + 1));
                }
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.setScrollToCursor();
                return true;
            }
            case 200: {
                this.mouseSelectEnd.setTo(this.lineUp());
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.setScrollToCursor();
                return true;
            }
            case 208: {
                this.mouseSelectEnd.setTo(this.lineDown());
                if (!Keyboard.isKeyDown((int)54) && !Keyboard.isKeyDown((int)42)) {
                    this.mouseSelectStart.setTo(this.mouseSelectEnd);
                }
                this.setScrollToCursor();
                return true;
            }
        }
        if (ChatAllowedCharacters.isAllowedCharacter(c)) {
            this.addKey(c);
            this.setScrollToCursor();
            return true;
        }
        return false;
    }

    private int getLineNumbers() {
        String s = "";
        int line = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            if (this.text.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    @Override
    public void mouseWheel(int i) {
        int maxY;
        this.scroll.y -= i;
        if (this.scroll.y < 0) {
            this.scroll.y = 0;
        }
        if ((maxY = this.getLineNumbers() - this.shownLines() + 1) < 0) {
            maxY = 0;
        }
        if (this.scroll.y > maxY) {
            this.scroll.y = maxY;
        }
    }

    @Override
    public void addedToWidget() {
    }

    public static class Keyword {
        public String word;
        public int color;

        public Keyword(String word, int color) {
            this.word = word;
            this.color = color;
        }
    }
}

