/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresWidget;

public class PC_GresLink
extends PC_GresWidget {
    private boolean isClicked = false;

    public PC_GresLink(String label) {
        super(label);
        this.canAddWidget = false;
        this.minSize.setTo(10, 0);
    }

    @Override
    public PC_CoordI calcSize() {
        this.size.setTo(this.getStringWidth(this.text), this.getLineHeight()).add(2, 0);
        if (this.size.x < this.minSize.x) {
            this.size.x = this.minSize.x;
        }
        return this.size.copy();
    }

    @Override
    public void calcChildPositions() {
    }

    @Override
    protected void render(PC_CoordI offsetPos) {
        int state = !this.enabled ? 0 : (this.isClicked ? 3 : (this.isMouseOver ? 2 : 1));
        int textColor = 0;
        if (state == 0) {
            textColor = 0xA0A0A0;
        }
        if (state == 1) {
            textColor = 0;
        }
        if (state == 2) {
            textColor = 255;
        }
        if (state == 3) {
            textColor = 0xFF0000;
        }
        this.drawStringColor(this.text, offsetPos.x + this.pos.x, offsetPos.y + this.pos.y, textColor);
        int yy = offsetPos.y + this.pos.y + this.getFontRenderer().FONT_HEIGHT;
        PC_GresLink.drawRect(offsetPos.x + this.pos.x, yy, offsetPos.x + this.size.x + this.pos.x + 1, yy + 1, textColor | 0xFF000000);
    }

    @Override
    public boolean mouseOver(PC_CoordI mpos) {
        this.isMouseOver = true;
        return true;
    }

    @Override
    public boolean mouseClick(PC_CoordI mpos, int key) {
        if (!this.enabled) {
            return false;
        }
        if (this.isClicked && key == -1) {
            this.isClicked = false;
            return true;
        }
        this.isClicked = key != -1;
        return false;
    }

    @Override
    public boolean keyTyped(char c, int key) {
        return false;
    }

    @Override
    public void mouseMove(PC_CoordI mpos) {
        if (mpos.x < 0 || mpos.x >= this.size.x || mpos.y < 0 || mpos.y >= this.size.y || !this.mouseOver(mpos)) {
            this.isClicked = false;
        }
    }

    @Override
    public PC_CoordI getMinSize() {
        return this.calcSize();
    }

    @Override
    public void mouseWheel(int i) {
    }

    @Override
    public void addedToWidget() {
    }
}

