/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_GresWidget;

public class PC_GresLabelMultiline
extends PC_GresWidget {
    private int minRows = 1;

    public PC_GresLabelMultiline(String text, int width) {
        super(width, 10, text);
        this.canAddWidget = false;
        this.alignH = PC_GresWidget.PC_GresAlign.LEFT;
    }

    public int getMinRows() {
        return this.minRows;
    }

    public PC_GresLabelMultiline setMinRows(int minRows) {
        this.minRows = minRows;
        return this;
    }

    @Override
    public PC_CoordI calcSize() {
        this.getMinSize();
        if (this.size.y < this.minSize.y) {
            this.size.y = this.minSize.y;
        }
        if (this.size.x < this.minSize.x) {
            this.size.x = this.minSize.x;
        }
        return this.size.copy();
    }

    @Override
    protected void render(PC_CoordI offsetPos) {
        String[] lines_nl;
        FontRenderer fontRenderer = this.getFontRenderer();
        int cnt = 0;
        for (String s : lines_nl = this.text.split("\n")) {
            s.trim();
            if (s.length() <= 0) continue;
            List lines = fontRenderer.listFormattedStringToWidth(s, this.getMinSize().x);
            for (String ss : lines) {
                ss.trim();
                if (ss.length() <= 0) continue;
                int wid = this.getStringWidth(ss);
                int xstart = offsetPos.x + this.pos.x;
                switch (this.alignH) {
                    case LEFT: {
                        break;
                    }
                    case CENTER: {
                        xstart = xstart + this.size.x / 2 - wid / 2;
                        break;
                    }
                    case RIGHT: {
                        xstart = xstart + this.size.x - wid;
                    }
                }
                this.drawString(ss, xstart, offsetPos.y + this.pos.y + (fontRenderer.FONT_HEIGHT + 1) * cnt);
                ++cnt;
            }
        }
    }

    @Override
    public boolean mouseOver(PC_CoordI mpos) {
        return false;
    }

    @Override
    public boolean mouseClick(PC_CoordI mpos, int key) {
        return false;
    }

    @Override
    public boolean keyTyped(char c, int key) {
        return false;
    }

    @Override
    public void calcChildPositions() {
    }

    @Override
    public void mouseMove(PC_CoordI mpos) {
    }

    @Override
    public PC_CoordI getMinSize() {
        String[] lines_nl;
        FontRenderer fontRenderer = this.getFontRenderer();
        int cnt = 0;
        for (String s : lines_nl = this.text.split("\n")) {
            s.trim();
            if (s.length() <= 0) continue;
            List lines = fontRenderer.listFormattedStringToWidth(s, this.minSize.x);
            for (String ss : lines) {
                ss.trim();
                if (s.length() <= 0) continue;
                ++cnt;
            }
        }
        this.minSize.setTo(this.minSize.x, (fontRenderer.FONT_HEIGHT + 1) * Math.max(this.minRows, cnt));
        return this.minSize;
    }

    @Override
    public void mouseWheel(int i) {
    }

    @Override
    public void addedToWidget() {
    }
}

