/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IBlockAccess;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PC_CoordD;
import net.minecraft.src.PC_CoordF;
import net.minecraft.src.PC_ICoord;
import net.minecraft.src.PC_INBT;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class PC_CoordI
implements PC_ICoord,
PC_INBT {
    public int x;
    public int y;
    public int z;

    public String toString() {
        return "[" + this.x + ";" + this.y + ";" + this.z + "]";
    }

    public PC_CoordI() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public PC_CoordI(int a, int b, int c) {
        this.x = a;
        this.y = b;
        this.z = c;
    }

    public PC_CoordI(int a, int b) {
        this.x = a;
        this.y = b;
        this.z = 0;
    }

    public PC_CoordI(long a, long b, long c) {
        this.x = (int)a;
        this.y = (int)b;
        this.z = (int)c;
    }

    public PC_CoordI(long a, long b) {
        this.x = (int)a;
        this.y = (int)b;
        this.z = 0;
    }

    public PC_CoordI(PC_CoordI c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public PC_CoordI copy() {
        return new PC_CoordI(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return ((PC_CoordI)obj).x == this.x && ((PC_CoordI)obj).y == this.y && ((PC_CoordI)obj).z == this.z;
    }

    public int hashCode() {
        return this.x + 17 ^ this.y - 156 ^ this.z;
    }

    public PC_CoordI setTo(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PC_CoordI setTo(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public PC_CoordI setTo(PC_CoordI src) {
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
        return this;
    }

    public PC_CoordI setTo(long x, long y, long z) {
        this.x = (int)x;
        this.y = (int)y;
        this.z = (int)z;
        return this;
    }

    public PC_CoordI setTo(long x, long y) {
        this.x = (int)x;
        this.y = (int)y;
        return this;
    }

    @Override
    public PC_CoordI getInverted() {
        return new PC_CoordI(-this.x, -this.y, -this.z);
    }

    public boolean equalsXZ(PC_CoordI compared) {
        return this.x == compared.x && this.z == compared.z;
    }

    public PC_CoordI add(PC_CoordI added) {
        this.x += added.x;
        this.y += added.y;
        this.z += added.z;
        return this;
    }

    public PC_CoordI add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public PC_CoordI add(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public PC_CoordI add(long x, long y, long z) {
        this.x = (int)((long)this.x + x);
        this.y = (int)((long)this.y + y);
        this.z = (int)((long)this.z + z);
        return this;
    }

    public PC_CoordI add(long x, long y) {
        this.x = (int)((long)this.x + x);
        this.y = (int)((long)this.y + y);
        return this;
    }

    @Override
    public PC_CoordI offset(PC_CoordI added) {
        return new PC_CoordI(this.x + added.x, this.y + added.y, this.z + added.z);
    }

    @Override
    public PC_CoordF offset(PC_CoordF added) {
        return new PC_CoordF((float)this.x + added.x, (float)this.y + added.y, (float)this.z + added.z);
    }

    @Override
    public PC_CoordD offset(PC_CoordD added) {
        return new PC_CoordD((double)this.x + added.x, (double)this.y + added.y, (double)this.z + added.z);
    }

    @Override
    public PC_CoordI offset(int xm, int ym, int zm) {
        return new PC_CoordI(this.x + xm, this.y + ym, this.z + zm);
    }

    @Override
    public PC_CoordF offset(float xm, float ym, float zm) {
        return new PC_CoordF((float)this.x + xm, (float)this.y + ym, (float)this.z + zm);
    }

    @Override
    public PC_CoordD offset(double xm, double ym, double zm) {
        return new PC_CoordD((double)this.x + xm, (double)this.y + ym, (double)this.z + zm);
    }

    @Override
    public PC_CoordI offset(long xm, long ym, long zm) {
        return new PC_CoordI((long)this.x + xm, (long)this.y + ym, (long)this.z + zm);
    }

    public PC_CoordI offset(int xm, int ym) {
        return new PC_CoordI(this.x + xm, this.y + ym, this.z);
    }

    public PC_CoordF offset(float xm, float ym) {
        return new PC_CoordF((float)this.x + xm, (float)this.y + ym, (float)this.z);
    }

    public PC_CoordD offset(double xm, double ym) {
        return new PC_CoordD((double)this.x + xm, (double)this.y + ym, (double)this.z);
    }

    public PC_CoordI offset(long xm, long ym) {
        return new PC_CoordI((long)this.x + xm, (long)this.y + ym, (long)this.z);
    }

    public PC_CoordI setX(int xx) {
        return new PC_CoordI(xx, this.y, this.z);
    }

    public PC_CoordI setY(int yy) {
        return new PC_CoordI(this.x, yy, this.z);
    }

    public PC_CoordI setZ(int zz) {
        return new PC_CoordI(this.x, this.y, zz);
    }

    public int getId(IBlockAccess iba) {
        return iba.getBlockId(this.x, this.y, this.z);
    }

    public int getMeta(IBlockAccess iba) {
        return iba.getBlockMetadata(this.x, this.y, this.z);
    }

    public boolean setBlock(World w, int id, int meta) {
        return w.setBlockAndMetadataWithNotify(this.x, this.y, this.z, id, meta);
    }

    public boolean setBlockNoNotify(World w, int id, int meta) {
        return w.setBlockAndMetadata(this.x, this.y, this.z, id, meta);
    }

    public void setMeta(World w, int meta) {
        w.setBlockMetadataWithNotify(this.x, this.y, this.z, meta);
    }

    public void setId(World w, int id) {
        w.setBlockWithNotify(this.x, this.y, this.z, id);
    }

    public TileEntity getTileEntity(World world) {
        return world.getBlockTileEntity(this.x, this.y, this.z);
    }

    @Override
    public PC_CoordI round() {
        return this.copy();
    }

    @Override
    public PC_CoordI floor() {
        return this.copy();
    }

    @Override
    public PC_CoordI ceil() {
        return this.copy();
    }

    public double distanceTo(PC_CoordI pos) {
        return Math.sqrt((this.x - pos.x) * (this.x - pos.x) + (this.y - pos.y) * (this.y - pos.y) + (this.z - pos.z) * (this.z - pos.z));
    }

    public PC_CoordD getVectorTo(PC_CoordI pos) {
        return new PC_CoordD(pos.x - this.x, pos.y - this.y, pos.z - this.z);
    }

    public static PC_CoordD getVector(PC_CoordI pos1, PC_CoordI pos2) {
        return new PC_CoordD(pos2.x - pos1.x, pos2.y - pos1.y, pos2.z - pos1.z);
    }

    public double distanceHorizontalTo(PC_CoordI pos) {
        return Math.sqrt((this.x - pos.x) * (this.x - pos.x) + (this.z - pos.z) * (this.z - pos.z));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.setInteger("ix", this.x);
        tag.setInteger("iy", this.y);
        tag.setInteger("iz", this.z);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.x = tag.getInteger("ix");
        this.y = tag.getInteger("iy");
        this.z = tag.getInteger("iz");
    }
}

