/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.PC_CoordI;
import net.minecraft.src.PC_IBlockType;
import net.minecraft.src.World;

public class PC_BlockUtils {
    public static Set<String> getBlockFlags(World world, PC_CoordI pos) {
        int id = pos.getId(world);
        if (Block.blocksList[id] != null && Block.blocksList[id] instanceof PC_IBlockType) {
            PC_IBlockType type = (PC_IBlockType)((Object)Block.blocksList[id]);
            return type.getBlockFlags(world, pos);
        }
        return new HashSet<String>();
    }

    public static boolean hasFlag(World world, PC_CoordI pos, String flag) {
        return PC_BlockUtils.getBlockFlags(world, pos).contains(flag);
    }

    public static boolean hasFlag(ItemStack stack, String flag) {
        return PC_BlockUtils.getItemFlags(stack).contains(flag);
    }

    public static Set<String> getItemFlags(ItemStack stack) {
        if (stack == null) {
            return new HashSet<String>();
        }
        if (stack.getItem() instanceof ItemBlock) {
            return new HashSet<String>();
        }
        if (Block.blocksList[stack.getItem().shiftedIndex] != null && Block.blocksList[stack.getItem().shiftedIndex] instanceof PC_IBlockType) {
            PC_IBlockType type = (PC_IBlockType)((Object)Block.blocksList[stack.getItem().shiftedIndex]);
            return type.getItemFlags(stack.getItemDamage());
        }
        return new HashSet<String>();
    }
}

