/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import codechicken.nei.API;
import codechicken.nei.IConfigureNEI;
import codechicken.nei.MultiItemRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.src.PC_InveditManager;
import net.minecraft.src.PC_Logger;

public class NEIPowerCraftConfig
implements IConfigureNEI {
    @Override
    public void loadConfig() {
        PC_Logger.fine("Loading NEI configuration.");
        for (Integer id : PC_InveditManager.hidden) {
            API.hideItem(id);
            PC_Logger.finer("Hiding item ID = " + id);
        }
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (Integer id : PC_InveditManager.damageRanges.keySet()) {
            list.clear();
            Integer[] range = PC_InveditManager.damageRanges.get(id);
            if (range.length != 2) {
                PC_Logger.severe("Invedit Manager: Invalid damage range for item with ID=" + id);
                continue;
            }
            list.add(new int[]{range[0], range[1]});
            API.setItemDamageVariants((int)id, list);
            PC_Logger.finer("Setting item damage variants ID = " + id + ", damage range=" + range[0] + " - " + range[1]);
        }
        for (Integer id : PC_InveditManager.damageLists.keySet()) {
            Integer[] damageList = PC_InveditManager.damageLists.get(id);
            List<Integer> col = Arrays.asList(damageList);
            if (col == null || col.size() == 0) {
                PC_Logger.severe("Invedit Manager: Invalid damage list for item with ID=" + id);
                continue;
            }
            API.setItemDamageVariants((int)id, col);
            PC_Logger.finer("Setting item damage variants ID = " + id + ", collection:");
            for (Integer dmg : col) {
                PC_Logger.finest("" + dmg);
            }
        }
        HashMap categoryLists = new HashMap();
        for (Integer id : PC_InveditManager.categories.keySet()) {
            String cat = PC_InveditManager.categories.get(id);
            if (!categoryLists.containsKey(cat)) {
                categoryLists.put(cat, new HashSet());
            }
            ((HashSet)categoryLists.get(cat)).add(id);
            PC_Logger.finest("Adding ID = " + id + " to category " + cat);
        }
        for (String catname : categoryLists.keySet()) {
            HashSet set = (HashSet)categoryLists.get(catname);
            if (set == null || set.size() <= 0) continue;
            MultiItemRange range = new MultiItemRange();
            for (Integer id : set) {
                range.add(id);
            }
            API.addSetRange("PowerCraft." + catname, range);
        }
    }
}

