/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.NBTBase;

public class NBTTagList
extends NBTBase {
    private List tagList = new ArrayList();
    private byte tagType;

    public NBTTagList() {
        super("");
    }

    public NBTTagList(String par1Str) {
        super(par1Str);
    }

    @Override
    void write(DataOutput par1DataOutput) throws IOException {
        this.tagType = this.tagList.size() > 0 ? ((NBTBase)this.tagList.get(0)).getId() : (byte)1;
        par1DataOutput.writeByte(this.tagType);
        par1DataOutput.writeInt(this.tagList.size());
        for (int i = 0; i < this.tagList.size(); ++i) {
            ((NBTBase)this.tagList.get(i)).write(par1DataOutput);
        }
    }

    @Override
    void load(DataInput par1DataInput) throws IOException {
        this.tagType = par1DataInput.readByte();
        int i = par1DataInput.readInt();
        this.tagList = new ArrayList();
        for (int j = 0; j < i; ++j) {
            NBTBase nbtbase = NBTBase.newTag(this.tagType, null);
            nbtbase.load(par1DataInput);
            this.tagList.add(nbtbase);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    public String toString() {
        return "" + this.tagList.size() + " entries of type " + NBTBase.getTagName(this.tagType);
    }

    public void appendTag(NBTBase par1NBTBase) {
        this.tagType = par1NBTBase.getId();
        this.tagList.add(par1NBTBase);
    }

    public NBTBase tagAt(int par1) {
        return (NBTBase)this.tagList.get(par1);
    }

    public int tagCount() {
        return this.tagList.size();
    }

    @Override
    public NBTBase copy() {
        NBTTagList nbttaglist = new NBTTagList(this.getName());
        nbttaglist.tagType = this.tagType;
        for (NBTBase nbtbase : this.tagList) {
            NBTBase nbtbase1 = nbtbase.copy();
            nbttaglist.tagList.add(nbtbase1);
        }
        return nbttaglist;
    }

    @Override
    public boolean equals(Object par1Obj) {
        if (super.equals(par1Obj)) {
            NBTTagList nbttaglist = (NBTTagList)par1Obj;
            if (this.tagType == nbttaglist.tagType) {
                return ((Object)this.tagList).equals(nbttaglist.tagList);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.tagList).hashCode();
    }
}

