/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityDragon;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.ModelBase;
import net.minecraft.src.ModelRenderer;
import org.lwjgl.opengl.GL11;

public class ModelDragon
extends ModelBase {
    private ModelRenderer head;
    private ModelRenderer neck;
    private ModelRenderer jaw;
    private ModelRenderer body;
    private ModelRenderer rearLeg;
    private ModelRenderer frontLeg;
    private ModelRenderer rearLegTip;
    private ModelRenderer frontLegTip;
    private ModelRenderer rearFoot;
    private ModelRenderer frontFoot;
    private ModelRenderer wing;
    private ModelRenderer wingTip;
    private float partialTicks;

    public ModelDragon(float par1) {
        this.textureWidth = 256;
        this.textureHeight = 256;
        this.setTextureOffset("body.body", 0, 0);
        this.setTextureOffset("wing.skin", -56, 88);
        this.setTextureOffset("wingtip.skin", -56, 144);
        this.setTextureOffset("rearleg.main", 0, 0);
        this.setTextureOffset("rearfoot.main", 112, 0);
        this.setTextureOffset("rearlegtip.main", 196, 0);
        this.setTextureOffset("head.upperhead", 112, 30);
        this.setTextureOffset("wing.bone", 112, 88);
        this.setTextureOffset("head.upperlip", 176, 44);
        this.setTextureOffset("jaw.jaw", 176, 65);
        this.setTextureOffset("frontleg.main", 112, 104);
        this.setTextureOffset("wingtip.bone", 112, 136);
        this.setTextureOffset("frontfoot.main", 144, 104);
        this.setTextureOffset("neck.box", 192, 104);
        this.setTextureOffset("frontlegtip.main", 226, 138);
        this.setTextureOffset("body.scale", 220, 53);
        this.setTextureOffset("head.scale", 0, 0);
        this.setTextureOffset("neck.scale", 48, 0);
        this.setTextureOffset("head.nostril", 112, 0);
        float f = -16.0f;
        this.head = new ModelRenderer(this, "head");
        this.head.addBox("upperlip", -6.0f, -1.0f, -8.0f + f, 12, 5, 16);
        this.head.addBox("upperhead", -8.0f, -8.0f, 6.0f + f, 16, 16, 16);
        this.head.mirror = true;
        this.head.addBox("scale", -5.0f, -12.0f, 12.0f + f, 2, 4, 6);
        this.head.addBox("nostril", -5.0f, -3.0f, -6.0f + f, 2, 2, 4);
        this.head.mirror = false;
        this.head.addBox("scale", 3.0f, -12.0f, 12.0f + f, 2, 4, 6);
        this.head.addBox("nostril", 3.0f, -3.0f, -6.0f + f, 2, 2, 4);
        this.jaw = new ModelRenderer(this, "jaw");
        this.jaw.setRotationPoint(0.0f, 4.0f, 8.0f + f);
        this.jaw.addBox("jaw", -6.0f, 0.0f, -16.0f, 12, 4, 16);
        this.head.addChild(this.jaw);
        this.neck = new ModelRenderer(this, "neck");
        this.neck.addBox("box", -5.0f, -5.0f, -5.0f, 10, 10, 10);
        this.neck.addBox("scale", -1.0f, -9.0f, -3.0f, 2, 4, 6);
        this.body = new ModelRenderer(this, "body");
        this.body.setRotationPoint(0.0f, 4.0f, 8.0f);
        this.body.addBox("body", -12.0f, 0.0f, -16.0f, 24, 24, 64);
        this.body.addBox("scale", -1.0f, -6.0f, -10.0f, 2, 6, 12);
        this.body.addBox("scale", -1.0f, -6.0f, 10.0f, 2, 6, 12);
        this.body.addBox("scale", -1.0f, -6.0f, 30.0f, 2, 6, 12);
        this.wing = new ModelRenderer(this, "wing");
        this.wing.setRotationPoint(-12.0f, 5.0f, 2.0f);
        this.wing.addBox("bone", -56.0f, -4.0f, -4.0f, 56, 8, 8);
        this.wing.addBox("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56);
        this.wingTip = new ModelRenderer(this, "wingtip");
        this.wingTip.setRotationPoint(-56.0f, 0.0f, 0.0f);
        this.wingTip.addBox("bone", -56.0f, -2.0f, -2.0f, 56, 4, 4);
        this.wingTip.addBox("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56);
        this.wing.addChild(this.wingTip);
        this.frontLeg = new ModelRenderer(this, "frontleg");
        this.frontLeg.setRotationPoint(-12.0f, 20.0f, 2.0f);
        this.frontLeg.addBox("main", -4.0f, -4.0f, -4.0f, 8, 24, 8);
        this.frontLegTip = new ModelRenderer(this, "frontlegtip");
        this.frontLegTip.setRotationPoint(0.0f, 20.0f, -1.0f);
        this.frontLegTip.addBox("main", -3.0f, -1.0f, -3.0f, 6, 24, 6);
        this.frontLeg.addChild(this.frontLegTip);
        this.frontFoot = new ModelRenderer(this, "frontfoot");
        this.frontFoot.setRotationPoint(0.0f, 23.0f, 0.0f);
        this.frontFoot.addBox("main", -4.0f, 0.0f, -12.0f, 8, 4, 16);
        this.frontLegTip.addChild(this.frontFoot);
        this.rearLeg = new ModelRenderer(this, "rearleg");
        this.rearLeg.setRotationPoint(-16.0f, 16.0f, 42.0f);
        this.rearLeg.addBox("main", -8.0f, -4.0f, -8.0f, 16, 32, 16);
        this.rearLegTip = new ModelRenderer(this, "rearlegtip");
        this.rearLegTip.setRotationPoint(0.0f, 32.0f, -4.0f);
        this.rearLegTip.addBox("main", -6.0f, -2.0f, 0.0f, 12, 32, 12);
        this.rearLeg.addChild(this.rearLegTip);
        this.rearFoot = new ModelRenderer(this, "rearfoot");
        this.rearFoot.setRotationPoint(0.0f, 31.0f, 4.0f);
        this.rearFoot.addBox("main", -9.0f, 0.0f, -20.0f, 18, 6, 24);
        this.rearLegTip.addChild(this.rearFoot);
    }

    @Override
    public void setLivingAnimations(EntityLiving par1EntityLiving, float par2, float par3, float par4) {
        this.partialTicks = par4;
    }

    @Override
    public void render(Entity par1Entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        GL11.glPushMatrix();
        EntityDragon entitydragon = (EntityDragon)par1Entity;
        float f = entitydragon.prevAnimTime + (entitydragon.animTime - entitydragon.prevAnimTime) * this.partialTicks;
        this.jaw.rotateAngleX = (float)(Math.sin(f * (float)Math.PI * 2.0f) + 1.0) * 0.2f;
        float f1 = (float)(Math.sin(f * (float)Math.PI * 2.0f - 1.0f) + 1.0);
        f1 = (f1 * f1 * 1.0f + f1 * 2.0f) * 0.05f;
        GL11.glTranslatef((float)0.0f, (float)(f1 - 2.0f), (float)-3.0f);
        GL11.glRotatef((float)(f1 * 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f2 = -30.0f;
        float f4 = 0.0f;
        float f5 = 1.5f;
        double[] ad = entitydragon.getMovementOffsets(6, this.partialTicks);
        float f6 = this.updateRotations(entitydragon.getMovementOffsets(5, this.partialTicks)[0] - entitydragon.getMovementOffsets(10, this.partialTicks)[0]);
        float f7 = this.updateRotations(entitydragon.getMovementOffsets(5, this.partialTicks)[0] + (double)(f6 / 2.0f));
        f2 += 2.0f;
        float f8 = f * (float)Math.PI * 2.0f;
        f2 = 20.0f;
        float f3 = -12.0f;
        for (int i = 0; i < 5; ++i) {
            double[] ad3 = entitydragon.getMovementOffsets(5 - i, this.partialTicks);
            float f10 = (float)Math.cos((float)i * 0.45f + f8) * 0.15f;
            this.neck.rotateAngleY = this.updateRotations(ad3[0] - ad[0]) * (float)Math.PI / 180.0f * f5;
            this.neck.rotateAngleX = f10 + (float)(ad3[1] - ad[1]) * (float)Math.PI / 180.0f * f5 * 5.0f;
            this.neck.rotateAngleZ = -this.updateRotations(ad3[0] - (double)f7) * (float)Math.PI / 180.0f * f5;
            this.neck.rotationPointY = f2;
            this.neck.rotationPointZ = f3;
            this.neck.rotationPointX = f4;
            f2 = (float)((double)f2 + Math.sin(this.neck.rotateAngleX) * 10.0);
            f3 = (float)((double)f3 - Math.cos(this.neck.rotateAngleY) * Math.cos(this.neck.rotateAngleX) * 10.0);
            f4 = (float)((double)f4 - Math.sin(this.neck.rotateAngleY) * Math.cos(this.neck.rotateAngleX) * 10.0);
            this.neck.render(par7);
        }
        this.head.rotationPointY = f2;
        this.head.rotationPointZ = f3;
        this.head.rotationPointX = f4;
        double[] ad1 = entitydragon.getMovementOffsets(0, this.partialTicks);
        this.head.rotateAngleY = this.updateRotations(ad1[0] - ad[0]) * (float)Math.PI / 180.0f * 1.0f;
        this.head.rotateAngleZ = -this.updateRotations(ad1[0] - (double)f7) * (float)Math.PI / 180.0f * 1.0f;
        this.head.render(par7);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f6 * f5 * 1.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)0.0f);
        this.body.rotateAngleZ = 0.0f;
        this.body.render(par7);
        for (int j = 0; j < 2; ++j) {
            GL11.glEnable((int)2884);
            float f11 = f * (float)Math.PI * 2.0f;
            this.wing.rotateAngleX = 0.125f - (float)Math.cos(f11) * 0.2f;
            this.wing.rotateAngleY = 0.25f;
            this.wing.rotateAngleZ = (float)(Math.sin(f11) + 0.125) * 0.8f;
            this.wingTip.rotateAngleZ = -((float)(Math.sin(f11 + 2.0f) + 0.5)) * 0.75f;
            this.rearLeg.rotateAngleX = 1.0f + f1 * 0.1f;
            this.rearLegTip.rotateAngleX = 0.5f + f1 * 0.1f;
            this.rearFoot.rotateAngleX = 0.75f + f1 * 0.1f;
            this.frontLeg.rotateAngleX = 1.3f + f1 * 0.1f;
            this.frontLegTip.rotateAngleX = -0.5f - f1 * 0.1f;
            this.frontFoot.rotateAngleX = 0.75f + f1 * 0.1f;
            this.wing.render(par7);
            this.frontLeg.render(par7);
            this.rearLeg.render(par7);
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            if (j != 0) continue;
            GL11.glCullFace((int)1028);
        }
        GL11.glPopMatrix();
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)2884);
        float f9 = -((float)Math.sin(f * (float)Math.PI * 2.0f)) * 0.0f;
        f8 = f * (float)Math.PI * 2.0f;
        f2 = 10.0f;
        f3 = 60.0f;
        f4 = 0.0f;
        ad = entitydragon.getMovementOffsets(11, this.partialTicks);
        for (int k = 0; k < 12; ++k) {
            double[] ad2 = entitydragon.getMovementOffsets(12 + k, this.partialTicks);
            f9 = (float)((double)f9 + Math.sin((float)k * 0.45f + f8) * (double)0.05f);
            this.neck.rotateAngleY = (this.updateRotations(ad2[0] - ad[0]) * f5 + 180.0f) * (float)Math.PI / 180.0f;
            this.neck.rotateAngleX = f9 + (float)(ad2[1] - ad[1]) * (float)Math.PI / 180.0f * f5 * 5.0f;
            this.neck.rotateAngleZ = this.updateRotations(ad2[0] - (double)f7) * (float)Math.PI / 180.0f * f5;
            this.neck.rotationPointY = f2;
            this.neck.rotationPointZ = f3;
            this.neck.rotationPointX = f4;
            f2 = (float)((double)f2 + Math.sin(this.neck.rotateAngleX) * 10.0);
            f3 = (float)((double)f3 - Math.cos(this.neck.rotateAngleY) * Math.cos(this.neck.rotateAngleX) * 10.0);
            f4 = (float)((double)f4 - Math.sin(this.neck.rotateAngleY) * Math.cos(this.neck.rotateAngleX) * 10.0);
            this.neck.render(par7);
        }
        GL11.glPopMatrix();
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6) {
        super.setRotationAngles(par1, par2, par3, par4, par5, par6);
    }

    private float updateRotations(double par1) {
        while (par1 >= 180.0) {
            par1 -= 360.0;
        }
        while (par1 < -180.0) {
            par1 += 360.0;
        }
        return (float)par1;
    }
}

