/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.minecraft.src.ModLoader;
import net.minecraft.src.TextureFX;
import org.lwjgl.opengl.GL11;

public class ModTextureAnimation
extends TextureFX {
    private final int tickRate;
    private final byte[][] images;
    private int index = 0;
    private int ticks = 0;

    public ModTextureAnimation(int i, int j, BufferedImage bufferedimage, int k) {
        this(i, 1, j, bufferedimage, k);
    }

    public ModTextureAnimation(int i, int j, int k, BufferedImage bufferedimage, int l) {
        super(i);
        this.tileSize = j;
        this.tileImage = k;
        this.tickRate = l;
        this.ticks = l;
        this.bindImage(ModLoader.getMinecraftInstance().renderEngine);
        int i1 = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) / 16;
        int j1 = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097) / 16;
        int k1 = bufferedimage.getWidth();
        int l1 = bufferedimage.getHeight();
        int i2 = (int)Math.floor(l1 / k1);
        if (i2 <= 0) {
            throw new IllegalArgumentException("source has no complete images");
        }
        this.images = new byte[i2][];
        if (k1 != i1) {
            BufferedImage bufferedimage1 = new BufferedImage(i1, j1 * i2, 6);
            Graphics2D graphics2d = bufferedimage1.createGraphics();
            graphics2d.drawImage(bufferedimage, 0, 0, i1, j1 * i2, 0, 0, k1, l1, null);
            graphics2d.dispose();
            bufferedimage = bufferedimage1;
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            int[] ai = new int[i1 * j1];
            bufferedimage.getRGB(0, j1 * j2, i1, j1, ai, 0, i1);
            this.images[j2] = new byte[i1 * j1 * 4];
            for (int k2 = 0; k2 < ai.length; ++k2) {
                int l2 = ai[k2] >> 24 & 0xFF;
                int i3 = ai[k2] >> 16 & 0xFF;
                int j3 = ai[k2] >> 8 & 0xFF;
                int k3 = ai[k2] >> 0 & 0xFF;
                this.images[j2][k2 * 4 + 0] = (byte)i3;
                this.images[j2][k2 * 4 + 1] = (byte)j3;
                this.images[j2][k2 * 4 + 2] = (byte)k3;
                this.images[j2][k2 * 4 + 3] = (byte)l2;
            }
        }
    }

    @Override
    public void onTick() {
        if (this.ticks >= this.tickRate) {
            ++this.index;
            if (this.index >= this.images.length) {
                this.index = 0;
            }
            this.imageData = this.images[this.index];
            this.ticks = 0;
        }
        ++this.ticks;
    }
}

