/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagShort;
import net.minecraft.src.WorldSavedData;

public class MapStorage {
    private ISaveHandler saveHandler;
    private Map loadedDataMap = new HashMap();
    private List loadedDataList = new ArrayList();
    private Map idCounts = new HashMap();

    public MapStorage(ISaveHandler par1ISaveHandler) {
        this.saveHandler = par1ISaveHandler;
        this.loadIdCounts();
    }

    public WorldSavedData loadData(Class par1Class, String par2Str) {
        WorldSavedData worldsaveddata;
        block7: {
            worldsaveddata = (WorldSavedData)this.loadedDataMap.get(par2Str);
            if (worldsaveddata != null) {
                return worldsaveddata;
            }
            if (this.saveHandler != null) {
                try {
                    File file = this.saveHandler.getMapFileFromName(par2Str);
                    if (file == null || !file.exists()) break block7;
                    try {
                        worldsaveddata = (WorldSavedData)par1Class.getConstructor(String.class).newInstance(par2Str);
                    }
                    catch (Exception exception1) {
                        throw new RuntimeException("Failed to instantiate " + par1Class.toString(), exception1);
                    }
                    FileInputStream fileinputstream = new FileInputStream(file);
                    NBTTagCompound nbttagcompound = CompressedStreamTools.readCompressed(fileinputstream);
                    fileinputstream.close();
                    worldsaveddata.readFromNBT(nbttagcompound.getCompoundTag("data"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (worldsaveddata != null) {
            this.loadedDataMap.put(par2Str, worldsaveddata);
            this.loadedDataList.add(worldsaveddata);
        }
        return worldsaveddata;
    }

    public void setData(String par1Str, WorldSavedData par2WorldSavedData) {
        if (par2WorldSavedData == null) {
            throw new RuntimeException("Can't set null data");
        }
        if (this.loadedDataMap.containsKey(par1Str)) {
            this.loadedDataList.remove(this.loadedDataMap.remove(par1Str));
        }
        this.loadedDataMap.put(par1Str, par2WorldSavedData);
        this.loadedDataList.add(par2WorldSavedData);
    }

    public void saveAllData() {
        for (int i = 0; i < this.loadedDataList.size(); ++i) {
            WorldSavedData worldsaveddata = (WorldSavedData)this.loadedDataList.get(i);
            if (!worldsaveddata.isDirty()) continue;
            this.saveData(worldsaveddata);
            worldsaveddata.setDirty(false);
        }
    }

    private void saveData(WorldSavedData par1WorldSavedData) {
        if (this.saveHandler == null) {
            return;
        }
        try {
            File file = this.saveHandler.getMapFileFromName(par1WorldSavedData.mapName);
            if (file != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                par1WorldSavedData.writeToNBT(nbttagcompound);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setCompoundTag("data", nbttagcompound);
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                CompressedStreamTools.writeCompressed(nbttagcompound1, fileoutputstream);
                fileoutputstream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadIdCounts() {
        try {
            this.idCounts.clear();
            if (this.saveHandler == null) {
                return;
            }
            File file = this.saveHandler.getMapFileFromName("idcounts");
            if (file != null && file.exists()) {
                DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));
                NBTTagCompound nbttagcompound = CompressedStreamTools.read(datainputstream);
                datainputstream.close();
                for (NBTBase nbtbase : nbttagcompound.getTags()) {
                    if (!(nbtbase instanceof NBTTagShort)) continue;
                    NBTTagShort nbttagshort = (NBTTagShort)nbtbase;
                    String s = nbttagshort.getName();
                    short word0 = nbttagshort.data;
                    this.idCounts.put(s, word0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getUniqueDataId(String par1Str) {
        Short short1 = (Short)this.idCounts.get(par1Str);
        if (short1 == null) {
            short1 = 0;
        } else {
            Short short2 = short1;
            Short short3 = short1 = Short.valueOf((short)(short1 + 1));
            Short _tmp = short2;
        }
        this.idCounts.put(par1Str, short1);
        if (this.saveHandler == null) {
            return short1.shortValue();
        }
        try {
            File file = this.saveHandler.getMapFileFromName("idcounts");
            if (file != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                for (String s : this.idCounts.keySet()) {
                    short word0 = (Short)this.idCounts.get(s);
                    nbttagcompound.setShort(s, word0);
                }
                DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));
                CompressedStreamTools.write(nbttagcompound, dataoutputstream);
                dataoutputstream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return short1.shortValue();
    }
}

