/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.StructureBoundingBox;
import net.minecraft.src.StructureComponent;
import net.minecraft.src.StructureStart;
import net.minecraft.src.World;

public abstract class MapGenStructure
extends MapGenBase {
    protected HashMap coordMap = new HashMap();

    @Override
    public void generate(IChunkProvider par1IChunkProvider, World par2World, int par3, int par4, byte[] par5ArrayOfByte) {
        super.generate(par1IChunkProvider, par2World, par3, par4, par5ArrayOfByte);
    }

    @Override
    protected void recursiveGenerate(World par1World, int par2, int par3, int par4, int par5, byte[] par6ArrayOfByte) {
        if (this.coordMap.containsKey(ChunkCoordIntPair.chunkXZ2Int(par2, par3))) {
            return;
        }
        this.rand.nextInt();
        if (this.canSpawnStructureAtCoords(par2, par3)) {
            StructureStart structurestart = this.getStructureStart(par2, par3);
            this.coordMap.put(ChunkCoordIntPair.chunkXZ2Int(par2, par3), structurestart);
        }
    }

    public boolean generateStructuresInChunk(World par1World, Random par2Random, int par3, int par4) {
        int i = (par3 << 4) + 8;
        int j = (par4 << 4) + 8;
        boolean flag = false;
        for (StructureStart structurestart : this.coordMap.values()) {
            if (!structurestart.isSizeableStructure() || !structurestart.getBoundingBox().intersectsWith(i, j, i + 15, j + 15)) continue;
            structurestart.generateStructure(par1World, par2Random, new StructureBoundingBox(i, j, i + 15, j + 15));
            flag = true;
        }
        return flag;
    }

    public boolean func_40483_a(int par1, int par2, int par3) {
        block2: {
            for (StructureStart structurestart : this.coordMap.values()) {
                if (!structurestart.isSizeableStructure() || !structurestart.getBoundingBox().intersectsWith(par1, par3, par1, par3)) continue;
                for (StructureComponent structurecomponent : structurestart.getComponents()) {
                    if (!structurecomponent.getBoundingBox().isVecInside(par1, par2, par3)) continue;
                    break block2;
                }
            }
            return false;
        }
        return true;
    }

    public ChunkPosition getNearestInstance(World par1World, int par2, int par3, int par4) {
        this.worldObj = par1World;
        this.rand.setSeed(par1World.getSeed());
        long l = this.rand.nextLong();
        long l1 = this.rand.nextLong();
        long l2 = (long)(par2 >> 4) * l;
        long l3 = (long)(par4 >> 4) * l1;
        this.rand.setSeed(l2 ^ l3 ^ par1World.getSeed());
        this.recursiveGenerate(par1World, par2 >> 4, par4 >> 4, 0, 0, null);
        double d = Double.MAX_VALUE;
        ChunkPosition chunkposition = null;
        for (StructureStart structurestart : this.coordMap.values()) {
            if (!structurestart.isSizeableStructure()) continue;
            StructureComponent structurecomponent = (StructureComponent)structurestart.getComponents().get(0);
            ChunkPosition chunkposition2 = structurecomponent.getCenter();
            int i = chunkposition2.x - par2;
            int k = chunkposition2.y - par3;
            int j1 = chunkposition2.z - par4;
            double d1 = i + i * k * k + j1 * j1;
            if (!(d1 < d)) continue;
            d = d1;
            chunkposition = chunkposition2;
        }
        if (chunkposition != null) {
            return chunkposition;
        }
        List obj = this.func_40482_a();
        if (obj != null) {
            ChunkPosition chunkposition1 = null;
            for (ChunkPosition chunkposition3 : (List)obj) {
                int j = chunkposition3.x - par2;
                int i1 = chunkposition3.y - par3;
                int k1 = chunkposition3.z - par4;
                double d2 = j + j * i1 * i1 + k1 * k1;
                if (!(d2 < d)) continue;
                d = d2;
                chunkposition1 = chunkposition3;
            }
            return chunkposition1;
        }
        return null;
    }

    protected List func_40482_a() {
        return null;
    }

    protected abstract boolean canSpawnStructureAtCoords(int var1, int var2);

    protected abstract StructureStart getStructureStart(int var1, int var2);
}

