/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MapCoord;
import net.minecraft.src.MapInfo;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.WorldSavedData;

public class MapData
extends WorldSavedData {
    public int xCenter;
    public int zCenter;
    public byte dimension;
    public byte scale;
    public byte[] colors = new byte[16384];
    public int field_28175_g;
    public List field_28174_h = new ArrayList();
    private Map field_28172_j = new HashMap();
    public List playersVisibleOnMap = new ArrayList();

    public MapData(String par1Str) {
        super(par1Str);
    }

    @Override
    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.dimension = par1NBTTagCompound.getByte("dimension");
        this.xCenter = par1NBTTagCompound.getInteger("xCenter");
        this.zCenter = par1NBTTagCompound.getInteger("zCenter");
        this.scale = par1NBTTagCompound.getByte("scale");
        if (this.scale < 0) {
            this.scale = 0;
        }
        if (this.scale > 4) {
            this.scale = (byte)4;
        }
        int word0 = par1NBTTagCompound.getShort("width");
        int word1 = par1NBTTagCompound.getShort("height");
        if (word0 == 128 && word1 == 128) {
            this.colors = par1NBTTagCompound.getByteArray("colors");
        } else {
            byte[] abyte0 = par1NBTTagCompound.getByteArray("colors");
            this.colors = new byte[16384];
            int i = (128 - word0) / 2;
            int j = (128 - word1) / 2;
            for (int k = 0; k < word1; ++k) {
                int l = k + j;
                if (l < 0 && l >= 128) continue;
                for (int i1 = 0; i1 < word0; ++i1) {
                    int j1 = i1 + i;
                    if (j1 < 0 && j1 >= 128) continue;
                    this.colors[j1 + l * 128] = abyte0[i1 + k * word0];
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setByte("dimension", this.dimension);
        par1NBTTagCompound.setInteger("xCenter", this.xCenter);
        par1NBTTagCompound.setInteger("zCenter", this.zCenter);
        par1NBTTagCompound.setByte("scale", this.scale);
        par1NBTTagCompound.setShort("width", (short)128);
        par1NBTTagCompound.setShort("height", (short)128);
        par1NBTTagCompound.setByteArray("colors", this.colors);
    }

    public void func_28169_a(EntityPlayer par1EntityPlayer, ItemStack par2ItemStack) {
        if (!this.field_28172_j.containsKey(par1EntityPlayer)) {
            MapInfo mapinfo = new MapInfo(this, par1EntityPlayer);
            this.field_28172_j.put(par1EntityPlayer, mapinfo);
            this.field_28174_h.add(mapinfo);
        }
        this.playersVisibleOnMap.clear();
        for (int i = 0; i < this.field_28174_h.size(); ++i) {
            MapInfo mapinfo1 = (MapInfo)this.field_28174_h.get(i);
            if (mapinfo1.entityplayerObj.isDead || !mapinfo1.entityplayerObj.inventory.hasItemStack(par2ItemStack)) {
                this.field_28172_j.remove(mapinfo1.entityplayerObj);
                this.field_28174_h.remove(mapinfo1);
                continue;
            }
            float f = (float)(mapinfo1.entityplayerObj.posX - (double)this.xCenter) / (float)(1 << this.scale);
            float f1 = (float)(mapinfo1.entityplayerObj.posZ - (double)this.zCenter) / (float)(1 << this.scale);
            int j = 64;
            int k = 64;
            if (f < (float)(-j) || f1 < (float)(-k) || f > (float)j || f1 > (float)k) continue;
            byte byte0 = 0;
            byte byte1 = (byte)((double)(f * 2.0f) + 0.5);
            byte byte2 = (byte)((double)(f1 * 2.0f) + 0.5);
            byte byte3 = (byte)((double)(par1EntityPlayer.rotationYaw * 16.0f / 360.0f) + 0.5);
            if (this.dimension < 0) {
                int l = this.field_28175_g / 10;
                byte3 = (byte)(l * l * 34187121 + l * 121 >> 15 & 0xF);
            }
            if (mapinfo1.entityplayerObj.dimension != this.dimension) continue;
            this.playersVisibleOnMap.add(new MapCoord(this, byte0, byte1, byte2, byte3));
        }
    }

    public void func_28170_a(int par1, int par2, int par3) {
        super.markDirty();
        for (int i = 0; i < this.field_28174_h.size(); ++i) {
            MapInfo mapinfo = (MapInfo)this.field_28174_h.get(i);
            if (mapinfo.field_28119_b[par1] < 0 || mapinfo.field_28119_b[par1] > par2) {
                mapinfo.field_28119_b[par1] = par2;
            }
            if (mapinfo.field_28124_c[par1] >= 0 && mapinfo.field_28124_c[par1] >= par3) continue;
            mapinfo.field_28124_c[par1] = par3;
        }
    }

    public void func_28171_a(byte[] par1ArrayOfByte) {
        if (par1ArrayOfByte[0] == 0) {
            int i = par1ArrayOfByte[1] & 0xFF;
            int k = par1ArrayOfByte[2] & 0xFF;
            for (int l = 0; l < par1ArrayOfByte.length - 3; ++l) {
                this.colors[(l + k) * 128 + i] = par1ArrayOfByte[l + 3];
            }
            this.markDirty();
        } else if (par1ArrayOfByte[0] == 1) {
            this.playersVisibleOnMap.clear();
            for (int j = 0; j < (par1ArrayOfByte.length - 1) / 3; ++j) {
                byte byte0 = (byte)(par1ArrayOfByte[j * 3 + 1] % 16);
                byte byte1 = par1ArrayOfByte[j * 3 + 2];
                byte byte2 = par1ArrayOfByte[j * 3 + 3];
                byte byte3 = (byte)(par1ArrayOfByte[j * 3 + 1] / 16);
                this.playersVisibleOnMap.add(new MapCoord(this, byte0, byte1, byte2, byte3));
            }
        }
    }
}

