/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockCloth;
import net.minecraft.src.BlockCrops;
import net.minecraft.src.BlockMushroom;
import net.minecraft.src.BlockSapling;
import net.minecraft.src.BlockStem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class ItemDye
extends Item {
    public static final String[] dyeColorNames = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "lightBlue", "magenta", "orange", "white"};
    public static final int[] dyeColors = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 2651799, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    public ItemDye(int par1) {
        super(par1);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    @Override
    public int getIconFromDamage(int par1) {
        int i = MathHelper.clamp_int(par1, 0, 15);
        return this.iconIndex + i % 8 * 16 + i / 8;
    }

    @Override
    public String getItemNameIS(ItemStack par1ItemStack) {
        int i = MathHelper.clamp_int(par1ItemStack.getItemDamage(), 0, 15);
        return super.getItemName() + "." + dyeColorNames[i];
    }

    @Override
    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7) {
        if (!par2EntityPlayer.canPlayerEdit(par4, par5, par6)) {
            return false;
        }
        if (par1ItemStack.getItemDamage() == 15) {
            int i = par3World.getBlockId(par4, par5, par6);
            if (i == Block.sapling.blockID) {
                if (!par3World.isRemote) {
                    ((BlockSapling)Block.sapling).growTree(par3World, par4, par5, par6, par3World.rand);
                    --par1ItemStack.stackSize;
                }
                return true;
            }
            if (i == Block.mushroomBrown.blockID || i == Block.mushroomRed.blockID) {
                if (!par3World.isRemote && ((BlockMushroom)Block.blocksList[i]).fertilizeMushroom(par3World, par4, par5, par6, par3World.rand)) {
                    --par1ItemStack.stackSize;
                }
                return true;
            }
            if (i == Block.melonStem.blockID || i == Block.pumpkinStem.blockID) {
                if (!par3World.isRemote) {
                    ((BlockStem)Block.blocksList[i]).fertilizeStem(par3World, par4, par5, par6);
                    --par1ItemStack.stackSize;
                }
                return true;
            }
            if (i == Block.crops.blockID) {
                if (!par3World.isRemote) {
                    ((BlockCrops)Block.crops).fertilize(par3World, par4, par5, par6);
                    --par1ItemStack.stackSize;
                }
                return true;
            }
            if (i == Block.grass.blockID) {
                if (!par3World.isRemote) {
                    --par1ItemStack.stackSize;
                    block0: for (int j = 0; j < 128; ++j) {
                        int k = par4;
                        int l = par5 + 1;
                        int i1 = par6;
                        for (int j1 = 0; j1 < j / 16; ++j1) {
                            if (par3World.getBlockId(k += itemRand.nextInt(3) - 1, (l += (itemRand.nextInt(3) - 1) * itemRand.nextInt(3) / 2) - 1, i1 += itemRand.nextInt(3) - 1) != Block.grass.blockID || par3World.isBlockNormalCube(k, l, i1)) continue block0;
                        }
                        if (par3World.getBlockId(k, l, i1) != 0) continue;
                        if (itemRand.nextInt(10) != 0) {
                            par3World.setBlockAndMetadataWithNotify(k, l, i1, Block.tallGrass.blockID, 1);
                            continue;
                        }
                        if (itemRand.nextInt(3) != 0) {
                            par3World.setBlockWithNotify(k, l, i1, Block.plantYellow.blockID);
                            continue;
                        }
                        par3World.setBlockWithNotify(k, l, i1, Block.plantRed.blockID);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void useItemOnEntity(ItemStack par1ItemStack, EntityLiving par2EntityLiving) {
        if (par2EntityLiving instanceof EntitySheep) {
            EntitySheep entitysheep = (EntitySheep)par2EntityLiving;
            int i = BlockCloth.getBlockFromDye(par1ItemStack.getItemDamage());
            if (!entitysheep.getSheared() && entitysheep.getFleeceColor() != i) {
                entitysheep.setFleeceColor(i);
                --par1ItemStack.stackSize;
            }
        }
    }
}

