/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Enchantment;
import net.minecraft.src.EnchantmentHelper;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumAction;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemBow
extends Item {
    public ItemBow(int par1) {
        super(par1);
        this.maxStackSize = 1;
        this.setMaxDamage(384);
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        boolean flag;
        boolean bl = flag = par3EntityPlayer.capabilities.isCreativeMode || EnchantmentHelper.getEnchantmentLevel(Enchantment.infinity.effectId, par1ItemStack) > 0;
        if (flag || par3EntityPlayer.inventory.hasItem(Item.arrow.shiftedIndex)) {
            int k;
            int j;
            int i = this.getMaxItemUseDuration(par1ItemStack) - par4;
            float f = (float)i / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityArrow entityarrow = new EntityArrow(par2World, par3EntityPlayer, f * 2.0f);
            if (f == 1.0f) {
                entityarrow.arrowCritical = true;
            }
            if ((j = EnchantmentHelper.getEnchantmentLevel(Enchantment.power.effectId, par1ItemStack)) > 0) {
                entityarrow.setDamage(entityarrow.getDamage() + (double)j * 0.5 + 0.5);
            }
            if ((k = EnchantmentHelper.getEnchantmentLevel(Enchantment.punch.effectId, par1ItemStack)) > 0) {
                entityarrow.func_46023_b(k);
            }
            if (EnchantmentHelper.getEnchantmentLevel(Enchantment.flame.effectId, par1ItemStack) > 0) {
                entityarrow.setFire(100);
            }
            par1ItemStack.damageItem(1, par3EntityPlayer);
            par2World.playSoundAtEntity(par3EntityPlayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!flag) {
                par3EntityPlayer.inventory.consumeInventoryItem(Item.arrow.shiftedIndex);
            } else {
                entityarrow.doesArrowBelongToPlayer = false;
            }
            if (!par2World.isRemote) {
                par2World.spawnEntityInWorld(entityarrow);
            }
        }
    }

    @Override
    public ItemStack onFoodEaten(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par3EntityPlayer.capabilities.isCreativeMode || par3EntityPlayer.inventory.hasItem(Item.arrow.shiftedIndex)) {
            par3EntityPlayer.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        }
        return par1ItemStack;
    }

    @Override
    public int getItemEnchantability() {
        return 1;
    }
}

