/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemBlock
extends Item {
    private int blockID;

    public ItemBlock(int par1) {
        super(par1);
        this.blockID = par1 + 256;
        this.setIconIndex(Block.blocksList[par1 + 256].getBlockTextureFromSide(2));
    }

    public int getBlockID() {
        return this.blockID;
    }

    @Override
    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7) {
        int i = par3World.getBlockId(par4, par5, par6);
        if (i == Block.snow.blockID) {
            par7 = 1;
        } else if (i != Block.vine.blockID && i != Block.tallGrass.blockID && i != Block.deadBush.blockID) {
            if (par7 == 0) {
                --par5;
            }
            if (par7 == 1) {
                ++par5;
            }
            if (par7 == 2) {
                --par6;
            }
            if (par7 == 3) {
                ++par6;
            }
            if (par7 == 4) {
                --par4;
            }
            if (par7 == 5) {
                ++par4;
            }
        }
        if (par1ItemStack.stackSize == 0) {
            return false;
        }
        if (!par2EntityPlayer.canPlayerEdit(par4, par5, par6)) {
            return false;
        }
        if (par5 == 255 && Block.blocksList[this.blockID].blockMaterial.isSolid()) {
            return false;
        }
        if (par3World.canBlockBePlacedAt(this.blockID, par4, par5, par6, false, par7)) {
            Block block = Block.blocksList[this.blockID];
            if (par3World.setBlockAndMetadataWithNotify(par4, par5, par6, this.blockID, this.getMetadata(par1ItemStack.getItemDamage()))) {
                if (par3World.getBlockId(par4, par5, par6) == this.blockID) {
                    Block.blocksList[this.blockID].onBlockPlaced(par3World, par4, par5, par6, par7);
                    Block.blocksList[this.blockID].onBlockPlacedBy(par3World, par4, par5, par6, par2EntityPlayer);
                }
                par3World.playSoundEffect((float)par4 + 0.5f, (float)par5 + 0.5f, (float)par6 + 0.5f, block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                --par1ItemStack.stackSize;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getItemNameIS(ItemStack par1ItemStack) {
        return Block.blocksList[this.blockID].getBlockName();
    }

    @Override
    public String getItemName() {
        return Block.blocksList[this.blockID].getBlockName();
    }
}

