/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Date;
import net.minecraft.src.GuiSelectWorld;
import net.minecraft.src.GuiSlot;
import net.minecraft.src.MathHelper;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.StatCollector;
import net.minecraft.src.Tessellator;

class GuiWorldSlot
extends GuiSlot {
    final GuiSelectWorld parentWorldGui;

    public GuiWorldSlot(GuiSelectWorld par1GuiSelectWorld) {
        super(par1GuiSelectWorld.mc, par1GuiSelectWorld.width, par1GuiSelectWorld.height, 32, par1GuiSelectWorld.height - 64, 36);
        this.parentWorldGui = par1GuiSelectWorld;
    }

    @Override
    protected int getSize() {
        return GuiSelectWorld.getSize(this.parentWorldGui).size();
    }

    @Override
    protected void elementClicked(int par1, boolean par2) {
        boolean flag;
        GuiSelectWorld.onElementSelected(this.parentWorldGui, par1);
        GuiSelectWorld.getSelectButton((GuiSelectWorld)this.parentWorldGui).enabled = flag = GuiSelectWorld.getSelectedWorld(this.parentWorldGui) >= 0 && GuiSelectWorld.getSelectedWorld(this.parentWorldGui) < this.getSize();
        GuiSelectWorld.getRenameButton((GuiSelectWorld)this.parentWorldGui).enabled = flag;
        GuiSelectWorld.getDeleteButton((GuiSelectWorld)this.parentWorldGui).enabled = flag;
        if (par2 && flag) {
            this.parentWorldGui.selectWorld(par1);
        }
    }

    @Override
    protected boolean isSelected(int par1) {
        return par1 == GuiSelectWorld.getSelectedWorld(this.parentWorldGui);
    }

    @Override
    protected int getContentHeight() {
        return GuiSelectWorld.getSize(this.parentWorldGui).size() * 36;
    }

    @Override
    protected void drawBackground() {
        this.parentWorldGui.drawDefaultBackground();
    }

    @Override
    protected void drawSlot(int par1, int par2, int par3, int par4, Tessellator par5Tessellator) {
        SaveFormatComparator saveformatcomparator = (SaveFormatComparator)GuiSelectWorld.getSize(this.parentWorldGui).get(par1);
        String s = saveformatcomparator.getDisplayName();
        if (s == null || MathHelper.stringNullOrLengthZero(s)) {
            s = GuiSelectWorld.getLocalizedWorldName(this.parentWorldGui) + " " + (par1 + 1);
        }
        String s1 = saveformatcomparator.getFileName();
        s1 = s1 + " (" + GuiSelectWorld.getDateFormatter(this.parentWorldGui).format(new Date(saveformatcomparator.getLastTimePlayed()));
        s1 = s1 + ")";
        String s2 = "";
        if (saveformatcomparator.requiresConversion()) {
            s2 = GuiSelectWorld.getLocalizedMustConvert(this.parentWorldGui) + " " + s2;
        } else {
            s2 = GuiSelectWorld.getLocalizedGameMode(this.parentWorldGui)[saveformatcomparator.getGameType()];
            if (saveformatcomparator.isHardcoreModeEnabled()) {
                s2 = "\u00a74" + StatCollector.translateToLocal("gameMode.hardcore") + "\u00a78";
            }
        }
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s, par2 + 2, par3 + 1, 0xFFFFFF);
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s1, par2 + 2, par3 + 12, 0x808080);
        this.parentWorldGui.drawString(this.parentWorldGui.fontRenderer, s2, par2 + 2, par3 + 12 + 10, 0x808080);
    }
}

