/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiCreateWorld;
import net.minecraft.src.GuiRenameWorld;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiWorldSlot;
import net.minecraft.src.GuiYesNo;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PlayerControllerCreative;
import net.minecraft.src.PlayerControllerSP;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.StringTranslate;

public class GuiSelectWorld
extends GuiScreen {
    private final DateFormat dateFormatter = new SimpleDateFormat();
    protected GuiScreen parentScreen;
    protected String screenTitle = "Select world";
    private boolean selected = false;
    private int selectedWorld;
    private List saveList;
    private GuiWorldSlot worldSlotContainer;
    private String localizedWorldText;
    private String localizedMustConvertText;
    private String[] localizedGameModeText = new String[2];
    private boolean deleting;
    private GuiButton buttonRename;
    private GuiButton buttonSelect;
    private GuiButton buttonDelete;

    public GuiSelectWorld(GuiScreen par1GuiScreen) {
        this.parentScreen = par1GuiScreen;
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.screenTitle = stringtranslate.translateKey("selectWorld.title");
        this.localizedWorldText = stringtranslate.translateKey("selectWorld.world");
        this.localizedMustConvertText = stringtranslate.translateKey("selectWorld.conversion");
        this.localizedGameModeText[0] = stringtranslate.translateKey("gameMode.survival");
        this.localizedGameModeText[1] = stringtranslate.translateKey("gameMode.creative");
        this.loadSaves();
        this.worldSlotContainer = new GuiWorldSlot(this);
        this.worldSlotContainer.registerScrollButtons(this.controlList, 4, 5);
        this.initButtons();
    }

    private void loadSaves() {
        ISaveFormat isaveformat = this.mc.getSaveLoader();
        this.saveList = isaveformat.getSaveList();
        Collections.sort(this.saveList);
        this.selectedWorld = -1;
    }

    protected String getSaveFileName(int par1) {
        return ((SaveFormatComparator)this.saveList.get(par1)).getFileName();
    }

    protected String getSaveName(int par1) {
        String s = ((SaveFormatComparator)this.saveList.get(par1)).getDisplayName();
        if (s == null || MathHelper.stringNullOrLengthZero(s)) {
            StringTranslate stringtranslate = StringTranslate.getInstance();
            s = stringtranslate.translateKey("selectWorld.world") + " " + (par1 + 1);
        }
        return s;
    }

    public void initButtons() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.buttonSelect = new GuiButton(1, this.width / 2 - 154, this.height - 52, 150, 20, stringtranslate.translateKey("selectWorld.select"));
        this.controlList.add(this.buttonSelect);
        this.buttonDelete = new GuiButton(6, this.width / 2 - 154, this.height - 28, 70, 20, stringtranslate.translateKey("selectWorld.rename"));
        this.controlList.add(this.buttonDelete);
        this.buttonRename = new GuiButton(2, this.width / 2 - 74, this.height - 28, 70, 20, stringtranslate.translateKey("selectWorld.delete"));
        this.controlList.add(this.buttonRename);
        this.controlList.add(new GuiButton(3, this.width / 2 + 4, this.height - 52, 150, 20, stringtranslate.translateKey("selectWorld.create")));
        this.controlList.add(new GuiButton(0, this.width / 2 + 4, this.height - 28, 150, 20, stringtranslate.translateKey("gui.cancel")));
        this.buttonSelect.enabled = false;
        this.buttonRename.enabled = false;
        this.buttonDelete.enabled = false;
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (!par1GuiButton.enabled) {
            return;
        }
        if (par1GuiButton.id == 2) {
            String s = this.getSaveName(this.selectedWorld);
            if (s != null) {
                this.deleting = true;
                StringTranslate stringtranslate = StringTranslate.getInstance();
                String s1 = stringtranslate.translateKey("selectWorld.deleteQuestion");
                String s2 = "'" + s + "' " + stringtranslate.translateKey("selectWorld.deleteWarning");
                String s3 = stringtranslate.translateKey("selectWorld.deleteButton");
                String s4 = stringtranslate.translateKey("gui.cancel");
                GuiYesNo guiyesno = new GuiYesNo(this, s1, s2, s3, s4, this.selectedWorld);
                this.mc.displayGuiScreen(guiyesno);
            }
        } else if (par1GuiButton.id == 1) {
            this.selectWorld(this.selectedWorld);
        } else if (par1GuiButton.id == 3) {
            this.mc.displayGuiScreen(new GuiCreateWorld(this));
        } else if (par1GuiButton.id == 6) {
            this.mc.displayGuiScreen(new GuiRenameWorld(this, this.getSaveFileName(this.selectedWorld)));
        } else if (par1GuiButton.id == 0) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else {
            this.worldSlotContainer.actionPerformed(par1GuiButton);
        }
    }

    public void selectWorld(int par1) {
        this.mc.displayGuiScreen(null);
        if (this.selected) {
            return;
        }
        this.selected = true;
        int i = ((SaveFormatComparator)this.saveList.get(par1)).getGameType();
        this.mc.playerController = i == 0 ? new PlayerControllerSP(this.mc) : new PlayerControllerCreative(this.mc);
        String s = this.getSaveFileName(par1);
        if (s == null) {
            s = "World" + par1;
        }
        this.mc.startWorld(s, this.getSaveName(par1), null);
        this.mc.displayGuiScreen(null);
    }

    @Override
    public void confirmClicked(boolean par1, int par2) {
        if (this.deleting) {
            this.deleting = false;
            if (par1) {
                ISaveFormat isaveformat = this.mc.getSaveLoader();
                isaveformat.flushCache();
                isaveformat.deleteWorldDirectory(this.getSaveFileName(par2));
                this.loadSaves();
            }
            this.mc.displayGuiScreen(this);
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.worldSlotContainer.drawScreen(par1, par2, par3);
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(par1, par2, par3);
    }

    static List getSize(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.saveList;
    }

    static int onElementSelected(GuiSelectWorld par0GuiSelectWorld, int par1) {
        par0GuiSelectWorld.selectedWorld = par1;
        return par0GuiSelectWorld.selectedWorld;
    }

    static int getSelectedWorld(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.selectedWorld;
    }

    static GuiButton getSelectButton(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.buttonSelect;
    }

    static GuiButton getRenameButton(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.buttonRename;
    }

    static GuiButton getDeleteButton(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.buttonDelete;
    }

    static String getLocalizedWorldName(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.localizedWorldText;
    }

    static DateFormat getDateFormatter(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.dateFormatter;
    }

    static String getLocalizedMustConvert(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.localizedMustConvertText;
    }

    static String[] getLocalizedGameMode(GuiSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.localizedGameModeText;
    }
}

