/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Gui;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiParticle;
import net.minecraft.src.Tessellator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreen
extends Gui {
    protected Minecraft mc;
    public int width;
    public int height;
    protected List controlList = new ArrayList();
    public boolean allowUserInput = false;
    protected FontRenderer fontRenderer;
    public GuiParticle guiParticles;
    private GuiButton selectedButton = null;

    public void drawScreen(int par1, int par2, float par3) {
        for (int i = 0; i < this.controlList.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.controlList.get(i);
            guibutton.drawButton(this.mc, par1, par2);
        }
    }

    protected void keyTyped(char par1, int par2) {
        if (par2 == 1) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        }
    }

    public static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static void setClipboardString(String par0Str) {
        try {
            StringSelection stringselection = new StringSelection(par0Str);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void mouseClicked(int par1, int par2, int par3) {
        if (par3 == 0) {
            for (int i = 0; i < this.controlList.size(); ++i) {
                GuiButton guibutton = (GuiButton)this.controlList.get(i);
                if (!guibutton.mousePressed(this.mc, par1, par2)) continue;
                this.selectedButton = guibutton;
                this.mc.sndManager.playSoundFX("random.click", 1.0f, 1.0f);
                this.actionPerformed(guibutton);
            }
        }
    }

    protected void mouseMovedOrUp(int par1, int par2, int par3) {
        if (this.selectedButton != null && par3 == 0) {
            this.selectedButton.mouseReleased(par1, par2);
            this.selectedButton = null;
        }
    }

    protected void actionPerformed(GuiButton guibutton) {
    }

    public void setWorldAndResolution(Minecraft par1Minecraft, int par2, int par3) {
        this.guiParticles = new GuiParticle(par1Minecraft);
        this.mc = par1Minecraft;
        this.fontRenderer = par1Minecraft.fontRenderer;
        this.width = par2;
        this.height = par3;
        this.controlList.clear();
        this.initGui();
    }

    public void initGui() {
    }

    public void handleInput() {
        while (Mouse.next()) {
            this.handleMouseInput();
        }
        while (Keyboard.next()) {
            this.handleKeyboardInput();
        }
    }

    public void handleMouseInput() {
        if (Mouse.getEventButtonState()) {
            int i = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int k = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.mouseClicked(i, k, Mouse.getEventButton());
        } else {
            int j = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int l = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.mouseMovedOrUp(j, l, Mouse.getEventButton());
        }
    }

    public void handleKeyboardInput() {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 87) {
                this.mc.toggleFullscreen();
                return;
            }
            this.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void updateScreen() {
    }

    public void onGuiClosed() {
    }

    public void drawDefaultBackground() {
        this.drawWorldBackground(0);
    }

    public void drawWorldBackground(int par1) {
        if (this.mc.theWorld != null) {
            this.drawGradientRect(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.drawBackground(par1);
        }
    }

    public void drawBackground(int par1) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f + (float)par1);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f + (float)par1);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, par1);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, par1);
        tessellator.draw();
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void confirmClicked(boolean flag, int i) {
    }

    public static boolean func_50051_l() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean func_50049_m() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }
}

