/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EnumOptions;
import net.minecraft.src.GameSettings;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiControls;
import net.minecraft.src.GuiLanguage;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSlider;
import net.minecraft.src.GuiSmallButton;
import net.minecraft.src.GuiVideoSettings;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StringTranslate;

public class GuiOptions
extends GuiScreen {
    private GuiScreen parentScreen;
    protected String screenTitle = "Options";
    private GameSettings options;
    private static EnumOptions[] relevantOptions = new EnumOptions[]{EnumOptions.MUSIC, EnumOptions.SOUND, EnumOptions.INVERT_MOUSE, EnumOptions.SENSITIVITY, EnumOptions.FOV, EnumOptions.DIFFICULTY};

    public GuiOptions(GuiScreen par1GuiScreen, GameSettings par2GameSettings) {
        this.parentScreen = par1GuiScreen;
        this.options = par2GameSettings;
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.screenTitle = stringtranslate.translateKey("options.title");
        int i = 0;
        for (EnumOptions enumoptions : relevantOptions) {
            if (!enumoptions.getEnumFloat()) {
                GuiSmallButton guismallbutton = new GuiSmallButton(enumoptions.returnEnumOrdinal(), this.width / 2 - 155 + i % 2 * 160, this.height / 6 + 24 * (i >> 1), enumoptions, this.options.getKeyBinding(enumoptions));
                if (enumoptions == EnumOptions.DIFFICULTY && this.mc.theWorld != null && this.mc.theWorld.getWorldInfo().isHardcoreModeEnabled()) {
                    guismallbutton.enabled = false;
                    guismallbutton.displayString = StatCollector.translateToLocal("options.difficulty") + ": " + StatCollector.translateToLocal("options.difficulty.hardcore");
                }
                this.controlList.add(guismallbutton);
            } else {
                this.controlList.add(new GuiSlider(enumoptions.returnEnumOrdinal(), this.width / 2 - 155 + i % 2 * 160, this.height / 6 + 24 * (i >> 1), enumoptions, this.options.getKeyBinding(enumoptions), this.options.getOptionFloatValue(enumoptions)));
            }
            ++i;
        }
        this.controlList.add(new GuiButton(101, this.width / 2 - 100, this.height / 6 + 96 - 6, stringtranslate.translateKey("options.video")));
        this.controlList.add(new GuiButton(100, this.width / 2 - 100, this.height / 6 + 120 - 6, stringtranslate.translateKey("options.controls")));
        this.controlList.add(new GuiButton(102, this.width / 2 - 100, this.height / 6 + 144 - 6, stringtranslate.translateKey("options.language")));
        this.controlList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168, stringtranslate.translateKey("gui.done")));
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (!par1GuiButton.enabled) {
            return;
        }
        if (par1GuiButton.id < 100 && par1GuiButton instanceof GuiSmallButton) {
            this.options.setOptionValue(((GuiSmallButton)par1GuiButton).returnEnumOptions(), 1);
            par1GuiButton.displayString = this.options.getKeyBinding(EnumOptions.getEnumOptions(par1GuiButton.id));
        }
        if (par1GuiButton.id == 101) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiVideoSettings(this, this.options));
        }
        if (par1GuiButton.id == 100) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiControls(this, this.options));
        }
        if (par1GuiButton.id == 102) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(new GuiLanguage(this, this.options));
        }
        if (par1GuiButton.id == 200) {
            this.mc.gameSettings.saveOptions();
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(par1, par2, par3);
    }
}

