/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiMainMenu;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiGameOver
extends GuiScreen {
    private int cooldownTimer;

    @Override
    public void initGui() {
        this.controlList.clear();
        if (this.mc.theWorld.getWorldInfo().isHardcoreModeEnabled()) {
            this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 96, StatCollector.translateToLocal("deathScreen.deleteWorld")));
        } else {
            this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 72, StatCollector.translateToLocal("deathScreen.respawn")));
            this.controlList.add(new GuiButton(2, this.width / 2 - 100, this.height / 4 + 96, StatCollector.translateToLocal("deathScreen.titleScreen")));
            if (this.mc.session == null) {
                ((GuiButton)this.controlList.get((int)1)).enabled = false;
            }
        }
        for (GuiButton guibutton : this.controlList) {
            guibutton.enabled = false;
        }
    }

    @Override
    protected void keyTyped(char c, int i) {
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        switch (par1GuiButton.id) {
            default: {
                break;
            }
            case 1: {
                if (this.mc.theWorld.getWorldInfo().isHardcoreModeEnabled()) {
                    String s = this.mc.theWorld.getSaveHandler().getSaveDirectoryName();
                    this.mc.exitToMainMenu("Deleting world");
                    ISaveFormat isaveformat = this.mc.getSaveLoader();
                    isaveformat.flushCache();
                    isaveformat.deleteWorldDirectory(s);
                    this.mc.displayGuiScreen(new GuiMainMenu());
                    break;
                }
                this.mc.thePlayer.respawnPlayer();
                this.mc.displayGuiScreen(null);
                break;
            }
            case 2: {
                if (this.mc.isMultiplayerWorld()) {
                    this.mc.theWorld.sendQuittingDisconnectingPacket();
                }
                this.mc.changeWorld1(null);
                this.mc.displayGuiScreen(new GuiMainMenu());
            }
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawGradientRect(0, 0, this.width, this.height, 0x60500000, -1602211792);
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        boolean flag = this.mc.theWorld.getWorldInfo().isHardcoreModeEnabled();
        String s = flag ? StatCollector.translateToLocal("deathScreen.title.hardcore") : StatCollector.translateToLocal("deathScreen.title");
        this.drawCenteredString(this.fontRenderer, s, this.width / 2 / 2, 30, 0xFFFFFF);
        GL11.glPopMatrix();
        if (flag) {
            this.drawCenteredString(this.fontRenderer, StatCollector.translateToLocal("deathScreen.hardcoreInfo"), this.width / 2, 144, 0xFFFFFF);
        }
        this.drawCenteredString(this.fontRenderer, StatCollector.translateToLocal("deathScreen.score") + ": \u00a7e" + this.mc.thePlayer.getScore(), this.width / 2, 100, 0xFFFFFF);
        super.drawScreen(par1, par2, par3);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        ++this.cooldownTimer;
        if (this.cooldownTimer == 20) {
            for (GuiButton guibutton : this.controlList) {
                guibutton.enabled = true;
            }
        }
    }
}

