/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.ChatAllowedCharacters;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiTextField;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PlayerControllerCreative;
import net.minecraft.src.PlayerControllerSP;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.WorldSettings;
import net.minecraft.src.WorldType;
import org.lwjgl.input.Keyboard;

public class GuiCreateWorld
extends GuiScreen {
    private GuiScreen parentGuiScreen;
    private GuiTextField textboxWorldName;
    private GuiTextField textboxSeed;
    private String folderName;
    private String gameMode = "survival";
    private boolean field_35365_g = true;
    private boolean field_40232_h = false;
    private boolean createClicked;
    private boolean moreOptions;
    private GuiButton gameModeButton;
    private GuiButton moreWorldOptions;
    private GuiButton generateStructuresButton;
    private GuiButton worldTypeButton;
    private String gameModeDescriptionLine1;
    private String gameModeDescriptionLine2;
    private String seed;
    private String localizedNewWorldText;
    private int field_46030_z = 0;

    public GuiCreateWorld(GuiScreen par1GuiScreen) {
        this.parentGuiScreen = par1GuiScreen;
        this.seed = "";
        this.localizedNewWorldText = StatCollector.translateToLocal("selectWorld.newWorld");
    }

    @Override
    public void updateScreen() {
        this.textboxWorldName.updateCursorCounter();
        this.textboxSeed.updateCursorCounter();
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.controlList.add(new GuiButton(0, this.width / 2 - 155, this.height - 28, 150, 20, stringtranslate.translateKey("selectWorld.create")));
        this.controlList.add(new GuiButton(1, this.width / 2 + 5, this.height - 28, 150, 20, stringtranslate.translateKey("gui.cancel")));
        this.gameModeButton = new GuiButton(2, this.width / 2 - 75, 100, 150, 20, stringtranslate.translateKey("selectWorld.gameMode"));
        this.controlList.add(this.gameModeButton);
        this.moreWorldOptions = new GuiButton(3, this.width / 2 - 75, 172, 150, 20, stringtranslate.translateKey("selectWorld.moreWorldOptions"));
        this.controlList.add(this.moreWorldOptions);
        this.generateStructuresButton = new GuiButton(4, this.width / 2 - 155, 100, 150, 20, stringtranslate.translateKey("selectWorld.mapFeatures"));
        this.controlList.add(this.generateStructuresButton);
        this.generateStructuresButton.drawButton = false;
        this.worldTypeButton = new GuiButton(5, this.width / 2 + 5, 100, 150, 20, stringtranslate.translateKey("selectWorld.mapType"));
        this.controlList.add(this.worldTypeButton);
        this.worldTypeButton.drawButton = false;
        this.textboxWorldName = new GuiTextField(this.fontRenderer, this.width / 2 - 100, 60, 200, 20);
        this.textboxWorldName.setFocused(true);
        this.textboxWorldName.setText(this.localizedNewWorldText);
        this.textboxSeed = new GuiTextField(this.fontRenderer, this.width / 2 - 100, 60, 200, 20);
        this.textboxSeed.setText(this.seed);
        this.makeUseableName();
        this.func_35363_g();
    }

    private void makeUseableName() {
        this.folderName = this.textboxWorldName.getText().trim();
        for (char c : ChatAllowedCharacters.allowedCharactersArray) {
            this.folderName = this.folderName.replace(c, '_');
        }
        if (MathHelper.stringNullOrLengthZero(this.folderName)) {
            this.folderName = "World";
        }
        this.folderName = GuiCreateWorld.func_25097_a(this.mc.getSaveLoader(), this.folderName);
    }

    private void func_35363_g() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.gameModeButton.displayString = stringtranslate.translateKey("selectWorld.gameMode") + " " + stringtranslate.translateKey("selectWorld.gameMode." + this.gameMode);
        this.gameModeDescriptionLine1 = stringtranslate.translateKey("selectWorld.gameMode." + this.gameMode + ".line1");
        this.gameModeDescriptionLine2 = stringtranslate.translateKey("selectWorld.gameMode." + this.gameMode + ".line2");
        this.generateStructuresButton.displayString = stringtranslate.translateKey("selectWorld.mapFeatures") + " ";
        this.generateStructuresButton.displayString = this.field_35365_g ? this.generateStructuresButton.displayString + stringtranslate.translateKey("options.on") : this.generateStructuresButton.displayString + stringtranslate.translateKey("options.off");
        this.worldTypeButton.displayString = stringtranslate.translateKey("selectWorld.mapType") + " " + stringtranslate.translateKey(WorldType.worldTypes[this.field_46030_z].getTranslateName());
    }

    public static String func_25097_a(ISaveFormat par0ISaveFormat, String par1Str) {
        par1Str = par1Str.replaceAll("[\\./\"]|COM", "_");
        while (par0ISaveFormat.getWorldInfo(par1Str) != null) {
            par1Str = par1Str + "-";
        }
        return par1Str;
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (!par1GuiButton.enabled) {
            return;
        }
        if (par1GuiButton.id == 1) {
            this.mc.displayGuiScreen(this.parentGuiScreen);
        } else if (par1GuiButton.id == 0) {
            this.mc.displayGuiScreen(null);
            if (this.createClicked) {
                return;
            }
            this.createClicked = true;
            long l = new Random().nextLong();
            String s = this.textboxSeed.getText();
            if (!MathHelper.stringNullOrLengthZero(s)) {
                try {
                    long l1 = Long.parseLong(s);
                    if (l1 != 0L) {
                        l = l1;
                    }
                }
                catch (NumberFormatException numberformatexception) {
                    l = s.hashCode();
                }
            }
            int i = 0;
            if (this.gameMode.equals("creative")) {
                i = 1;
                this.mc.playerController = new PlayerControllerCreative(this.mc);
            } else {
                this.mc.playerController = new PlayerControllerSP(this.mc);
            }
            this.mc.startWorld(this.folderName, this.textboxWorldName.getText(), new WorldSettings(l, i, this.field_35365_g, this.field_40232_h, WorldType.worldTypes[this.field_46030_z]));
            this.mc.displayGuiScreen(null);
        } else if (par1GuiButton.id == 3) {
            this.moreOptions = !this.moreOptions;
            this.gameModeButton.drawButton = !this.moreOptions;
            this.generateStructuresButton.drawButton = this.moreOptions;
            this.worldTypeButton.drawButton = this.moreOptions;
            if (this.moreOptions) {
                StringTranslate stringtranslate = StringTranslate.getInstance();
                this.moreWorldOptions.displayString = stringtranslate.translateKey("gui.done");
            } else {
                StringTranslate stringtranslate1 = StringTranslate.getInstance();
                this.moreWorldOptions.displayString = stringtranslate1.translateKey("selectWorld.moreWorldOptions");
            }
        } else if (par1GuiButton.id == 2) {
            if (this.gameMode.equals("survival")) {
                this.field_40232_h = false;
                this.gameMode = "hardcore";
                this.field_40232_h = true;
                this.func_35363_g();
            } else if (this.gameMode.equals("hardcore")) {
                this.field_40232_h = false;
                this.gameMode = "creative";
                this.func_35363_g();
                this.field_40232_h = false;
            } else {
                this.gameMode = "survival";
                this.func_35363_g();
                this.field_40232_h = false;
            }
            this.func_35363_g();
        } else if (par1GuiButton.id == 4) {
            this.field_35365_g = !this.field_35365_g;
            this.func_35363_g();
        } else if (par1GuiButton.id == 5) {
            ++this.field_46030_z;
            if (this.field_46030_z >= WorldType.worldTypes.length) {
                this.field_46030_z = 0;
            }
            while (WorldType.worldTypes[this.field_46030_z] == null || !WorldType.worldTypes[this.field_46030_z].getCanBeCreated()) {
                ++this.field_46030_z;
                if (this.field_46030_z < WorldType.worldTypes.length) continue;
                this.field_46030_z = 0;
            }
            this.func_35363_g();
        }
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        if (this.textboxWorldName.getIsFocused() && !this.moreOptions) {
            this.textboxWorldName.textboxKeyTyped(par1, par2);
            this.localizedNewWorldText = this.textboxWorldName.getText();
        } else if (this.textboxSeed.getIsFocused() && this.moreOptions) {
            this.textboxSeed.textboxKeyTyped(par1, par2);
            this.seed = this.textboxSeed.getText();
        }
        if (par1 == '\r') {
            this.actionPerformed((GuiButton)this.controlList.get(0));
        }
        ((GuiButton)this.controlList.get((int)0)).enabled = this.textboxWorldName.getText().length() > 0;
        this.makeUseableName();
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) {
        super.mouseClicked(par1, par2, par3);
        if (!this.moreOptions) {
            this.textboxWorldName.mouseClicked(par1, par2, par3);
        } else {
            this.textboxSeed.mouseClicked(par1, par2, par3);
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, stringtranslate.translateKey("selectWorld.create"), this.width / 2, 20, 0xFFFFFF);
        if (!this.moreOptions) {
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.enterName"), this.width / 2 - 100, 47, 0xA0A0A0);
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.resultFolder") + " " + this.folderName, this.width / 2 - 100, 85, 0xA0A0A0);
            this.textboxWorldName.drawTextBox();
            this.drawString(this.fontRenderer, this.gameModeDescriptionLine1, this.width / 2 - 100, 122, 0xA0A0A0);
            this.drawString(this.fontRenderer, this.gameModeDescriptionLine2, this.width / 2 - 100, 134, 0xA0A0A0);
        } else {
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.enterSeed"), this.width / 2 - 100, 47, 0xA0A0A0);
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.seedInfo"), this.width / 2 - 100, 85, 0xA0A0A0);
            this.drawString(this.fontRenderer, stringtranslate.translateKey("selectWorld.mapFeatures.info"), this.width / 2 - 150, 122, 0xA0A0A0);
            this.textboxSeed.drawTextBox();
        }
        super.drawScreen(par1, par2, par3);
    }
}

