/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Achievement;
import net.minecraft.src.AchievementList;
import net.minecraft.src.Block;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiSmallButton;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.RenderItem;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StatFileWriter;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiAchievements
extends GuiScreen {
    private static final int guiMapTop = AchievementList.minDisplayColumn * 24 - 112;
    private static final int guiMapLeft = AchievementList.minDisplayRow * 24 - 112;
    private static final int guiMapBottom = AchievementList.maxDisplayColumn * 24 - 77;
    private static final int guiMapRight = AchievementList.maxDisplayRow * 24 - 77;
    protected int achievementsPaneWidth = 256;
    protected int achievementsPaneHeight = 202;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected double field_27116_m;
    protected double field_27115_n;
    protected double guiMapX;
    protected double guiMapY;
    protected double field_27112_q;
    protected double field_27111_r;
    private int isMouseButtonDown = 0;
    private StatFileWriter statFileWriter;

    public GuiAchievements(StatFileWriter par1StatFileWriter) {
        this.statFileWriter = par1StatFileWriter;
        int c = 141;
        int c1 = 141;
        this.guiMapX = this.field_27112_q = (double)(AchievementList.openInventory.displayColumn * 24 - c / 2 - 12);
        this.field_27116_m = this.field_27112_q;
        this.guiMapY = this.field_27111_r = (double)(AchievementList.openInventory.displayRow * 24 - c1 / 2);
        this.field_27115_n = this.field_27111_r;
    }

    @Override
    public void initGui() {
        this.controlList.clear();
        this.controlList.add(new GuiSmallButton(1, this.width / 2 + 24, this.height / 2 + 74, 80, 20, StatCollector.translateToLocal("gui.done")));
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) {
        if (par1GuiButton.id == 1) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        }
        super.actionPerformed(par1GuiButton);
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        if (par2 == this.mc.gameSettings.keyBindInventory.keyCode) {
            this.mc.displayGuiScreen(null);
            this.mc.setIngameFocus();
        } else {
            super.keyTyped(par1, par2);
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        if (Mouse.isButtonDown((int)0)) {
            int i = (this.width - this.achievementsPaneWidth) / 2;
            int j = (this.height - this.achievementsPaneHeight) / 2;
            int k = i + 8;
            int l = j + 17;
            if ((this.isMouseButtonDown == 0 || this.isMouseButtonDown == 1) && par1 >= k && par1 < k + 224 && par2 >= l && par2 < l + 155) {
                if (this.isMouseButtonDown == 0) {
                    this.isMouseButtonDown = 1;
                } else {
                    this.guiMapX -= (double)(par1 - this.mouseX);
                    this.guiMapY -= (double)(par2 - this.mouseY);
                    this.field_27112_q = this.field_27116_m = this.guiMapX;
                    this.field_27111_r = this.field_27115_n = this.guiMapY;
                }
                this.mouseX = par1;
                this.mouseY = par2;
            }
            if (this.field_27112_q < (double)guiMapTop) {
                this.field_27112_q = guiMapTop;
            }
            if (this.field_27111_r < (double)guiMapLeft) {
                this.field_27111_r = guiMapLeft;
            }
            if (this.field_27112_q >= (double)guiMapBottom) {
                this.field_27112_q = guiMapBottom - 1;
            }
            if (this.field_27111_r >= (double)guiMapRight) {
                this.field_27111_r = guiMapRight - 1;
            }
        } else {
            this.isMouseButtonDown = 0;
        }
        this.drawDefaultBackground();
        this.genAchievementBackground(par1, par2, par3);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.func_27110_k();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    @Override
    public void updateScreen() {
        this.field_27116_m = this.guiMapX;
        this.field_27115_n = this.guiMapY;
        double d = this.field_27112_q - this.guiMapX;
        double d1 = this.field_27111_r - this.guiMapY;
        if (d * d + d1 * d1 < 4.0) {
            this.guiMapX += d;
            this.guiMapY += d1;
        } else {
            this.guiMapX += d * 0.85;
            this.guiMapY += d1 * 0.85;
        }
    }

    protected void func_27110_k() {
        int i = (this.width - this.achievementsPaneWidth) / 2;
        int j = (this.height - this.achievementsPaneHeight) / 2;
        this.fontRenderer.drawString("Achievements", i + 15, j + 5, 0x404040);
    }

    protected void genAchievementBackground(int par1, int par2, float par3) {
        int i = MathHelper.floor_double(this.field_27116_m + (this.guiMapX - this.field_27116_m) * (double)par3);
        int j = MathHelper.floor_double(this.field_27115_n + (this.guiMapY - this.field_27115_n) * (double)par3);
        if (i < guiMapTop) {
            i = guiMapTop;
        }
        if (j < guiMapLeft) {
            j = guiMapLeft;
        }
        if (i >= guiMapBottom) {
            i = guiMapBottom - 1;
        }
        if (j >= guiMapRight) {
            j = guiMapRight - 1;
        }
        int k = this.mc.renderEngine.getTexture("/terrain.png");
        int l = this.mc.renderEngine.getTexture("/achievement/bg.png");
        int i1 = (this.width - this.achievementsPaneWidth) / 2;
        int j1 = (this.height - this.achievementsPaneHeight) / 2;
        int k1 = i1 + 16;
        int l1 = j1 + 17;
        this.zLevel = 0.0f;
        GL11.glDepthFunc((int)518);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        this.mc.renderEngine.bindTexture(k);
        int i2 = i + 288 >> 4;
        int j2 = j + 288 >> 4;
        int k2 = (i + 288) % 16;
        int l2 = (j + 288) % 16;
        Random random = new Random();
        int i3 = 0;
        while (i3 * 16 - l2 < 155) {
            float f = 0.6f - (float)(j2 + i3) / 25.0f * 0.3f;
            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
            int k3 = 0;
            while (k3 * 16 - k2 < 224) {
                random.setSeed(1234 + i2 + k3);
                random.nextInt();
                int j4 = random.nextInt(1 + j2 + i3) + (j2 + i3) / 2;
                int l4 = Block.sand.blockIndexInTexture;
                if (j4 > 37 || j2 + i3 == 35) {
                    l4 = Block.bedrock.blockIndexInTexture;
                } else if (j4 == 22) {
                    l4 = random.nextInt(2) == 0 ? Block.oreDiamond.blockIndexInTexture : Block.oreRedstone.blockIndexInTexture;
                } else if (j4 == 10) {
                    l4 = Block.oreIron.blockIndexInTexture;
                } else if (j4 == 8) {
                    l4 = Block.oreCoal.blockIndexInTexture;
                } else if (j4 > 4) {
                    l4 = Block.stone.blockIndexInTexture;
                } else if (j4 > 0) {
                    l4 = Block.dirt.blockIndexInTexture;
                }
                this.drawTexturedModalRect(k1 + k3 * 16 - k2, l1 + i3 * 16 - l2, l4 % 16 << 4, l4 >> 4 << 4, 16, 16);
                ++k3;
            }
            ++i3;
        }
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)3553);
        for (int j3 = 0; j3 < AchievementList.achievementList.size(); ++j3) {
            Achievement achievement1 = (Achievement)AchievementList.achievementList.get(j3);
            if (achievement1.parentAchievement == null) continue;
            int l3 = achievement1.displayColumn * 24 - i + 11 + k1;
            int k4 = achievement1.displayRow * 24 - j + 11 + l1;
            int i5 = achievement1.parentAchievement.displayColumn * 24 - i + 11 + k1;
            int l5 = achievement1.parentAchievement.displayRow * 24 - j + 11 + l1;
            boolean flag = this.statFileWriter.hasAchievementUnlocked(achievement1);
            boolean flag1 = this.statFileWriter.canUnlockAchievement(achievement1);
            int c = Math.sin((double)(System.currentTimeMillis() % 600L) / 600.0 * Math.PI * 2.0) <= 0.6 ? 130 : 255;
            int i8 = -16777216;
            if (flag) {
                i8 = -9408400;
            } else if (flag1) {
                i8 = 65280 + (c << 24);
            }
            this.drawHorizontalLine(l3, i5, k4, i8);
            this.drawVerticalLine(i5, k4, l5, i8);
        }
        StatBase achievement = null;
        RenderItem renderitem = new RenderItem();
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        for (int i4 = 0; i4 < AchievementList.achievementList.size(); ++i4) {
            Achievement achievement2 = (Achievement)AchievementList.achievementList.get(i4);
            int j5 = achievement2.displayColumn * 24 - i;
            int i6 = achievement2.displayRow * 24 - j;
            if (j5 < -24 || i6 < -24 || j5 > 224 || i6 > 155) continue;
            if (this.statFileWriter.hasAchievementUnlocked(achievement2)) {
                float f1 = 1.0f;
                GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)1.0f);
            } else if (this.statFileWriter.canUnlockAchievement(achievement2)) {
                float f2 = Math.sin((double)(System.currentTimeMillis() % 600L) / 600.0 * Math.PI * 2.0) >= 0.6 ? 0.8f : 0.6f;
                GL11.glColor4f((float)f2, (float)f2, (float)f2, (float)1.0f);
            } else {
                float f3 = 0.3f;
                GL11.glColor4f((float)f3, (float)f3, (float)f3, (float)1.0f);
            }
            this.mc.renderEngine.bindTexture(l);
            int k6 = k1 + j5;
            int j7 = l1 + i6;
            if (achievement2.getSpecial()) {
                this.drawTexturedModalRect(k6 - 2, j7 - 2, 26, 202, 26, 26);
            } else {
                this.drawTexturedModalRect(k6 - 2, j7 - 2, 0, 202, 26, 26);
            }
            if (!this.statFileWriter.canUnlockAchievement(achievement2)) {
                float f4 = 0.1f;
                GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)1.0f);
                renderitem.field_27004_a = false;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            renderitem.renderItemIntoGUI(this.mc.fontRenderer, this.mc.renderEngine, achievement2.theItemStack, k6 + 3, j7 + 3);
            GL11.glDisable((int)2896);
            if (!this.statFileWriter.canUnlockAchievement(achievement2)) {
                renderitem.field_27004_a = true;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (par1 < k1 || par2 < l1 || par1 >= k1 + 224 || par2 >= l1 + 155 || par1 < k6 || par1 > k6 + 22 || par2 < j7 || par2 > j7 + 22) continue;
            achievement = achievement2;
        }
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(l);
        this.drawTexturedModalRect(i1, j1, 0, 0, this.achievementsPaneWidth, this.achievementsPaneHeight);
        GL11.glPopMatrix();
        this.zLevel = 0.0f;
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        super.drawScreen(par1, par2, par3);
        if (achievement != null) {
            String s = StatCollector.translateToLocal(achievement.getName());
            String s1 = ((Achievement)achievement).getDescription();
            int k5 = par1 + 12;
            int j6 = par2 - 4;
            if (this.statFileWriter.canUnlockAchievement((Achievement)achievement)) {
                int l6 = Math.max(this.fontRenderer.getStringWidth(s), 120);
                int k7 = this.fontRenderer.splitStringWidth(s1, l6);
                if (this.statFileWriter.hasAchievementUnlocked((Achievement)achievement)) {
                    k7 += 12;
                }
                this.drawGradientRect(k5 - 3, j6 - 3, k5 + l6 + 3, j6 + k7 + 3 + 12, -1073741824, -1073741824);
                this.fontRenderer.drawSplitString(s1, k5, j6 + 12, l6, -6250336);
                if (this.statFileWriter.hasAchievementUnlocked((Achievement)achievement)) {
                    this.fontRenderer.drawStringWithShadow(StatCollector.translateToLocal("achievement.taken"), k5, j6 + k7 + 4, -7302913);
                }
            } else {
                int i7 = Math.max(this.fontRenderer.getStringWidth(s), 120);
                String s2 = StatCollector.translateToLocalFormatted("achievement.requires", new Object[]{StatCollector.translateToLocal(((Achievement)achievement).parentAchievement.getName())});
                int l7 = this.fontRenderer.splitStringWidth(s2, i7);
                this.drawGradientRect(k5 - 3, j6 - 3, k5 + i7 + 3, j6 + l7 + 12 + 3, -1073741824, -1073741824);
                this.fontRenderer.drawSplitString(s2, k5, j6 + 12, i7, -9416624);
            }
            this.fontRenderer.drawStringWithShadow(s, k5, j6, this.statFileWriter.canUnlockAchievement((Achievement)achievement) ? (((Achievement)achievement).getSpecial() ? -128 : -1) : (((Achievement)achievement).getSpecial() ? -8355776 : -8355712));
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        RenderHelper.disableStandardItemLighting();
    }

    @Override
    public boolean doesGuiPauseGame() {
        return true;
    }
}

