/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.src.EnumOptions;
import net.minecraft.src.EnumOptionsMappingHelper;
import net.minecraft.src.KeyBinding;
import net.minecraft.src.StatCollector;
import net.minecraft.src.StringTranslate;
import org.lwjgl.input.Keyboard;

public class GameSettings {
    private static final String[] RENDER_DISTANCES = new String[]{"options.renderDistance.far", "options.renderDistance.normal", "options.renderDistance.short", "options.renderDistance.tiny"};
    private static final String[] DIFFICULTIES = new String[]{"options.difficulty.peaceful", "options.difficulty.easy", "options.difficulty.normal", "options.difficulty.hard"};
    private static final String[] GUISCALES = new String[]{"options.guiScale.auto", "options.guiScale.small", "options.guiScale.normal", "options.guiScale.large"};
    private static final String[] PARTICLES = new String[]{"options.particles.all", "options.particles.decreased", "options.particles.minimal"};
    private static final String[] LIMIT_FRAMERATES = new String[]{"performance.max", "performance.balanced", "performance.powersaver"};
    public float musicVolume = 1.0f;
    public float soundVolume = 1.0f;
    public float mouseSensitivity = 0.5f;
    public boolean invertMouse = false;
    public int renderDistance = 0;
    public boolean viewBobbing = true;
    public boolean anaglyph = false;
    public boolean advancedOpengl = false;
    public int limitFramerate = 1;
    public boolean fancyGraphics = true;
    public boolean ambientOcclusion = true;
    public boolean clouds = true;
    public String skin = "Default";
    public KeyBinding keyBindForward = new KeyBinding("key.forward", 17);
    public KeyBinding keyBindLeft = new KeyBinding("key.left", 30);
    public KeyBinding keyBindBack = new KeyBinding("key.back", 31);
    public KeyBinding keyBindRight = new KeyBinding("key.right", 32);
    public KeyBinding keyBindJump = new KeyBinding("key.jump", 57);
    public KeyBinding keyBindInventory = new KeyBinding("key.inventory", 18);
    public KeyBinding keyBindDrop = new KeyBinding("key.drop", 16);
    public KeyBinding keyBindChat = new KeyBinding("key.chat", 20);
    public KeyBinding keyBindSneak = new KeyBinding("key.sneak", 42);
    public KeyBinding keyBindAttack = new KeyBinding("key.attack", -100);
    public KeyBinding keyBindUseItem = new KeyBinding("key.use", -99);
    public KeyBinding keyBindPlayerList = new KeyBinding("key.playerlist", 15);
    public KeyBinding keyBindPickBlock = new KeyBinding("key.pickItem", -98);
    public KeyBinding[] keyBindings = new KeyBinding[]{this.keyBindAttack, this.keyBindUseItem, this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindPlayerList, this.keyBindPickBlock};
    protected Minecraft mc;
    private File optionsFile;
    public int difficulty = 2;
    public boolean hideGUI = false;
    public int thirdPersonView = 0;
    public boolean showDebugInfo = false;
    public boolean field_50119_G = false;
    public String lastServer = "";
    public boolean noclip = false;
    public boolean smoothCamera = false;
    public boolean debugCamEnable = false;
    public float noclipRate = 1.0f;
    public float debugCamRate = 1.0f;
    public float fovSetting = 0.0f;
    public float gammaSetting = 0.0f;
    public int guiScale = 0;
    public int particleSetting = 0;
    public String language = "en_US";

    public GameSettings(Minecraft par1Minecraft, File par2File) {
        this.mc = par1Minecraft;
        this.optionsFile = new File(par2File, "options.txt");
        this.loadOptions();
    }

    public GameSettings() {
    }

    public String getKeyBindingDescription(int par1) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        return stringtranslate.translateKey(this.keyBindings[par1].keyDescription);
    }

    public String getOptionDisplayString(int par1) {
        int i = this.keyBindings[par1].keyCode;
        return GameSettings.getKeyDisplayString(i);
    }

    public static String getKeyDisplayString(int par0) {
        if (par0 < 0) {
            return StatCollector.translateToLocalFormatted("key.mouseButton", new Object[]{par0 + 101});
        }
        return Keyboard.getKeyName((int)par0);
    }

    public void setKeyBinding(int par1, int par2) {
        this.keyBindings[par1].keyCode = par2;
        this.saveOptions();
    }

    public void setOptionFloatValue(EnumOptions par1EnumOptions, float par2) {
        if (par1EnumOptions == EnumOptions.MUSIC) {
            this.musicVolume = par2;
            this.mc.sndManager.onSoundOptionsChanged();
        }
        if (par1EnumOptions == EnumOptions.SOUND) {
            this.soundVolume = par2;
            this.mc.sndManager.onSoundOptionsChanged();
        }
        if (par1EnumOptions == EnumOptions.SENSITIVITY) {
            this.mouseSensitivity = par2;
        }
        if (par1EnumOptions == EnumOptions.FOV) {
            this.fovSetting = par2;
        }
        if (par1EnumOptions == EnumOptions.GAMMA) {
            this.gammaSetting = par2;
        }
    }

    public void setOptionValue(EnumOptions par1EnumOptions, int par2) {
        if (par1EnumOptions == EnumOptions.INVERT_MOUSE) {
            boolean bl = this.invertMouse = !this.invertMouse;
        }
        if (par1EnumOptions == EnumOptions.RENDER_DISTANCE) {
            this.renderDistance = this.renderDistance + par2 & 3;
        }
        if (par1EnumOptions == EnumOptions.GUI_SCALE) {
            this.guiScale = this.guiScale + par2 & 3;
        }
        if (par1EnumOptions == EnumOptions.PARTICLES) {
            this.particleSetting = (this.particleSetting + par2) % 3;
        }
        if (par1EnumOptions == EnumOptions.VIEW_BOBBING) {
            boolean bl = this.viewBobbing = !this.viewBobbing;
        }
        if (par1EnumOptions == EnumOptions.RENDER_CLOUDS) {
            boolean bl = this.clouds = !this.clouds;
        }
        if (par1EnumOptions == EnumOptions.ADVANCED_OPENGL) {
            this.advancedOpengl = !this.advancedOpengl;
            this.mc.renderGlobal.loadRenderers();
        }
        if (par1EnumOptions == EnumOptions.ANAGLYPH) {
            this.anaglyph = !this.anaglyph;
            this.mc.renderEngine.refreshTextures();
        }
        if (par1EnumOptions == EnumOptions.FRAMERATE_LIMIT) {
            this.limitFramerate = (this.limitFramerate + par2 + 3) % 3;
        }
        if (par1EnumOptions == EnumOptions.DIFFICULTY) {
            this.difficulty = this.difficulty + par2 & 3;
        }
        if (par1EnumOptions == EnumOptions.GRAPHICS) {
            this.fancyGraphics = !this.fancyGraphics;
            this.mc.renderGlobal.loadRenderers();
        }
        if (par1EnumOptions == EnumOptions.AMBIENT_OCCLUSION) {
            this.ambientOcclusion = !this.ambientOcclusion;
            this.mc.renderGlobal.loadRenderers();
        }
        this.saveOptions();
    }

    public float getOptionFloatValue(EnumOptions par1EnumOptions) {
        if (par1EnumOptions == EnumOptions.FOV) {
            return this.fovSetting;
        }
        if (par1EnumOptions == EnumOptions.GAMMA) {
            return this.gammaSetting;
        }
        if (par1EnumOptions == EnumOptions.MUSIC) {
            return this.musicVolume;
        }
        if (par1EnumOptions == EnumOptions.SOUND) {
            return this.soundVolume;
        }
        if (par1EnumOptions == EnumOptions.SENSITIVITY) {
            return this.mouseSensitivity;
        }
        return 0.0f;
    }

    public boolean getOptionOrdinalValue(EnumOptions par1EnumOptions) {
        switch (EnumOptionsMappingHelper.enumOptionsMappingHelperArray[par1EnumOptions.ordinal()]) {
            case 1: {
                return this.invertMouse;
            }
            case 2: {
                return this.viewBobbing;
            }
            case 3: {
                return this.anaglyph;
            }
            case 4: {
                return this.advancedOpengl;
            }
            case 5: {
                return this.ambientOcclusion;
            }
            case 6: {
                return this.clouds;
            }
        }
        return false;
    }

    private static String func_48571_a(String[] par0ArrayOfStr, int par1) {
        if (par1 < 0 || par1 >= par0ArrayOfStr.length) {
            par1 = 0;
        }
        StringTranslate stringtranslate = StringTranslate.getInstance();
        return stringtranslate.translateKey(par0ArrayOfStr[par1]);
    }

    public String getKeyBinding(EnumOptions par1EnumOptions) {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        String s = stringtranslate.translateKey(par1EnumOptions.getEnumString()) + ": ";
        if (par1EnumOptions.getEnumFloat()) {
            float f = this.getOptionFloatValue(par1EnumOptions);
            if (par1EnumOptions == EnumOptions.SENSITIVITY) {
                if (f == 0.0f) {
                    return s + stringtranslate.translateKey("options.sensitivity.min");
                }
                if (f == 1.0f) {
                    return s + stringtranslate.translateKey("options.sensitivity.max");
                }
                return s + (int)(f * 200.0f) + "%";
            }
            if (par1EnumOptions == EnumOptions.FOV) {
                if (f == 0.0f) {
                    return s + stringtranslate.translateKey("options.fov.min");
                }
                if (f == 1.0f) {
                    return s + stringtranslate.translateKey("options.fov.max");
                }
                return s + (int)(70.0f + f * 40.0f);
            }
            if (par1EnumOptions == EnumOptions.GAMMA) {
                if (f == 0.0f) {
                    return s + stringtranslate.translateKey("options.gamma.min");
                }
                if (f == 1.0f) {
                    return s + stringtranslate.translateKey("options.gamma.max");
                }
                return s + "+" + (int)(f * 100.0f) + "%";
            }
            if (f == 0.0f) {
                return s + stringtranslate.translateKey("options.off");
            }
            return s + (int)(f * 100.0f) + "%";
        }
        if (par1EnumOptions.getEnumBoolean()) {
            boolean flag = this.getOptionOrdinalValue(par1EnumOptions);
            if (flag) {
                return s + stringtranslate.translateKey("options.on");
            }
            return s + stringtranslate.translateKey("options.off");
        }
        if (par1EnumOptions == EnumOptions.RENDER_DISTANCE) {
            return s + GameSettings.func_48571_a(RENDER_DISTANCES, this.renderDistance);
        }
        if (par1EnumOptions == EnumOptions.DIFFICULTY) {
            return s + GameSettings.func_48571_a(DIFFICULTIES, this.difficulty);
        }
        if (par1EnumOptions == EnumOptions.GUI_SCALE) {
            return s + GameSettings.func_48571_a(GUISCALES, this.guiScale);
        }
        if (par1EnumOptions == EnumOptions.PARTICLES) {
            return s + GameSettings.func_48571_a(PARTICLES, this.particleSetting);
        }
        if (par1EnumOptions == EnumOptions.FRAMERATE_LIMIT) {
            return s + GameSettings.func_48571_a(LIMIT_FRAMERATES, this.limitFramerate);
        }
        if (par1EnumOptions == EnumOptions.GRAPHICS) {
            if (this.fancyGraphics) {
                return s + stringtranslate.translateKey("options.graphics.fancy");
            }
            return s + stringtranslate.translateKey("options.graphics.fast");
        }
        return s;
    }

    public void loadOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.optionsFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                try {
                    String[] as = s.split(":");
                    if (as[0].equals("music")) {
                        this.musicVolume = this.parseFloat(as[1]);
                    }
                    if (as[0].equals("sound")) {
                        this.soundVolume = this.parseFloat(as[1]);
                    }
                    if (as[0].equals("mouseSensitivity")) {
                        this.mouseSensitivity = this.parseFloat(as[1]);
                    }
                    if (as[0].equals("fov")) {
                        this.fovSetting = this.parseFloat(as[1]);
                    }
                    if (as[0].equals("gamma")) {
                        this.gammaSetting = this.parseFloat(as[1]);
                    }
                    if (as[0].equals("invertYMouse")) {
                        this.invertMouse = as[1].equals("true");
                    }
                    if (as[0].equals("viewDistance")) {
                        this.renderDistance = Integer.parseInt(as[1]);
                    }
                    if (as[0].equals("guiScale")) {
                        this.guiScale = Integer.parseInt(as[1]);
                    }
                    if (as[0].equals("particles")) {
                        this.particleSetting = Integer.parseInt(as[1]);
                    }
                    if (as[0].equals("bobView")) {
                        this.viewBobbing = as[1].equals("true");
                    }
                    if (as[0].equals("anaglyph3d")) {
                        this.anaglyph = as[1].equals("true");
                    }
                    if (as[0].equals("advancedOpengl")) {
                        this.advancedOpengl = as[1].equals("true");
                    }
                    if (as[0].equals("fpsLimit")) {
                        this.limitFramerate = Integer.parseInt(as[1]);
                    }
                    if (as[0].equals("difficulty")) {
                        this.difficulty = Integer.parseInt(as[1]);
                    }
                    if (as[0].equals("fancyGraphics")) {
                        this.fancyGraphics = as[1].equals("true");
                    }
                    if (as[0].equals("ao")) {
                        this.ambientOcclusion = as[1].equals("true");
                    }
                    if (as[0].equals("clouds")) {
                        this.clouds = as[1].equals("true");
                    }
                    if (as[0].equals("skin")) {
                        this.skin = as[1];
                    }
                    if (as[0].equals("lastServer") && as.length >= 2) {
                        this.lastServer = as[1];
                    }
                    if (as[0].equals("lang") && as.length >= 2) {
                        this.language = as[1];
                    }
                    for (int i = 0; i < this.keyBindings.length; ++i) {
                        if (!as[0].equals("key_" + this.keyBindings[i].keyDescription)) continue;
                        this.keyBindings[i].keyCode = Integer.parseInt(as[1]);
                    }
                }
                catch (Exception exception1) {
                    System.out.println("Skipping bad option: " + s);
                }
            }
            KeyBinding.resetKeyBindingArrayAndHash();
            bufferedreader.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to load options");
            exception.printStackTrace();
        }
    }

    private float parseFloat(String par1Str) {
        if (par1Str.equals("true")) {
            return 1.0f;
        }
        if (par1Str.equals("false")) {
            return 0.0f;
        }
        return Float.parseFloat(par1Str);
    }

    public void saveOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            printwriter.println("music:" + this.musicVolume);
            printwriter.println("sound:" + this.soundVolume);
            printwriter.println("invertYMouse:" + this.invertMouse);
            printwriter.println("mouseSensitivity:" + this.mouseSensitivity);
            printwriter.println("fov:" + this.fovSetting);
            printwriter.println("gamma:" + this.gammaSetting);
            printwriter.println("viewDistance:" + this.renderDistance);
            printwriter.println("guiScale:" + this.guiScale);
            printwriter.println("particles:" + this.particleSetting);
            printwriter.println("bobView:" + this.viewBobbing);
            printwriter.println("anaglyph3d:" + this.anaglyph);
            printwriter.println("advancedOpengl:" + this.advancedOpengl);
            printwriter.println("fpsLimit:" + this.limitFramerate);
            printwriter.println("difficulty:" + this.difficulty);
            printwriter.println("fancyGraphics:" + this.fancyGraphics);
            printwriter.println("ao:" + this.ambientOcclusion);
            printwriter.println("clouds:" + this.clouds);
            printwriter.println("skin:" + this.skin);
            printwriter.println("lastServer:" + this.lastServer);
            printwriter.println("lang:" + this.language);
            for (int i = 0; i < this.keyBindings.length; ++i) {
                printwriter.println("key_" + this.keyBindings[i].keyDescription + ":" + this.keyBindings[i].keyCode);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }

    public boolean shouldRenderClouds() {
        return this.renderDistance < 2 && this.clouds;
    }
}

