/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAIAttackOnCollide;
import net.minecraft.src.EntityAIBeg;
import net.minecraft.src.EntityAIFollowOwner;
import net.minecraft.src.EntityAIHurtByTarget;
import net.minecraft.src.EntityAILeapAtTarget;
import net.minecraft.src.EntityAILookIdle;
import net.minecraft.src.EntityAIMate;
import net.minecraft.src.EntityAIOwnerHurtByTarget;
import net.minecraft.src.EntityAIOwnerHurtTarget;
import net.minecraft.src.EntityAISwimming;
import net.minecraft.src.EntityAITargetNonTamed;
import net.minecraft.src.EntityAIWander;
import net.minecraft.src.EntityAIWatchClosest;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntityTameable;
import net.minecraft.src.Item;
import net.minecraft.src.ItemFood;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityWolf
extends EntityTameable {
    private boolean looksWithInterest = false;
    private float field_25048_b;
    private float field_25054_c;
    private boolean isShaking;
    private boolean field_25052_g;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;

    public EntityWolf(World par1World) {
        super(par1World);
        this.texture = "/mob/wolf.png";
        this.setSize(0.6f, 0.8f);
        this.moveSpeed = 0.3f;
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(2, this.aiSit);
        this.tasks.addTask(3, new EntityAILeapAtTarget(this, 0.4f));
        this.tasks.addTask(4, new EntityAIAttackOnCollide(this, this.moveSpeed, true));
        this.tasks.addTask(5, new EntityAIFollowOwner(this, this.moveSpeed, 10.0f, 2.0f));
        this.tasks.addTask(6, new EntityAIMate(this, this.moveSpeed));
        this.tasks.addTask(7, new EntityAIWander(this, this.moveSpeed));
        this.tasks.addTask(8, new EntityAIBeg(this, 8.0f));
        this.tasks.addTask(9, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(9, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAIOwnerHurtByTarget(this));
        this.targetTasks.addTask(2, new EntityAIOwnerHurtTarget(this));
        this.targetTasks.addTask(3, new EntityAIHurtByTarget(this, true));
        this.targetTasks.addTask(4, new EntityAITargetNonTamed(this, EntitySheep.class, 16.0f, 200, false));
    }

    @Override
    public boolean isAIEnabled() {
        return true;
    }

    @Override
    public void setAttackTarget(EntityLiving par1EntityLiving) {
        super.setAttackTarget(par1EntityLiving);
        if (par1EntityLiving instanceof EntityPlayer) {
            this.setAngry(true);
        }
    }

    @Override
    protected void updateAITick() {
        this.dataWatcher.updateObject(18, this.getHealth());
    }

    @Override
    public int getMaxHealth() {
        return !this.isTamed() ? 8 : 20;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, new Integer(this.getHealth()));
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    public String getTexture() {
        if (this.isTamed()) {
            return "/mob/wolf_tame.png";
        }
        if (this.isAngry()) {
            return "/mob/wolf_angry.png";
        }
        return super.getTexture();
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("Angry", this.isAngry());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setAngry(par1NBTTagCompound.getBoolean("Angry"));
    }

    @Override
    protected boolean canDespawn() {
        return this.isAngry();
    }

    @Override
    protected String getLivingSound() {
        if (this.isAngry()) {
            return "mob.wolf.growl";
        }
        if (this.rand.nextInt(3) == 0) {
            if (this.isTamed() && this.dataWatcher.getWatchableObjectInt(18) < 10) {
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    @Override
    protected String getHurtSound() {
        return "mob.wolf.hurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.wolf.death";
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected int getDropItemId() {
        return -1;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.worldObj.isRemote && this.isShaking && !this.field_25052_g && !this.hasPath() && this.onGround) {
            this.field_25052_g = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.worldObj.setEntityState(this, (byte)8);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.field_25054_c = this.field_25048_b;
        this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
        if (this.looksWithInterest) {
            this.numTicksToChaseTarget = 10;
        }
        if (this.isWet()) {
            this.isShaking = true;
            this.field_25052_g = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isShaking || this.field_25052_g) && this.field_25052_g) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.worldObj.playSoundAtEntity(this, "mob.wolf.shake", this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isShaking = false;
                this.field_25052_g = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.boundingBox.minY;
                int i = (int)(MathHelper.sin((this.timeWolfIsShaking - 0.4f) * (float)Math.PI) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    this.worldObj.spawnParticle("splash", this.posX + (double)f1, f + 0.8f, this.posZ + (double)f2, this.motionX, this.motionY, this.motionZ);
                }
            }
        }
    }

    public boolean getWolfShaking() {
        return this.isShaking;
    }

    public float getShadingWhileShaking(float par1) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * par1) / 2.0f * 0.25f;
    }

    public float getShakeAngle(float par1, float par2) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * par1 + par2) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.sin(f * (float)Math.PI) * MathHelper.sin(f * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float getInterestedAngle(float par1) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * par1) * 0.15f * (float)Math.PI;
    }

    @Override
    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    @Override
    public int getVerticalFaceSpeed() {
        if (this.isSitting()) {
            return 20;
        }
        return super.getVerticalFaceSpeed();
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        Entity entity = par1DamageSource.getEntity();
        this.aiSit.func_48407_a(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            par2 = (par2 + 1) / 2;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @Override
    public boolean attackEntityAsMob(Entity par1Entity) {
        byte byte0 = (byte)(this.isTamed() ? 4 : 2);
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage(this), byte0);
    }

    @Override
    public boolean interact(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        if (!this.isTamed()) {
            if (itemstack != null && itemstack.itemID == Item.bone.shiftedIndex && !this.isAngry()) {
                if (!par1EntityPlayer.capabilities.isCreativeMode) {
                    --itemstack.stackSize;
                }
                if (itemstack.stackSize <= 0) {
                    par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, null);
                }
                if (!this.worldObj.isRemote) {
                    if (this.rand.nextInt(3) == 0) {
                        this.setTamed(true);
                        this.setPathToEntity(null);
                        this.setAttackTarget(null);
                        this.aiSit.func_48407_a(true);
                        this.setEntityHealth(20);
                        this.setOwner(par1EntityPlayer.username);
                        this.func_48142_a(true);
                        this.worldObj.setEntityState(this, (byte)7);
                    } else {
                        this.func_48142_a(false);
                        this.worldObj.setEntityState(this, (byte)6);
                    }
                }
                return true;
            }
        } else {
            ItemFood itemfood;
            if (itemstack != null && Item.itemsList[itemstack.itemID] instanceof ItemFood && (itemfood = (ItemFood)Item.itemsList[itemstack.itemID]).isWolfsFavoriteMeat() && this.dataWatcher.getWatchableObjectInt(18) < 20) {
                if (!par1EntityPlayer.capabilities.isCreativeMode) {
                    --itemstack.stackSize;
                }
                this.heal(itemfood.getHealAmount());
                if (itemstack.stackSize <= 0) {
                    par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, null);
                }
                return true;
            }
            if (par1EntityPlayer.username.equalsIgnoreCase(this.getOwnerName()) && !this.worldObj.isRemote && !this.isWheat(itemstack)) {
                this.aiSit.func_48407_a(!this.isSitting());
                this.isJumping = false;
                this.setPathToEntity(null);
            }
        }
        return super.interact(par1EntityPlayer);
    }

    @Override
    public void handleHealthUpdate(byte par1) {
        if (par1 == 8) {
            this.field_25052_g = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.53938f;
        }
        if (this.isTamed()) {
            return (0.55f - (float)(20 - this.dataWatcher.getWatchableObjectInt(18)) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean isWheat(ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return false;
        }
        if (!(Item.itemsList[par1ItemStack.itemID] instanceof ItemFood)) {
            return false;
        }
        return ((ItemFood)Item.itemsList[par1ItemStack.itemID]).isWolfsFavoriteMeat();
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 8;
    }

    public boolean isAngry() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 2) != 0;
    }

    public void setAngry(boolean par1) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 2));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFFD));
        }
    }

    @Override
    public EntityAnimal spawnBabyAnimal(EntityAnimal par1EntityAnimal) {
        EntityWolf entitywolf = new EntityWolf(this.worldObj);
        entitywolf.setOwner(this.getOwnerName());
        entitywolf.setTamed(true);
        return entitywolf;
    }

    public void func_48150_h(boolean par1) {
        this.looksWithInterest = par1;
    }

    @Override
    public boolean func_48135_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)par1EntityAnimal;
        if (!entitywolf.isTamed()) {
            return false;
        }
        if (entitywolf.isSitting()) {
            return false;
        }
        return this.isInLove() && entitywolf.isInLove();
    }
}

