/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityWaterMob;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntitySquid
extends EntityWaterMob {
    public float field_21089_a = 0.0f;
    public float field_21088_b = 0.0f;
    public float field_21087_c = 0.0f;
    public float field_21086_f = 0.0f;
    public float field_21085_g = 0.0f;
    public float field_21084_h = 0.0f;
    public float tentacleAngle = 0.0f;
    public float lastTentacleAngle = 0.0f;
    private float randomMotionSpeed = 0.0f;
    private float field_21080_l = 0.0f;
    private float field_21079_m = 0.0f;
    private float randomMotionVecX = 0.0f;
    private float randomMotionVecY = 0.0f;
    private float randomMotionVecZ = 0.0f;

    public EntitySquid(World par1World) {
        super(par1World);
        this.texture = "/mob/squid.png";
        this.setSize(0.95f, 0.95f);
        this.field_21080_l = 1.0f / (this.rand.nextFloat() + 1.0f) * 0.2f;
    }

    @Override
    public int getMaxHealth() {
        return 10;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    @Override
    protected String getLivingSound() {
        return null;
    }

    @Override
    protected String getHurtSound() {
        return null;
    }

    @Override
    protected String getDeathSound() {
        return null;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected int getDropItemId() {
        return 0;
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        int i = this.rand.nextInt(3 + par2) + 1;
        for (int j = 0; j < i; ++j) {
            this.entityDropItem(new ItemStack(Item.dyePowder, 1, 0), 0.0f);
        }
    }

    @Override
    public boolean interact(EntityPlayer par1EntityPlayer) {
        return super.interact(par1EntityPlayer);
    }

    @Override
    public boolean isInWater() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, -0.6f, 0.0), Material.water, this);
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.field_21088_b = this.field_21089_a;
        this.field_21086_f = this.field_21087_c;
        this.field_21084_h = this.field_21085_g;
        this.lastTentacleAngle = this.tentacleAngle;
        this.field_21085_g += this.field_21080_l;
        if (this.field_21085_g > (float)Math.PI * 2) {
            this.field_21085_g -= (float)Math.PI * 2;
            if (this.rand.nextInt(10) == 0) {
                this.field_21080_l = 1.0f / (this.rand.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.isInWater()) {
            if (this.field_21085_g < (float)Math.PI) {
                float f = this.field_21085_g / (float)Math.PI;
                this.tentacleAngle = MathHelper.sin(f * f * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.field_21079_m = 1.0f;
                } else {
                    this.field_21079_m *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.field_21079_m *= 0.99f;
            }
            if (!this.worldObj.isRemote) {
                this.motionX = this.randomMotionVecX * this.randomMotionSpeed;
                this.motionY = this.randomMotionVecY * this.randomMotionSpeed;
                this.motionZ = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            float f1 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.renderYawOffset += (-((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / (float)Math.PI - this.renderYawOffset) * 0.1f;
            this.rotationYaw = this.renderYawOffset;
            this.field_21087_c += (float)Math.PI * this.field_21079_m * 1.5f;
            this.field_21089_a += (-((float)Math.atan2(f1, this.motionY)) * 180.0f / (float)Math.PI - this.field_21089_a) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.abs(MathHelper.sin(this.field_21085_g)) * (float)Math.PI * 0.25f;
            if (!this.worldObj.isRemote) {
                this.motionX = 0.0;
                this.motionY -= 0.08;
                this.motionY *= (double)0.98f;
                this.motionZ = 0.0;
            }
            this.field_21089_a = (float)((double)this.field_21089_a + (double)(-90.0f - this.field_21089_a) * 0.02);
        }
    }

    @Override
    public void moveEntityWithHeading(float par1, float par2) {
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
    }

    @Override
    protected void updateEntityActionState() {
        ++this.entityAge;
        if (this.entityAge > 100) {
            this.randomMotionVecZ = 0.0f;
            this.randomMotionVecY = 0.0f;
            this.randomMotionVecX = 0.0f;
        } else if (this.rand.nextInt(50) == 0 || !this.inWater || this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f) {
            float f = this.rand.nextFloat() * (float)Math.PI * 2.0f;
            this.randomMotionVecX = MathHelper.cos(f) * 0.2f;
            this.randomMotionVecY = -0.1f + this.rand.nextFloat() * 0.2f;
            this.randomMotionVecZ = MathHelper.sin(f) * 0.2f;
        }
        this.despawnEntity();
    }

    @Override
    public boolean getCanSpawnHere() {
        return this.posY > 45.0 && this.posY < 63.0 && super.getCanSpawnHere();
    }
}

