/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.DamageSource;
import net.minecraft.src.EntityAIArrowAttack;
import net.minecraft.src.EntityAILookIdle;
import net.minecraft.src.EntityAINearestAttackableTarget;
import net.minecraft.src.EntityAIWander;
import net.minecraft.src.EntityAIWatchClosest;
import net.minecraft.src.EntityGolem;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntitySnowman
extends EntityGolem {
    public EntitySnowman(World par1World) {
        super(par1World);
        this.texture = "/mob/snowman.png";
        this.setSize(0.4f, 1.8f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, new EntityAIArrowAttack(this, 0.25f, 2, 20));
        this.tasks.addTask(2, new EntityAIWander(this, 0.2f));
        this.tasks.addTask(3, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(4, new EntityAILookIdle(this));
        this.targetTasks.addTask(1, new EntityAINearestAttackableTarget(this, EntityMob.class, 16.0f, 0, true));
    }

    @Override
    public boolean isAIEnabled() {
        return true;
    }

    @Override
    public int getMaxHealth() {
        return 4;
    }

    @Override
    public void onLivingUpdate() {
        int k;
        int i;
        super.onLivingUpdate();
        if (this.isWet()) {
            this.attackEntityFrom(DamageSource.drown, 1);
        }
        if (this.worldObj.getBiomeGenForCoords(i = MathHelper.floor_double(this.posX), k = MathHelper.floor_double(this.posZ)).getFloatTemperature() > 1.0f) {
            this.attackEntityFrom(DamageSource.onFire, 1);
        }
        for (int j = 0; j < 4; ++j) {
            int j1;
            int i1;
            int l = MathHelper.floor_double(this.posX + (double)((float)(j % 2 * 2 - 1) * 0.25f));
            if (this.worldObj.getBlockId(l, i1 = MathHelper.floor_double(this.posY), j1 = MathHelper.floor_double(this.posZ + (double)((float)(j / 2 % 2 * 2 - 1) * 0.25f))) != 0 || !(this.worldObj.getBiomeGenForCoords(l, j1).getFloatTemperature() < 0.8f) || !Block.snow.canPlaceBlockAt(this.worldObj, l, i1, j1)) continue;
            this.worldObj.setBlockWithNotify(l, i1, j1, Block.snow.blockID);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    @Override
    protected int getDropItemId() {
        return Item.snowball.shiftedIndex;
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        int i = this.rand.nextInt(16);
        for (int j = 0; j < i; ++j) {
            this.dropItem(Item.snowball.shiftedIndex, 1);
        }
    }
}

