/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.EntityAIEatGrass;
import net.minecraft.src.EntityAIFollowParent;
import net.minecraft.src.EntityAILookIdle;
import net.minecraft.src.EntityAIMate;
import net.minecraft.src.EntityAIPanic;
import net.minecraft.src.EntityAISwimming;
import net.minecraft.src.EntityAITempt;
import net.minecraft.src.EntityAIWander;
import net.minecraft.src.EntityAIWatchClosest;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntitySheep
extends EntityAnimal {
    public static final float[][] fleeceColorTable = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    private int sheepTimer;
    private EntityAIEatGrass aiEatGrass = new EntityAIEatGrass(this);

    public EntitySheep(World par1World) {
        super(par1World);
        this.texture = "/mob/sheep.png";
        this.setSize(0.9f, 1.3f);
        float f = 0.23f;
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIPanic(this, 0.38f));
        this.tasks.addTask(2, new EntityAIMate(this, f));
        this.tasks.addTask(3, new EntityAITempt(this, 0.25f, Item.wheat.shiftedIndex, false));
        this.tasks.addTask(4, new EntityAIFollowParent(this, 0.25f));
        this.tasks.addTask(5, this.aiEatGrass);
        this.tasks.addTask(6, new EntityAIWander(this, f));
        this.tasks.addTask(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, new EntityAILookIdle(this));
    }

    @Override
    protected boolean isAIEnabled() {
        return true;
    }

    @Override
    protected void updateAITasks() {
        this.sheepTimer = this.aiEatGrass.func_48396_h();
        super.updateAITasks();
    }

    @Override
    public void onLivingUpdate() {
        if (this.worldObj.isRemote) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.onLivingUpdate();
    }

    @Override
    public int getMaxHealth() {
        return 8;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(0));
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        if (!this.getSheared()) {
            this.entityDropItem(new ItemStack(Block.cloth.blockID, 1, this.getFleeceColor()), 0.0f);
        }
    }

    @Override
    protected int getDropItemId() {
        return Block.cloth.blockID;
    }

    @Override
    public void handleHealthUpdate(byte par1) {
        if (par1 == 10) {
            this.sheepTimer = 40;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public float func_44003_c(float par1) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        if (this.sheepTimer < 4) {
            return ((float)this.sheepTimer - par1) / 4.0f;
        }
        return -((float)(this.sheepTimer - 40) - par1) / 4.0f;
    }

    public float func_44002_d(float par1) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - par1) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.sin(f * 28.7f);
        }
        if (this.sheepTimer > 0) {
            return 0.62831855f;
        }
        return this.rotationPitch / 57.295776f;
    }

    @Override
    public boolean interact(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        if (itemstack != null && itemstack.itemID == Item.shears.shiftedIndex && !this.getSheared() && !this.isChild()) {
            if (!this.worldObj.isRemote) {
                this.setSheared(true);
                int i = 1 + this.rand.nextInt(3);
                for (int j = 0; j < i; ++j) {
                    EntityItem entityitem = this.entityDropItem(new ItemStack(Block.cloth.blockID, 1, this.getFleeceColor()), 1.0f);
                    entityitem.motionY += (double)(this.rand.nextFloat() * 0.05f);
                    entityitem.motionX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                    entityitem.motionZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                }
            }
            itemstack.damageItem(1, par1EntityPlayer);
        }
        return super.interact(par1EntityPlayer);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("Sheared", this.getSheared());
        par1NBTTagCompound.setByte("Color", (byte)this.getFleeceColor());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setSheared(par1NBTTagCompound.getBoolean("Sheared"));
        this.setFleeceColor(par1NBTTagCompound.getByte("Color"));
    }

    @Override
    protected String getLivingSound() {
        return "mob.sheep";
    }

    @Override
    protected String getHurtSound() {
        return "mob.sheep";
    }

    @Override
    protected String getDeathSound() {
        return "mob.sheep";
    }

    public int getFleeceColor() {
        return this.dataWatcher.getWatchableObjectByte(16) & 0xF;
    }

    public void setFleeceColor(int par1) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        this.dataWatcher.updateObject(16, (byte)(byte0 & 0xF0 | par1 & 0xF));
    }

    public boolean getSheared() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean par1) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 0x10));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFEF));
        }
    }

    public static int getRandomFleeceColor(Random par0Random) {
        int i = par0Random.nextInt(100);
        if (i < 5) {
            return 15;
        }
        if (i < 10) {
            return 7;
        }
        if (i < 15) {
            return 8;
        }
        if (i < 18) {
            return 12;
        }
        return par0Random.nextInt(500) != 0 ? 0 : 6;
    }

    @Override
    public EntityAnimal spawnBabyAnimal(EntityAnimal par1EntityAnimal) {
        EntitySheep entitysheep = (EntitySheep)par1EntityAnimal;
        EntitySheep entitysheep1 = new EntitySheep(this.worldObj);
        if (this.rand.nextBoolean()) {
            entitysheep1.setFleeceColor(this.getFleeceColor());
        } else {
            entitysheep1.setFleeceColor(entitysheep.getFleeceColor());
        }
        return entitysheep1;
    }

    @Override
    public void eatGrassBonus() {
        this.setSheared(false);
        if (this.isChild()) {
            int i = this.getGrowingAge() + 1200;
            if (i > 0) {
                i = 0;
            }
            this.setGrowingAge(i);
        }
    }
}

