/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ActiveRenderInfo;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkProviderLoadOrGenerate;
import net.minecraft.src.ClippingHelperImpl;
import net.minecraft.src.EffectRenderer;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.EntityRainFX;
import net.minecraft.src.EntitySmokeFX;
import net.minecraft.src.Frustrum;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.ItemRenderer;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MouseFilter;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.OpenGlHelper;
import net.minecraft.src.Potion;
import net.minecraft.src.Profiler;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.RenderHelper;
import net.minecraft.src.ScaledResolution;
import net.minecraft.src.Tessellator;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class EntityRenderer {
    public static boolean anaglyphEnable = false;
    public static int anaglyphField;
    private Minecraft mc;
    private float farPlaneDistance = 0.0f;
    public ItemRenderer itemRenderer;
    private int rendererUpdateCount;
    private Entity pointedEntity = null;
    private MouseFilter mouseFilterXAxis = new MouseFilter();
    private MouseFilter mouseFilterYAxis = new MouseFilter();
    private MouseFilter mouseFilterDummy1 = new MouseFilter();
    private MouseFilter mouseFilterDummy2 = new MouseFilter();
    private MouseFilter mouseFilterDummy3 = new MouseFilter();
    private MouseFilter mouseFilterDummy4 = new MouseFilter();
    private float thirdPersonDistance = 4.0f;
    private float thirdPersonDistanceTemp = 4.0f;
    private float debugCamYaw = 0.0f;
    private float prevDebugCamYaw = 0.0f;
    private float debugCamPitch = 0.0f;
    private float prevDebugCamPitch = 0.0f;
    private float smoothCamYaw;
    private float smoothCamPitch;
    private float smoothCamFilterX;
    private float smoothCamFilterY;
    private float smoothCamPartialTicks;
    private float debugCamFOV = 0.0f;
    private float prevDebugCamFOV = 0.0f;
    private float camRoll = 0.0f;
    private float prevCamRoll = 0.0f;
    public int lightmapTexture;
    private int[] lightmapColors;
    private float fovModifierHand;
    private float fovModifierHandPrev;
    private float fovMultiplierTemp;
    private boolean cloudFog = false;
    private double cameraZoom = 1.0;
    private double cameraYaw = 0.0;
    private double cameraPitch = 0.0;
    private long prevFrameTime = System.currentTimeMillis();
    private long renderEndNanoTime = 0L;
    private boolean lightmapUpdateNeeded = false;
    float torchFlickerX = 0.0f;
    float torchFlickerDX = 0.0f;
    float torchFlickerY = 0.0f;
    float torchFlickerDY = 0.0f;
    private Random random = new Random();
    private int rainSoundCounter = 0;
    float[] rainXCoords;
    float[] rainYCoords;
    volatile int field_1394_b = 0;
    volatile int field_1393_c = 0;
    FloatBuffer fogColorBuffer = GLAllocation.createDirectFloatBuffer(16);
    float fogColorRed;
    float fogColorGreen;
    float fogColorBlue;
    private float fogColor2;
    private float fogColor1;
    public int debugViewDirection;

    public EntityRenderer(Minecraft par1Minecraft) {
        this.mc = par1Minecraft;
        this.itemRenderer = new ItemRenderer(par1Minecraft);
        this.lightmapTexture = par1Minecraft.renderEngine.allocateAndSetupTexture(new BufferedImage(16, 16, 1));
        this.lightmapColors = new int[256];
    }

    public void updateRenderer() {
        this.updateFovModifierHand();
        this.updateTorchFlicker();
        this.fogColor2 = this.fogColor1;
        this.thirdPersonDistanceTemp = this.thirdPersonDistance;
        this.prevDebugCamYaw = this.debugCamYaw;
        this.prevDebugCamPitch = this.debugCamPitch;
        this.prevDebugCamFOV = this.debugCamFOV;
        this.prevCamRoll = this.camRoll;
        if (this.mc.gameSettings.smoothCamera) {
            float f = this.mc.gameSettings.mouseSensitivity * 0.6f + 0.2f;
            float f2 = f * f * f * 8.0f;
            this.smoothCamFilterX = this.mouseFilterXAxis.func_22386_a(this.smoothCamYaw, 0.05f * f2);
            this.smoothCamFilterY = this.mouseFilterYAxis.func_22386_a(this.smoothCamPitch, 0.05f * f2);
            this.smoothCamPartialTicks = 0.0f;
            this.smoothCamYaw = 0.0f;
            this.smoothCamPitch = 0.0f;
        }
        if (this.mc.renderViewEntity == null) {
            this.mc.renderViewEntity = this.mc.thePlayer;
        }
        float f1 = this.mc.theWorld.getLightBrightness(MathHelper.floor_double(this.mc.renderViewEntity.posX), MathHelper.floor_double(this.mc.renderViewEntity.posY), MathHelper.floor_double(this.mc.renderViewEntity.posZ));
        float f3 = (float)(3 - this.mc.gameSettings.renderDistance) / 3.0f;
        float f4 = f1 * (1.0f - f3) + f3;
        this.fogColor1 += (f4 - this.fogColor1) * 0.1f;
        ++this.rendererUpdateCount;
        this.itemRenderer.updateEquippedItem();
        this.addRainParticles();
    }

    public void getMouseOver(float par1) {
        if (this.mc.renderViewEntity == null) {
            return;
        }
        if (this.mc.theWorld == null) {
            return;
        }
        double d = this.mc.playerController.getBlockReachDistance();
        this.mc.objectMouseOver = this.mc.renderViewEntity.rayTrace(d, par1);
        double d1 = d;
        Vec3D vec3d = this.mc.renderViewEntity.getPosition(par1);
        if (this.mc.playerController.extendedReach()) {
            d = 6.0;
            d1 = 6.0;
        } else {
            if (d1 > 3.0) {
                d1 = 3.0;
            }
            d = d1;
        }
        if (this.mc.objectMouseOver != null) {
            d1 = this.mc.objectMouseOver.hitVec.distanceTo(vec3d);
        }
        Vec3D vec3d1 = this.mc.renderViewEntity.getLook(par1);
        Vec3D vec3d2 = vec3d.addVector(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d);
        this.pointedEntity = null;
        float f = 1.0f;
        List list = this.mc.theWorld.getEntitiesWithinAABBExcludingEntity(this.mc.renderViewEntity, this.mc.renderViewEntity.boundingBox.addCoord(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d).expand(f, f, f));
        double d2 = d1;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = (Entity)list.get(i);
            if (!entity.canBeCollidedWith()) continue;
            float f1 = entity.getCollisionBorderSize();
            AxisAlignedBB axisalignedbb = entity.boundingBox.expand(f1, f1, f1);
            MovingObjectPosition movingobjectposition = axisalignedbb.calculateIntercept(vec3d, vec3d2);
            if (axisalignedbb.isVecInside(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                this.pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.distanceTo(movingobjectposition.hitVec)) < d2) && d2 != 0.0) continue;
            this.pointedEntity = entity;
            d2 = d3;
        }
        if (this.pointedEntity != null && (d2 < d1 || this.mc.objectMouseOver == null)) {
            this.mc.objectMouseOver = new MovingObjectPosition(this.pointedEntity);
        }
    }

    private void updateFovModifierHand() {
        EntityPlayerSP entityplayersp = (EntityPlayerSP)this.mc.renderViewEntity;
        this.fovMultiplierTemp = entityplayersp.getFOVMultiplier();
        this.fovModifierHandPrev = this.fovModifierHand;
        this.fovModifierHand += (this.fovMultiplierTemp - this.fovModifierHand) * 0.5f;
    }

    private float getFOVModifier(float par1, boolean par2) {
        int i;
        if (this.debugViewDirection > 0) {
            return 90.0f;
        }
        EntityPlayer entityplayer = (EntityPlayer)this.mc.renderViewEntity;
        float f = 70.0f;
        if (par2) {
            f += this.mc.gameSettings.fovSetting * 40.0f;
            f *= this.fovModifierHandPrev + (this.fovModifierHand - this.fovModifierHandPrev) * par1;
        }
        if (entityplayer.getHealth() <= 0) {
            float f1 = (float)entityplayer.deathTime + par1;
            f /= (1.0f - 500.0f / (f1 + 500.0f)) * 2.0f + 1.0f;
        }
        if ((i = ActiveRenderInfo.getBlockIdAtEntityViewpoint(this.mc.theWorld, entityplayer, par1)) != 0 && Block.blocksList[i].blockMaterial == Material.water) {
            f = f * 60.0f / 70.0f;
        }
        return f + this.prevDebugCamFOV + (this.debugCamFOV - this.prevDebugCamFOV) * par1;
    }

    private void hurtCameraEffect(float par1) {
        EntityLiving entityliving = this.mc.renderViewEntity;
        float f = (float)entityliving.hurtTime - par1;
        if (entityliving.getHealth() <= 0) {
            float f1 = (float)entityliving.deathTime + par1;
            GL11.glRotatef((float)(40.0f - 8000.0f / (f1 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (f < 0.0f) {
            return;
        }
        f /= (float)entityliving.maxHurtTime;
        f = MathHelper.sin(f * f * f * f * (float)Math.PI);
        float f2 = entityliving.attackedAtYaw;
        GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void setupViewBobbing(float par1) {
        if (!(this.mc.renderViewEntity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)this.mc.renderViewEntity;
        float f = entityplayer.distanceWalkedModified - entityplayer.prevDistanceWalkedModified;
        float f1 = -(entityplayer.distanceWalkedModified + f * par1);
        float f2 = entityplayer.prevCameraYaw + (entityplayer.cameraYaw - entityplayer.prevCameraYaw) * par1;
        float f3 = entityplayer.prevCameraPitch + (entityplayer.cameraPitch - entityplayer.prevCameraPitch) * par1;
        GL11.glTranslatef((float)(MathHelper.sin(f1 * (float)Math.PI) * f2 * 0.5f), (float)(-Math.abs(MathHelper.cos(f1 * (float)Math.PI) * f2)), (float)0.0f);
        GL11.glRotatef((float)(MathHelper.sin(f1 * (float)Math.PI) * f2 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(Math.abs(MathHelper.cos(f1 * (float)Math.PI - 0.2f) * f2) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    private void orientCamera(float par1) {
        EntityLiving entityliving = this.mc.renderViewEntity;
        float f = entityliving.yOffset - 1.62f;
        double d = entityliving.prevPosX + (entityliving.posX - entityliving.prevPosX) * (double)par1;
        double d1 = entityliving.prevPosY + (entityliving.posY - entityliving.prevPosY) * (double)par1 - (double)f;
        double d2 = entityliving.prevPosZ + (entityliving.posZ - entityliving.prevPosZ) * (double)par1;
        GL11.glRotatef((float)(this.prevCamRoll + (this.camRoll - this.prevCamRoll) * par1), (float)0.0f, (float)0.0f, (float)1.0f);
        if (entityliving.isPlayerSleeping()) {
            f = (float)((double)f + 1.0);
            GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
            if (!this.mc.gameSettings.debugCamEnable) {
                int i = this.mc.theWorld.getBlockId(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posY), MathHelper.floor_double(entityliving.posZ));
                if (i == Block.bed.blockID) {
                    int j = this.mc.theWorld.getBlockMetadata(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posY), MathHelper.floor_double(entityliving.posZ));
                    int k = j & 3;
                    GL11.glRotatef((float)(k * 90), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glRotatef((float)(entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * par1 + 180.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glRotatef((float)(entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * par1), (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.mc.gameSettings.thirdPersonView > 0) {
            double d3 = this.thirdPersonDistanceTemp + (this.thirdPersonDistance - this.thirdPersonDistanceTemp) * par1;
            if (this.mc.gameSettings.debugCamEnable) {
                float f1 = this.prevDebugCamYaw + (this.debugCamYaw - this.prevDebugCamYaw) * par1;
                float f3 = this.prevDebugCamPitch + (this.debugCamPitch - this.prevDebugCamPitch) * par1;
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-d3)));
                GL11.glRotatef((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)f1, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float f2 = entityliving.rotationYaw;
                float f4 = entityliving.rotationPitch;
                if (this.mc.gameSettings.thirdPersonView == 2) {
                    f4 += 180.0f;
                }
                double d4 = (double)(-MathHelper.sin(f2 / 180.0f * (float)Math.PI) * MathHelper.cos(f4 / 180.0f * (float)Math.PI)) * d3;
                double d5 = (double)(MathHelper.cos(f2 / 180.0f * (float)Math.PI) * MathHelper.cos(f4 / 180.0f * (float)Math.PI)) * d3;
                double d6 = (double)(-MathHelper.sin(f4 / 180.0f * (float)Math.PI)) * d3;
                for (int l = 0; l < 8; ++l) {
                    double d7;
                    MovingObjectPosition movingobjectposition;
                    float f5 = (l & 1) * 2 - 1;
                    float f6 = (l >> 1 & 1) * 2 - 1;
                    float f7 = (l >> 2 & 1) * 2 - 1;
                    if ((movingobjectposition = this.mc.theWorld.rayTraceBlocks(Vec3D.createVector(d + (double)(f5 *= 0.1f), d1 + (double)(f6 *= 0.1f), d2 + (double)(f7 *= 0.1f)), Vec3D.createVector(d - d4 + (double)f5 + (double)f7, d1 - d6 + (double)f6, d2 - d5 + (double)f7))) == null || !((d7 = movingobjectposition.hitVec.distanceTo(Vec3D.createVector(d, d1, d2))) < d3)) continue;
                    d3 = d7;
                }
                if (this.mc.gameSettings.thirdPersonView == 2) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glRotatef((float)(entityliving.rotationPitch - f4), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(entityliving.rotationYaw - f2), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-d3)));
                GL11.glRotatef((float)(f2 - entityliving.rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(f4 - entityliving.rotationPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.1f);
        }
        if (!this.mc.gameSettings.debugCamEnable) {
            GL11.glRotatef((float)(entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * par1), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * par1 + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)f, (float)0.0f);
        d = entityliving.prevPosX + (entityliving.posX - entityliving.prevPosX) * (double)par1;
        d1 = entityliving.prevPosY + (entityliving.posY - entityliving.prevPosY) * (double)par1 - (double)f;
        d2 = entityliving.prevPosZ + (entityliving.posZ - entityliving.prevPosZ) * (double)par1;
        this.cloudFog = this.mc.renderGlobal.func_27307_a(d, d1, d2, par1);
    }

    private void setupCameraTransform(float par1, int par2) {
        float f2;
        this.farPlaneDistance = 256 >> this.mc.gameSettings.renderDistance;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float f = 0.07f;
        if (this.mc.gameSettings.anaglyph) {
            GL11.glTranslatef((float)((float)(-(par2 * 2 - 1)) * f), (float)0.0f, (float)0.0f);
        }
        if (this.cameraZoom != 1.0) {
            GL11.glTranslatef((float)((float)this.cameraYaw), (float)((float)(-this.cameraPitch)), (float)0.0f);
            GL11.glScaled((double)this.cameraZoom, (double)this.cameraZoom, (double)1.0);
        }
        GLU.gluPerspective((float)this.getFOVModifier(par1, true), (float)((float)this.mc.displayWidth / (float)this.mc.displayHeight), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        if (this.mc.playerController.func_35643_e()) {
            float f1 = 0.6666667f;
            GL11.glScalef((float)1.0f, (float)f1, (float)1.0f);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (this.mc.gameSettings.anaglyph) {
            GL11.glTranslatef((float)((float)(par2 * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        this.hurtCameraEffect(par1);
        if (this.mc.gameSettings.viewBobbing) {
            this.setupViewBobbing(par1);
        }
        if ((f2 = this.mc.thePlayer.prevTimeInPortal + (this.mc.thePlayer.timeInPortal - this.mc.thePlayer.prevTimeInPortal) * par1) > 0.0f) {
            int i = 20;
            if (this.mc.thePlayer.isPotionActive(Potion.confusion)) {
                i = 7;
            }
            float f3 = 5.0f / (f2 * f2 + 5.0f) - f2 * 0.04f;
            f3 *= f3;
            GL11.glRotatef((float)(((float)this.rendererUpdateCount + par1) * (float)i), (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)(1.0f / f3), (float)1.0f, (float)1.0f);
            GL11.glRotatef((float)(-((float)this.rendererUpdateCount + par1) * (float)i), (float)0.0f, (float)1.0f, (float)1.0f);
        }
        this.orientCamera(par1);
        if (this.debugViewDirection > 0) {
            int j = this.debugViewDirection - 1;
            if (j == 1) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (j == 2) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (j == 3) {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (j == 4) {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (j == 5) {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    private void renderHand(float par1, int par2) {
        if (this.debugViewDirection > 0) {
            return;
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float f = 0.07f;
        if (this.mc.gameSettings.anaglyph) {
            GL11.glTranslatef((float)((float)(-(par2 * 2 - 1)) * f), (float)0.0f, (float)0.0f);
        }
        if (this.cameraZoom != 1.0) {
            GL11.glTranslatef((float)((float)this.cameraYaw), (float)((float)(-this.cameraPitch)), (float)0.0f);
            GL11.glScaled((double)this.cameraZoom, (double)this.cameraZoom, (double)1.0);
        }
        GLU.gluPerspective((float)this.getFOVModifier(par1, false), (float)((float)this.mc.displayWidth / (float)this.mc.displayHeight), (float)0.05f, (float)(this.farPlaneDistance * 2.0f));
        if (this.mc.playerController.func_35643_e()) {
            float f1 = 0.6666667f;
            GL11.glScalef((float)1.0f, (float)f1, (float)1.0f);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (this.mc.gameSettings.anaglyph) {
            GL11.glTranslatef((float)((float)(par2 * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        this.hurtCameraEffect(par1);
        if (this.mc.gameSettings.viewBobbing) {
            this.setupViewBobbing(par1);
        }
        if (!(this.mc.gameSettings.thirdPersonView != 0 || this.mc.renderViewEntity.isPlayerSleeping() || this.mc.gameSettings.hideGUI || this.mc.playerController.func_35643_e())) {
            this.enableLightmap(par1);
            this.itemRenderer.renderItemInFirstPerson(par1);
            this.disableLightmap(par1);
        }
        GL11.glPopMatrix();
        if (this.mc.gameSettings.thirdPersonView == 0 && !this.mc.renderViewEntity.isPlayerSleeping()) {
            this.itemRenderer.renderOverlays(par1);
            this.hurtCameraEffect(par1);
        }
        if (this.mc.gameSettings.viewBobbing) {
            this.setupViewBobbing(par1);
        }
    }

    public void disableLightmap(double par1) {
        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GL11.glDisable((int)3553);
        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
    }

    public void enableLightmap(double par1) {
        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        float f = 0.00390625f;
        GL11.glScalef((float)f, (float)f, (float)f);
        GL11.glTranslatef((float)8.0f, (float)8.0f, (float)8.0f);
        GL11.glMatrixMode((int)5888);
        this.mc.renderEngine.bindTexture(this.lightmapTexture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
    }

    private void updateTorchFlicker() {
        this.torchFlickerDX = (float)((double)this.torchFlickerDX + (Math.random() - Math.random()) * Math.random() * Math.random());
        this.torchFlickerDY = (float)((double)this.torchFlickerDY + (Math.random() - Math.random()) * Math.random() * Math.random());
        this.torchFlickerDX = (float)((double)this.torchFlickerDX * 0.9);
        this.torchFlickerDY = (float)((double)this.torchFlickerDY * 0.9);
        this.torchFlickerX += (this.torchFlickerDX - this.torchFlickerX) * 1.0f;
        this.torchFlickerY += (this.torchFlickerDY - this.torchFlickerY) * 1.0f;
        this.lightmapUpdateNeeded = true;
    }

    private void updateLightmap() {
        World world = this.mc.theWorld;
        if (world == null) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            float f = world.func_35464_b(1.0f) * 0.95f + 0.05f;
            float f1 = world.worldProvider.lightBrightnessTable[i / 16] * f;
            float f2 = world.worldProvider.lightBrightnessTable[i % 16] * (this.torchFlickerX * 0.1f + 1.5f);
            if (world.lightningFlash > 0) {
                f1 = world.worldProvider.lightBrightnessTable[i / 16];
            }
            float f3 = f1 * (world.func_35464_b(1.0f) * 0.65f + 0.35f);
            float f4 = f1 * (world.func_35464_b(1.0f) * 0.65f + 0.35f);
            float f5 = f1;
            float f6 = f2;
            float f7 = f2 * ((f2 * 0.6f + 0.4f) * 0.6f + 0.4f);
            float f8 = f2 * (f2 * f2 * 0.6f + 0.4f);
            float f9 = f3 + f6;
            float f10 = f4 + f7;
            float f11 = f5 + f8;
            f9 = f9 * 0.96f + 0.03f;
            f10 = f10 * 0.96f + 0.03f;
            f11 = f11 * 0.96f + 0.03f;
            if (world.worldProvider.worldType == 1) {
                f9 = 0.22f + f6 * 0.75f;
                f10 = 0.28f + f7 * 0.75f;
                f11 = 0.25f + f8 * 0.75f;
            }
            float f12 = this.mc.gameSettings.gammaSetting;
            if (f9 > 1.0f) {
                f9 = 1.0f;
            }
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            float f13 = 1.0f - f9;
            float f14 = 1.0f - f10;
            float f15 = 1.0f - f11;
            f13 = 1.0f - f13 * f13 * f13 * f13;
            f14 = 1.0f - f14 * f14 * f14 * f14;
            f15 = 1.0f - f15 * f15 * f15 * f15;
            f9 = f9 * (1.0f - f12) + f13 * f12;
            f10 = f10 * (1.0f - f12) + f14 * f12;
            f11 = f11 * (1.0f - f12) + f15 * f12;
            f9 = f9 * 0.96f + 0.03f;
            f10 = f10 * 0.96f + 0.03f;
            f11 = f11 * 0.96f + 0.03f;
            if (f9 > 1.0f) {
                f9 = 1.0f;
            }
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            if (f9 < 0.0f) {
                f9 = 0.0f;
            }
            if (f10 < 0.0f) {
                f10 = 0.0f;
            }
            if (f11 < 0.0f) {
                f11 = 0.0f;
            }
            int c = 255;
            int j = (int)(f9 * 255.0f);
            int k = (int)(f10 * 255.0f);
            int l = (int)(f11 * 255.0f);
            this.lightmapColors[i] = c << 24 | j << 16 | k << 8 | l;
        }
        this.mc.renderEngine.createTextureFromBytes(this.lightmapColors, 16, 16, this.lightmapTexture);
    }

    public void updateCameraAndRender(float par1) {
        Profiler.startSection("lightTex");
        if (this.lightmapUpdateNeeded) {
            this.updateLightmap();
        }
        Profiler.endSection();
        if (!Display.isActive()) {
            if (System.currentTimeMillis() - this.prevFrameTime > 500L) {
                this.mc.displayInGameMenu();
            }
        } else {
            this.prevFrameTime = System.currentTimeMillis();
        }
        Profiler.startSection("mouse");
        if (this.mc.inGameHasFocus) {
            this.mc.mouseHelper.mouseXYChange();
            float f = this.mc.gameSettings.mouseSensitivity * 0.6f + 0.2f;
            float f1 = f * f * f * 8.0f;
            float f2 = (float)this.mc.mouseHelper.deltaX * f1;
            float f3 = (float)this.mc.mouseHelper.deltaY * f1;
            int l = 1;
            if (this.mc.gameSettings.invertMouse) {
                l = -1;
            }
            if (this.mc.gameSettings.smoothCamera) {
                this.smoothCamYaw += f2;
                this.smoothCamPitch += f3;
                float f4 = par1 - this.smoothCamPartialTicks;
                this.smoothCamPartialTicks = par1;
                f2 = this.smoothCamFilterX * f4;
                f3 = this.smoothCamFilterY * f4;
                this.mc.thePlayer.setAngles(f2, f3 * (float)l);
            } else {
                this.mc.thePlayer.setAngles(f2, f3 * (float)l);
            }
        }
        Profiler.endSection();
        if (this.mc.skipRenderWorld) {
            return;
        }
        anaglyphEnable = this.mc.gameSettings.anaglyph;
        ScaledResolution scaledresolution = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
        int i = scaledresolution.getScaledWidth();
        int j = scaledresolution.getScaledHeight();
        int k = Mouse.getX() * i / this.mc.displayWidth;
        int i1 = j - Mouse.getY() * j / this.mc.displayHeight - 1;
        int c = 200;
        if (this.mc.gameSettings.limitFramerate == 1) {
            c = 120;
        }
        if (this.mc.gameSettings.limitFramerate == 2) {
            c = 40;
        }
        if (this.mc.theWorld != null) {
            long l1;
            Profiler.startSection("level");
            if (this.mc.gameSettings.limitFramerate == 0) {
                this.renderWorld(par1, 0L);
            } else {
                this.renderWorld(par1, this.renderEndNanoTime + (long)(1000000000 / c));
            }
            Profiler.endStartSection("sleep");
            if (this.mc.gameSettings.limitFramerate == 2 && (l1 = (this.renderEndNanoTime + (long)(1000000000 / c) - System.nanoTime()) / 1000000L) > 0L && l1 < 500L) {
                try {
                    Thread.sleep(l1);
                }
                catch (InterruptedException interruptedexception) {
                    interruptedexception.printStackTrace();
                }
            }
            this.renderEndNanoTime = System.nanoTime();
            Profiler.endStartSection("gui");
            if (!this.mc.gameSettings.hideGUI || this.mc.currentScreen != null) {
                this.mc.ingameGUI.renderGameOverlay(par1, this.mc.currentScreen != null, k, i1);
            }
            Profiler.endSection();
        } else {
            GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            this.setupOverlayRendering();
            long l2 = (this.renderEndNanoTime + (long)(1000000000 / c) - System.nanoTime()) / 1000000L;
            if (l2 < 0L) {
                l2 += 10L;
            }
            if (l2 > 0L && l2 < 500L) {
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedexception1) {
                    interruptedexception1.printStackTrace();
                }
            }
            this.renderEndNanoTime = System.nanoTime();
        }
        if (this.mc.currentScreen != null) {
            GL11.glClear((int)256);
            this.mc.currentScreen.drawScreen(k, i1, par1);
            if (this.mc.currentScreen != null && this.mc.currentScreen.guiParticles != null) {
                this.mc.currentScreen.guiParticles.draw(par1);
            }
        }
    }

    public void renderWorld(float par1, long par2) {
        Profiler.startSection("lightTex");
        if (this.lightmapUpdateNeeded) {
            this.updateLightmap();
        }
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        if (this.mc.renderViewEntity == null) {
            this.mc.renderViewEntity = this.mc.thePlayer;
        }
        Profiler.endStartSection("pick");
        this.getMouseOver(par1);
        EntityLiving entityliving = this.mc.renderViewEntity;
        RenderGlobal renderglobal = this.mc.renderGlobal;
        EffectRenderer effectrenderer = this.mc.effectRenderer;
        double d = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)par1;
        double d1 = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)par1;
        double d2 = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)par1;
        Profiler.endStartSection("center");
        IChunkProvider ichunkprovider = this.mc.theWorld.getChunkProvider();
        if (ichunkprovider instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            int j = MathHelper.floor_float((int)d) >> 4;
            int k = MathHelper.floor_float((int)d2) >> 4;
            chunkproviderloadorgenerate.setCurrentChunkOver(j, k);
        }
        for (int i = 0; i < 2; ++i) {
            if (this.mc.gameSettings.anaglyph) {
                anaglyphField = i;
                if (anaglyphField == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                }
            }
            Profiler.endStartSection("clear");
            GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
            this.updateFogColor(par1);
            GL11.glClear((int)16640);
            GL11.glEnable((int)2884);
            Profiler.endStartSection("camera");
            this.setupCameraTransform(par1, i);
            ActiveRenderInfo.updateRenderInfo(this.mc.thePlayer, this.mc.gameSettings.thirdPersonView == 2);
            Profiler.endStartSection("frustrum");
            ClippingHelperImpl.getInstance();
            if (this.mc.gameSettings.renderDistance < 2) {
                this.setupFog(-1, par1);
                Profiler.endStartSection("sky");
                renderglobal.renderSky(par1);
            }
            GL11.glEnable((int)2912);
            this.setupFog(1, par1);
            if (this.mc.gameSettings.ambientOcclusion) {
                GL11.glShadeModel((int)7425);
            }
            Profiler.endStartSection("culling");
            Frustrum frustrum = new Frustrum();
            frustrum.setPosition(d, d1, d2);
            this.mc.renderGlobal.clipRenderersByFrustum(frustrum, par1);
            if (i == 0) {
                long l;
                Profiler.endStartSection("updatechunks");
                while (!this.mc.renderGlobal.updateRenderers(entityliving, false) && par2 != 0L && (l = par2 - System.nanoTime()) >= 0L && l <= 1000000000L) {
                }
            }
            this.setupFog(0, par1);
            GL11.glEnable((int)2912);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            RenderHelper.disableStandardItemLighting();
            Profiler.endStartSection("terrain");
            renderglobal.sortAndRender(entityliving, 0, par1);
            GL11.glShadeModel((int)7424);
            if (this.debugViewDirection == 0) {
                RenderHelper.enableStandardItemLighting();
                Profiler.endStartSection("entities");
                renderglobal.renderEntities(entityliving.getPosition(par1), frustrum, par1);
                this.enableLightmap(par1);
                Profiler.endStartSection("litParticles");
                effectrenderer.func_1187_b(entityliving, par1);
                RenderHelper.disableStandardItemLighting();
                this.setupFog(0, par1);
                Profiler.endStartSection("particles");
                effectrenderer.renderParticles(entityliving, par1);
                this.disableLightmap(par1);
                if (this.mc.objectMouseOver != null && entityliving.isInsideOfMaterial(Material.water) && entityliving instanceof EntityPlayer && !this.mc.gameSettings.hideGUI) {
                    EntityPlayer entityplayer = (EntityPlayer)entityliving;
                    GL11.glDisable((int)3008);
                    Profiler.endStartSection("outline");
                    renderglobal.drawBlockBreaking(entityplayer, this.mc.objectMouseOver, 0, entityplayer.inventory.getCurrentItem(), par1);
                    renderglobal.drawSelectionBox(entityplayer, this.mc.objectMouseOver, 0, entityplayer.inventory.getCurrentItem(), par1);
                    GL11.glEnable((int)3008);
                }
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)true);
            this.setupFog(0, par1);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            if (this.mc.gameSettings.fancyGraphics) {
                Profiler.endStartSection("water");
                if (this.mc.gameSettings.ambientOcclusion) {
                    GL11.glShadeModel((int)7425);
                }
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                int i1 = renderglobal.sortAndRender(entityliving, 1, par1);
                if (this.mc.gameSettings.anaglyph) {
                    if (anaglyphField == 0) {
                        GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                    } else {
                        GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                    }
                } else {
                    GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                }
                if (i1 > 0) {
                    renderglobal.renderAllRenderLists(1, par1);
                }
                GL11.glShadeModel((int)7424);
            } else {
                Profiler.endStartSection("water");
                renderglobal.sortAndRender(entityliving, 1, par1);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            if (this.cameraZoom == 1.0 && entityliving instanceof EntityPlayer && !this.mc.gameSettings.hideGUI && this.mc.objectMouseOver != null && !entityliving.isInsideOfMaterial(Material.water)) {
                EntityPlayer entityplayer1 = (EntityPlayer)entityliving;
                GL11.glDisable((int)3008);
                Profiler.endStartSection("outline");
                renderglobal.drawBlockBreaking(entityplayer1, this.mc.objectMouseOver, 0, entityplayer1.inventory.getCurrentItem(), par1);
                renderglobal.drawSelectionBox(entityplayer1, this.mc.objectMouseOver, 0, entityplayer1.inventory.getCurrentItem(), par1);
                GL11.glEnable((int)3008);
            }
            Profiler.endStartSection("weather");
            this.renderRainSnow(par1);
            GL11.glDisable((int)2912);
            if (this.pointedEntity == null) {
                // empty if block
            }
            if (this.mc.gameSettings.shouldRenderClouds()) {
                Profiler.endStartSection("clouds");
                GL11.glPushMatrix();
                this.setupFog(0, par1);
                GL11.glEnable((int)2912);
                renderglobal.renderClouds(par1);
                GL11.glDisable((int)2912);
                this.setupFog(1, par1);
                GL11.glPopMatrix();
            }
            Profiler.endStartSection("hand");
            if (this.cameraZoom == 1.0) {
                GL11.glClear((int)256);
                this.renderHand(par1, i);
            }
            if (this.mc.gameSettings.anaglyph) continue;
            Profiler.endSection();
            return;
        }
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Profiler.endSection();
    }

    private void addRainParticles() {
        float f = this.mc.theWorld.getRainStrength(1.0f);
        if (!this.mc.gameSettings.fancyGraphics) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        this.random.setSeed((long)this.rendererUpdateCount * 312987231L);
        EntityLiving entityliving = this.mc.renderViewEntity;
        World world = this.mc.theWorld;
        int i = MathHelper.floor_double(entityliving.posX);
        int j = MathHelper.floor_double(entityliving.posY);
        int k = MathHelper.floor_double(entityliving.posZ);
        int byte0 = 10;
        double d = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int l = 0;
        int i1 = (int)(100.0f * f * f);
        if (this.mc.gameSettings.particleSetting == 1) {
            i1 >>= 1;
        } else if (this.mc.gameSettings.particleSetting == 2) {
            i1 = 0;
        }
        for (int j1 = 0; j1 < i1; ++j1) {
            int k1 = i + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int l1 = k + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int i2 = world.getPrecipitationHeight(k1, l1);
            int j2 = world.getBlockId(k1, i2 - 1, l1);
            BiomeGenBase biomegenbase = world.getBiomeGenForCoords(k1, l1);
            if (i2 > j + byte0 || i2 < j - byte0 || !biomegenbase.canSpawnLightningBolt() || biomegenbase.getFloatTemperature() <= 0.2f) continue;
            float f1 = this.random.nextFloat();
            float f2 = this.random.nextFloat();
            if (j2 <= 0) continue;
            if (Block.blocksList[j2].blockMaterial == Material.lava) {
                this.mc.effectRenderer.addEffect(new EntitySmokeFX(world, (float)k1 + f1, (double)((float)i2 + 0.1f) - Block.blocksList[j2].minY, (float)l1 + f2, 0.0, 0.0, 0.0));
                continue;
            }
            if (this.random.nextInt(++l) == 0) {
                d = (float)k1 + f1;
                d1 = (double)((float)i2 + 0.1f) - Block.blocksList[j2].minY;
                d2 = (float)l1 + f2;
            }
            this.mc.effectRenderer.addEffect(new EntityRainFX(world, (float)k1 + f1, (double)((float)i2 + 0.1f) - Block.blocksList[j2].minY, (float)l1 + f2));
        }
        if (l > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
            this.rainSoundCounter = 0;
            if (d1 > entityliving.posY + 1.0 && world.getPrecipitationHeight(MathHelper.floor_double(entityliving.posX), MathHelper.floor_double(entityliving.posZ)) > MathHelper.floor_double(entityliving.posY)) {
                this.mc.theWorld.playSoundEffect(d, d1, d2, "ambient.weather.rain", 0.1f, 0.5f);
            } else {
                this.mc.theWorld.playSoundEffect(d, d1, d2, "ambient.weather.rain", 0.2f, 1.0f);
            }
        }
    }

    protected void renderRainSnow(float par1) {
        float f = this.mc.theWorld.getRainStrength(par1);
        if (f <= 0.0f) {
            return;
        }
        this.enableLightmap(par1);
        if (this.rainXCoords == null) {
            this.rainXCoords = new float[1024];
            this.rainYCoords = new float[1024];
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    float f1 = j - 16;
                    float f2 = i - 16;
                    float f3 = MathHelper.sqrt_float(f1 * f1 + f2 * f2);
                    this.rainXCoords[i << 5 | j] = -f2 / f3;
                    this.rainYCoords[i << 5 | j] = f1 / f3;
                }
            }
        }
        EntityLiving entityliving = this.mc.renderViewEntity;
        World world = this.mc.theWorld;
        int k = MathHelper.floor_double(entityliving.posX);
        int l = MathHelper.floor_double(entityliving.posY);
        int i1 = MathHelper.floor_double(entityliving.posZ);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/environment/snow.png"));
        double d = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)par1;
        double d1 = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)par1;
        double d2 = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)par1;
        int j1 = MathHelper.floor_double(d1);
        int k1 = 5;
        if (this.mc.gameSettings.fancyGraphics) {
            k1 = 10;
        }
        boolean flag = false;
        int byte0 = -1;
        float f4 = (float)this.rendererUpdateCount + par1;
        if (this.mc.gameSettings.fancyGraphics) {
            k1 = 10;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        flag = false;
        for (int l1 = i1 - k1; l1 <= i1 + k1; ++l1) {
            for (int i2 = k - k1; i2 <= k + k1; ++i2) {
                int j2 = (l1 - i1 + 16) * 32 + (i2 - k + 16);
                float f5 = this.rainXCoords[j2] * 0.5f;
                float f6 = this.rainYCoords[j2] * 0.5f;
                BiomeGenBase biomegenbase = world.getBiomeGenForCoords(i2, l1);
                if (!biomegenbase.canSpawnLightningBolt() && !biomegenbase.getEnableSnow()) continue;
                int k2 = world.getPrecipitationHeight(i2, l1);
                int l2 = l - k1;
                int i3 = l + k1;
                if (l2 < k2) {
                    l2 = k2;
                }
                if (i3 < k2) {
                    i3 = k2;
                }
                float f7 = 1.0f;
                int j3 = k2;
                if (j3 < j1) {
                    j3 = j1;
                }
                if (l2 == i3) continue;
                this.random.setSeed(i2 * i2 * 3121 + i2 * 45238971 ^ l1 * l1 * 418711 + l1 * 13761);
                float f8 = biomegenbase.getFloatTemperature();
                if (world.getWorldChunkManager().getTemperatureAtHeight(f8, k2) >= 0.15f) {
                    if (byte0 != 0) {
                        if (byte0 >= 0) {
                            tessellator.draw();
                        }
                        byte0 = 0;
                        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/environment/rain.png"));
                        tessellator.startDrawingQuads();
                    }
                    float f9 = ((float)(this.rendererUpdateCount + i2 * i2 * 3121 + i2 * 45238971 + l1 * l1 * 418711 + l1 * 13761 & 0x1F) + par1) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)i2 + 0.5f) - entityliving.posX;
                    double d4 = (double)((float)l1 + 0.5f) - entityliving.posZ;
                    float f13 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)k1;
                    float f14 = 1.0f;
                    tessellator.setBrightness(world.getLightBrightnessForSkyBlocks(i2, j3, l1, 0));
                    tessellator.setColorRGBA_F(f14, f14, f14, ((1.0f - f13 * f13) * 0.5f + 0.5f) * f);
                    tessellator.setTranslation(-d * 1.0, -d1 * 1.0, -d2 * 1.0);
                    tessellator.addVertexWithUV((double)((float)i2 - f5) + 0.5, l2, (double)((float)l1 - f6) + 0.5, 0.0f * f7, (float)l2 * f7 / 4.0f + f9 * f7);
                    tessellator.addVertexWithUV((double)((float)i2 + f5) + 0.5, l2, (double)((float)l1 + f6) + 0.5, 1.0f * f7, (float)l2 * f7 / 4.0f + f9 * f7);
                    tessellator.addVertexWithUV((double)((float)i2 + f5) + 0.5, i3, (double)((float)l1 + f6) + 0.5, 1.0f * f7, (float)i3 * f7 / 4.0f + f9 * f7);
                    tessellator.addVertexWithUV((double)((float)i2 - f5) + 0.5, i3, (double)((float)l1 - f6) + 0.5, 0.0f * f7, (float)i3 * f7 / 4.0f + f9 * f7);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    continue;
                }
                if (byte0 != 1) {
                    if (byte0 >= 0) {
                        tessellator.draw();
                    }
                    byte0 = 1;
                    GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/environment/snow.png"));
                    tessellator.startDrawingQuads();
                }
                float f10 = ((float)(this.rendererUpdateCount & 0x1FF) + par1) / 512.0f;
                float f11 = this.random.nextFloat() + f4 * 0.01f * (float)this.random.nextGaussian();
                float f12 = this.random.nextFloat() + f4 * (float)this.random.nextGaussian() * 0.001f;
                double d5 = (double)((float)i2 + 0.5f) - entityliving.posX;
                double d6 = (double)((float)l1 + 0.5f) - entityliving.posZ;
                float f15 = MathHelper.sqrt_double(d5 * d5 + d6 * d6) / (float)k1;
                float f16 = 1.0f;
                tessellator.setBrightness((world.getLightBrightnessForSkyBlocks(i2, j3, l1, 0) * 3 + 0xF000F0) / 4);
                tessellator.setColorRGBA_F(f16, f16, f16, ((1.0f - f15 * f15) * 0.3f + 0.5f) * f);
                tessellator.setTranslation(-d * 1.0, -d1 * 1.0, -d2 * 1.0);
                tessellator.addVertexWithUV((double)((float)i2 - f5) + 0.5, l2, (double)((float)l1 - f6) + 0.5, 0.0f * f7 + f11, (float)l2 * f7 / 4.0f + f10 * f7 + f12);
                tessellator.addVertexWithUV((double)((float)i2 + f5) + 0.5, l2, (double)((float)l1 + f6) + 0.5, 1.0f * f7 + f11, (float)l2 * f7 / 4.0f + f10 * f7 + f12);
                tessellator.addVertexWithUV((double)((float)i2 + f5) + 0.5, i3, (double)((float)l1 + f6) + 0.5, 1.0f * f7 + f11, (float)i3 * f7 / 4.0f + f10 * f7 + f12);
                tessellator.addVertexWithUV((double)((float)i2 - f5) + 0.5, i3, (double)((float)l1 - f6) + 0.5, 0.0f * f7 + f11, (float)i3 * f7 / 4.0f + f10 * f7 + f12);
                tessellator.setTranslation(0.0, 0.0, 0.0);
            }
        }
        if (byte0 >= 0) {
            tessellator.draw();
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        this.disableLightmap(par1);
    }

    public void setupOverlayRendering() {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc.gameSettings, this.mc.displayWidth, this.mc.displayHeight);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.scaledWidthD, (double)scaledresolution.scaledHeightD, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private void updateFogColor(float par1) {
        float f7;
        World world = this.mc.theWorld;
        EntityLiving entityliving = this.mc.renderViewEntity;
        float f = 1.0f / (float)(4 - this.mc.gameSettings.renderDistance);
        f = 1.0f - (float)Math.pow(f, 0.25);
        Vec3D vec3d = world.getSkyColor(this.mc.renderViewEntity, par1);
        float f1 = (float)vec3d.xCoord;
        float f2 = (float)vec3d.yCoord;
        float f3 = (float)vec3d.zCoord;
        Vec3D vec3d1 = world.getFogColor(par1);
        this.fogColorRed = (float)vec3d1.xCoord;
        this.fogColorGreen = (float)vec3d1.yCoord;
        this.fogColorBlue = (float)vec3d1.zCoord;
        if (this.mc.gameSettings.renderDistance < 2) {
            float[] af;
            Vec3D vec3d2 = MathHelper.sin(world.getCelestialAngleRadians(par1)) <= 0.0f ? Vec3D.createVector(1.0, 0.0, 0.0) : Vec3D.createVector(-1.0, 0.0, 0.0);
            float f5 = (float)entityliving.getLook(par1).dotProduct(vec3d2);
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            if (f5 > 0.0f && (af = world.worldProvider.calcSunriseSunsetColors(world.getCelestialAngle(par1), par1)) != null) {
                this.fogColorRed = this.fogColorRed * (1.0f - (f5 *= af[3])) + af[0] * f5;
                this.fogColorGreen = this.fogColorGreen * (1.0f - f5) + af[1] * f5;
                this.fogColorBlue = this.fogColorBlue * (1.0f - f5) + af[2] * f5;
            }
        }
        this.fogColorRed += (f1 - this.fogColorRed) * f;
        this.fogColorGreen += (f2 - this.fogColorGreen) * f;
        this.fogColorBlue += (f3 - this.fogColorBlue) * f;
        float f4 = world.getRainStrength(par1);
        if (f4 > 0.0f) {
            float f6 = 1.0f - f4 * 0.5f;
            float f8 = 1.0f - f4 * 0.4f;
            this.fogColorRed *= f6;
            this.fogColorGreen *= f6;
            this.fogColorBlue *= f8;
        }
        if ((f7 = world.getWeightedThunderStrength(par1)) > 0.0f) {
            float f9 = 1.0f - f7 * 0.5f;
            this.fogColorRed *= f9;
            this.fogColorGreen *= f9;
            this.fogColorBlue *= f9;
        }
        int i = ActiveRenderInfo.getBlockIdAtEntityViewpoint(this.mc.theWorld, entityliving, par1);
        if (this.cloudFog) {
            Vec3D vec3d3 = world.drawClouds(par1);
            this.fogColorRed = (float)vec3d3.xCoord;
            this.fogColorGreen = (float)vec3d3.yCoord;
            this.fogColorBlue = (float)vec3d3.zCoord;
        } else if (i != 0 && Block.blocksList[i].blockMaterial == Material.water) {
            this.fogColorRed = 0.02f;
            this.fogColorGreen = 0.02f;
            this.fogColorBlue = 0.2f;
        } else if (i != 0 && Block.blocksList[i].blockMaterial == Material.lava) {
            this.fogColorRed = 0.6f;
            this.fogColorGreen = 0.1f;
            this.fogColorBlue = 0.0f;
        }
        float f10 = this.fogColor2 + (this.fogColor1 - this.fogColor2) * par1;
        this.fogColorRed *= f10;
        this.fogColorGreen *= f10;
        this.fogColorBlue *= f10;
        double d = (entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)par1) * world.worldProvider.getVoidFogYFactor();
        if (entityliving.isPotionActive(Potion.blindness)) {
            int j = entityliving.getActivePotionEffect(Potion.blindness).getDuration();
            d = j < 20 ? (d *= (double)(1.0f - (float)j / 20.0f)) : 0.0;
        }
        if (d < 1.0) {
            if (d < 0.0) {
                d = 0.0;
            }
            d *= d;
            this.fogColorRed = (float)((double)this.fogColorRed * d);
            this.fogColorGreen = (float)((double)this.fogColorGreen * d);
            this.fogColorBlue = (float)((double)this.fogColorBlue * d);
        }
        if (this.mc.gameSettings.anaglyph) {
            float f11 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float f12 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float f13 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = f11;
            this.fogColorGreen = f12;
            this.fogColorBlue = f13;
        }
        GL11.glClearColor((float)this.fogColorRed, (float)this.fogColorGreen, (float)this.fogColorBlue, (float)0.0f);
    }

    private void setupFog(int par1, float par2) {
        EntityLiving entityliving = this.mc.renderViewEntity;
        boolean flag = false;
        if (entityliving instanceof EntityPlayer) {
            flag = ((EntityPlayer)entityliving).capabilities.isCreativeMode;
        }
        if (par1 == 999) {
            GL11.glFog((int)2918, (FloatBuffer)this.setFogColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)0.0f);
            GL11.glFogf((int)2916, (float)8.0f);
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi((int)34138, (int)34139);
            }
            GL11.glFogf((int)2915, (float)0.0f);
            return;
        }
        GL11.glFog((int)2918, (FloatBuffer)this.setFogColorBuffer(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 1.0f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = ActiveRenderInfo.getBlockIdAtEntityViewpoint(this.mc.theWorld, entityliving, par2);
        if (entityliving.isPotionActive(Potion.blindness)) {
            float f = 5.0f;
            int j = entityliving.getActivePotionEffect(Potion.blindness).getDuration();
            if (j < 20) {
                f = 5.0f + (this.farPlaneDistance - 5.0f) * (1.0f - (float)j / 20.0f);
            }
            GL11.glFogi((int)2917, (int)9729);
            if (par1 < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(f * 0.8f));
            } else {
                GL11.glFogf((int)2915, (float)(f * 0.25f));
                GL11.glFogf((int)2916, (float)f);
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi((int)34138, (int)34139);
            }
        } else if (this.cloudFog) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.1f);
            float f1 = 1.0f;
            float f5 = 1.0f;
            float f8 = 1.0f;
            if (this.mc.gameSettings.anaglyph) {
                float f11 = (f1 * 30.0f + f5 * 59.0f + f8 * 11.0f) / 100.0f;
                float f15 = (f1 * 30.0f + f5 * 70.0f) / 100.0f;
                float f18 = (f1 * 30.0f + f8 * 70.0f) / 100.0f;
                f1 = f11;
                f5 = f15;
                f8 = f18;
            }
        } else if (i > 0 && Block.blocksList[i].blockMaterial == Material.water) {
            GL11.glFogi((int)2917, (int)2048);
            if (!entityliving.isPotionActive(Potion.waterBreathing)) {
                GL11.glFogf((int)2914, (float)0.1f);
            } else {
                GL11.glFogf((int)2914, (float)0.05f);
            }
            float f2 = 0.4f;
            float f6 = 0.4f;
            float f9 = 0.9f;
            if (this.mc.gameSettings.anaglyph) {
                float f12 = (f2 * 30.0f + f6 * 59.0f + f9 * 11.0f) / 100.0f;
                float f16 = (f2 * 30.0f + f6 * 70.0f) / 100.0f;
                float f19 = (f2 * 30.0f + f9 * 70.0f) / 100.0f;
                f2 = f12;
                f6 = f16;
                f9 = f19;
            }
        } else if (i > 0 && Block.blocksList[i].blockMaterial == Material.lava) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)2.0f);
            float f3 = 0.4f;
            float f7 = 0.3f;
            float f10 = 0.3f;
            if (this.mc.gameSettings.anaglyph) {
                float f13 = (f3 * 30.0f + f7 * 59.0f + f10 * 11.0f) / 100.0f;
                float f17 = (f3 * 30.0f + f7 * 70.0f) / 100.0f;
                float f20 = (f3 * 30.0f + f10 * 70.0f) / 100.0f;
                f3 = f13;
                f7 = f17;
                f10 = f20;
            }
        } else {
            double d;
            float f4 = this.farPlaneDistance;
            if (this.mc.theWorld.worldProvider.getWorldHasNoSky() && !flag && (d = (double)((entityliving.getBrightnessForRender(par2) & 0xF00000) >> 20) / 16.0 + (entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)par2 + 4.0) / 32.0) < 1.0) {
                float f14;
                if (d < 0.0) {
                    d = 0.0;
                }
                if ((f14 = 100.0f * (float)(d *= d)) < 5.0f) {
                    f14 = 5.0f;
                }
                if (f4 > f14) {
                    f4 = f14;
                }
            }
            GL11.glFogi((int)2917, (int)9729);
            if (par1 < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(f4 * 0.8f));
            } else {
                GL11.glFogf((int)2915, (float)(f4 * 0.25f));
                GL11.glFogf((int)2916, (float)f4);
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi((int)34138, (int)34139);
            }
            if (this.mc.theWorld.worldProvider.func_48218_b((int)entityliving.posX, (int)entityliving.posZ)) {
                GL11.glFogf((int)2915, (float)(f4 * 0.05f));
                GL11.glFogf((int)2916, (float)(Math.min(f4, 192.0f) * 0.5f));
            }
        }
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
    }

    private FloatBuffer setFogColorBuffer(float par1, float par2, float par3, float par4) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(par1).put(par2).put(par3).put(par4);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

