/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Achievement;
import net.minecraft.src.AchievementList;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityCrit2FX;
import net.minecraft.src.EntityPickupFX;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiBrewingStand;
import net.minecraft.src.GuiChest;
import net.minecraft.src.GuiCrafting;
import net.minecraft.src.GuiDispenser;
import net.minecraft.src.GuiEditSign;
import net.minecraft.src.GuiEnchantment;
import net.minecraft.src.GuiFurnace;
import net.minecraft.src.GuiWinGame;
import net.minecraft.src.IInventory;
import net.minecraft.src.Item;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MouseFilter;
import net.minecraft.src.MovementInput;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Potion;
import net.minecraft.src.Session;
import net.minecraft.src.StatBase;
import net.minecraft.src.TileEntityBrewingStand;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.World;

public class EntityPlayerSP
extends EntityPlayer {
    public MovementInput movementInput;
    protected Minecraft mc;
    protected int sprintToggleTimer = 0;
    public int sprintingTicksLeft = 0;
    public float renderArmYaw;
    public float renderArmPitch;
    public float prevRenderArmYaw;
    public float prevRenderArmPitch;
    private MouseFilter field_21903_bJ = new MouseFilter();
    private MouseFilter field_21904_bK = new MouseFilter();
    private MouseFilter field_21902_bL = new MouseFilter();

    public EntityPlayerSP(Minecraft par1Minecraft, World par2World, Session par3Session, int par4) {
        super(par2World);
        this.mc = par1Minecraft;
        this.dimension = par4;
        if (par3Session != null && par3Session.username != null && par3Session.username.length() > 0) {
            this.skinUrl = "http://s3.amazonaws.com/MinecraftSkins/" + par3Session.username + ".png";
        }
        this.username = par3Session.username;
    }

    @Override
    public void moveEntity(double par1, double par3, double par5) {
        super.moveEntity(par1, par3, par5);
    }

    @Override
    public void updateEntityActionState() {
        super.updateEntityActionState();
        this.moveStrafing = this.movementInput.moveStrafe;
        this.moveForward = this.movementInput.moveForward;
        this.isJumping = this.movementInput.jump;
        this.prevRenderArmYaw = this.renderArmYaw;
        this.prevRenderArmPitch = this.renderArmPitch;
        this.renderArmPitch = (float)((double)this.renderArmPitch + (double)(this.rotationPitch - this.renderArmPitch) * 0.5);
        this.renderArmYaw = (float)((double)this.renderArmYaw + (double)(this.rotationYaw - this.renderArmYaw) * 0.5);
    }

    @Override
    protected boolean isClientWorld() {
        return true;
    }

    @Override
    public void onLivingUpdate() {
        boolean flag2;
        if (this.sprintingTicksLeft > 0) {
            --this.sprintingTicksLeft;
            if (this.sprintingTicksLeft == 0) {
                this.setSprinting(false);
            }
        }
        if (this.sprintToggleTimer > 0) {
            --this.sprintToggleTimer;
        }
        if (this.mc.playerController.func_35643_e()) {
            this.posZ = 0.5;
            this.posX = 0.5;
            this.posX = 0.0;
            this.posZ = 0.0;
            this.rotationYaw = (float)this.ticksExisted / 12.0f;
            this.rotationPitch = 10.0f;
            this.posY = 68.5;
            return;
        }
        if (!this.mc.statFileWriter.hasAchievementUnlocked(AchievementList.openInventory)) {
            this.mc.guiAchievement.queueAchievementInformation(AchievementList.openInventory);
        }
        this.prevTimeInPortal = this.timeInPortal;
        if (this.inPortal) {
            if (!this.worldObj.isRemote && this.ridingEntity != null) {
                this.mountEntity(null);
            }
            if (this.mc.currentScreen != null) {
                this.mc.displayGuiScreen(null);
            }
            if (this.timeInPortal == 0.0f) {
                this.mc.sndManager.playSoundFX("portal.trigger", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
            }
            this.timeInPortal += 0.0125f;
            if (this.timeInPortal >= 1.0f) {
                this.timeInPortal = 1.0f;
                if (!this.worldObj.isRemote) {
                    this.timeUntilPortal = 10;
                    this.mc.sndManager.playSoundFX("portal.travel", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
                    int byte0 = 0;
                    byte0 = this.dimension == -1 ? 0 : -1;
                    this.mc.usePortal(byte0);
                    this.triggerAchievement(AchievementList.portal);
                }
            }
            this.inPortal = false;
        } else if (this.isPotionActive(Potion.confusion) && this.getActivePotionEffect(Potion.confusion).getDuration() > 60) {
            this.timeInPortal += 0.006666667f;
            if (this.timeInPortal > 1.0f) {
                this.timeInPortal = 1.0f;
            }
        } else {
            if (this.timeInPortal > 0.0f) {
                this.timeInPortal -= 0.05f;
            }
            if (this.timeInPortal < 0.0f) {
                this.timeInPortal = 0.0f;
            }
        }
        if (this.timeUntilPortal > 0) {
            --this.timeUntilPortal;
        }
        boolean flag = this.movementInput.jump;
        float f = 0.8f;
        boolean flag1 = this.movementInput.moveForward >= f;
        this.movementInput.updatePlayerMoveState();
        if (this.isUsingItem()) {
            this.movementInput.moveStrafe *= 0.2f;
            this.movementInput.moveForward *= 0.2f;
            this.sprintToggleTimer = 0;
        }
        if (this.movementInput.sneak && this.ySize < 0.2f) {
            this.ySize = 0.2f;
        }
        this.pushOutOfBlocks(this.posX - (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ + (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX - (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ - (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX + (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ - (double)this.width * 0.35);
        this.pushOutOfBlocks(this.posX + (double)this.width * 0.35, this.boundingBox.minY + 0.5, this.posZ + (double)this.width * 0.35);
        boolean bl = flag2 = (float)this.getFoodStats().getFoodLevel() > 6.0f;
        if (this.onGround && !flag1 && this.movementInput.moveForward >= f && !this.isSprinting() && flag2 && !this.isUsingItem() && !this.isPotionActive(Potion.blindness)) {
            if (this.sprintToggleTimer == 0) {
                this.sprintToggleTimer = 7;
            } else {
                this.setSprinting(true);
                this.sprintToggleTimer = 0;
            }
        }
        if (this.isSneaking()) {
            this.sprintToggleTimer = 0;
        }
        if (this.isSprinting() && (this.movementInput.moveForward < f || this.isCollidedHorizontally || !flag2)) {
            this.setSprinting(false);
        }
        if (this.capabilities.allowFlying && !flag && this.movementInput.jump) {
            if (this.flyToggleTimer == 0) {
                this.flyToggleTimer = 7;
            } else {
                this.capabilities.isFlying = !this.capabilities.isFlying;
                this.func_50009_aI();
                this.flyToggleTimer = 0;
            }
        }
        if (this.capabilities.isFlying) {
            if (this.movementInput.sneak) {
                this.motionY -= 0.15;
            }
            if (this.movementInput.jump) {
                this.motionY += 0.15;
            }
        }
        super.onLivingUpdate();
        if (this.onGround && this.capabilities.isFlying) {
            this.capabilities.isFlying = false;
            this.func_50009_aI();
        }
    }

    @Override
    public void travelToTheEnd(int par1) {
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.dimension == 1 && par1 == 1) {
            this.triggerAchievement(AchievementList.theEnd2);
            this.mc.displayGuiScreen(new GuiWinGame());
        } else {
            this.triggerAchievement(AchievementList.theEnd);
            this.mc.sndManager.playSoundFX("portal.travel", 1.0f, this.rand.nextFloat() * 0.4f + 0.8f);
            this.mc.usePortal(1);
        }
    }

    public float getFOVMultiplier() {
        float f = 1.0f;
        if (this.capabilities.isFlying) {
            f *= 1.1f;
        }
        f *= (this.landMovementFactor * this.getSpeedModifier() / this.speedOnGround + 1.0f) / 2.0f;
        if (this.isUsingItem() && this.getItemInUse().itemID == Item.bow.shiftedIndex) {
            int i = this.getItemInUseDuration();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            f *= 1.0f - f1 * 0.15f;
        }
        return f;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("Score", this.score);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.score = par1NBTTagCompound.getInteger("Score");
    }

    @Override
    public void closeScreen() {
        super.closeScreen();
        this.mc.displayGuiScreen(null);
    }

    @Override
    public void displayGUIEditSign(TileEntitySign par1TileEntitySign) {
        this.mc.displayGuiScreen(new GuiEditSign(par1TileEntitySign));
    }

    @Override
    public void displayGUIChest(IInventory par1IInventory) {
        this.mc.displayGuiScreen(new GuiChest(this.inventory, par1IInventory));
    }

    @Override
    public void displayWorkbenchGUI(int par1, int par2, int par3) {
        this.mc.displayGuiScreen(new GuiCrafting(this.inventory, this.worldObj, par1, par2, par3));
    }

    @Override
    public void displayGUIEnchantment(int par1, int par2, int par3) {
        this.mc.displayGuiScreen(new GuiEnchantment(this.inventory, this.worldObj, par1, par2, par3));
    }

    @Override
    public void displayGUIFurnace(TileEntityFurnace par1TileEntityFurnace) {
        this.mc.displayGuiScreen(new GuiFurnace(this.inventory, par1TileEntityFurnace));
    }

    @Override
    public void displayGUIBrewingStand(TileEntityBrewingStand par1TileEntityBrewingStand) {
        this.mc.displayGuiScreen(new GuiBrewingStand(this.inventory, par1TileEntityBrewingStand));
    }

    @Override
    public void displayGUIDispenser(TileEntityDispenser par1TileEntityDispenser) {
        this.mc.displayGuiScreen(new GuiDispenser(this.inventory, par1TileEntityDispenser));
    }

    @Override
    public void onCriticalHit(Entity par1Entity) {
        this.mc.effectRenderer.addEffect(new EntityCrit2FX(this.mc.theWorld, par1Entity));
    }

    @Override
    public void onEnchantmentCritical(Entity par1Entity) {
        EntityCrit2FX entitycrit2fx = new EntityCrit2FX(this.mc.theWorld, par1Entity, "magicCrit");
        this.mc.effectRenderer.addEffect(entitycrit2fx);
    }

    @Override
    public void onItemPickup(Entity par1Entity, int par2) {
        this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.theWorld, par1Entity, this, -0.5f));
    }

    public void sendChatMessage(String s) {
    }

    @Override
    public boolean isSneaking() {
        return this.movementInput.sneak && !this.sleeping;
    }

    public void setHealth(int par1) {
        int i = this.getHealth() - par1;
        if (i <= 0) {
            this.setEntityHealth(par1);
            if (i < 0) {
                this.heartsLife = this.heartsHalvesLife / 2;
            }
        } else {
            this.naturalArmorRating = i;
            this.setEntityHealth(this.getHealth());
            this.heartsLife = this.heartsHalvesLife;
            this.damageEntity(DamageSource.generic, i);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
    }

    @Override
    public void respawnPlayer() {
        this.mc.respawn(false, 0, false);
    }

    @Override
    public void func_6420_o() {
    }

    @Override
    public void addChatMessage(String par1Str) {
        this.mc.ingameGUI.addChatMessageTranslate(par1Str);
    }

    @Override
    public void addStat(StatBase par1StatBase, int par2) {
        if (par1StatBase == null) {
            return;
        }
        if (par1StatBase.isAchievement()) {
            Achievement achievement = (Achievement)par1StatBase;
            if (achievement.parentAchievement == null || this.mc.statFileWriter.hasAchievementUnlocked(achievement.parentAchievement)) {
                if (!this.mc.statFileWriter.hasAchievementUnlocked(achievement)) {
                    this.mc.guiAchievement.queueTakenAchievement(achievement);
                }
                this.mc.statFileWriter.readStat(par1StatBase, par2);
            }
        } else {
            this.mc.statFileWriter.readStat(par1StatBase, par2);
        }
    }

    private boolean isBlockTranslucent(int par1, int par2, int par3) {
        return this.worldObj.isBlockNormalCube(par1, par2, par3);
    }

    @Override
    protected boolean pushOutOfBlocks(double par1, double par3, double par5) {
        int i = MathHelper.floor_double(par1);
        int j = MathHelper.floor_double(par3);
        int k = MathHelper.floor_double(par5);
        double d = par1 - (double)i;
        double d1 = par5 - (double)k;
        if (this.isBlockTranslucent(i, j, k) || this.isBlockTranslucent(i, j + 1, k)) {
            boolean flag = !this.isBlockTranslucent(i - 1, j, k) && !this.isBlockTranslucent(i - 1, j + 1, k);
            boolean flag1 = !this.isBlockTranslucent(i + 1, j, k) && !this.isBlockTranslucent(i + 1, j + 1, k);
            boolean flag2 = !this.isBlockTranslucent(i, j, k - 1) && !this.isBlockTranslucent(i, j + 1, k - 1);
            boolean flag3 = !this.isBlockTranslucent(i, j, k + 1) && !this.isBlockTranslucent(i, j + 1, k + 1);
            int byte0 = -1;
            double d2 = 9999.0;
            if (flag && d < d2) {
                d2 = d;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d < d2) {
                d2 = 1.0 - d;
                byte0 = 1;
            }
            if (flag2 && d1 < d2) {
                d2 = d1;
                byte0 = 4;
            }
            if (flag3 && 1.0 - d1 < d2) {
                double d3 = 1.0 - d1;
                byte0 = 5;
            }
            float f = 0.1f;
            if (byte0 == 0) {
                this.motionX = -f;
            }
            if (byte0 == 1) {
                this.motionX = f;
            }
            if (byte0 == 4) {
                this.motionZ = -f;
            }
            if (byte0 == 5) {
                this.motionZ = f;
            }
        }
        return false;
    }

    @Override
    public void setSprinting(boolean par1) {
        super.setSprinting(par1);
        this.sprintingTicksLeft = par1 ? 600 : 0;
    }

    public void setXPStats(float par1, int par2, int par3) {
        this.experience = par1;
        this.experienceTotal = par2;
        this.experienceLevel = par3;
    }
}

