/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AchievementList;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockBed;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.Container;
import net.minecraft.src.ContainerPlayer;
import net.minecraft.src.DamageSource;
import net.minecraft.src.EnchantmentHelper;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityFishHook;
import net.minecraft.src.EntityGhast;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntityWolf;
import net.minecraft.src.EnumAction;
import net.minecraft.src.EnumStatus;
import net.minecraft.src.FoodStats;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PlayerCapabilities;
import net.minecraft.src.Potion;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatList;
import net.minecraft.src.TileEntityBrewingStand;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityFurnace;
import net.minecraft.src.TileEntitySign;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public abstract class EntityPlayer
extends EntityLiving {
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public Container inventorySlots;
    public Container craftingInventory;
    protected FoodStats foodStats = new FoodStats();
    protected int flyToggleTimer = 0;
    public byte field_9371_f = 0;
    public int score = 0;
    public float prevCameraYaw;
    public float cameraYaw;
    public boolean isSwinging = false;
    public int swingProgressInt = 0;
    public String username;
    public int dimension;
    public String playerCloakUrl;
    public int xpCooldown = 0;
    public double field_20066_r;
    public double field_20065_s;
    public double field_20064_t;
    public double field_20063_u;
    public double field_20062_v;
    public double field_20061_w;
    protected boolean sleeping;
    public ChunkCoordinates playerLocation;
    private int sleepTimer;
    public float field_22063_x;
    public float field_22062_y;
    public float field_22061_z;
    private ChunkCoordinates spawnChunk;
    private ChunkCoordinates startMinecartRidingCoordinate;
    public int timeUntilPortal = 20;
    protected boolean inPortal = false;
    public float timeInPortal;
    public float prevTimeInPortal;
    public PlayerCapabilities capabilities = new PlayerCapabilities();
    public int experienceLevel;
    public int experienceTotal;
    public float experience;
    private ItemStack itemInUse;
    private int itemInUseCount;
    protected float speedOnGround = 0.1f;
    protected float speedInAir = 0.02f;
    public EntityFishHook fishEntity = null;

    public EntityPlayer(World par1World) {
        super(par1World);
        this.craftingInventory = this.inventorySlots = new ContainerPlayer(this.inventory, !par1World.isRemote);
        this.yOffset = 1.62f;
        ChunkCoordinates chunkcoordinates = par1World.getSpawnPoint();
        this.setLocationAndAngles((double)chunkcoordinates.posX + 0.5, chunkcoordinates.posY + 1, (double)chunkcoordinates.posZ + 0.5, 0.0f, 0.0f);
        this.entityType = "humanoid";
        this.field_9353_B = 180.0f;
        this.fireResistance = 20;
        this.texture = "/mob/char.png";
    }

    @Override
    public int getMaxHealth() {
        return 20;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)0);
        this.dataWatcher.addObject(17, (byte)0);
    }

    public ItemStack getItemInUse() {
        return this.itemInUse;
    }

    public int getItemInUseCount() {
        return this.itemInUseCount;
    }

    public boolean isUsingItem() {
        return this.itemInUse != null;
    }

    public int getItemInUseDuration() {
        if (this.isUsingItem()) {
            return this.itemInUse.getMaxItemUseDuration() - this.itemInUseCount;
        }
        return 0;
    }

    public void stopUsingItem() {
        if (this.itemInUse != null) {
            this.itemInUse.onPlayerStoppedUsing(this.worldObj, this, this.itemInUseCount);
        }
        this.clearItemInUse();
    }

    public void clearItemInUse() {
        this.itemInUse = null;
        this.itemInUseCount = 0;
        if (!this.worldObj.isRemote) {
            this.setEating(false);
        }
    }

    @Override
    public boolean isBlocking() {
        return this.isUsingItem() && Item.itemsList[this.itemInUse.itemID].getItemUseAction(this.itemInUse) == EnumAction.block;
    }

    @Override
    public void onUpdate() {
        if (this.itemInUse != null) {
            ItemStack itemstack = this.inventory.getCurrentItem();
            if (itemstack != this.itemInUse) {
                this.clearItemInUse();
            } else {
                if (this.itemInUseCount <= 25 && this.itemInUseCount % 4 == 0) {
                    this.updateItemUse(itemstack, 5);
                }
                if (--this.itemInUseCount == 0 && !this.worldObj.isRemote) {
                    this.onItemUseFinish();
                }
            }
        }
        if (this.xpCooldown > 0) {
            --this.xpCooldown;
        }
        if (this.isPlayerSleeping()) {
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.worldObj.isRemote) {
                if (!this.isInBed()) {
                    this.wakeUpPlayer(true, true, false);
                } else if (this.worldObj.isDaytime()) {
                    this.wakeUpPlayer(false, true, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        super.onUpdate();
        if (!this.worldObj.isRemote && this.craftingInventory != null && !this.craftingInventory.canInteractWith(this)) {
            this.closeScreen();
            this.craftingInventory = this.inventorySlots;
        }
        if (this.capabilities.isFlying) {
            for (int i = 0; i < 8; ++i) {
            }
        }
        if (this.isBurning() && this.capabilities.disableDamage) {
            this.extinguish();
        }
        this.field_20066_r = this.field_20063_u;
        this.field_20065_s = this.field_20062_v;
        this.field_20064_t = this.field_20061_w;
        double d = this.posX - this.field_20063_u;
        double d1 = this.posY - this.field_20062_v;
        double d2 = this.posZ - this.field_20061_w;
        double d3 = 10.0;
        if (d > d3) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (d2 > d3) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (d1 > d3) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        if (d < -d3) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (d2 < -d3) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (d1 < -d3) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        this.field_20063_u += d * 0.25;
        this.field_20061_w += d2 * 0.25;
        this.field_20062_v += d1 * 0.25;
        this.addStat(StatList.minutesPlayedStat, 1);
        if (this.ridingEntity == null) {
            this.startMinecartRidingCoordinate = null;
        }
        if (!this.worldObj.isRemote) {
            this.foodStats.onUpdate(this);
        }
    }

    protected void updateItemUse(ItemStack par1ItemStack, int par2) {
        if (par1ItemStack.getItemUseAction() == EnumAction.drink) {
            this.worldObj.playSoundAtEntity(this, "random.drink", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
        }
        if (par1ItemStack.getItemUseAction() == EnumAction.eat) {
            for (int i = 0; i < par2; ++i) {
                Vec3D vec3d = Vec3D.createVector(((double)this.rand.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                vec3d.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0f);
                vec3d.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0f);
                Vec3D vec3d1 = Vec3D.createVector(((double)this.rand.nextFloat() - 0.5) * 0.3, (double)(-this.rand.nextFloat()) * 0.6 - 0.3, 0.6);
                vec3d1.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0f);
                vec3d1.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0f);
                vec3d1 = vec3d1.addVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ);
                this.worldObj.spawnParticle("iconcrack_" + par1ItemStack.getItem().shiftedIndex, vec3d1.xCoord, vec3d1.yCoord, vec3d1.zCoord, vec3d.xCoord, vec3d.yCoord + 0.05, vec3d.zCoord);
            }
            this.worldObj.playSoundAtEntity(this, "random.eat", 0.5f + 0.5f * (float)this.rand.nextInt(2), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected void onItemUseFinish() {
        if (this.itemInUse != null) {
            this.updateItemUse(this.itemInUse, 16);
            int i = this.itemInUse.stackSize;
            ItemStack itemstack = this.itemInUse.onFoodEaten(this.worldObj, this);
            if (itemstack != this.itemInUse || itemstack != null && itemstack.stackSize != i) {
                this.inventory.mainInventory[this.inventory.currentItem] = itemstack;
                if (itemstack.stackSize == 0) {
                    this.inventory.mainInventory[this.inventory.currentItem] = null;
                }
            }
            this.clearItemInUse();
        }
    }

    @Override
    public void handleHealthUpdate(byte par1) {
        if (par1 == 9) {
            this.onItemUseFinish();
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.getHealth() <= 0 || this.isPlayerSleeping();
    }

    protected void closeScreen() {
        this.craftingInventory = this.inventorySlots;
    }

    @Override
    public void updateCloak() {
        this.cloakUrl = this.playerCloakUrl = "http://s3.amazonaws.com/MinecraftCloaks/" + this.username + ".png";
    }

    @Override
    public void updateRidden() {
        double d = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        super.updateRidden();
        this.prevCameraYaw = this.cameraYaw;
        this.cameraYaw = 0.0f;
        this.addMountedMovementStat(this.posX - d, this.posY - d1, this.posZ - d2);
    }

    @Override
    public void preparePlayerToSpawn() {
        this.yOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.preparePlayerToSpawn();
        this.setEntityHealth(this.getMaxHealth());
        this.deathTime = 0;
    }

    private int getSwingSpeedModifier() {
        if (this.isPotionActive(Potion.digSpeed)) {
            return 6 - (1 + this.getActivePotionEffect(Potion.digSpeed).getAmplifier()) * 1;
        }
        if (this.isPotionActive(Potion.digSlowdown)) {
            return 6 + (1 + this.getActivePotionEffect(Potion.digSlowdown).getAmplifier()) * 2;
        }
        return 6;
    }

    @Override
    protected void updateEntityActionState() {
        int i = this.getSwingSpeedModifier();
        if (this.isSwinging) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= i) {
                this.swingProgressInt = 0;
                this.isSwinging = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / (float)i;
    }

    @Override
    public void onLivingUpdate() {
        List list;
        if (this.flyToggleTimer > 0) {
            --this.flyToggleTimer;
        }
        if (this.worldObj.difficultySetting == 0 && this.getHealth() < this.getMaxHealth() && this.ticksExisted % 20 * 12 == 0) {
            this.heal(1);
        }
        this.inventory.decrementAnimations();
        this.prevCameraYaw = this.cameraYaw;
        super.onLivingUpdate();
        this.landMovementFactor = this.speedOnGround;
        this.jumpMovementFactor = this.speedInAir;
        if (this.isSprinting()) {
            this.landMovementFactor = (float)((double)this.landMovementFactor + (double)this.speedOnGround * 0.3);
            this.jumpMovementFactor = (float)((double)this.jumpMovementFactor + (double)this.speedInAir * 0.3);
        }
        float f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.getHealth() <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.getHealth() <= 0) {
            f1 = 0.0f;
        }
        this.cameraYaw += (f - this.cameraYaw) * 0.4f;
        this.cameraPitch += (f1 - this.cameraPitch) * 0.8f;
        if (this.getHealth() > 0 && (list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1.0, 0.0, 1.0))) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.isDead) continue;
                this.collideWithPlayer(entity);
            }
        }
    }

    private void collideWithPlayer(Entity par1Entity) {
        par1Entity.onCollideWithPlayer(this);
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        if (this.username.equals("Notch")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.appleRed, 1), true);
        }
        this.inventory.dropAllItems();
        if (par1DamageSource != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * (float)Math.PI / 180.0f) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.yOffset = 0.1f;
        this.addStat(StatList.deathsStat, 1);
    }

    @Override
    public void addToPlayerScore(Entity par1Entity, int par2) {
        this.score += par2;
        if (par1Entity instanceof EntityPlayer) {
            this.addStat(StatList.playerKillsStat, 1);
        } else {
            this.addStat(StatList.mobKillsStat, 1);
        }
    }

    @Override
    protected int decreaseAirSupply(int par1) {
        int i = EnchantmentHelper.getRespiration(this.inventory);
        if (i > 0 && this.rand.nextInt(i + 1) > 0) {
            return par1;
        }
        return super.decreaseAirSupply(par1);
    }

    public EntityItem dropOneItem() {
        return this.dropPlayerItemWithRandomChoice(this.inventory.decrStackSize(this.inventory.currentItem, 1), false);
    }

    public EntityItem dropPlayerItem(ItemStack par1ItemStack) {
        return this.dropPlayerItemWithRandomChoice(par1ItemStack, false);
    }

    public EntityItem dropPlayerItemWithRandomChoice(ItemStack par1ItemStack, boolean par2) {
        if (par1ItemStack == null) {
            return null;
        }
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY - (double)0.3f + (double)this.getEyeHeight(), this.posZ, par1ItemStack);
        entityitem.delayBeforeCanPickup = 40;
        float f = 0.1f;
        if (par2) {
            float f2 = this.rand.nextFloat() * 0.5f;
            float f4 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.motionX = -MathHelper.sin(f4) * f2;
            entityitem.motionZ = MathHelper.cos(f4) * f2;
            entityitem.motionY = 0.2f;
        } else {
            float f1 = 0.3f;
            entityitem.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI) * f1;
            entityitem.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI) * f1;
            entityitem.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * (float)Math.PI) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.motionX += Math.cos(f3) * (double)(f1 *= this.rand.nextFloat());
            entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f3) * (double)f1;
        }
        this.joinEntityItemWithWorld(entityitem);
        this.addStat(StatList.dropStat, 1);
        return entityitem;
    }

    protected void joinEntityItemWithWorld(EntityItem par1EntityItem) {
        this.worldObj.spawnEntityInWorld(par1EntityItem);
    }

    public float getCurrentPlayerStrVsBlock(Block par1Block) {
        float f;
        float f1 = f = this.inventory.getStrVsBlock(par1Block);
        int i = EnchantmentHelper.getEfficiencyModifier(this.inventory);
        if (i > 0 && this.inventory.canHarvestBlock(par1Block)) {
            f1 += (float)(i * i + 1);
        }
        if (this.isPotionActive(Potion.digSpeed)) {
            f1 *= 1.0f + (float)(this.getActivePotionEffect(Potion.digSpeed).getAmplifier() + 1) * 0.2f;
        }
        if (this.isPotionActive(Potion.digSlowdown)) {
            f1 *= 1.0f - (float)(this.getActivePotionEffect(Potion.digSlowdown).getAmplifier() + 1) * 0.2f;
        }
        if (this.isInsideOfMaterial(Material.water) && !EnchantmentHelper.getAquaAffinityModifier(this.inventory)) {
            f1 /= 5.0f;
        }
        if (!this.onGround) {
            f1 /= 5.0f;
        }
        return f1;
    }

    public boolean canHarvestBlock(Block par1Block) {
        return this.inventory.canHarvestBlock(par1Block);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
        this.dimension = par1NBTTagCompound.getInteger("Dimension");
        this.sleeping = par1NBTTagCompound.getBoolean("Sleeping");
        this.sleepTimer = par1NBTTagCompound.getShort("SleepTimer");
        this.experience = par1NBTTagCompound.getFloat("XpP");
        this.experienceLevel = par1NBTTagCompound.getInteger("XpLevel");
        this.experienceTotal = par1NBTTagCompound.getInteger("XpTotal");
        if (this.sleeping) {
            this.playerLocation = new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
            this.wakeUpPlayer(true, true, false);
        }
        if (par1NBTTagCompound.hasKey("SpawnX") && par1NBTTagCompound.hasKey("SpawnY") && par1NBTTagCompound.hasKey("SpawnZ")) {
            this.spawnChunk = new ChunkCoordinates(par1NBTTagCompound.getInteger("SpawnX"), par1NBTTagCompound.getInteger("SpawnY"), par1NBTTagCompound.getInteger("SpawnZ"));
        }
        this.foodStats.readNBT(par1NBTTagCompound);
        this.capabilities.readCapabilitiesFromNBT(par1NBTTagCompound);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setTag("Inventory", this.inventory.writeToNBT(new NBTTagList()));
        par1NBTTagCompound.setInteger("Dimension", this.dimension);
        par1NBTTagCompound.setBoolean("Sleeping", this.sleeping);
        par1NBTTagCompound.setShort("SleepTimer", (short)this.sleepTimer);
        par1NBTTagCompound.setFloat("XpP", this.experience);
        par1NBTTagCompound.setInteger("XpLevel", this.experienceLevel);
        par1NBTTagCompound.setInteger("XpTotal", this.experienceTotal);
        if (this.spawnChunk != null) {
            par1NBTTagCompound.setInteger("SpawnX", this.spawnChunk.posX);
            par1NBTTagCompound.setInteger("SpawnY", this.spawnChunk.posY);
            par1NBTTagCompound.setInteger("SpawnZ", this.spawnChunk.posZ);
        }
        this.foodStats.writeNBT(par1NBTTagCompound);
        this.capabilities.writeCapabilitiesToNBT(par1NBTTagCompound);
    }

    public void displayGUIChest(IInventory iinventory) {
    }

    public void displayGUIEnchantment(int i, int j, int k) {
    }

    public void displayWorkbenchGUI(int i, int j, int k) {
    }

    public void onItemPickup(Entity entity, int i) {
    }

    @Override
    public float getEyeHeight() {
        return 0.12f;
    }

    protected void resetHeight() {
        this.yOffset = 1.62f;
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        Entity entity;
        if (this.capabilities.disableDamage && !par1DamageSource.canHarmInCreative()) {
            return false;
        }
        this.entityAge = 0;
        if (this.getHealth() <= 0) {
            return false;
        }
        if (this.isPlayerSleeping() && !this.worldObj.isRemote) {
            this.wakeUpPlayer(true, true, false);
        }
        if ((entity = par1DamageSource.getEntity()) instanceof EntityMob || entity instanceof EntityArrow) {
            if (this.worldObj.difficultySetting == 0) {
                par2 = 0;
            }
            if (this.worldObj.difficultySetting == 1) {
                par2 = par2 / 2 + 1;
            }
            if (this.worldObj.difficultySetting == 3) {
                par2 = par2 * 3 / 2;
            }
        }
        if (par2 == 0) {
            return false;
        }
        Entity entity1 = entity;
        if (entity1 instanceof EntityArrow && ((EntityArrow)entity1).shootingEntity != null) {
            entity1 = ((EntityArrow)entity1).shootingEntity;
        }
        if (entity1 instanceof EntityLiving) {
            this.alertWolves((EntityLiving)entity1, false);
        }
        this.addStat(StatList.damageTakenStat, par2);
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @Override
    protected int applyPotionDamageCalculations(DamageSource par1DamageSource, int par2) {
        int i = super.applyPotionDamageCalculations(par1DamageSource, par2);
        if (i <= 0) {
            return 0;
        }
        int j = EnchantmentHelper.getEnchantmentModifierDamage(this.inventory, par1DamageSource);
        if (j > 20) {
            j = 20;
        }
        if (j > 0 && j <= 20) {
            int k = 25 - j;
            int l = i * k + this.carryoverDamage;
            i = l / 25;
            this.carryoverDamage = l % 25;
        }
        return i;
    }

    protected boolean isPVPEnabled() {
        return false;
    }

    protected void alertWolves(EntityLiving par1EntityLiving, boolean par2) {
        EntityWolf entitywolf;
        if (par1EntityLiving instanceof EntityCreeper || par1EntityLiving instanceof EntityGhast) {
            return;
        }
        if (par1EntityLiving instanceof EntityWolf && (entitywolf = (EntityWolf)par1EntityLiving).isTamed() && this.username.equals(entitywolf.getOwnerName())) {
            return;
        }
        if (par1EntityLiving instanceof EntityPlayer && !this.isPVPEnabled()) {
            return;
        }
        List list = this.worldObj.getEntitiesWithinAABB(EntityWolf.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0));
        for (Entity entity : list) {
            EntityWolf entitywolf1 = (EntityWolf)entity;
            if (!entitywolf1.isTamed() || entitywolf1.getEntityToAttack() != null || !this.username.equals(entitywolf1.getOwnerName()) || par2 && entitywolf1.isSitting()) continue;
            entitywolf1.setSitting(false);
            entitywolf1.setTarget(par1EntityLiving);
        }
    }

    @Override
    protected void damageArmor(int par1) {
        this.inventory.damageArmor(par1);
    }

    @Override
    public int getTotalArmorValue() {
        return this.inventory.getTotalArmorValue();
    }

    @Override
    protected void damageEntity(DamageSource par1DamageSource, int par2) {
        if (!par1DamageSource.isUnblockable() && this.isBlocking()) {
            par2 = 1 + par2 >> 1;
        }
        par2 = this.applyArmorCalculations(par1DamageSource, par2);
        par2 = this.applyPotionDamageCalculations(par1DamageSource, par2);
        this.addExhaustion(par1DamageSource.getHungerDamage());
        this.health -= par2;
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
    }

    public void displayGUIDispenser(TileEntityDispenser tileentitydispenser) {
    }

    public void displayGUIEditSign(TileEntitySign tileentitysign) {
    }

    public void displayGUIBrewingStand(TileEntityBrewingStand tileentitybrewingstand) {
    }

    public void useCurrentItemOnEntity(Entity par1Entity) {
        if (par1Entity.interact(this)) {
            return;
        }
        ItemStack itemstack = this.getCurrentEquippedItem();
        if (itemstack != null && par1Entity instanceof EntityLiving) {
            itemstack.useItemOnEntity((EntityLiving)par1Entity);
            if (itemstack.stackSize <= 0) {
                itemstack.onItemDestroyedByUse(this);
                this.destroyCurrentEquippedItem();
            }
        }
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    @Override
    public double getYOffset() {
        return this.yOffset - 0.5f;
    }

    public void swingItem() {
        if (!this.isSwinging || this.swingProgressInt >= this.getSwingSpeedModifier() / 2 || this.swingProgressInt < 0) {
            this.swingProgressInt = -1;
            this.isSwinging = true;
        }
    }

    public void attackTargetEntityWithCurrentItem(Entity par1Entity) {
        if (!par1Entity.canAttackWithItem()) {
            return;
        }
        int i = this.inventory.getDamageVsEntity(par1Entity);
        if (this.isPotionActive(Potion.damageBoost)) {
            i += 3 << this.getActivePotionEffect(Potion.damageBoost).getAmplifier();
        }
        if (this.isPotionActive(Potion.weakness)) {
            i -= 2 << this.getActivePotionEffect(Potion.weakness).getAmplifier();
        }
        int j = 0;
        int k = 0;
        if (par1Entity instanceof EntityLiving) {
            k = EnchantmentHelper.getEnchantmentModifierLiving(this.inventory, (EntityLiving)par1Entity);
            j += EnchantmentHelper.getKnockbackModifier(this.inventory, (EntityLiving)par1Entity);
        }
        if (this.isSprinting()) {
            ++j;
        }
        if (i > 0 || k > 0) {
            ItemStack itemstack;
            boolean flag1;
            boolean flag;
            boolean bl = flag = this.fallDistance > 0.0f && !this.onGround && !this.isOnLadder() && !this.isInWater() && !this.isPotionActive(Potion.blindness) && this.ridingEntity == null && par1Entity instanceof EntityLiving;
            if (flag) {
                i += this.rand.nextInt(i / 2 + 2);
            }
            if (flag1 = par1Entity.attackEntityFrom(DamageSource.causePlayerDamage(this), i += k)) {
                if (j > 0) {
                    par1Entity.addVelocity(-MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0f) * (float)j * 0.5f, 0.1, MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0f) * (float)j * 0.5f);
                    this.motionX *= 0.6;
                    this.motionZ *= 0.6;
                    this.setSprinting(false);
                }
                if (flag) {
                    this.onCriticalHit(par1Entity);
                }
                if (k > 0) {
                    this.onEnchantmentCritical(par1Entity);
                }
                if (i >= 18) {
                    this.triggerAchievement(AchievementList.overkill);
                }
                this.setLastAttackingEntity(par1Entity);
            }
            if ((itemstack = this.getCurrentEquippedItem()) != null && par1Entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)par1Entity, this);
                if (itemstack.stackSize <= 0) {
                    itemstack.onItemDestroyedByUse(this);
                    this.destroyCurrentEquippedItem();
                }
            }
            if (par1Entity instanceof EntityLiving) {
                if (par1Entity.isEntityAlive()) {
                    this.alertWolves((EntityLiving)par1Entity, true);
                }
                this.addStat(StatList.damageDealtStat, i);
                int l = EnchantmentHelper.getFireAspectModifier(this.inventory, (EntityLiving)par1Entity);
                if (l > 0) {
                    par1Entity.setFire(l * 4);
                }
            }
            this.addExhaustion(0.3f);
        }
    }

    public void onCriticalHit(Entity entity) {
    }

    public void onEnchantmentCritical(Entity entity) {
    }

    public void respawnPlayer() {
    }

    public abstract void func_6420_o();

    public void onItemStackChanged(ItemStack itemstack) {
    }

    @Override
    public void setDead() {
        super.setDead();
        this.inventorySlots.onCraftGuiClosed(this);
        if (this.craftingInventory != null) {
            this.craftingInventory.onCraftGuiClosed(this);
        }
    }

    @Override
    public boolean isEntityInsideOpaqueBlock() {
        return !this.sleeping && super.isEntityInsideOpaqueBlock();
    }

    public EnumStatus sleepInBedAt(int par1, int par2, int par3) {
        if (!this.worldObj.isRemote) {
            if (this.isPlayerSleeping() || !this.isEntityAlive()) {
                return EnumStatus.OTHER_PROBLEM;
            }
            if (!this.worldObj.worldProvider.func_48217_e()) {
                return EnumStatus.NOT_POSSIBLE_HERE;
            }
            if (this.worldObj.isDaytime()) {
                return EnumStatus.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.posX - (double)par1) > 3.0 || Math.abs(this.posY - (double)par2) > 2.0 || Math.abs(this.posZ - (double)par3) > 3.0) {
                return EnumStatus.TOO_FAR_AWAY;
            }
            double d = 8.0;
            double d1 = 5.0;
            List list = this.worldObj.getEntitiesWithinAABB(EntityMob.class, AxisAlignedBB.getBoundingBoxFromPool((double)par1 - d, (double)par2 - d1, (double)par3 - d, (double)par1 + d, (double)par2 + d1, (double)par3 + d));
            if (!list.isEmpty()) {
                return EnumStatus.NOT_SAFE;
            }
        }
        this.setSize(0.2f, 0.2f);
        this.yOffset = 0.2f;
        if (this.worldObj.blockExists(par1, par2, par3)) {
            int i = this.worldObj.getBlockMetadata(par1, par2, par3);
            int j = BlockBed.getDirection(i);
            float f = 0.5f;
            float f1 = 0.5f;
            switch (j) {
                case 0: {
                    f1 = 0.9f;
                    break;
                }
                case 2: {
                    f1 = 0.1f;
                    break;
                }
                case 1: {
                    f = 0.1f;
                    break;
                }
                case 3: {
                    f = 0.9f;
                }
            }
            this.func_22052_e(j);
            this.setPosition((float)par1 + f, (float)par2 + 0.9375f, (float)par3 + f1);
        } else {
            this.setPosition((float)par1 + 0.5f, (float)par2 + 0.9375f, (float)par3 + 0.5f);
        }
        this.sleeping = true;
        this.sleepTimer = 0;
        this.playerLocation = new ChunkCoordinates(par1, par2, par3);
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.motionX = 0.0;
        if (!this.worldObj.isRemote) {
            this.worldObj.updateAllPlayersSleepingFlag();
        }
        return EnumStatus.OK;
    }

    private void func_22052_e(int par1) {
        this.field_22063_x = 0.0f;
        this.field_22061_z = 0.0f;
        switch (par1) {
            case 0: {
                this.field_22061_z = -1.8f;
                break;
            }
            case 2: {
                this.field_22061_z = 1.8f;
                break;
            }
            case 1: {
                this.field_22063_x = 1.8f;
                break;
            }
            case 3: {
                this.field_22063_x = -1.8f;
            }
        }
    }

    public void wakeUpPlayer(boolean par1, boolean par2, boolean par3) {
        this.setSize(0.6f, 1.8f);
        this.resetHeight();
        ChunkCoordinates chunkcoordinates = this.playerLocation;
        ChunkCoordinates chunkcoordinates1 = this.playerLocation;
        if (chunkcoordinates != null && this.worldObj.getBlockId(chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ) == Block.bed.blockID) {
            BlockBed.setBedOccupied(this.worldObj, chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ, false);
            ChunkCoordinates chunkcoordinates2 = BlockBed.getNearestEmptyChunkCoordinates(this.worldObj, chunkcoordinates.posX, chunkcoordinates.posY, chunkcoordinates.posZ, 0);
            if (chunkcoordinates2 == null) {
                chunkcoordinates2 = new ChunkCoordinates(chunkcoordinates.posX, chunkcoordinates.posY + 1, chunkcoordinates.posZ);
            }
            this.setPosition((float)chunkcoordinates2.posX + 0.5f, (float)chunkcoordinates2.posY + this.yOffset + 0.1f, (float)chunkcoordinates2.posZ + 0.5f);
        }
        this.sleeping = false;
        if (!this.worldObj.isRemote && par2) {
            this.worldObj.updateAllPlayersSleepingFlag();
        }
        this.sleepTimer = par1 ? 0 : 100;
        if (par3) {
            this.setSpawnChunk(this.playerLocation);
        }
    }

    private boolean isInBed() {
        return this.worldObj.getBlockId(this.playerLocation.posX, this.playerLocation.posY, this.playerLocation.posZ) == Block.bed.blockID;
    }

    public static ChunkCoordinates verifyRespawnCoordinates(World par0World, ChunkCoordinates par1ChunkCoordinates) {
        IChunkProvider ichunkprovider = par0World.getChunkProvider();
        ichunkprovider.loadChunk(par1ChunkCoordinates.posX - 3 >> 4, par1ChunkCoordinates.posZ - 3 >> 4);
        ichunkprovider.loadChunk(par1ChunkCoordinates.posX + 3 >> 4, par1ChunkCoordinates.posZ - 3 >> 4);
        ichunkprovider.loadChunk(par1ChunkCoordinates.posX - 3 >> 4, par1ChunkCoordinates.posZ + 3 >> 4);
        ichunkprovider.loadChunk(par1ChunkCoordinates.posX + 3 >> 4, par1ChunkCoordinates.posZ + 3 >> 4);
        if (par0World.getBlockId(par1ChunkCoordinates.posX, par1ChunkCoordinates.posY, par1ChunkCoordinates.posZ) != Block.bed.blockID) {
            return null;
        }
        ChunkCoordinates chunkcoordinates = BlockBed.getNearestEmptyChunkCoordinates(par0World, par1ChunkCoordinates.posX, par1ChunkCoordinates.posY, par1ChunkCoordinates.posZ, 0);
        return chunkcoordinates;
    }

    public float getBedOrientationInDegrees() {
        if (this.playerLocation != null) {
            int i = this.worldObj.getBlockMetadata(this.playerLocation.posX, this.playerLocation.posY, this.playerLocation.posZ);
            int j = BlockBed.getDirection(i);
            switch (j) {
                case 0: {
                    return 90.0f;
                }
                case 1: {
                    return 0.0f;
                }
                case 2: {
                    return 270.0f;
                }
                case 3: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isPlayerSleeping() {
        return this.sleeping;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleeping && this.sleepTimer >= 100;
    }

    public int getSleepTimer() {
        return this.sleepTimer;
    }

    public void addChatMessage(String s) {
    }

    public ChunkCoordinates getSpawnChunk() {
        return this.spawnChunk;
    }

    public void setSpawnChunk(ChunkCoordinates par1ChunkCoordinates) {
        this.spawnChunk = par1ChunkCoordinates != null ? new ChunkCoordinates(par1ChunkCoordinates) : null;
    }

    public void triggerAchievement(StatBase par1StatBase) {
        this.addStat(par1StatBase, 1);
    }

    public void addStat(StatBase statbase, int i) {
    }

    @Override
    protected void jump() {
        super.jump();
        this.addStat(StatList.jumpStat, 1);
        if (this.isSprinting()) {
            this.addExhaustion(0.8f);
        } else {
            this.addExhaustion(0.2f);
        }
    }

    @Override
    public void moveEntityWithHeading(float par1, float par2) {
        double d = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        if (this.capabilities.isFlying) {
            double d3 = this.motionY;
            float f = this.jumpMovementFactor;
            this.jumpMovementFactor = 0.05f;
            super.moveEntityWithHeading(par1, par2);
            this.motionY = d3 * 0.6;
            this.jumpMovementFactor = f;
        } else {
            super.moveEntityWithHeading(par1, par2);
        }
        this.addMovementStat(this.posX - d, this.posY - d1, this.posZ - d2);
    }

    public void addMovementStat(double par1, double par3, double par5) {
        if (this.ridingEntity != null) {
            return;
        }
        if (this.isInsideOfMaterial(Material.water)) {
            int i = Math.round(MathHelper.sqrt_double(par1 * par1 + par3 * par3 + par5 * par5) * 100.0f);
            if (i > 0) {
                this.addStat(StatList.distanceDoveStat, i);
                this.addExhaustion(0.015f * (float)i * 0.01f);
            }
        } else if (this.isInWater()) {
            int j = Math.round(MathHelper.sqrt_double(par1 * par1 + par5 * par5) * 100.0f);
            if (j > 0) {
                this.addStat(StatList.distanceSwumStat, j);
                this.addExhaustion(0.015f * (float)j * 0.01f);
            }
        } else if (this.isOnLadder()) {
            if (par3 > 0.0) {
                this.addStat(StatList.distanceClimbedStat, (int)Math.round(par3 * 100.0));
            }
        } else if (this.onGround) {
            int k = Math.round(MathHelper.sqrt_double(par1 * par1 + par5 * par5) * 100.0f);
            if (k > 0) {
                this.addStat(StatList.distanceWalkedStat, k);
                if (this.isSprinting()) {
                    this.addExhaustion(0.09999999f * (float)k * 0.01f);
                } else {
                    this.addExhaustion(0.01f * (float)k * 0.01f);
                }
            }
        } else {
            int l = Math.round(MathHelper.sqrt_double(par1 * par1 + par5 * par5) * 100.0f);
            if (l > 25) {
                this.addStat(StatList.distanceFlownStat, l);
            }
        }
    }

    private void addMountedMovementStat(double par1, double par3, double par5) {
        int i;
        if (this.ridingEntity != null && (i = Math.round(MathHelper.sqrt_double(par1 * par1 + par3 * par3 + par5 * par5) * 100.0f)) > 0) {
            if (this.ridingEntity instanceof EntityMinecart) {
                this.addStat(StatList.distanceByMinecartStat, i);
                if (this.startMinecartRidingCoordinate == null) {
                    this.startMinecartRidingCoordinate = new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
                } else if (this.startMinecartRidingCoordinate.getEuclideanDistanceTo(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) >= 1000.0) {
                    this.addStat(AchievementList.onARail, 1);
                }
            } else if (this.ridingEntity instanceof EntityBoat) {
                this.addStat(StatList.distanceByBoatStat, i);
            } else if (this.ridingEntity instanceof EntityPig) {
                this.addStat(StatList.distanceByPigStat, i);
            }
        }
    }

    @Override
    protected void fall(float par1) {
        if (this.capabilities.allowFlying) {
            return;
        }
        if (par1 >= 2.0f) {
            this.addStat(StatList.distanceFallenStat, (int)Math.round((double)par1 * 100.0));
        }
        super.fall(par1);
    }

    @Override
    public void onKillEntity(EntityLiving par1EntityLiving) {
        if (par1EntityLiving instanceof EntityMob) {
            this.triggerAchievement(AchievementList.killEnemy);
        }
    }

    @Override
    public int getItemIcon(ItemStack par1ItemStack, int par2) {
        int i = super.getItemIcon(par1ItemStack, par2);
        if (par1ItemStack.itemID == Item.fishingRod.shiftedIndex && this.fishEntity != null) {
            i = par1ItemStack.getIconIndex() + 16;
        } else {
            if (par1ItemStack.getItem().func_46058_c()) {
                return par1ItemStack.getItem().func_46057_a(par1ItemStack.getItemDamage(), par2);
            }
            if (this.itemInUse != null && par1ItemStack.itemID == Item.bow.shiftedIndex) {
                int j = par1ItemStack.getMaxItemUseDuration() - this.itemInUseCount;
                if (j >= 18) {
                    return 133;
                }
                if (j > 13) {
                    return 117;
                }
                if (j > 0) {
                    return 101;
                }
            }
        }
        return i;
    }

    @Override
    public void setInPortal() {
        if (this.timeUntilPortal > 0) {
            this.timeUntilPortal = 10;
            return;
        }
        this.inPortal = true;
    }

    public void addExperience(int par1) {
        this.score += par1;
        int i = Integer.MAX_VALUE - this.experienceTotal;
        if (par1 > i) {
            par1 = i;
        }
        this.experience += (float)par1 / (float)this.xpBarCap();
        this.experienceTotal += par1;
        while (this.experience >= 1.0f) {
            this.experience = (this.experience - 1.0f) * (float)this.xpBarCap();
            this.increaseLevel();
            this.experience /= (float)this.xpBarCap();
        }
    }

    public void removeExperience(int par1) {
        this.experienceLevel -= par1;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
        }
    }

    public int xpBarCap() {
        return 7 + (this.experienceLevel * 7 >> 1);
    }

    private void increaseLevel() {
        ++this.experienceLevel;
    }

    public void addExhaustion(float par1) {
        if (this.capabilities.disableDamage) {
            return;
        }
        if (!this.worldObj.isRemote) {
            this.foodStats.addExhaustion(par1);
        }
    }

    public FoodStats getFoodStats() {
        return this.foodStats;
    }

    public boolean canEat(boolean par1) {
        return (par1 || this.foodStats.needFood()) && !this.capabilities.disableDamage;
    }

    public boolean shouldHeal() {
        return this.getHealth() > 0 && this.getHealth() < this.getMaxHealth();
    }

    public void setItemInUse(ItemStack par1ItemStack, int par2) {
        if (par1ItemStack == this.itemInUse) {
            return;
        }
        this.itemInUse = par1ItemStack;
        this.itemInUseCount = par2;
        if (!this.worldObj.isRemote) {
            this.setEating(true);
        }
    }

    public boolean canPlayerEdit(int par1, int par2, int par3) {
        return true;
    }

    @Override
    protected int getExperiencePoints(EntityPlayer par1EntityPlayer) {
        int i = this.experienceLevel * 7;
        if (i > 100) {
            return 100;
        }
        return i;
    }

    @Override
    protected boolean isPlayer() {
        return true;
    }

    public void travelToTheEnd(int i) {
    }

    public void copyPlayer(EntityPlayer par1EntityPlayer) {
        this.inventory.copyInventory(par1EntityPlayer.inventory);
        this.health = par1EntityPlayer.health;
        this.foodStats = par1EntityPlayer.foodStats;
        this.experienceLevel = par1EntityPlayer.experienceLevel;
        this.experienceTotal = par1EntityPlayer.experienceTotal;
        this.experience = par1EntityPlayer.experience;
        this.score = par1EntityPlayer.score;
    }

    @Override
    protected boolean canTriggerWalking() {
        return !this.capabilities.isFlying;
    }

    public void func_50009_aI() {
    }
}

