/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAIAvoidEntity;
import net.minecraft.src.EntityAIFollowOwner;
import net.minecraft.src.EntityAILeapAtTarget;
import net.minecraft.src.EntityAIMate;
import net.minecraft.src.EntityAIOcelotAttack;
import net.minecraft.src.EntityAIOcelotSit;
import net.minecraft.src.EntityAISwimming;
import net.minecraft.src.EntityAITargetNonTamed;
import net.minecraft.src.EntityAITempt;
import net.minecraft.src.EntityAIWander;
import net.minecraft.src.EntityAIWatchClosest;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityTameable;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityOcelot
extends EntityTameable {
    private EntityAITempt aiTempt;

    public EntityOcelot(World par1World) {
        super(par1World);
        this.texture = "/mob/ozelot.png";
        this.setSize(0.6f, 0.8f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, new EntityAISwimming(this));
        this.tasks.addTask(2, this.aiSit);
        this.aiTempt = new EntityAITempt(this, 0.18f, Item.fishRaw.shiftedIndex, true);
        this.tasks.addTask(3, this.aiTempt);
        this.tasks.addTask(4, new EntityAIAvoidEntity(this, EntityPlayer.class, 16.0f, 0.23f, 0.4f));
        this.tasks.addTask(5, new EntityAIFollowOwner(this, 0.3f, 10.0f, 5.0f));
        this.tasks.addTask(6, new EntityAIOcelotSit(this, 0.4f));
        this.tasks.addTask(7, new EntityAILeapAtTarget(this, 0.3f));
        this.tasks.addTask(8, new EntityAIOcelotAttack(this));
        this.tasks.addTask(9, new EntityAIMate(this, 0.23f));
        this.tasks.addTask(10, new EntityAIWander(this, 0.23f));
        this.tasks.addTask(11, new EntityAIWatchClosest(this, EntityPlayer.class, 10.0f));
        this.targetTasks.addTask(1, new EntityAITargetNonTamed(this, EntityChicken.class, 14.0f, 750, false));
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (byte)0);
    }

    @Override
    public void updateAITick() {
        if (!this.getMoveHelper().func_48186_a()) {
            this.setSneaking(false);
            this.setSprinting(false);
        } else {
            float f = this.getMoveHelper().getSpeed();
            if (f == 0.18f) {
                this.setSneaking(true);
                this.setSprinting(false);
            } else if (f == 0.4f) {
                this.setSneaking(false);
                this.setSprinting(true);
            } else {
                this.setSneaking(false);
                this.setSprinting(false);
            }
        }
    }

    @Override
    protected boolean canDespawn() {
        return !this.isTamed();
    }

    @Override
    public String getTexture() {
        switch (this.func_48148_ad()) {
            case 0: {
                return "/mob/ozelot.png";
            }
            case 1: {
                return "/mob/cat_black.png";
            }
            case 2: {
                return "/mob/cat_red.png";
            }
            case 3: {
                return "/mob/cat_siamese.png";
            }
        }
        return super.getTexture();
    }

    @Override
    public boolean isAIEnabled() {
        return true;
    }

    @Override
    public int getMaxHealth() {
        return 10;
    }

    @Override
    protected void fall(float f) {
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("CatType", this.func_48148_ad());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.func_48147_c(par1NBTTagCompound.getInteger("CatType"));
    }

    @Override
    protected String getLivingSound() {
        if (this.isTamed()) {
            if (this.isInLove()) {
                return "mob.cat.purr";
            }
            if (this.rand.nextInt(4) == 0) {
                return "mob.cat.purreow";
            }
            return "mob.cat.meow";
        }
        return "";
    }

    @Override
    protected String getHurtSound() {
        return "mob.cat.hitt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.cat.hitt";
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected int getDropItemId() {
        return Item.leather.shiftedIndex;
    }

    @Override
    public boolean attackEntityAsMob(Entity par1Entity) {
        return par1Entity.attackEntityFrom(DamageSource.causeMobDamage(this), 3);
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        this.aiSit.func_48407_a(false);
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    @Override
    protected void dropFewItems(boolean flag, int i) {
    }

    @Override
    public boolean interact(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.inventory.getCurrentItem();
        if (!this.isTamed()) {
            if (this.aiTempt.func_48270_h() && itemstack != null && itemstack.itemID == Item.fishRaw.shiftedIndex && par1EntityPlayer.getDistanceSqToEntity(this) < 9.0) {
                --itemstack.stackSize;
                if (itemstack.stackSize <= 0) {
                    par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, null);
                }
                if (!this.worldObj.isRemote) {
                    if (this.rand.nextInt(3) == 0) {
                        this.setTamed(true);
                        this.func_48147_c(1 + this.worldObj.rand.nextInt(3));
                        this.setOwner(par1EntityPlayer.username);
                        this.func_48142_a(true);
                        this.aiSit.func_48407_a(true);
                        this.worldObj.setEntityState(this, (byte)7);
                    } else {
                        this.func_48142_a(false);
                        this.worldObj.setEntityState(this, (byte)6);
                    }
                }
            }
            return true;
        }
        if (par1EntityPlayer.username.equalsIgnoreCase(this.getOwnerName()) && !this.worldObj.isRemote && !this.isWheat(itemstack)) {
            this.aiSit.func_48407_a(!this.isSitting());
        }
        return super.interact(par1EntityPlayer);
    }

    @Override
    public EntityAnimal spawnBabyAnimal(EntityAnimal par1EntityAnimal) {
        EntityOcelot entityocelot = new EntityOcelot(this.worldObj);
        if (this.isTamed()) {
            entityocelot.setOwner(this.getOwnerName());
            entityocelot.setTamed(true);
            entityocelot.func_48147_c(this.func_48148_ad());
        }
        return entityocelot;
    }

    @Override
    public boolean isWheat(ItemStack par1ItemStack) {
        return par1ItemStack != null && par1ItemStack.itemID == Item.fishRaw.shiftedIndex;
    }

    @Override
    public boolean func_48135_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntityOcelot)) {
            return false;
        }
        EntityOcelot entityocelot = (EntityOcelot)par1EntityAnimal;
        if (!entityocelot.isTamed()) {
            return false;
        }
        return this.isInLove() && entityocelot.isInLove();
    }

    public int func_48148_ad() {
        return this.dataWatcher.getWatchableObjectByte(18);
    }

    public void func_48147_c(int par1) {
        this.dataWatcher.updateObject(18, (byte)par1);
    }

    @Override
    public boolean getCanSpawnHere() {
        if (this.worldObj.rand.nextInt(3) == 0) {
            return false;
        }
        if (this.worldObj.checkIfAABBIsClear(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.isAnyLiquid(this.boundingBox)) {
            int i = MathHelper.floor_double(this.posX);
            int j = MathHelper.floor_double(this.boundingBox.minY);
            int k = MathHelper.floor_double(this.posZ);
            if (j < 63) {
                return false;
            }
            int l = this.worldObj.getBlockId(i, j - 1, k);
            if (l == Block.grass.blockID || l == Block.leaves.blockID) {
                return true;
            }
        }
        return false;
    }
}

