/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntitySlime;
import net.minecraft.src.Item;
import net.minecraft.src.World;

public class EntityMagmaCube
extends EntitySlime {
    public EntityMagmaCube(World par1World) {
        super(par1World);
        this.texture = "/mob/lava.png";
        this.isImmuneToFire = true;
        this.landMovementFactor = 0.2f;
    }

    @Override
    public boolean getCanSpawnHere() {
        return this.worldObj.difficultySetting > 0 && this.worldObj.checkIfAABBIsClear(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.isAnyLiquid(this.boundingBox);
    }

    @Override
    public int getTotalArmorValue() {
        return this.getSlimeSize() * 3;
    }

    @Override
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    @Override
    public float getBrightness(float par1) {
        return 1.0f;
    }

    @Override
    protected String getSlimeParticle() {
        return "flame";
    }

    @Override
    protected EntitySlime createInstance() {
        return new EntityMagmaCube(this.worldObj);
    }

    @Override
    protected int getDropItemId() {
        return Item.magmaCream.shiftedIndex;
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        int i = this.getDropItemId();
        if (i > 0 && this.getSlimeSize() > 1) {
            int j = this.rand.nextInt(4) - 2;
            if (par2 > 0) {
                j += this.rand.nextInt(par2 + 1);
            }
            for (int k = 0; k < j; ++k) {
                this.dropItem(i, 1);
            }
        }
    }

    @Override
    public boolean isBurning() {
        return false;
    }

    @Override
    protected int func_40131_af() {
        return super.func_40131_af() * 4;
    }

    @Override
    protected void func_40136_ag() {
        this.field_40139_a *= 0.9f;
    }

    @Override
    protected void jump() {
        this.motionY = 0.42f + (float)this.getSlimeSize() * 0.1f;
        this.isAirBorne = true;
    }

    @Override
    protected void fall(float f) {
    }

    @Override
    protected boolean func_40137_ah() {
        return true;
    }

    @Override
    protected int func_40130_ai() {
        return super.func_40130_ai() + 2;
    }

    @Override
    protected String getHurtSound() {
        return "mob.slime";
    }

    @Override
    protected String getDeathSound() {
        return "mob.slime";
    }

    @Override
    protected String func_40138_aj() {
        if (this.getSlimeSize() > 1) {
            return "mob.magmacube.big";
        }
        return "mob.magmacube.small";
    }

    @Override
    public boolean handleLavaMovement() {
        return false;
    }

    @Override
    protected boolean func_40134_ak() {
        return true;
    }
}

