/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.DamageSource;
import net.minecraft.src.EnchantmentHelper;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAITasks;
import net.minecraft.src.EntityBodyHelper;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityGhast;
import net.minecraft.src.EntityJumpHelper;
import net.minecraft.src.EntityLookHelper;
import net.minecraft.src.EntityMoveHelper;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySenses;
import net.minecraft.src.EntityWolf;
import net.minecraft.src.EntityXPOrb;
import net.minecraft.src.EnumCreatureAttribute;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.PathNavigate;
import net.minecraft.src.Potion;
import net.minecraft.src.PotionEffect;
import net.minecraft.src.PotionHelper;
import net.minecraft.src.Profiler;
import net.minecraft.src.StepSound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public abstract class EntityLiving
extends Entity {
    public int heartsHalvesLife = 20;
    public float field_9365_p;
    public float field_9363_r;
    public float renderYawOffset = 0.0f;
    public float prevRenderYawOffset = 0.0f;
    public float rotationYawHead = 0.0f;
    public float prevRotationYawHead = 0.0f;
    protected float field_9362_u;
    protected float field_9361_v;
    protected float field_9360_w;
    protected float field_9359_x;
    protected boolean field_9358_y = true;
    protected String texture = "/mob/char.png";
    protected boolean field_9355_A = true;
    protected float field_9353_B = 0.0f;
    protected String entityType = null;
    protected float field_9349_D = 1.0f;
    protected int scoreValue = 0;
    protected float field_9345_F = 0.0f;
    public float landMovementFactor = 0.1f;
    public float jumpMovementFactor = 0.02f;
    public float prevSwingProgress;
    public float swingProgress;
    protected int health;
    public int prevHealth;
    protected int carryoverDamage;
    private int livingSoundTime;
    public int hurtTime;
    public int maxHurtTime;
    public float attackedAtYaw = 0.0f;
    public int deathTime = 0;
    public int attackTime = 0;
    public float prevCameraPitch;
    public float cameraPitch;
    protected boolean dead = false;
    protected int experienceValue;
    public int field_9326_T = -1;
    public float field_9325_U = (float)(Math.random() * (double)0.9f + (double)0.1f);
    public float field_705_Q;
    public float field_704_R;
    public float field_703_S;
    protected EntityPlayer attackingPlayer = null;
    protected int recentlyHit = 0;
    private EntityLiving entityLivingToAttack = null;
    private int revengeTimer = 0;
    private EntityLiving lastAttackingEntity = null;
    public int arrowHitTempCounter = 0;
    public int arrowHitTimer = 0;
    protected HashMap activePotionsMap = new HashMap();
    private boolean potionsNeedUpdate = true;
    private int field_39002_c;
    private EntityLookHelper lookHelper;
    private EntityMoveHelper moveHelper;
    private EntityJumpHelper jumpHelper;
    private EntityBodyHelper bodyHelper;
    private PathNavigate navigator;
    protected EntityAITasks tasks = new EntityAITasks();
    protected EntityAITasks targetTasks = new EntityAITasks();
    private EntityLiving attackTarget;
    private EntitySenses senses;
    private float field_48111_au;
    private ChunkCoordinates homePosition = new ChunkCoordinates(0, 0, 0);
    private float maximumHomeDistance = -1.0f;
    protected int newPosRotationIncrements;
    protected double newPosX;
    protected double newPosY;
    protected double newPosZ;
    protected double newRotationYaw;
    protected double newRotationPitch;
    float field_9348_ae = 0.0f;
    protected int naturalArmorRating = 0;
    protected int entityAge = 0;
    protected float moveStrafing;
    protected float moveForward;
    protected float randomYawVelocity;
    protected boolean isJumping = false;
    protected float defaultPitch = 0.0f;
    protected float moveSpeed = 0.7f;
    private int jumpTicks = 0;
    private Entity currentTarget;
    protected int numTicksToChaseTarget = 0;

    public EntityLiving(World par1World) {
        super(par1World);
        this.health = this.getMaxHealth();
        this.preventEntitySpawning = true;
        this.lookHelper = new EntityLookHelper(this);
        this.moveHelper = new EntityMoveHelper(this);
        this.jumpHelper = new EntityJumpHelper(this);
        this.bodyHelper = new EntityBodyHelper(this);
        this.navigator = new PathNavigate(this, par1World, 16.0f);
        this.senses = new EntitySenses(this);
        this.field_9363_r = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.posX, this.posY, this.posZ);
        this.field_9365_p = (float)Math.random() * 12398.0f;
        this.rotationYawHead = this.rotationYaw = (float)(Math.random() * Math.PI * 2.0);
        this.stepHeight = 0.5f;
    }

    public EntityLookHelper getLookHelper() {
        return this.lookHelper;
    }

    public EntityMoveHelper getMoveHelper() {
        return this.moveHelper;
    }

    public EntityJumpHelper getJumpHelper() {
        return this.jumpHelper;
    }

    public PathNavigate getNavigator() {
        return this.navigator;
    }

    public EntitySenses getEntitySenses() {
        return this.senses;
    }

    public Random getRNG() {
        return this.rand;
    }

    public EntityLiving getAITarget() {
        return this.entityLivingToAttack;
    }

    public EntityLiving getLastAttackingEntity() {
        return this.lastAttackingEntity;
    }

    public void setLastAttackingEntity(Entity par1Entity) {
        if (par1Entity instanceof EntityLiving) {
            this.lastAttackingEntity = (EntityLiving)par1Entity;
        }
    }

    public int getAge() {
        return this.entityAge;
    }

    @Override
    public void func_48079_f(float par1) {
        this.rotationYawHead = par1;
    }

    public float func_48101_aR() {
        return this.field_48111_au;
    }

    public void func_48098_g(float par1) {
        this.field_48111_au = par1;
        this.setMoveForward(par1);
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.setLastAttackingEntity(par1Entity);
        return false;
    }

    public EntityLiving getAttackTarget() {
        return this.attackTarget;
    }

    public void setAttackTarget(EntityLiving par1EntityLiving) {
        this.attackTarget = par1EntityLiving;
    }

    public boolean func_48100_a(Class par1Class) {
        return EntityCreeper.class != par1Class && EntityGhast.class != par1Class;
    }

    public void eatGrassBonus() {
    }

    public boolean isWithinHomeDistanceCurrentPosition() {
        return this.isWithinHomeDistance(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
    }

    public boolean isWithinHomeDistance(int par1, int par2, int par3) {
        if (this.maximumHomeDistance == -1.0f) {
            return true;
        }
        return this.homePosition.getDistanceSquared(par1, par2, par3) < this.maximumHomeDistance * this.maximumHomeDistance;
    }

    public void setHomeArea(int par1, int par2, int par3, int par4) {
        this.homePosition.set(par1, par2, par3);
        this.maximumHomeDistance = par4;
    }

    public ChunkCoordinates getHomePosition() {
        return this.homePosition;
    }

    public float getMaximumHomeDistance() {
        return this.maximumHomeDistance;
    }

    public void detachHome() {
        this.maximumHomeDistance = -1.0f;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }

    public void setRevengeTarget(EntityLiving par1EntityLiving) {
        this.entityLivingToAttack = par1EntityLiving;
        this.revengeTimer = this.entityLivingToAttack == null ? 0 : 60;
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.addObject(8, this.field_39002_c);
    }

    public boolean canEntityBeSeen(Entity par1Entity) {
        return this.worldObj.rayTraceBlocks(Vec3D.createVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ), Vec3D.createVector(par1Entity.posX, par1Entity.posY + (double)par1Entity.getEyeHeight(), par1Entity.posZ)) == null;
    }

    @Override
    public String getTexture() {
        return this.texture;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public boolean canBePushed() {
        return !this.isDead;
    }

    @Override
    public float getEyeHeight() {
        return this.height * 0.85f;
    }

    public int getTalkInterval() {
        return 80;
    }

    public void playLivingSound() {
        String s = this.getLivingSound();
        if (s != null) {
            this.worldObj.playSoundAtEntity(this, s, this.getSoundVolume(), this.getSoundPitch());
        }
    }

    @Override
    public void onEntityUpdate() {
        this.prevSwingProgress = this.swingProgress;
        super.onEntityUpdate();
        Profiler.startSection("mobBaseTick");
        if (this.isEntityAlive() && this.rand.nextInt(1000) < this.livingSoundTime++) {
            this.livingSoundTime = -this.getTalkInterval();
            this.playLivingSound();
        }
        if (!(this.isEntityAlive() && this.isEntityInsideOpaqueBlock() && this.attackEntityFrom(DamageSource.inWall, 1))) {
            // empty if block
        }
        if (this.isImmuneToFire() || this.worldObj.isRemote) {
            this.extinguish();
        }
        if (this.isEntityAlive() && this.isInsideOfMaterial(Material.water) && !this.canBreatheUnderwater() && !this.activePotionsMap.containsKey(Potion.waterBreathing.id)) {
            this.setAir(this.decreaseAirSupply(this.getAir()));
            if (this.getAir() == -20) {
                this.setAir(0);
                for (int i = 0; i < 8; ++i) {
                    float f = this.rand.nextFloat() - this.rand.nextFloat();
                    float f1 = this.rand.nextFloat() - this.rand.nextFloat();
                    float f2 = this.rand.nextFloat() - this.rand.nextFloat();
                    this.worldObj.spawnParticle("bubble", this.posX + (double)f, this.posY + (double)f1, this.posZ + (double)f2, this.motionX, this.motionY, this.motionZ);
                }
                this.attackEntityFrom(DamageSource.drown, 2);
            }
            this.extinguish();
        } else {
            this.setAir(300);
        }
        this.prevCameraPitch = this.cameraPitch;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.heartsLife > 0) {
            --this.heartsLife;
        }
        if (this.health <= 0) {
            this.onDeathUpdate();
        }
        if (this.recentlyHit > 0) {
            --this.recentlyHit;
        } else {
            this.attackingPlayer = null;
        }
        if (this.lastAttackingEntity != null && !this.lastAttackingEntity.isEntityAlive()) {
            this.lastAttackingEntity = null;
        }
        if (this.entityLivingToAttack != null) {
            if (!this.entityLivingToAttack.isEntityAlive()) {
                this.setRevengeTarget(null);
            } else if (this.revengeTimer > 0) {
                --this.revengeTimer;
            } else {
                this.setRevengeTarget(null);
            }
        }
        this.updatePotionEffects();
        this.field_9359_x = this.field_9360_w;
        this.prevRenderYawOffset = this.renderYawOffset;
        this.prevRotationYawHead = this.rotationYawHead;
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
        Profiler.endSection();
    }

    protected void onDeathUpdate() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            if (!(this.worldObj.isRemote || this.recentlyHit <= 0 && !this.isPlayer() || this.isChild())) {
                int k;
                for (int i = this.getExperiencePoints(this.attackingPlayer); i > 0; i -= k) {
                    k = EntityXPOrb.getXPSplit(i);
                    this.worldObj.spawnEntityInWorld(new EntityXPOrb(this.worldObj, this.posX, this.posY, this.posZ, k));
                }
            }
            this.onEntityDeath();
            this.setDead();
            for (int j = 0; j < 20; ++j) {
                double d = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
            }
        }
    }

    protected int decreaseAirSupply(int par1) {
        return par1 - 1;
    }

    protected int getExperiencePoints(EntityPlayer par1EntityPlayer) {
        return this.experienceValue;
    }

    protected boolean isPlayer() {
        return false;
    }

    public void spawnExplosionParticle() {
        for (int i = 0; i < 20; ++i) {
            double d = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d * d3, this.posY + (double)(this.rand.nextFloat() * this.height) - d1 * d3, this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d2 * d3, d, d1, d2);
        }
    }

    @Override
    public void updateRidden() {
        super.updateRidden();
        this.field_9362_u = this.field_9361_v;
        this.field_9361_v = 0.0f;
        this.fallDistance = 0.0f;
    }

    @Override
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.yOffset = 0.0f;
        this.newPosX = par1;
        this.newPosY = par3;
        this.newPosZ = par5;
        this.newRotationYaw = par7;
        this.newRotationPitch = par8;
        this.newPosRotationIncrements = par9;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.arrowHitTempCounter > 0) {
            if (this.arrowHitTimer <= 0) {
                this.arrowHitTimer = 60;
            }
            --this.arrowHitTimer;
            if (this.arrowHitTimer <= 0) {
                --this.arrowHitTempCounter;
            }
        }
        this.onLivingUpdate();
        double d = this.posX - this.prevPosX;
        double d1 = this.posZ - this.prevPosZ;
        float f = MathHelper.sqrt_double(d * d + d1 * d1);
        float f1 = this.renderYawOffset;
        float f2 = 0.0f;
        this.field_9362_u = this.field_9361_v;
        float f3 = 0.0f;
        if (f > 0.05f) {
            f3 = 1.0f;
            f2 = f * 3.0f;
            f1 = (float)Math.atan2(d1, d) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.swingProgress > 0.0f) {
            f1 = this.rotationYaw;
        }
        if (!this.onGround) {
            f3 = 0.0f;
        }
        this.field_9361_v += (f3 - this.field_9361_v) * 0.3f;
        if (this.isAIEnabled()) {
            this.bodyHelper.func_48650_a();
        } else {
            boolean flag;
            float f5;
            float f4;
            for (f4 = f1 - this.renderYawOffset; f4 < -180.0f; f4 += 360.0f) {
            }
            while (f4 >= 180.0f) {
                f4 -= 360.0f;
            }
            this.renderYawOffset += f4 * 0.3f;
            for (f5 = this.rotationYaw - this.renderYawOffset; f5 < -180.0f; f5 += 360.0f) {
            }
            while (f5 >= 180.0f) {
                f5 -= 360.0f;
            }
            boolean bl = flag = f5 < -90.0f || f5 >= 90.0f;
            if (f5 < -75.0f) {
                f5 = -75.0f;
            }
            if (f5 >= 75.0f) {
                f5 = 75.0f;
            }
            this.renderYawOffset = this.rotationYaw - f5;
            if (f5 * f5 > 2500.0f) {
                this.renderYawOffset += f5 * 0.2f;
            }
            if (flag) {
                f2 *= -1.0f;
            }
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYawHead - this.prevRotationYawHead < -180.0f) {
            this.prevRotationYawHead -= 360.0f;
        }
        while (this.rotationYawHead - this.prevRotationYawHead >= 180.0f) {
            this.prevRotationYawHead += 360.0f;
        }
        this.field_9360_w += f2;
    }

    @Override
    protected void setSize(float par1, float par2) {
        super.setSize(par1, par2);
    }

    public void heal(int par1) {
        if (this.health <= 0) {
            return;
        }
        this.health += par1;
        if (this.health > this.getMaxHealth()) {
            this.health = this.getMaxHealth();
        }
        this.heartsLife = this.heartsHalvesLife / 2;
    }

    public abstract int getMaxHealth();

    public int getHealth() {
        return this.health;
    }

    public void setEntityHealth(int par1) {
        this.health = par1;
        if (par1 > this.getMaxHealth()) {
            par1 = this.getMaxHealth();
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (this.worldObj.isRemote) {
            return false;
        }
        this.entityAge = 0;
        if (this.health <= 0) {
            return false;
        }
        if (par1DamageSource.fireDamage() && this.isPotionActive(Potion.fireResistance)) {
            return false;
        }
        this.field_704_R = 1.5f;
        boolean flag = true;
        if ((float)this.heartsLife > (float)this.heartsHalvesLife / 2.0f) {
            if (par2 <= this.naturalArmorRating) {
                return false;
            }
            this.damageEntity(par1DamageSource, par2 - this.naturalArmorRating);
            this.naturalArmorRating = par2;
            flag = false;
        } else {
            this.naturalArmorRating = par2;
            this.prevHealth = this.health;
            this.heartsLife = this.heartsHalvesLife;
            this.damageEntity(par1DamageSource, par2);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
        this.attackedAtYaw = 0.0f;
        Entity entity = par1DamageSource.getEntity();
        if (entity != null) {
            EntityWolf entitywolf;
            if (entity instanceof EntityLiving) {
                this.setRevengeTarget((EntityLiving)entity);
            }
            if (entity instanceof EntityPlayer) {
                this.recentlyHit = 60;
                this.attackingPlayer = (EntityPlayer)entity;
            } else if (entity instanceof EntityWolf && (entitywolf = (EntityWolf)entity).isTamed()) {
                this.recentlyHit = 60;
                this.attackingPlayer = null;
            }
        }
        if (flag) {
            this.worldObj.setEntityState(this, (byte)2);
            this.setBeenAttacked();
            if (entity != null) {
                double d = entity.posX - this.posX;
                double d1 = entity.posZ - this.posZ;
                while (d * d + d1 * d1 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.attackedAtYaw = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - this.rotationYaw;
                this.knockBack(entity, par2, d, d1);
            } else {
                this.attackedAtYaw = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.health <= 0) {
            if (flag) {
                this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), this.getSoundPitch());
            }
            this.onDeath(par1DamageSource);
        } else if (flag) {
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), this.getSoundPitch());
        }
        return true;
    }

    private float getSoundPitch() {
        if (this.isChild()) {
            return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    public void performHurtAnimation() {
        this.maxHurtTime = 10;
        this.hurtTime = 10;
        this.attackedAtYaw = 0.0f;
    }

    public int getTotalArmorValue() {
        return 0;
    }

    protected void damageArmor(int i) {
    }

    protected int applyArmorCalculations(DamageSource par1DamageSource, int par2) {
        if (!par1DamageSource.isUnblockable()) {
            int i = 25 - this.getTotalArmorValue();
            int j = par2 * i + this.carryoverDamage;
            this.damageArmor(par2);
            par2 = j / 25;
            this.carryoverDamage = j % 25;
        }
        return par2;
    }

    protected int applyPotionDamageCalculations(DamageSource par1DamageSource, int par2) {
        if (this.isPotionActive(Potion.resistance)) {
            int i = (this.getActivePotionEffect(Potion.resistance).getAmplifier() + 1) * 5;
            int j = 25 - i;
            int k = par2 * j + this.carryoverDamage;
            par2 = k / 25;
            this.carryoverDamage = k % 25;
        }
        return par2;
    }

    protected void damageEntity(DamageSource par1DamageSource, int par2) {
        par2 = this.applyArmorCalculations(par1DamageSource, par2);
        par2 = this.applyPotionDamageCalculations(par1DamageSource, par2);
        this.health -= par2;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "damage.hurtflesh";
    }

    protected String getDeathSound() {
        return "damage.hurtflesh";
    }

    public void knockBack(Entity par1Entity, int par2, double par3, double par5) {
        this.isAirBorne = true;
        float f = MathHelper.sqrt_double(par3 * par3 + par5 * par5);
        float f1 = 0.4f;
        this.motionX /= 2.0;
        this.motionY /= 2.0;
        this.motionZ /= 2.0;
        this.motionX -= par3 / (double)f * (double)f1;
        this.motionY += (double)f1;
        this.motionZ -= par5 / (double)f * (double)f1;
        if (this.motionY > (double)0.4f) {
            this.motionY = 0.4f;
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        Entity entity = par1DamageSource.getEntity();
        if (this.scoreValue >= 0 && entity != null) {
            entity.addToPlayerScore(this, this.scoreValue);
        }
        if (entity != null) {
            entity.onKillEntity(this);
        }
        this.dead = true;
        if (!this.worldObj.isRemote) {
            int i = 0;
            if (entity instanceof EntityPlayer) {
                i = EnchantmentHelper.getLootingModifier(((EntityPlayer)entity).inventory);
            }
            if (!this.isChild()) {
                int j;
                this.dropFewItems(this.recentlyHit > 0, i);
                if (this.recentlyHit > 0 && (j = this.rand.nextInt(200) - i) < 5) {
                    this.dropRareDrop(j > 0 ? 0 : 1);
                }
            }
        }
        this.worldObj.setEntityState(this, (byte)3);
    }

    protected void dropRareDrop(int i) {
    }

    protected void dropFewItems(boolean par1, int par2) {
        int i = this.getDropItemId();
        if (i > 0) {
            int j = this.rand.nextInt(3);
            if (par2 > 0) {
                j += this.rand.nextInt(par2 + 1);
            }
            for (int k = 0; k < j; ++k) {
                this.dropItem(i, 1);
            }
        }
    }

    protected int getDropItemId() {
        return 0;
    }

    @Override
    protected void fall(float par1) {
        super.fall(par1);
        int i = (int)Math.ceil(par1 - 3.0f);
        if (i > 0) {
            if (i > 4) {
                this.worldObj.playSoundAtEntity(this, "damage.fallbig", 1.0f, 1.0f);
            } else {
                this.worldObj.playSoundAtEntity(this, "damage.fallsmall", 1.0f, 1.0f);
            }
            this.attackEntityFrom(DamageSource.fall, i);
            int j = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), MathHelper.floor_double(this.posZ));
            if (j > 0) {
                StepSound stepsound = Block.blocksList[j].stepSound;
                this.worldObj.playSoundAtEntity(this, stepsound.getStepSound(), stepsound.getVolume() * 0.5f, stepsound.getPitch() * 0.75f);
            }
        }
    }

    public void moveEntityWithHeading(float par1, float par2) {
        if (this.isInWater()) {
            double d = this.posY;
            this.moveFlying(par1, par2, this.isAIEnabled() ? 0.04f : 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + d, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else if (this.handleLavaMovement()) {
            double d1 = this.posY;
            this.moveFlying(par1, par2, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + d1, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else {
            float f2;
            float f = 0.91f;
            if (this.onGround) {
                f = 0.5460001f;
                int i = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (i > 0) {
                    f = Block.blocksList[i].slipperiness * 0.91f;
                }
            }
            float f1 = 0.1627714f / (f * f * f);
            if (this.onGround) {
                f2 = this.isAIEnabled() ? this.func_48101_aR() : this.landMovementFactor;
                f2 *= f1;
            } else {
                f2 = this.jumpMovementFactor;
            }
            this.moveFlying(par1, par2, f2);
            f = 0.91f;
            if (this.onGround) {
                f = 0.5460001f;
                int j = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (j > 0) {
                    f = Block.blocksList[j].slipperiness * 0.91f;
                }
            }
            if (this.isOnLadder()) {
                boolean flag;
                float f3 = 0.15f;
                if (this.motionX < (double)(-f3)) {
                    this.motionX = -f3;
                }
                if (this.motionX > (double)f3) {
                    this.motionX = f3;
                }
                if (this.motionZ < (double)(-f3)) {
                    this.motionZ = -f3;
                }
                if (this.motionZ > (double)f3) {
                    this.motionZ = f3;
                }
                this.fallDistance = 0.0f;
                if (this.motionY < -0.15) {
                    this.motionY = -0.15;
                }
                boolean bl = flag = this.isSneaking() && this instanceof EntityPlayer;
                if (flag && this.motionY < 0.0) {
                    this.motionY = 0.0;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (this.isCollidedHorizontally && this.isOnLadder()) {
                this.motionY = 0.2;
            }
            this.motionY -= 0.08;
            this.motionY *= (double)0.98f;
            this.motionX *= (double)f;
            this.motionZ *= (double)f;
        }
        this.field_705_Q = this.field_704_R;
        double d2 = this.posX - this.prevPosX;
        double d3 = this.posZ - this.prevPosZ;
        float f4 = MathHelper.sqrt_double(d2 * d2 + d3 * d3) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_704_R += (f4 - this.field_704_R) * 0.4f;
        this.field_703_S += this.field_704_R;
    }

    public boolean isOnLadder() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        int l = this.worldObj.getBlockId(i, j = MathHelper.floor_double(this.boundingBox.minY), k = MathHelper.floor_double(this.posZ));
        return l == Block.ladder.blockID || l == Block.vine.blockID;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setShort("Health", (short)this.health);
        par1NBTTagCompound.setShort("HurtTime", (short)this.hurtTime);
        par1NBTTagCompound.setShort("DeathTime", (short)this.deathTime);
        par1NBTTagCompound.setShort("AttackTime", (short)this.attackTime);
        if (!this.activePotionsMap.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.activePotionsMap.values()) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setByte("Id", (byte)potioneffect.getPotionID());
                nbttagcompound.setByte("Amplifier", (byte)potioneffect.getAmplifier());
                nbttagcompound.setInteger("Duration", potioneffect.getDuration());
                nbttaglist.appendTag(nbttagcompound);
            }
            par1NBTTagCompound.setTag("ActiveEffects", nbttaglist);
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        if (this.health < Short.MIN_VALUE) {
            this.health = Short.MIN_VALUE;
        }
        this.health = par1NBTTagCompound.getShort("Health");
        if (!par1NBTTagCompound.hasKey("Health")) {
            this.health = this.getMaxHealth();
        }
        this.hurtTime = par1NBTTagCompound.getShort("HurtTime");
        this.deathTime = par1NBTTagCompound.getShort("DeathTime");
        this.attackTime = par1NBTTagCompound.getShort("AttackTime");
        if (par1NBTTagCompound.hasKey("ActiveEffects")) {
            NBTTagList nbttaglist = par1NBTTagCompound.getTagList("ActiveEffects");
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(i);
                byte byte0 = nbttagcompound.getByte("Id");
                byte byte1 = nbttagcompound.getByte("Amplifier");
                int j = nbttagcompound.getInteger("Duration");
                this.activePotionsMap.put(Integer.valueOf(byte0), new PotionEffect(byte0, j, byte1));
            }
        }
    }

    @Override
    public boolean isEntityAlive() {
        return !this.isDead && this.health > 0;
    }

    public boolean canBreatheUnderwater() {
        return false;
    }

    public void setMoveForward(float par1) {
        this.moveForward = par1;
    }

    public void setJumping(boolean par1) {
        this.isJumping = par1;
    }

    public void onLivingUpdate() {
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
        if (this.newPosRotationIncrements > 0) {
            double d3;
            double d = this.posX + (this.newPosX - this.posX) / (double)this.newPosRotationIncrements;
            double d1 = this.posY + (this.newPosY - this.posY) / (double)this.newPosRotationIncrements;
            double d2 = this.posZ + (this.newPosZ - this.posZ) / (double)this.newPosRotationIncrements;
            for (d3 = this.newRotationYaw - (double)this.rotationYaw; d3 < -180.0; d3 += 360.0) {
            }
            while (d3 >= 180.0) {
                d3 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + d3 / (double)this.newPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.newRotationPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPosition(d, d1, d2);
            this.setRotation(this.rotationYaw, this.rotationPitch);
            List list1 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.contract(0.03125, 0.0, 0.03125));
            if (list1.size() > 0) {
                double d4 = 0.0;
                for (int j = 0; j < list1.size(); ++j) {
                    AxisAlignedBB axisalignedbb = (AxisAlignedBB)list1.get(j);
                    if (!(axisalignedbb.maxY > d4)) continue;
                    d4 = axisalignedbb.maxY;
                }
                this.setPosition(d, d1 += d4 - this.boundingBox.minY, d2);
            }
        }
        Profiler.startSection("ai");
        if (this.isMovementBlocked()) {
            this.isJumping = false;
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
            this.randomYawVelocity = 0.0f;
        } else if (this.isClientWorld()) {
            if (this.isAIEnabled()) {
                Profiler.startSection("newAi");
                this.updateAITasks();
                Profiler.endSection();
            } else {
                Profiler.startSection("oldAi");
                this.updateEntityActionState();
                Profiler.endSection();
                this.rotationYawHead = this.rotationYaw;
            }
        }
        Profiler.endSection();
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        if (this.isJumping) {
            if (flag) {
                this.motionY += (double)0.04f;
            } else if (flag1) {
                this.motionY += (double)0.04f;
            } else if (this.onGround && this.jumpTicks == 0) {
                this.jump();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.randomYawVelocity *= 0.9f;
        float f = this.landMovementFactor;
        this.landMovementFactor *= this.getSpeedModifier();
        this.moveEntityWithHeading(this.moveStrafing, this.moveForward);
        this.landMovementFactor = f;
        Profiler.startSection("push");
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!entity.canBePushed()) continue;
                entity.applyEntityCollision(this);
            }
        }
        Profiler.endSection();
    }

    protected boolean isAIEnabled() {
        return false;
    }

    protected boolean isClientWorld() {
        return !this.worldObj.isRemote;
    }

    protected boolean isMovementBlocked() {
        return this.health <= 0;
    }

    public boolean isBlocking() {
        return false;
    }

    protected void jump() {
        this.motionY = 0.42f;
        if (this.isPotionActive(Potion.jump)) {
            this.motionY += (double)((float)(this.getActivePotionEffect(Potion.jump).getAmplifier() + 1) * 0.1f);
        }
        if (this.isSprinting()) {
            float f = this.rotationYaw * 0.01745329f;
            this.motionX -= (double)(MathHelper.sin(f) * 0.2f);
            this.motionZ += (double)(MathHelper.cos(f) * 0.2f);
        }
        this.isAirBorne = true;
    }

    protected boolean canDespawn() {
        return true;
    }

    protected void despawnEntity() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        if (entityplayer != null) {
            double d = entityplayer.posX - this.posX;
            double d1 = entityplayer.posY - this.posY;
            double d2 = entityplayer.posZ - this.posZ;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (this.canDespawn() && d3 > 16384.0) {
                this.setDead();
            }
            if (this.entityAge > 600 && this.rand.nextInt(800) == 0 && d3 > 1024.0 && this.canDespawn()) {
                this.setDead();
            } else if (d3 < 1024.0) {
                this.entityAge = 0;
            }
        }
    }

    protected void updateAITasks() {
        ++this.entityAge;
        Profiler.startSection("checkDespawn");
        this.despawnEntity();
        Profiler.endSection();
        Profiler.startSection("sensing");
        this.senses.clearSensingCache();
        Profiler.endSection();
        Profiler.startSection("targetSelector");
        this.targetTasks.onUpdateTasks();
        Profiler.endSection();
        Profiler.startSection("goalSelector");
        this.tasks.onUpdateTasks();
        Profiler.endSection();
        Profiler.startSection("navigation");
        this.navigator.onUpdateNavigation();
        Profiler.endSection();
        Profiler.startSection("mob tick");
        this.updateAITick();
        Profiler.endSection();
        Profiler.startSection("controls");
        this.moveHelper.onUpdateMoveHelper();
        this.lookHelper.onUpdateLook();
        this.jumpHelper.doJump();
        Profiler.endSection();
    }

    protected void updateAITick() {
    }

    protected void updateEntityActionState() {
        ++this.entityAge;
        this.despawnEntity();
        this.moveStrafing = 0.0f;
        this.moveForward = 0.0f;
        float f = 8.0f;
        if (this.rand.nextFloat() < 0.02f) {
            EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, f);
            if (entityplayer != null) {
                this.currentTarget = entityplayer;
                this.numTicksToChaseTarget = 10 + this.rand.nextInt(20);
            } else {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.currentTarget != null) {
            this.faceEntity(this.currentTarget, 10.0f, this.getVerticalFaceSpeed());
            if (this.numTicksToChaseTarget-- <= 0 || this.currentTarget.isDead || this.currentTarget.getDistanceSqToEntity(this) > (double)(f * f)) {
                this.currentTarget = null;
            }
        } else {
            if (this.rand.nextFloat() < 0.05f) {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
            this.rotationYaw += this.randomYawVelocity;
            this.rotationPitch = this.defaultPitch;
        }
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        if (flag || flag1) {
            this.isJumping = this.rand.nextFloat() < 0.8f;
        }
    }

    public int getVerticalFaceSpeed() {
        return 40;
    }

    public void faceEntity(Entity par1Entity, float par2, float par3) {
        double d1;
        double d = par1Entity.posX - this.posX;
        double d2 = par1Entity.posZ - this.posZ;
        if (par1Entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)par1Entity;
            d1 = this.posY + (double)this.getEyeHeight() - (entityliving.posY + (double)entityliving.getEyeHeight());
        } else {
            d1 = (par1Entity.boundingBox.minY + par1Entity.boundingBox.maxY) / 2.0 - (this.posY + (double)this.getEyeHeight());
        }
        double d3 = MathHelper.sqrt_double(d * d + d2 * d2);
        float f = (float)(Math.atan2(d2, d) * 180.0 / Math.PI) - 90.0f;
        float f1 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        this.rotationPitch = -this.updateRotation(this.rotationPitch, f1, par3);
        this.rotationYaw = this.updateRotation(this.rotationYaw, f, par2);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f;
        for (f = par2 - par1; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f > par3) {
            f = par3;
        }
        if (f < -par3) {
            f = -par3;
        }
        return par1 + f;
    }

    public void onEntityDeath() {
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.checkIfAABBIsClear(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.isAnyLiquid(this.boundingBox);
    }

    @Override
    protected void kill() {
        this.attackEntityFrom(DamageSource.outOfWorld, 4);
    }

    public float getSwingProgress(float par1) {
        float f = this.swingProgress - this.prevSwingProgress;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.prevSwingProgress + f * par1;
    }

    public Vec3D getPosition(float par1) {
        if (par1 == 1.0f) {
            return Vec3D.createVector(this.posX, this.posY, this.posZ);
        }
        double d = this.prevPosX + (this.posX - this.prevPosX) * (double)par1;
        double d1 = this.prevPosY + (this.posY - this.prevPosY) * (double)par1;
        double d2 = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)par1;
        return Vec3D.createVector(d, d1, d2);
    }

    @Override
    public Vec3D getLookVec() {
        return this.getLook(1.0f);
    }

    public Vec3D getLook(float par1) {
        if (par1 == 1.0f) {
            float f = MathHelper.cos(-this.rotationYaw * 0.01745329f - (float)Math.PI);
            float f2 = MathHelper.sin(-this.rotationYaw * 0.01745329f - (float)Math.PI);
            float f4 = -MathHelper.cos(-this.rotationPitch * 0.01745329f);
            float f6 = MathHelper.sin(-this.rotationPitch * 0.01745329f);
            return Vec3D.createVector(f2 * f4, f6, f * f4);
        }
        float f1 = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * par1;
        float f3 = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * par1;
        float f5 = MathHelper.cos(-f3 * 0.01745329f - (float)Math.PI);
        float f7 = MathHelper.sin(-f3 * 0.01745329f - (float)Math.PI);
        float f8 = -MathHelper.cos(-f1 * 0.01745329f);
        float f9 = MathHelper.sin(-f1 * 0.01745329f);
        return Vec3D.createVector(f7 * f8, f9, f5 * f8);
    }

    public float getRenderSizeModifier() {
        return 1.0f;
    }

    public MovingObjectPosition rayTrace(double par1, float par3) {
        Vec3D vec3d = this.getPosition(par3);
        Vec3D vec3d1 = this.getLook(par3);
        Vec3D vec3d2 = vec3d.addVector(vec3d1.xCoord * par1, vec3d1.yCoord * par1, vec3d1.zCoord * par1);
        return this.worldObj.rayTraceBlocks(vec3d, vec3d2);
    }

    public int getMaxSpawnedInChunk() {
        return 4;
    }

    public ItemStack getHeldItem() {
        return null;
    }

    @Override
    public void handleHealthUpdate(byte par1) {
        if (par1 == 2) {
            this.field_704_R = 1.5f;
            this.heartsLife = this.heartsHalvesLife;
            this.maxHurtTime = 10;
            this.hurtTime = 10;
            this.attackedAtYaw = 0.0f;
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.attackEntityFrom(DamageSource.generic, 0);
        } else if (par1 == 3) {
            this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.health = 0;
            this.onDeath(DamageSource.generic);
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public boolean isPlayerSleeping() {
        return false;
    }

    public int getItemIcon(ItemStack par1ItemStack, int par2) {
        return par1ItemStack.getIconIndex();
    }

    protected void updatePotionEffects() {
        int j;
        Iterator iterator = this.activePotionsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer integer = (Integer)iterator.next();
            PotionEffect potioneffect = (PotionEffect)this.activePotionsMap.get(integer);
            if (potioneffect.onUpdate(this) || this.worldObj.isRemote) continue;
            iterator.remove();
            this.onFinishedPotionEffect(potioneffect);
        }
        if (this.potionsNeedUpdate) {
            if (!this.worldObj.isRemote) {
                if (!this.activePotionsMap.isEmpty()) {
                    int i = PotionHelper.func_40354_a(this.activePotionsMap.values());
                    this.dataWatcher.updateObject(8, i);
                } else {
                    this.dataWatcher.updateObject(8, 0);
                }
            }
            this.potionsNeedUpdate = false;
        }
        if (this.rand.nextBoolean() && (j = this.dataWatcher.getWatchableObjectInt(8)) > 0) {
            double d = (double)(j >> 16 & 0xFF) / 255.0;
            double d1 = (double)(j >> 8 & 0xFF) / 255.0;
            double d2 = (double)(j >> 0 & 0xFF) / 255.0;
            this.worldObj.spawnParticle("mobSpell", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height - (double)this.yOffset, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, d, d1, d2);
        }
    }

    public void clearActivePotions() {
        Iterator iterator = this.activePotionsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer integer = (Integer)iterator.next();
            PotionEffect potioneffect = (PotionEffect)this.activePotionsMap.get(integer);
            if (this.worldObj.isRemote) continue;
            iterator.remove();
            this.onFinishedPotionEffect(potioneffect);
        }
    }

    public Collection getActivePotionEffects() {
        return this.activePotionsMap.values();
    }

    public boolean isPotionActive(Potion par1Potion) {
        return this.activePotionsMap.containsKey(par1Potion.id);
    }

    public PotionEffect getActivePotionEffect(Potion par1Potion) {
        return (PotionEffect)this.activePotionsMap.get(par1Potion.id);
    }

    public void addPotionEffect(PotionEffect par1PotionEffect) {
        if (!this.isPotionApplicable(par1PotionEffect)) {
            return;
        }
        if (this.activePotionsMap.containsKey(par1PotionEffect.getPotionID())) {
            ((PotionEffect)this.activePotionsMap.get(par1PotionEffect.getPotionID())).combine(par1PotionEffect);
            this.onChangedPotionEffect((PotionEffect)this.activePotionsMap.get(par1PotionEffect.getPotionID()));
        } else {
            this.activePotionsMap.put(par1PotionEffect.getPotionID(), par1PotionEffect);
            this.onNewPotionEffect(par1PotionEffect);
        }
    }

    public boolean isPotionApplicable(PotionEffect par1PotionEffect) {
        int i;
        return this.getCreatureAttribute() != EnumCreatureAttribute.UNDEAD || (i = par1PotionEffect.getPotionID()) != Potion.regeneration.id && i != Potion.poison.id;
    }

    public boolean isEntityUndead() {
        return this.getCreatureAttribute() == EnumCreatureAttribute.UNDEAD;
    }

    public void removePotionEffect(int par1) {
        this.activePotionsMap.remove(par1);
    }

    protected void onNewPotionEffect(PotionEffect par1PotionEffect) {
        this.potionsNeedUpdate = true;
    }

    protected void onChangedPotionEffect(PotionEffect par1PotionEffect) {
        this.potionsNeedUpdate = true;
    }

    protected void onFinishedPotionEffect(PotionEffect par1PotionEffect) {
        this.potionsNeedUpdate = true;
    }

    protected float getSpeedModifier() {
        float f = 1.0f;
        if (this.isPotionActive(Potion.moveSpeed)) {
            f *= 1.0f + 0.2f * (float)(this.getActivePotionEffect(Potion.moveSpeed).getAmplifier() + 1);
        }
        if (this.isPotionActive(Potion.moveSlowdown)) {
            f *= 1.0f - 0.15f * (float)(this.getActivePotionEffect(Potion.moveSlowdown).getAmplifier() + 1);
        }
        return f;
    }

    public void setPositionAndUpdate(double par1, double par3, double par5) {
        this.setLocationAndAngles(par1, par3, par5, this.rotationYaw, this.rotationPitch);
    }

    public boolean isChild() {
        return false;
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    public void renderBrokenItemStack(ItemStack par1ItemStack) {
        this.worldObj.playSoundAtEntity(this, "random.break", 0.8f, 0.8f + this.worldObj.rand.nextFloat() * 0.4f);
        for (int i = 0; i < 5; ++i) {
            Vec3D vec3d = Vec3D.createVector(((double)this.rand.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0f);
            vec3d.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0f);
            Vec3D vec3d1 = Vec3D.createVector(((double)this.rand.nextFloat() - 0.5) * 0.3, (double)(-this.rand.nextFloat()) * 0.6 - 0.3, 0.6);
            vec3d1.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0f);
            vec3d1.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0f);
            vec3d1 = vec3d1.addVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ);
            this.worldObj.spawnParticle("iconcrack_" + par1ItemStack.getItem().shiftedIndex, vec3d1.xCoord, vec3d1.yCoord, vec3d1.zCoord, vec3d.xCoord, vec3d.yCoord + 0.05, vec3d.zCoord);
        }
    }
}

