/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Entity;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityFallingSand
extends Entity {
    public int blockID;
    public int fallTime = 0;

    public EntityFallingSand(World par1World) {
        super(par1World);
    }

    public EntityFallingSand(World par1World, double par2, double par4, double par6, int par8) {
        super(par1World);
        this.blockID = par8;
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(par2, par4, par6);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = par2;
        this.prevPosY = par4;
        this.prevPosZ = par6;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void onUpdate() {
        if (this.blockID == 0) {
            this.setDead();
            return;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        ++this.fallTime;
        this.motionY -= (double)0.04f;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.posY);
        int k = MathHelper.floor_double(this.posZ);
        if (this.fallTime == 1 && this.worldObj.getBlockId(i, j, k) == this.blockID) {
            this.worldObj.setBlockWithNotify(i, j, k, 0);
        } else if (!this.worldObj.isRemote && this.fallTime == 1) {
            this.setDead();
        }
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
            if (this.worldObj.getBlockId(i, j, k) != Block.pistonMoving.blockID) {
                this.setDead();
                if (!(this.worldObj.canBlockBePlacedAt(this.blockID, i, j, k, true, 1) && !BlockSand.canFallBelow(this.worldObj, i, j - 1, k) && this.worldObj.setBlockWithNotify(i, j, k, this.blockID) || this.worldObj.isRemote)) {
                    this.dropItem(this.blockID, 1);
                }
            }
        } else if (this.fallTime > 100 && !this.worldObj.isRemote && (j < 1 || j > 256) || this.fallTime > 600) {
            this.dropItem(this.blockID, 1);
            this.setDead();
        }
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setByte("Tile", (byte)this.blockID);
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.blockID = par1NBTTagCompound.getByte("Tile") & 0xFF;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    public World getWorld() {
        return this.worldObj;
    }
}

