/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityDamageSourceIndirect;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityEnderman
extends EntityMob {
    private static boolean[] canCarryBlocks = new boolean[256];
    public boolean isAttacking = false;
    private int teleportDelay = 0;
    private int field_35185_e = 0;

    public EntityEnderman(World par1World) {
        super(par1World);
        this.texture = "/mob/enderman.png";
        this.moveSpeed = 0.2f;
        this.attackStrength = 7;
        this.setSize(0.6f, 2.9f);
        this.stepHeight = 1.0f;
    }

    @Override
    public int getMaxHealth() {
        return 40;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(0));
        this.dataWatcher.addObject(17, new Byte(0));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setShort("carried", (short)this.getCarried());
        par1NBTTagCompound.setShort("carriedData", (short)this.getCarryingData());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setCarried(par1NBTTagCompound.getShort("carried"));
        this.setCarryingData(par1NBTTagCompound.getShort("carriedData"));
    }

    @Override
    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.getClosestVulnerablePlayerToEntity(this, 64.0);
        if (entityplayer != null) {
            if (this.shouldAttackPlayer(entityplayer)) {
                if (this.field_35185_e++ == 5) {
                    this.field_35185_e = 0;
                    return entityplayer;
                }
            } else {
                this.field_35185_e = 0;
            }
        }
        return null;
    }

    @Override
    public int getBrightnessForRender(float par1) {
        return super.getBrightnessForRender(par1);
    }

    @Override
    public float getBrightness(float par1) {
        return super.getBrightness(par1);
    }

    private boolean shouldAttackPlayer(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.inventory.armorInventory[3];
        if (itemstack != null && itemstack.itemID == Block.pumpkin.blockID) {
            return false;
        }
        Vec3D vec3d = par1EntityPlayer.getLook(1.0f).normalize();
        Vec3D vec3d1 = Vec3D.createVector(this.posX - par1EntityPlayer.posX, this.boundingBox.minY + (double)(this.height / 2.0f) - (par1EntityPlayer.posY + (double)par1EntityPlayer.getEyeHeight()), this.posZ - par1EntityPlayer.posZ);
        double d = vec3d1.lengthVector();
        double d1 = vec3d.dotProduct(vec3d1 = vec3d1.normalize());
        if (d1 > 1.0 - 0.025 / d) {
            return par1EntityPlayer.canEntityBeSeen(this);
        }
        return false;
    }

    @Override
    public void onLivingUpdate() {
        float f;
        if (this.isWet()) {
            this.attackEntityFrom(DamageSource.drown, 1);
        }
        this.isAttacking = this.entityToAttack != null;
        float f2 = this.moveSpeed = this.entityToAttack == null ? 0.3f : 6.5f;
        if (!this.worldObj.isRemote) {
            if (this.getCarried() == 0) {
                int j1;
                int l;
                int i;
                int l1;
                if (this.rand.nextInt(20) == 0 && canCarryBlocks[l1 = this.worldObj.getBlockId(i = MathHelper.floor_double(this.posX - 2.0 + this.rand.nextDouble() * 4.0), l = MathHelper.floor_double(this.posY + this.rand.nextDouble() * 3.0), j1 = MathHelper.floor_double(this.posZ - 2.0 + this.rand.nextDouble() * 4.0))]) {
                    this.setCarried(this.worldObj.getBlockId(i, l, j1));
                    this.setCarryingData(this.worldObj.getBlockMetadata(i, l, j1));
                    this.worldObj.setBlockWithNotify(i, l, j1, 0);
                }
            } else if (this.rand.nextInt(2000) == 0) {
                int j = MathHelper.floor_double(this.posX - 1.0 + this.rand.nextDouble() * 2.0);
                int i1 = MathHelper.floor_double(this.posY + this.rand.nextDouble() * 2.0);
                int k1 = MathHelper.floor_double(this.posZ - 1.0 + this.rand.nextDouble() * 2.0);
                int i2 = this.worldObj.getBlockId(j, i1, k1);
                int j2 = this.worldObj.getBlockId(j, i1 - 1, k1);
                if (i2 == 0 && j2 > 0 && Block.blocksList[j2].renderAsNormalBlock()) {
                    this.worldObj.setBlockAndMetadataWithNotify(j, i1, k1, this.getCarried(), this.getCarryingData());
                    this.setCarried(0);
                }
            }
        }
        for (int k = 0; k < 2; ++k) {
            this.worldObj.spawnParticle("portal", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height - 0.25, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0);
        }
        if (this.worldObj.isDaytime() && !this.worldObj.isRemote && (f = this.getBrightness(1.0f)) > 0.5f && this.worldObj.canBlockSeeTheSky(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) && this.rand.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.entityToAttack = null;
            this.teleportRandomly();
        }
        if (this.isWet()) {
            this.entityToAttack = null;
            this.teleportRandomly();
        }
        this.isJumping = false;
        if (this.entityToAttack != null) {
            this.faceEntity(this.entityToAttack, 100.0f, 100.0f);
        }
        if (!this.worldObj.isRemote && this.isEntityAlive()) {
            if (this.entityToAttack != null) {
                if (this.entityToAttack instanceof EntityPlayer && this.shouldAttackPlayer((EntityPlayer)this.entityToAttack)) {
                    this.moveForward = 0.0f;
                    this.moveStrafing = 0.0f;
                    this.moveSpeed = 0.0f;
                    if (this.entityToAttack.getDistanceSqToEntity(this) < 16.0) {
                        this.teleportRandomly();
                    }
                    this.teleportDelay = 0;
                } else if (this.entityToAttack.getDistanceSqToEntity(this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity(this.entityToAttack)) {
                    this.teleportDelay = 0;
                }
            } else {
                this.teleportDelay = 0;
            }
        }
        super.onLivingUpdate();
    }

    protected boolean teleportRandomly() {
        double d = this.posX + (this.rand.nextDouble() - 0.5) * 64.0;
        double d1 = this.posY + (double)(this.rand.nextInt(64) - 32);
        double d2 = this.posZ + (this.rand.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d, d1, d2);
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3D vec3d = Vec3D.createVector(this.posX - par1Entity.posX, this.boundingBox.minY + (double)(this.height / 2.0f) - par1Entity.posY + (double)par1Entity.getEyeHeight(), this.posZ - par1Entity.posZ);
        vec3d = vec3d.normalize();
        double d = 16.0;
        double d1 = this.posX + (this.rand.nextDouble() - 0.5) * 8.0 - vec3d.xCoord * d;
        double d2 = this.posY + (double)(this.rand.nextInt(16) - 8) - vec3d.yCoord * d;
        double d3 = this.posZ + (this.rand.nextDouble() - 0.5) * 8.0 - vec3d.zCoord * d;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        this.posX = par1;
        this.posY = par3;
        this.posZ = par5;
        boolean flag = false;
        int i = MathHelper.floor_double(this.posX);
        if (this.worldObj.blockExists(i, j = MathHelper.floor_double(this.posY), k = MathHelper.floor_double(this.posZ))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                int i1 = this.worldObj.getBlockId(i, j - 1, k);
                if (i1 == 0 || !Block.blocksList[i1].blockMaterial.blocksMovement()) {
                    this.posY -= 1.0;
                    --j;
                    continue;
                }
                flag1 = true;
            }
            if (flag1) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.isAnyLiquid(this.boundingBox)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.setPosition(d, d1, d2);
            return false;
        }
        int l = 128;
        for (int j1 = 0; j1 < l; ++j1) {
            double d3 = (double)j1 / ((double)l - 1.0);
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double d4 = d + (this.posX - d) * d3 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double d5 = d1 + (this.posY - d1) * d3 + this.rand.nextDouble() * (double)this.height;
            double d6 = d2 + (this.posZ - d2) * d3 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.worldObj.spawnParticle("portal", d4, d5, d6, f, f1, f2);
        }
        this.worldObj.playSoundEffect(d, d1, d2, "mob.endermen.portal", 1.0f, 1.0f);
        this.worldObj.playSoundAtEntity(this, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    @Override
    protected String getLivingSound() {
        return "mob.endermen.idle";
    }

    @Override
    protected String getHurtSound() {
        return "mob.endermen.hit";
    }

    @Override
    protected String getDeathSound() {
        return "mob.endermen.death";
    }

    @Override
    protected int getDropItemId() {
        return Item.enderPearl.shiftedIndex;
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        int i = this.getDropItemId();
        if (i > 0) {
            int j = this.rand.nextInt(2 + par2);
            for (int k = 0; k < j; ++k) {
                this.dropItem(i, 1);
            }
        }
    }

    public void setCarried(int par1) {
        this.dataWatcher.updateObject(16, (byte)(par1 & 0xFF));
    }

    public int getCarried() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    public void setCarryingData(int par1) {
        this.dataWatcher.updateObject(17, (byte)(par1 & 0xFF));
    }

    public int getCarryingData() {
        return this.dataWatcher.getWatchableObjectByte(17);
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (par1DamageSource instanceof EntityDamageSourceIndirect) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    static {
        EntityEnderman.canCarryBlocks[Block.grass.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.dirt.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.sand.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.gravel.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.plantYellow.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.plantRed.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.mushroomBrown.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.mushroomRed.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.tnt.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.cactus.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.blockClay.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.pumpkin.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.melon.blockID] = true;
        EntityEnderman.canCarryBlocks[Block.mycelium.blockID] = true;
    }
}

