/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityEnderEye
extends Entity {
    public int field_40096_a = 0;
    private double field_40094_b;
    private double field_40095_c;
    private double field_40091_d;
    private int despawnTimer;
    private boolean shatterOrDrop;

    public EntityEnderEye(World par1World) {
        super(par1World);
        this.setSize(0.25f, 0.25f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public boolean isInRangeToRenderDist(double par1) {
        double d = this.boundingBox.getAverageEdgeLength() * 4.0;
        return par1 < (d *= 64.0) * d;
    }

    public EntityEnderEye(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.despawnTimer = 0;
        this.setSize(0.25f, 0.25f);
        this.setPosition(par2, par4, par6);
        this.yOffset = 0.0f;
    }

    public void func_40090_a(double par1, int par3, double par4) {
        double d = par1 - this.posX;
        double d1 = par4 - this.posZ;
        float f = MathHelper.sqrt_double(d * d + d1 * d1);
        if (f > 12.0f) {
            this.field_40094_b = this.posX + d / (double)f * 12.0;
            this.field_40091_d = this.posZ + d1 / (double)f * 12.0;
            this.field_40095_c = this.posY + 8.0;
        } else {
            this.field_40094_b = par1;
            this.field_40095_c = par3;
            this.field_40091_d = par4;
        }
        this.despawnTimer = 0;
        this.shatterOrDrop = this.rand.nextInt(5) > 0;
    }

    @Override
    public void setVelocity(double par1, double par3, double par5) {
        this.motionX = par1;
        this.motionY = par3;
        this.motionZ = par5;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double(par1 * par1 + par5 * par5);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(par3, f) * 180.0 / Math.PI);
        }
    }

    @Override
    public void onUpdate() {
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onUpdate();
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        if (!this.worldObj.isRemote) {
            double d = this.field_40094_b - this.posX;
            double d1 = this.field_40091_d - this.posZ;
            float f2 = (float)Math.sqrt(d * d + d1 * d1);
            float f3 = (float)Math.atan2(d1, d);
            double d2 = (double)f + (double)(f2 - f) * 0.0025;
            if (f2 < 1.0f) {
                d2 *= 0.8;
                this.motionY *= 0.8;
            }
            this.motionX = Math.cos(f3) * d2;
            this.motionZ = Math.sin(f3) * d2;
            this.motionY = this.posY < this.field_40095_c ? (this.motionY += (1.0 - this.motionY) * (double)0.015f) : (this.motionY += (-1.0 - this.motionY) * (double)0.015f);
        }
        float f1 = 0.25f;
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f1, this.posY - this.motionY * (double)f1, this.posZ - this.motionZ * (double)f1, this.motionX, this.motionY, this.motionZ);
            }
        } else {
            this.worldObj.spawnParticle("portal", this.posX - this.motionX * (double)f1 + this.rand.nextDouble() * 0.6 - 0.3, this.posY - this.motionY * (double)f1 - 0.5, this.posZ - this.motionZ * (double)f1 + this.rand.nextDouble() * 0.6 - 0.3, this.motionX, this.motionY, this.motionZ);
        }
        if (!this.worldObj.isRemote) {
            this.setPosition(this.posX, this.posY, this.posZ);
            ++this.despawnTimer;
            if (this.despawnTimer > 80 && !this.worldObj.isRemote) {
                this.setDead();
                if (this.shatterOrDrop) {
                    this.worldObj.spawnEntityInWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.eyeOfEnder)));
                } else {
                    this.worldObj.playAuxSFX(2003, (int)Math.round(this.posX), (int)Math.round(this.posY), (int)Math.round(this.posZ), 0);
                }
            }
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer entityplayer) {
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public float getBrightness(float par1) {
        return 1.0f;
    }

    @Override
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    @Override
    public boolean canAttackWithItem() {
        return false;
    }
}

