/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.Profiler;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public abstract class EntityCreature
extends EntityLiving {
    private PathEntity pathToEntity;
    protected Entity entityToAttack;
    protected boolean hasAttacked = false;
    protected int fleeingTick = 0;

    public EntityCreature(World par1World) {
        super(par1World);
    }

    protected boolean isMovementCeased() {
        return false;
    }

    @Override
    protected void updateEntityActionState() {
        Profiler.startSection("ai");
        if (this.fleeingTick > 0) {
            --this.fleeingTick;
        }
        this.hasAttacked = this.isMovementCeased();
        float f = 16.0f;
        if (this.entityToAttack == null) {
            this.entityToAttack = this.findPlayerToAttack();
            if (this.entityToAttack != null) {
                this.pathToEntity = this.worldObj.getPathEntityToEntity(this, this.entityToAttack, f, true, false, false, true);
            }
        } else if (!this.entityToAttack.isEntityAlive()) {
            this.entityToAttack = null;
        } else {
            float f1 = this.entityToAttack.getDistanceToEntity(this);
            if (this.canEntityBeSeen(this.entityToAttack)) {
                this.attackEntity(this.entityToAttack, f1);
            } else {
                this.attackBlockedEntity(this.entityToAttack, f1);
            }
        }
        Profiler.endSection();
        if (!(this.hasAttacked || this.entityToAttack == null || this.pathToEntity != null && this.rand.nextInt(20) != 0)) {
            this.pathToEntity = this.worldObj.getPathEntityToEntity(this, this.entityToAttack, f, true, false, false, true);
        } else if (!this.hasAttacked && (this.pathToEntity == null && this.rand.nextInt(180) == 0 || this.rand.nextInt(120) == 0 || this.fleeingTick > 0) && this.entityAge < 100) {
            this.updateWanderPath();
        }
        int i = MathHelper.floor_double(this.boundingBox.minY + 0.5);
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        this.rotationPitch = 0.0f;
        if (this.pathToEntity == null || this.rand.nextInt(100) == 0) {
            super.updateEntityActionState();
            this.pathToEntity = null;
            return;
        }
        Profiler.startSection("followpath");
        Vec3D vec3d = this.pathToEntity.getCurrentNodeVec3d(this);
        double d = this.width * 2.0f;
        while (vec3d != null && vec3d.squareDistanceTo(this.posX, vec3d.yCoord, this.posZ) < d * d) {
            this.pathToEntity.incrementPathIndex();
            if (this.pathToEntity.isFinished()) {
                vec3d = null;
                this.pathToEntity = null;
                continue;
            }
            vec3d = this.pathToEntity.getCurrentNodeVec3d(this);
        }
        this.isJumping = false;
        if (vec3d != null) {
            float f3;
            double d1 = vec3d.xCoord - this.posX;
            double d2 = vec3d.zCoord - this.posZ;
            double d3 = vec3d.yCoord - (double)i;
            float f2 = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f;
            this.moveForward = this.moveSpeed;
            for (f3 = f2 - this.rotationYaw; f3 < -180.0f; f3 += 360.0f) {
            }
            while (f3 >= 180.0f) {
                f3 -= 360.0f;
            }
            if (f3 > 30.0f) {
                f3 = 30.0f;
            }
            if (f3 < -30.0f) {
                f3 = -30.0f;
            }
            this.rotationYaw += f3;
            if (this.hasAttacked && this.entityToAttack != null) {
                double d4 = this.entityToAttack.posX - this.posX;
                double d5 = this.entityToAttack.posZ - this.posZ;
                float f5 = this.rotationYaw;
                this.rotationYaw = (float)(Math.atan2(d5, d4) * 180.0 / Math.PI) - 90.0f;
                float f4 = (f5 - this.rotationYaw + 90.0f) * (float)Math.PI / 180.0f;
                this.moveStrafing = -MathHelper.sin(f4) * this.moveForward * 1.0f;
                this.moveForward = MathHelper.cos(f4) * this.moveForward * 1.0f;
            }
            if (d3 > 0.0) {
                this.isJumping = true;
            }
        }
        if (this.entityToAttack != null) {
            this.faceEntity(this.entityToAttack, 30.0f, 30.0f);
        }
        if (this.isCollidedHorizontally && !this.hasPath()) {
            this.isJumping = true;
        }
        if (this.rand.nextFloat() < 0.8f && (flag || flag1)) {
            this.isJumping = true;
        }
        Profiler.endSection();
    }

    protected void updateWanderPath() {
        Profiler.startSection("stroll");
        boolean flag = false;
        int i = -1;
        int j = -1;
        int k = -1;
        float f = -99999.0f;
        for (int l = 0; l < 10; ++l) {
            int k1;
            int j1;
            int i1 = MathHelper.floor_double(this.posX + (double)this.rand.nextInt(13) - 6.0);
            float f1 = this.getBlockPathWeight(i1, j1 = MathHelper.floor_double(this.posY + (double)this.rand.nextInt(7) - 3.0), k1 = MathHelper.floor_double(this.posZ + (double)this.rand.nextInt(13) - 6.0));
            if (!(f1 > f)) continue;
            f = f1;
            i = i1;
            j = j1;
            k = k1;
            flag = true;
        }
        if (flag) {
            this.pathToEntity = this.worldObj.getEntityPathToXYZ(this, i, j, k, 10.0f, true, false, false, true);
        }
        Profiler.endSection();
    }

    protected void attackEntity(Entity entity, float f) {
    }

    protected void attackBlockedEntity(Entity entity, float f) {
    }

    public float getBlockPathWeight(int par1, int par2, int par3) {
        return 0.0f;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    @Override
    public boolean getCanSpawnHere() {
        int i = MathHelper.floor_double(this.posX);
        int j = MathHelper.floor_double(this.boundingBox.minY);
        int k = MathHelper.floor_double(this.posZ);
        return super.getCanSpawnHere() && this.getBlockPathWeight(i, j, k) >= 0.0f;
    }

    public boolean hasPath() {
        return this.pathToEntity != null;
    }

    public void setPathToEntity(PathEntity par1PathEntity) {
        this.pathToEntity = par1PathEntity;
    }

    public Entity getEntityToAttack() {
        return this.entityToAttack;
    }

    public void setTarget(Entity par1Entity) {
        this.entityToAttack = par1Entity;
    }

    @Override
    protected float getSpeedModifier() {
        if (this.isAIEnabled()) {
            return 1.0f;
        }
        float f = super.getSpeedModifier();
        if (this.fleeingTick > 0) {
            f *= 2.0f;
        }
        return f;
    }
}

