/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityAIFollowParent;
import net.minecraft.src.EntityAILookIdle;
import net.minecraft.src.EntityAIMate;
import net.minecraft.src.EntityAIPanic;
import net.minecraft.src.EntityAISwimming;
import net.minecraft.src.EntityAITempt;
import net.minecraft.src.EntityAIWander;
import net.minecraft.src.EntityAIWatchClosest;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityChicken
extends EntityAnimal {
    public boolean field_753_a = false;
    public float field_752_b = 0.0f;
    public float destPos = 0.0f;
    public float field_757_d;
    public float field_756_e;
    public float field_755_h = 1.0f;
    public int timeUntilNextEgg;

    public EntityChicken(World par1World) {
        super(par1World);
        this.texture = "/mob/chicken.png";
        this.setSize(0.3f, 0.7f);
        this.timeUntilNextEgg = this.rand.nextInt(6000) + 6000;
        float f = 0.25f;
        this.tasks.addTask(0, new EntityAISwimming(this));
        this.tasks.addTask(1, new EntityAIPanic(this, 0.38f));
        this.tasks.addTask(2, new EntityAIMate(this, f));
        this.tasks.addTask(3, new EntityAITempt(this, 0.25f, Item.wheat.shiftedIndex, false));
        this.tasks.addTask(4, new EntityAIFollowParent(this, 0.28f));
        this.tasks.addTask(5, new EntityAIWander(this, f));
        this.tasks.addTask(6, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, new EntityAILookIdle(this));
    }

    @Override
    public boolean isAIEnabled() {
        return true;
    }

    @Override
    public int getMaxHealth() {
        return 4;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.field_756_e = this.field_752_b;
        this.field_757_d = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.onGround ? -1 : 4) * 0.3);
        if (this.destPos < 0.0f) {
            this.destPos = 0.0f;
        }
        if (this.destPos > 1.0f) {
            this.destPos = 1.0f;
        }
        if (!this.onGround && this.field_755_h < 1.0f) {
            this.field_755_h = 1.0f;
        }
        this.field_755_h = (float)((double)this.field_755_h * 0.9);
        if (!this.onGround && this.motionY < 0.0) {
            this.motionY *= 0.6;
        }
        this.field_752_b += this.field_755_h * 2.0f;
        if (!this.isChild() && !this.worldObj.isRemote && --this.timeUntilNextEgg <= 0) {
            this.worldObj.playSoundAtEntity(this, "mob.chickenplop", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.dropItem(Item.egg.shiftedIndex, 1);
            this.timeUntilNextEgg = this.rand.nextInt(6000) + 6000;
        }
    }

    @Override
    protected void fall(float f) {
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
    }

    @Override
    protected String getLivingSound() {
        return "mob.chicken";
    }

    @Override
    protected String getHurtSound() {
        return "mob.chickenhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.chickenhurt";
    }

    @Override
    protected int getDropItemId() {
        return Item.feather.shiftedIndex;
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        int i = this.rand.nextInt(3) + this.rand.nextInt(1 + par2);
        for (int j = 0; j < i; ++j) {
            this.dropItem(Item.feather.shiftedIndex, 1);
        }
        if (this.isBurning()) {
            this.dropItem(Item.chickenCooked.shiftedIndex, 1);
        } else {
            this.dropItem(Item.chickenRaw.shiftedIndex, 1);
        }
    }

    @Override
    public EntityAnimal spawnBabyAnimal(EntityAnimal par1EntityAnimal) {
        return new EntityChicken(this.worldObj);
    }
}

