/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityBoat
extends Entity {
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public EntityBoat(World par1World) {
        super(par1World);
        this.preventEntitySpawning = true;
        this.setSize(1.5f, 0.6f);
        this.yOffset = this.height / 2.0f;
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.addObject(17, new Integer(0));
        this.dataWatcher.addObject(18, new Integer(1));
        this.dataWatcher.addObject(19, new Integer(0));
    }

    @Override
    public AxisAlignedBB getCollisionBox(Entity par1Entity) {
        return par1Entity.boundingBox;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public boolean canBePushed() {
        return true;
    }

    public EntityBoat(World par1World, double par2, double par4, double par6) {
        this(par1World);
        this.setPosition(par2, par4 + (double)this.yOffset, par6);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = par2;
        this.prevPosY = par4;
        this.prevPosZ = par6;
    }

    @Override
    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    @Override
    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        if (this.worldObj.isRemote || this.isDead) {
            return true;
        }
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() + par2 * 10);
        this.setBeenAttacked();
        if (this.getDamageTaken() > 40) {
            if (this.riddenByEntity != null) {
                this.riddenByEntity.mountEntity(this);
            }
            for (int i = 0; i < 3; ++i) {
                this.dropItemWithOffset(Block.planks.blockID, 1, 0.0f);
            }
            for (int j = 0; j < 2; ++j) {
                this.dropItemWithOffset(Item.stick.shiftedIndex, 1, 0.0f);
            }
            this.setDead();
        }
        return true;
    }

    @Override
    public void performHurtAnimation() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11);
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.boatX = par1;
        this.boatY = par3;
        this.boatZ = par5;
        this.boatYaw = par7;
        this.boatPitch = par8;
        this.boatPosRotationIncrements = par9 + 4;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @Override
    public void setVelocity(double par1, double par3, double par5) {
        this.velocityX = this.motionX = par1;
        this.velocityY = this.motionY = par3;
        this.velocityZ = this.motionZ = par5;
    }

    @Override
    public void onUpdate() {
        double d20;
        double d7;
        super.onUpdate();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0) {
            this.setDamageTaken(this.getDamageTaken() - 1);
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int i = 5;
        double d = 0.0;
        for (int j = 0; j < i; ++j) {
            double d2 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(j + 0) / (double)i - 0.125;
            double d8 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(j + 1) / (double)i - 0.125;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBoxFromPool(this.boundingBox.minX, d2, this.boundingBox.minZ, this.boundingBox.maxX, d8, this.boundingBox.maxZ);
            if (!this.worldObj.isAABBInMaterial(axisalignedbb, Material.water)) continue;
            d += 1.0 / (double)i;
        }
        double d1 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        if (d1 > 0.15) {
            double d3 = Math.cos((double)this.rotationYaw * Math.PI / 180.0);
            double d9 = Math.sin((double)this.rotationYaw * Math.PI / 180.0);
            int i1 = 0;
            while ((double)i1 < 1.0 + d1 * 60.0) {
                double d16 = this.rand.nextFloat() * 2.0f - 1.0f;
                double d19 = (double)(this.rand.nextInt(2) * 2 - 1) * 0.7;
                if (this.rand.nextBoolean()) {
                    double d21 = this.posX - d3 * d16 * 0.8 + d9 * d19;
                    double d23 = this.posZ - d9 * d16 * 0.8 - d3 * d19;
                    this.worldObj.spawnParticle("splash", d21, this.posY - 0.125, d23, this.motionX, this.motionY, this.motionZ);
                } else {
                    double d22 = this.posX + d3 + d9 * d16 * 0.7;
                    double d24 = this.posZ + d9 - d3 * d16 * 0.7;
                    this.worldObj.spawnParticle("splash", d22, this.posY - 0.125, d24, this.motionX, this.motionY, this.motionZ);
                }
                ++i1;
            }
        }
        if (this.worldObj.isRemote) {
            if (this.boatPosRotationIncrements > 0) {
                double d17;
                double d4 = this.posX + (this.boatX - this.posX) / (double)this.boatPosRotationIncrements;
                double d10 = this.posY + (this.boatY - this.posY) / (double)this.boatPosRotationIncrements;
                double d13 = this.posZ + (this.boatZ - this.posZ) / (double)this.boatPosRotationIncrements;
                for (d17 = this.boatYaw - (double)this.rotationYaw; d17 < -180.0; d17 += 360.0) {
                }
                while (d17 >= 180.0) {
                    d17 -= 360.0;
                }
                this.rotationYaw = (float)((double)this.rotationYaw + d17 / (double)this.boatPosRotationIncrements);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.boatPitch - (double)this.rotationPitch) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.setPosition(d4, d10, d13);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                double d5 = this.posX + this.motionX;
                double d11 = this.posY + this.motionY;
                double d14 = this.posZ + this.motionZ;
                this.setPosition(d5, d11, d14);
                if (this.onGround) {
                    this.motionX *= 0.5;
                    this.motionY *= 0.5;
                    this.motionZ *= 0.5;
                }
                this.motionX *= (double)0.99f;
                this.motionY *= (double)0.95f;
                this.motionZ *= (double)0.99f;
            }
            return;
        }
        if (d < 1.0) {
            double d6 = d * 2.0 - 1.0;
            this.motionY += (double)0.04f * d6;
        } else {
            if (this.motionY < 0.0) {
                this.motionY /= 2.0;
            }
            this.motionY += (double)0.007f;
        }
        if (this.riddenByEntity != null) {
            this.motionX += this.riddenByEntity.motionX * 0.2;
            this.motionZ += this.riddenByEntity.motionZ * 0.2;
        }
        if (this.motionX < -(d7 = 0.4)) {
            this.motionX = -d7;
        }
        if (this.motionX > d7) {
            this.motionX = d7;
        }
        if (this.motionZ < -d7) {
            this.motionZ = -d7;
        }
        if (this.motionZ > d7) {
            this.motionZ = d7;
        }
        if (this.onGround) {
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        if (this.isCollidedHorizontally && d1 > 0.2) {
            if (!this.worldObj.isRemote) {
                this.setDead();
                for (int k = 0; k < 3; ++k) {
                    this.dropItemWithOffset(Block.planks.blockID, 1, 0.0f);
                }
                for (int l = 0; l < 2; ++l) {
                    this.dropItemWithOffset(Item.stick.shiftedIndex, 1, 0.0f);
                }
            }
        } else {
            this.motionX *= (double)0.99f;
            this.motionY *= (double)0.95f;
            this.motionZ *= (double)0.99f;
        }
        this.rotationPitch = 0.0f;
        double d12 = this.rotationYaw;
        double d15 = this.prevPosX - this.posX;
        double d18 = this.prevPosZ - this.posZ;
        if (d15 * d15 + d18 * d18 > 0.001) {
            d12 = (float)(Math.atan2(d18, d15) * 180.0 / Math.PI);
        }
        for (d20 = d12 - (double)this.rotationYaw; d20 >= 180.0; d20 -= 360.0) {
        }
        while (d20 < -180.0) {
            d20 += 360.0;
        }
        if (d20 > 20.0) {
            d20 = 20.0;
        }
        if (d20 < -20.0) {
            d20 = -20.0;
        }
        this.rotationYaw = (float)((double)this.rotationYaw + d20);
        this.setRotation(this.rotationYaw, this.rotationPitch);
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = (Entity)list.get(j1);
                if (entity == this.riddenByEntity || !entity.canBePushed() || !(entity instanceof EntityBoat)) continue;
                entity.applyEntityCollision(this);
            }
        }
        for (int k1 = 0; k1 < 4; ++k1) {
            int j2;
            int i2;
            int l1 = MathHelper.floor_double(this.posX + ((double)(k1 % 2) - 0.5) * 0.8);
            if (this.worldObj.getBlockId(l1, i2 = MathHelper.floor_double(this.posY), j2 = MathHelper.floor_double(this.posZ + ((double)(k1 / 2) - 0.5) * 0.8)) != Block.snow.blockID) continue;
            this.worldObj.setBlockWithNotify(l1, i2, j2, 0);
        }
        if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
            this.riddenByEntity = null;
        }
    }

    @Override
    public void updateRiderPosition() {
        if (this.riddenByEntity == null) {
            return;
        }
        double d = Math.cos((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
        double d1 = Math.sin((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
        this.riddenByEntity.setPosition(this.posX + d, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ + d1);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public boolean interact(EntityPlayer par1EntityPlayer) {
        if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != par1EntityPlayer) {
            return true;
        }
        if (!this.worldObj.isRemote) {
            par1EntityPlayer.mountEntity(this);
        }
        return true;
    }

    public void setDamageTaken(int par1) {
        this.dataWatcher.updateObject(19, par1);
    }

    public int getDamageTaken() {
        return this.dataWatcher.getWatchableObjectInt(19);
    }

    public void setTimeSinceHit(int par1) {
        this.dataWatcher.updateObject(17, par1);
    }

    public int getTimeSinceHit() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    public void setForwardDirection(int par1) {
        this.dataWatcher.updateObject(18, par1);
    }

    public int getForwardDirection() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }
}

